Team Kodi Manifesto
===================

The Kodi manifesto is Team-Kodi's public declaration of the Kodi project members principles, philosophy and intentions. This manifesto tries to outline the goals we aim and hope to achieve with Kodi and sum up the Kodi project's strategic direction vision for the present and the future.

In one sentence, the vision of Team-Kodi is to create the best cross-platform media center software there is.

User-friendliness is next to godlyness
--------------------------------------

One major ongoing goal of Team-Kodi has always been to make Kodi and its user interface feel even more intuitive and user-friendly for its end-users, based on the **KISS** (**K**eep **I**t **S**imple, **S**tupid) principle of simplicity. It is our belief that usability is the most important aspect of a media center like Kodi. Many other media center projects make user interface decisions by developers, who often have little experience in user interface design. In contrast, Team-Kodi does its best to listen to Kodi's end-users to learn how Kodi is actually being used and how we can improve the user experience. We also aim to do regular overhauls, improving existing features/functions, and scrapping outdated code and features/functions (as "too much stuff" adds unnecessary complexity and can thus also be a bad thing). Everything should be made as simple as possible, but no simpler.

Kodi as a whole must...

* First and foremost be aimed at a large-screen (28" or more) [10-foot user interface](https://kodi.wiki/view/10-foot_user_interface) for the living-room experience.
  * Large menus, text/fonts and buttons that is designed to be navigated by a hand-held remote-control.
* Be focused around the main features of playing music, watching movies, recorded television broadcasts, and viewing pictures.
  * Kodi may be capable of converging other things but those things should never take over the main focus in the interface.
* Be easy to install, set up and maintain (so that our valuable end-users do not get fed up with it and quit).
* Have an user interface that is simple and intuitive enough so that less tech-savvy people are not intimidated by it.
  * Make common usage easy, simple 'Human–Computer Interaction (HCI)', from the viewpoint of an ordinary user.
* Be able to play audio and video files that have been encoded using DivX, XviD, etc. directly out-of-the-box.
* Be able to organize audio and video files in an easy and user-friendly way.
* Use standards and be consistent, (the Music section can for example not use completely different controls from the Video section).
* Perform actions in the GUI with as few 'clicks' as possible.
* Be aimed at an international audience, internationalization and localization by supporting different languages, timezones and other regional differences
* Require little to no non-GUI configuration (and all such non-GUI configuration should be done in just one file: [advancedsettings.xml](https://kodi.wiki/view/Advancedsettings.xml)).
* Be beautiful to look at, after all we hope you will be using it a lot!

1.2 Team-Kodi members should always strive to

* **Promote open source** - Kodi is based on the ideas of FOSS (free open source software), licensed under the GPL and builds partly on other open source projects which we do our best to support. The GPL should be respected at all times. All code should be committed to the Kodi project’s [git repo](https://github.com/xbmc/xbmc) before any public binaries are released.
* **Promote the sharing of knowledge and collaboration** - Through the use of information sharing tools and practices Kodi is a collaborative environment.
* **Understand that development is a team effort** - Treating our users as co-developers has proven to be the most effective option for rapid development. Always strive to work as a team at all times. Actively promote discussion on new features and bug fixes, and respect others comments and criticisms with replies in a timely fashion.
* **Apply the Law of Diminishing Return** - The majority of the effort should be invested in implementing features which have the most benefit and widest general usage by the community.
* **Try to make all code, feature, and functions to be platform agnostic** - Kodi is a multi-platform software, thus any single platform specific features should be discussed with other team members before implemented. Major features should be developed in a separate branch or committed in small increments so that other members have the opportunity to review the code and comment on it during development.
