/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#include "identity_client.h"

IdentityClient::IdentityClient(int clientNbr,QLabel *pict, OsCharacteristic *characteristics, QWidget *parent)
        :nbr(clientNbr), image(pict), osCharacteristics(characteristics), QFrame(parent)
{
#ifdef WIN32
    filePath = QDir::toNativeSeparators(QDir::homePath()) + "\\" + KP_DIRECTORY + "\\";
#elif defined (linux)
    filePath = QDir::toNativeSeparators(QDir::homePath()) + "/" + KP_DIRECTORY + "/";
#elif defined __APPLE__
    filePath = QDir::toNativeSeparators(QDir::homePath()) + "/" + KP_DIRECTORY + "/";
#else
    filePath = QDir::toNativeSeparators(QDir::homePath()) + "/" + KP_DIRECTORY + "/";
#endif
    this->setAttribute(
            Qt::WA_TranslucentBackground, false);
    blocked = false;
    QPushButton *refreshScreenshotButton = new QPushButton(tr("Refresh screenshot"), this);
    refreshScreenshotButton->setIcon(QIcon(":/images/refresh.png"));
    refreshScreenshotButton->setToolTip(tr("Refresh remote desktop."));
    QScrollArea *scroller = new QScrollArea(this);
    screenshotLabel = new QLabel;
    screenshotLabel->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
    screenshotLabel->setAlignment(Qt::AlignJustify);
    screenshotLabel->setMinimumSize(1240, 1040);
    screenshotLabel->setText("Loading remote desktop ...");
    screenshotLabel->setPixmap(QPixmap(":/images/loading.png"));
    // Host infos
    QString os =  osCharacteristics->system;
    QGroupBox *groupBox = new QGroupBox(tr("A remote ") + os +tr(" workstation is connected."), this);
    QGridLayout *gridBox = new QGridLayout;
    gridBox->addWidget(image, 0, 0);
    QLabel *operatingSystem;
    if (os.startsWith("LINUX"))
         operatingSystem = new QLabel(tr("Operating system : GNU/Linux based OS"));
    else
        operatingSystem = new QLabel(tr("Operating system : ") + os);
    QLabel *hostName = new QLabel(tr("Host name : ") + osCharacteristics->hostname);
    gridBox->addWidget(operatingSystem, 1, 0);
    gridBox->addWidget(hostName, 2, 0);
    int cpt = 2;
    for (int i = 0; i < osCharacteristics->ip_list->size(); i++) {
        cpt++;
        gridBox->addWidget(new QLabel(tr("IP address : ") + osCharacteristics->ip_list->at(i)), cpt, 0);
    }
    gridBox->addWidget(new QLabel(tr("")), cpt+3, 0);
    gridBox->addWidget(new QLabel(tr("")), cpt+3, 0);

    gridBox->addWidget(new QLabel(tr("Visualize the remote desktop on the left.")), (cpt+4), 0);
    gridBox->addWidget(refreshScreenshotButton, (cpt+5), 0);

    // End host infos

    scroller->setWidget(screenshotLabel);
    QSplitter *verticalSplitter = new QSplitter(this);
    QFrame *verticalFrame = new QFrame(this);

    QVBoxLayout *vBox = new QVBoxLayout;
    groupBox->setLayout(gridBox);
    verticalSplitter->addWidget(scroller);
    verticalSplitter->addWidget(groupBox);
    verticalSplitter->setStretchFactor(verticalSplitter->indexOf(scroller), 1);
    vBox->addWidget(verticalSplitter);

    verticalFrame->setLayout(vBox);
    QGridLayout *layout = new QGridLayout;

    layout->addWidget(verticalFrame);

    setLayout(layout);

    connect(refreshScreenshotButton, SIGNAL(clicked()), this, SLOT(refreshScreenshot()));
}

void IdentityClient::refreshScreenshot()
{
    if (!blocked) {
        if (osCharacteristics->system.startsWith("WINDOWS"))
            emit refreshScreenshotSignal(filePath, osCharacteristics->home_path + "\\" + KP_DIRECTORY, QString(REMOTE_DESKTOP_PNG));
        else
            emit refreshScreenshotSignal(filePath, osCharacteristics->home_path + "/" + KP_DIRECTORY, QString(REMOTE_DESKTOP_PNG));
    }
}
