/**************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
* This program is free software; you can redistribute it and/or           *
* modify it either under the terms of the GNU Lesser General Public       *
* License version 3 as published by the Free Software Foundation          *
* (the "LGPL") or, at your option, any later version.                     *
* If you do not alter this notice, a recipient may use your version       *
* of this file under the LGPL.                                            *
*                                                                         *
* You should have received a copy of the LGPL along with this library     *
* in the file COPYING; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
*                                                                         *
* This software is distributed on an "AS IS" basis, WITHOUT WARRANTY      *
* OF ANY KIND, either express or implied. See the LGPL for                *
* the specific language governing rights and limitations.                 *
**************************************************************************/

#ifndef HEADER_TCP_CLIENT_AUTH
#define HEADER_TCP_CLIENT_AUTH

#include <QTcpSocket>
#include <QApplication>
#include <QByteArray>
#include <QHostInfo>
#include <QList>
#include <QStringList>
#include <QHostAddress>
#include <stdlib.h>
#include <stdio.h>
#include <string>
#include <stdexcept>
#include <openssl/sha.h>
#include <openssl/rsa.h>
#include <openssl/pem.h>
#include <openssl/engine.h>
#include <openssl/evp.h>
#include <openssl/aes.h>
#include "../crypto/rsa_utils.h"
#include "../xml/xml_parser.h"
#include "../xml/xml.h"
#include "../utils/b64_utils.h"
#include "../crypto/aes_utils.h"
#include "../crypto/aes_wrapper.h"
#include "../utils/b64_utils.h"
#include "auth_commons.h"

class auth_tcp_client : public QObject
{
    Q_OBJECT

public:
    auth_tcp_client(QString server_password, QObject *parent);
    QString get_data_from_socket();
    void write_data_to_socket(QString data);
    int write_encrypted_data_to_socket(QString data);
    void send_error();
    QString auth_aes_encrypt(char* message);
    QString auth_aes_decrypt(QString message);

signals:
    void emit_tcp_state(int state);
    void emit_error();
    void auth_suceeded();
    void received_stream(QString message);
    void received_stream(QTcpSocket *tcp_socket);
    void disconnected_client(int error);
    void disconnected_socket();
    void wrong_password();
    void update_progress_size(int current, int total);

public slots:
    void connect_to_server(
    const char* ip_server, int port_server);
    void stop_client();
    void socket_error(QAbstractSocket::SocketError socketError);
    void disconnected_client();

private slots:
    void read_from_server();

private:
    QTcpSocket *tcp_socket;
    quint16 block_size;
    int auth_status;
    RSA *rsa_key_pair;
    RSA *rsa_pub;
    RSA *rsa_prv;
    char *pubk;
    char *b64_hashed_password;
    QString qstring_pub_key;
    QString pub_key_final;
    QString password;
    AES_WRAPPER *aes;
    int current_size;
    int packet_size;
    QByteArray *current_bytes;
    bool receiving;
    int progress;
    char* token;
    char* authentication;
    void handle_crypted_auth();
};

#endif
