/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   _lcas_log.h
    \brief  Internal header file for LCAS logging routines.
    \author Martijn Steenbakkers for the EU DataGrid.
    \internal
*/

#ifndef _LCAS_LOG_H
#define _LCAS_LOG_H

/******************************************************************************
                             Include header files
******************************************************************************/
#include "lcas_log.h"

/******************************************************************************
                               Define constants
******************************************************************************/
#define MAX_LOG_BUFFER_SIZE 2048 /*!< Maximum logging buffer size, length of log
                                      may not exceed this number \internal */

#define DO_USRLOG           ((unsigned short)0x0001) /*!< flag to indicate that
                                      user logging has to be done \internal */
#define DO_SYSLOG           ((unsigned short)0x0002) /*!< flag to indicate that
                                      syslogging has to be done \internal */

/******************************************************************************
 *                            Module definition
 *****************************************************************************/

/******************************************************************************
Function:       lcas_log_open()
Description:    Start logging
Parameters:
                path:    path of logfile
                fp:      file pointer to already opened file (or NULL)
                logtype: DO_USRLOG, DO_SYSLOG
Returns:        0 succes
                1 failure
******************************************************************************/
/*!
    \fn lcas_log_open(
        char * path,
        FILE * fp,
        unsigned short logtype
        )
    \brief Start logging

    This function should only be used by the LCAS itself.
    It opens the logfile and tries to set the debugging level in the following order:
    -# Try if DEBUG_LEVEL > 0
    -# Try if environment variable LCAS_DEBUG_LEVEL is set and if it is an integer > 0
    -# Otherwise set debug_level = 0;


    \param path    path of logfile.
    \param fp      file pointer to already opened file (or NULL)
    \param logtype DO_USRLOG, DO_SYSLOG

    \retval 0 succes.
    \retval 1 failure.
    \internal
*/
extern int lcas_log_open(
        char * path,
        FILE * fp,
        unsigned short logtype
);

/******************************************************************************
Function:       lcas_log_close()
Description:    Stop logging
Parameters:
Returns:        0 succes
                1 failure
******************************************************************************/
/*!
    \fn lcas_log_close()
    \brief Stop logging.

    \internal
    This function should only be used by the LCAS itself.

    \retval 0 succes.
    \retval 1 failure.
    \internal
*/
extern int lcas_log_close(void);

#endif /* _LCAS_LOG_H */

/******************************************************************************
CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcas/src/_lcas_log.h,v $
    $Date: 2010-05-03 10:42:49 $
    $Revision: 2.8 $
    $Author: okoeroo $
******************************************************************************/
