/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */
 
 /* (C) Marcin Kwadrans <quarter@users.sourceforge.net> */

#include "include/support.h"
#include "include/environment.h"
#include "include/wizard.h"
#include <cstdio>
#include <cstring>

extern GData *get_symbols();
static gboolean delete_cb (gpointer dummy);
static gboolean init_cb (gchar *filename);
static LWProject *project;

class LWProgramTest : public LWProgram
{
	gchar *filename;
	
	void showRunTimeMessage (LWMessage *msg)
	{
		if (!strcmp (filename, "-")) {
			g_print ("RTM: %u", msg->getId());
		} else {
		 	FILE *f = fopen (filename,  "w");
			g_return_if_fail (f != NULL);
			fprintf (f, "RTM: %u", msg->getId());
			fclose (f);
		}
	}
		
	void showParseMessage (LWMessage *msg)
	{
		if (!strcmp (filename, "-")) {
			g_print ("PM: %u", msg->getId());
		} else {
		 	FILE *f = fopen (filename,  "w");
			g_return_if_fail (f != NULL);
			fprintf (f, "PM: %u", msg->getId());
			fclose (f);
		}
	}
	
	void finish ()
	{
		LWProgram::finish();
	    xmlDoc *doc = xmlNewDoc(BAD_CAST "1.0");
    	xmlNode *node = xmlNewNode(NULL, BAD_CAST "LittleWizardOutput");
		getWorld()->storeToXML (node);
		xmlDocSetRootElement (doc, node);
		xmlSaveFile (filename, doc);
		xmlFreeDoc (doc);
		
		delete this;
	}
	
public:	

	LWProgramTest (gchar *a_filename): filename (a_filename) { }
	
	~LWProgramTest ()
	{
		g_idle_add ( (GSourceFunc) delete_cb, NULL);
	}
	
};

static gboolean delete_cb (gpointer dummy)
{
	(void) dummy;
	
	LWEnvironment::uninit();	
	
	gtk_main_quit();
	
	return FALSE;
}

static gboolean init_cb (gchar *filename)
{
	LWProgram *program = new LWProgramTest (filename);
	
	if (FALSE == program->parse (project->getProgram()))
		return FALSE;
	
	program->setWorld (project->getWorld());
	program->getWorld()->getWizard()->setSpeed(9);
	program->execute();
	
	/* Don't delete the program, it's destroyed internally when message is thrown
	   or program is finished */
	
	return FALSE;
}

int
main (int argc, char *argv[])
{
	gtk_init (&argc, &argv);

	if (argc == 1) {
		g_print (" === Little Wizard Test Tool ===\n");
		g_print (" ===== (C) Marcin Kwadrans  ====\n");
		g_print (" =========== v 0.0.2 ===========\n\n");
		g_print ("Syntax:\n");
		g_print ("         littlewizardtest program [output]\n");
		return 0;
	}
	
	GData *symbols = get_symbols();
	LWEnvironment::init(symbols);

	project = new LWProject();
	LWEnvironment::setProject (project);
	
	if (TRUE != project->load (argv[1])) {
		g_print ("Can't load a project!\n");
		return -1;
	}
	
	/* It makes the implementation easier, we can assume in that case we are always in
	   main loop */
	g_idle_add ((GSourceFunc) init_cb, (gpointer) (argc > 2 ? argv[2] :  "-"));
	
	gtk_main ();

	return 0;
}
