; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=thumbv7-apple-ios -mcpu=cortex-a8 -pre-RA-sched=source -disable-post-ra | FileCheck %s
; RUN: llc < %s -mtriple=thumbv6m-none-eabi -mcpu=cortex-m0 -pre-RA-sched=source -disable-post-ra -mattr=+strict-align | FileCheck %s --check-prefix=CHECK-T1
%struct.x = type { i8, i8, i8, i8, i8, i8, i8, i8, i8, i8, i8 }

@src = external global %struct.x
@dst = external global %struct.x

@.str1 = private unnamed_addr constant [31 x i8] c"DHRYSTONE PROGRAM, SOME STRING\00", align 1
@.str2 = private unnamed_addr constant [36 x i8] c"DHRYSTONE PROGRAM, SOME STRING BLAH\00", align 1
@.str3 = private unnamed_addr constant [24 x i8] c"DHRYSTONE PROGRAM, SOME\00", align 1
@.str4 = private unnamed_addr constant [18 x i8] c"DHRYSTONE PROGR  \00", align 1
@.str5 = private unnamed_addr constant [7 x i8] c"DHRYST\00", align 1
@.str6 = private unnamed_addr constant [14 x i8] c"/tmp/rmXXXXXX\00", align 1
@empty = private unnamed_addr constant [31 x i8] zeroinitializer, align 1
@spool.splbuf = internal global [512 x i8] zeroinitializer, align 16

define i32 @t0() {
; CHECK-LABEL: t0:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    movw r0, :lower16:(L_dst$non_lazy_ptr-(LPC0_0+4))
; CHECK-NEXT:    movt r0, :upper16:(L_dst$non_lazy_ptr-(LPC0_0+4))
; CHECK-NEXT:  LPC0_0:
; CHECK-NEXT:    add r0, pc
; CHECK-NEXT:    ldr r0, [r0]
; CHECK-NEXT:    movw r1, :lower16:(L_src$non_lazy_ptr-(LPC0_1+4))
; CHECK-NEXT:    movt r1, :upper16:(L_src$non_lazy_ptr-(LPC0_1+4))
; CHECK-NEXT:  LPC0_1:
; CHECK-NEXT:    add r1, pc
; CHECK-NEXT:    ldr r1, [r1]
; CHECK-NEXT:    ldr.w r2, [r1, #7]
; CHECK-NEXT:    str.w r2, [r0, #7]
; CHECK-NEXT:    vldr d16, [r1]
; CHECK-NEXT:    vstr d16, [r0]
; CHECK-NEXT:    movs r0, #0
; CHECK-NEXT:    bx lr
;
; CHECK-T1-LABEL: t0:
; CHECK-T1:       @ %bb.0: @ %entry
; CHECK-T1-NEXT:    ldr r0, .LCPI0_0
; CHECK-T1-NEXT:    ldrb r1, [r0, #10]
; CHECK-T1-NEXT:    ldr r2, .LCPI0_1
; CHECK-T1-NEXT:    strb r1, [r2, #10]
; CHECK-T1-NEXT:    ldrh r1, [r0, #8]
; CHECK-T1-NEXT:    strh r1, [r2, #8]
; CHECK-T1-NEXT:    ldr r1, [r0]
; CHECK-T1-NEXT:    ldr r0, [r0, #4]
; CHECK-T1-NEXT:    str r1, [r2]
; CHECK-T1-NEXT:    str r0, [r2, #4]
; CHECK-T1-NEXT:    movs r0, #0
; CHECK-T1-NEXT:    bx lr
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI0_0:
; CHECK-T1-NEXT:    .long src
; CHECK-T1-NEXT:  .LCPI0_1:
; CHECK-T1-NEXT:    .long dst
entry:
  call void @llvm.memcpy.p0.p0.i32(ptr align 8 @dst, ptr align 8 @src, i32 11, i1 false)
  ret i32 0
}

define void @t1(ptr nocapture %C) nounwind {
; CHECK-LABEL: t1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    movw r1, :lower16:(L_.str1-(LPC1_0+4))
; CHECK-NEXT:    movt r1, :upper16:(L_.str1-(LPC1_0+4))
; CHECK-NEXT:  LPC1_0:
; CHECK-NEXT:    add r1, pc
; CHECK-NEXT:    movs r2, #15
; CHECK-NEXT:    vld1.8 {d16, d17}, [r1], r2
; CHECK-NEXT:    vst1.8 {d16, d17}, [r0], r2
; CHECK-NEXT:    vld1.8 {d16, d17}, [r1]
; CHECK-NEXT:    vst1.8 {d16, d17}, [r0]
; CHECK-NEXT:    bx lr
;
; CHECK-T1-LABEL: t1:
; CHECK-T1:       @ %bb.0: @ %entry
; CHECK-T1-NEXT:    .save {r7, lr}
; CHECK-T1-NEXT:    push {r7, lr}
; CHECK-T1-NEXT:    ldr r1, .LCPI1_0
; CHECK-T1-NEXT:    movs r2, #31
; CHECK-T1-NEXT:    bl __aeabi_memcpy
; CHECK-T1-NEXT:    pop {r7, pc}
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI1_0:
; CHECK-T1-NEXT:    .long .L.str1
entry:
  tail call void @llvm.memcpy.p0.p0.i64(ptr %C, ptr @.str1, i64 31, i1 false)
  ret void
}

define void @t2(ptr nocapture %C) nounwind {
; CHECK-LABEL: t2:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    movw r1, :lower16:(L_.str2-(LPC2_0+4))
; CHECK-NEXT:    movt r1, :upper16:(L_.str2-(LPC2_0+4))
; CHECK-NEXT:  LPC2_0:
; CHECK-NEXT:    add r1, pc
; CHECK-NEXT:    vld1.8 {d16, d17}, [r1]!
; CHECK-NEXT:    vst1.8 {d16, d17}, [r0]!
; CHECK-NEXT:    vld1.64 {d16, d17}, [r1]
; CHECK-NEXT:    vst1.8 {d16, d17}, [r0]!
; CHECK-NEXT:    movw r1, #16716
; CHECK-NEXT:    movt r1, #72
; CHECK-NEXT:    str r1, [r0]
; CHECK-NEXT:    bx lr
;
; CHECK-T1-LABEL: t2:
; CHECK-T1:       @ %bb.0: @ %entry
; CHECK-T1-NEXT:    .save {r7, lr}
; CHECK-T1-NEXT:    push {r7, lr}
; CHECK-T1-NEXT:    ldr r1, .LCPI2_0
; CHECK-T1-NEXT:    movs r2, #36
; CHECK-T1-NEXT:    bl __aeabi_memcpy
; CHECK-T1-NEXT:    pop {r7, pc}
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI2_0:
; CHECK-T1-NEXT:    .long .L.str2
entry:
  tail call void @llvm.memcpy.p0.p0.i64(ptr %C, ptr @.str2, i64 36, i1 false)
  ret void
}

define void @t3(ptr nocapture %C) nounwind {
; CHECK-LABEL: t3:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    movw r1, :lower16:(L_.str3-(LPC3_0+4))
; CHECK-NEXT:    movt r1, :upper16:(L_.str3-(LPC3_0+4))
; CHECK-NEXT:  LPC3_0:
; CHECK-NEXT:    add r1, pc
; CHECK-NEXT:    vld1.8 {d16, d17}, [r1]!
; CHECK-NEXT:    vst1.8 {d16, d17}, [r0]!
; CHECK-NEXT:    vldr d16, [r1]
; CHECK-NEXT:    vst1.8 {d16}, [r0]
; CHECK-NEXT:    bx lr
;
; CHECK-T1-LABEL: t3:
; CHECK-T1:       @ %bb.0: @ %entry
; CHECK-T1-NEXT:    .save {r7, lr}
; CHECK-T1-NEXT:    push {r7, lr}
; CHECK-T1-NEXT:    ldr r1, .LCPI3_0
; CHECK-T1-NEXT:    movs r2, #24
; CHECK-T1-NEXT:    bl __aeabi_memcpy
; CHECK-T1-NEXT:    pop {r7, pc}
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI3_0:
; CHECK-T1-NEXT:    .long .L.str3
entry:
  tail call void @llvm.memcpy.p0.p0.i64(ptr %C, ptr @.str3, i64 24, i1 false)
  ret void
}

define void @t4(ptr nocapture %C) nounwind {
; CHECK-LABEL: t4:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    movw r1, :lower16:(L_.str4-(LPC4_0+4))
; CHECK-NEXT:    movt r1, :upper16:(L_.str4-(LPC4_0+4))
; CHECK-NEXT:  LPC4_0:
; CHECK-NEXT:    add r1, pc
; CHECK-NEXT:    vld1.64 {d16, d17}, [r1]
; CHECK-NEXT:    vst1.8 {d16, d17}, [r0]!
; CHECK-NEXT:    movs r1, #32
; CHECK-NEXT:    strh r1, [r0]
; CHECK-NEXT:    bx lr
;
; CHECK-T1-LABEL: t4:
; CHECK-T1:       @ %bb.0: @ %entry
; CHECK-T1-NEXT:    .save {r7, lr}
; CHECK-T1-NEXT:    push {r7, lr}
; CHECK-T1-NEXT:    ldr r1, .LCPI4_0
; CHECK-T1-NEXT:    movs r2, #18
; CHECK-T1-NEXT:    bl __aeabi_memcpy
; CHECK-T1-NEXT:    pop {r7, pc}
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI4_0:
; CHECK-T1-NEXT:    .long .L.str4
entry:
  tail call void @llvm.memcpy.p0.p0.i64(ptr %C, ptr @.str4, i64 18, i1 false)
  ret void
}

define void @t5(ptr nocapture %C) nounwind {
; CHECK-LABEL: t5:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    movw r1, #21337
; CHECK-NEXT:    movt r1, #84
; CHECK-NEXT:    str.w r1, [r0, #3]
; CHECK-NEXT:    movw r1, #18500
; CHECK-NEXT:    movt r1, #22866
; CHECK-NEXT:    str r1, [r0]
; CHECK-NEXT:    bx lr
;
; CHECK-T1-LABEL: t5:
; CHECK-T1:       @ %bb.0: @ %entry
; CHECK-T1-NEXT:    .save {r7, lr}
; CHECK-T1-NEXT:    push {r7, lr}
; CHECK-T1-NEXT:    ldr r1, .LCPI5_0
; CHECK-T1-NEXT:    movs r2, #7
; CHECK-T1-NEXT:    bl __aeabi_memcpy
; CHECK-T1-NEXT:    pop {r7, pc}
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI5_0:
; CHECK-T1-NEXT:    .long .L.str5
entry:
  tail call void @llvm.memcpy.p0.p0.i64(ptr %C, ptr @.str5, i64 7, i1 false)
  ret void
}

define void @t6() nounwind {
; CHECK-LABEL: t6:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    movw r0, :lower16:(L_.str6-(LPC6_0+4))
; CHECK-NEXT:    movt r0, :upper16:(L_.str6-(LPC6_0+4))
; CHECK-NEXT:  LPC6_0:
; CHECK-NEXT:    add r0, pc
; CHECK-NEXT:    vldr d16, [r0]
; CHECK-NEXT:    movw r1, :lower16:(_spool.splbuf-(LPC6_1+4))
; CHECK-NEXT:    movt r1, :upper16:(_spool.splbuf-(LPC6_1+4))
; CHECK-NEXT:  LPC6_1:
; CHECK-NEXT:    add r1, pc
; CHECK-NEXT:    vstr d16, [r1]
; CHECK-NEXT:    adds r1, #6
; CHECK-NEXT:    adds r0, #6
; CHECK-NEXT:    vld1.16 {d16}, [r0]
; CHECK-NEXT:    vst1.16 {d16}, [r1]
; CHECK-NEXT:    bx lr
;
; CHECK-T1-LABEL: t6:
; CHECK-T1:       @ %bb.0: @ %entry
; CHECK-T1-NEXT:    ldr r0, .LCPI6_0
; CHECK-T1-NEXT:    movs r1, #88
; CHECK-T1-NEXT:    strh r1, [r0, #12]
; CHECK-T1-NEXT:    ldr r1, .LCPI6_1
; CHECK-T1-NEXT:    ldr r2, .LCPI6_2
; CHECK-T1-NEXT:    ldr r3, .LCPI6_3
; CHECK-T1-NEXT:    str r3, [r0]
; CHECK-T1-NEXT:    str r2, [r0, #4]
; CHECK-T1-NEXT:    str r1, [r0, #8]
; CHECK-T1-NEXT:    bx lr
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI6_0:
; CHECK-T1-NEXT:    .long spool.splbuf
; CHECK-T1-NEXT:  .LCPI6_1:
; CHECK-T1-NEXT:    .long 1482184792 @ 0x58585858
; CHECK-T1-NEXT:  .LCPI6_2:
; CHECK-T1-NEXT:    .long 1483567663 @ 0x586d722f
; CHECK-T1-NEXT:  .LCPI6_3:
; CHECK-T1-NEXT:    .long 1886221359 @ 0x706d742f
entry:
  call void @llvm.memcpy.p0.p0.i64(ptr @spool.splbuf, ptr @.str6, i64 14, i1 false)
  ret void
}

%struct.Foo = type { i32, i32, i32, i32 }

define void @t7(ptr nocapture %a, ptr nocapture %b) nounwind {
; CHECK-LABEL: t7:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vld1.32 {d16, d17}, [r1]
; CHECK-NEXT:    vst1.32 {d16, d17}, [r0]
; CHECK-NEXT:    bx lr
;
; CHECK-T1-LABEL: t7:
; CHECK-T1:       @ %bb.0: @ %entry
; CHECK-T1-NEXT:    ldr r2, [r1, #12]
; CHECK-T1-NEXT:    str r2, [r0, #12]
; CHECK-T1-NEXT:    ldr r2, [r1, #8]
; CHECK-T1-NEXT:    str r2, [r0, #8]
; CHECK-T1-NEXT:    ldr r2, [r1, #4]
; CHECK-T1-NEXT:    str r2, [r0, #4]
; CHECK-T1-NEXT:    ldr r1, [r1]
; CHECK-T1-NEXT:    str r1, [r0]
; CHECK-T1-NEXT:    bx lr
entry:
  tail call void @llvm.memcpy.p0.p0.i32(ptr align 4 %a, ptr align 4 %b, i32 16, i1 false)
  ret void
}

define void @copy_from_zero_constant(ptr nocapture %C) nounwind {
; CHECK-LABEL: copy_from_zero_constant:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.i32 q8, #0x0
; CHECK-NEXT:    movs r1, #15
; CHECK-NEXT:    vst1.8 {d16, d17}, [r0], r1
; CHECK-NEXT:    vst1.8 {d16, d17}, [r0]
; CHECK-NEXT:    bx lr
;
; CHECK-T1-LABEL: copy_from_zero_constant:
; CHECK-T1:       @ %bb.0: @ %entry
; CHECK-T1-NEXT:    .save {r7, lr}
; CHECK-T1-NEXT:    push {r7, lr}
; CHECK-T1-NEXT:    ldr r1, .LCPI8_0
; CHECK-T1-NEXT:    movs r2, #31
; CHECK-T1-NEXT:    bl __aeabi_memcpy
; CHECK-T1-NEXT:    pop {r7, pc}
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI8_0:
; CHECK-T1-NEXT:    .long .Lempty
entry:
  tail call void @llvm.memcpy.p0.p0.i64(ptr %C, ptr @empty, i64 31, i1 false)
  ret void
}

declare void @llvm.memcpy.p0.p0.i32(ptr nocapture, ptr nocapture, i32, i1) nounwind
declare void @llvm.memcpy.p0.p0.i64(ptr nocapture, ptr nocapture, i64, i1) nounwind
