; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc-unknown-linux-gnu -mcpu=ppc64 < %s | FileCheck --check-prefix=CHECK %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc-unknown-linux-gnu -mcpu=ppc < %s | FileCheck --check-prefix=CHECK %s

define i32 @fold_urem_positive_odd(i32 %x) {
; CHECK-LABEL: fold_urem_positive_odd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lis 4, 22765
; CHECK-NEXT:    ori 4, 4, 8969
; CHECK-NEXT:    mulhwu 4, 3, 4
; CHECK-NEXT:    sub 5, 3, 4
; CHECK-NEXT:    srwi 5, 5, 1
; CHECK-NEXT:    add 4, 5, 4
; CHECK-NEXT:    srwi 4, 4, 6
; CHECK-NEXT:    mulli 4, 4, 95
; CHECK-NEXT:    sub 3, 3, 4
; CHECK-NEXT:    blr
  %1 = urem i32 %x, 95
  ret i32 %1
}


define i32 @fold_urem_positive_even(i32 %x) {
; CHECK-LABEL: fold_urem_positive_even:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lis 4, -2226
; CHECK-NEXT:    ori 4, 4, 16323
; CHECK-NEXT:    mulhwu 4, 3, 4
; CHECK-NEXT:    srwi 4, 4, 10
; CHECK-NEXT:    mulli 4, 4, 1060
; CHECK-NEXT:    sub 3, 3, 4
; CHECK-NEXT:    blr
  %1 = urem i32 %x, 1060
  ret i32 %1
}


; Don't fold if we can combine urem with udiv.
define i32 @combine_urem_udiv(i32 %x) {
; CHECK-LABEL: combine_urem_udiv:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lis 4, 22765
; CHECK-NEXT:    ori 4, 4, 8969
; CHECK-NEXT:    mulhwu 4, 3, 4
; CHECK-NEXT:    sub 5, 3, 4
; CHECK-NEXT:    srwi 5, 5, 1
; CHECK-NEXT:    add 4, 5, 4
; CHECK-NEXT:    srwi 4, 4, 6
; CHECK-NEXT:    mulli 5, 4, 95
; CHECK-NEXT:    sub 3, 3, 5
; CHECK-NEXT:    add 3, 3, 4
; CHECK-NEXT:    blr
  %1 = urem i32 %x, 95
  %2 = udiv i32 %x, 95
  %3 = add i32 %1, %2
  ret i32 %3
}

; Don't fold for divisors that are a power of two.
define i32 @dont_fold_urem_power_of_two(i32 %x) {
; CHECK-LABEL: dont_fold_urem_power_of_two:
; CHECK:       # %bb.0:
; CHECK-NEXT:    clrlwi 3, 3, 26
; CHECK-NEXT:    blr
  %1 = urem i32 %x, 64
  ret i32 %1
}

; Don't fold if the divisor is one.
define i32 @dont_fold_urem_one(i32 %x) {
; CHECK-LABEL: dont_fold_urem_one:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li 3, 0
; CHECK-NEXT:    blr
  %1 = urem i32 %x, 1
  ret i32 %1
}

; Don't fold if the divisor is 2^32.
define i32 @dont_fold_urem_i32_umax(i32 %x) {
; CHECK-LABEL: dont_fold_urem_i32_umax:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blr
  %1 = urem i32 %x, 4294967296
  ret i32 %1
}

; Don't fold i64 urem
define i64 @dont_fold_urem_i64(i64 %x) {
; CHECK-LABEL: dont_fold_urem_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr 0
; CHECK-NEXT:    stwu 1, -16(1)
; CHECK-NEXT:    stw 0, 20(1)
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset lr, 4
; CHECK-NEXT:    li 5, 0
; CHECK-NEXT:    li 6, 98
; CHECK-NEXT:    bl __umoddi3
; CHECK-NEXT:    lwz 0, 20(1)
; CHECK-NEXT:    addi 1, 1, 16
; CHECK-NEXT:    mtlr 0
; CHECK-NEXT:    blr
  %1 = urem i64 %x, 98
  ret i64 %1
}
