/*
 * Copyright (C) 2015-2016 Canonical Ltd.
 *
 * This file is part of Lomiri Weather App
 *
 * Lomiri Weather App is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * Lomiri Weather App is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.12
import Lomiri.Components 1.3
import "../../components"

Item {
    id: forecastDaysPage
    height: forecastDaysSetting.height

    ListModel {
        id: forecastDaysModel
        function initialize() {
            // TRANSLATORS: %1 will be replaced with the number of days
            forecastDaysModel.append({"days": 5, "text": i18n.tr("%1 days").arg(5)})
            forecastDaysModel.append({"days": 6, "text": i18n.tr("%1 days").arg(6)})
            forecastDaysModel.append({"days": 7, "text": i18n.tr("%1 days").arg(7)})
            forecastDaysModel.append({"days": 8, "text": i18n.tr("%1 days").arg(8)})
            forecastDaysModel.append({"days": 9, "text": i18n.tr("%1 days").arg(9)})
            forecastDaysModel.append({"days": 10, "text": i18n.tr("%1 days").arg(10)})
            forecastDaysModel.append({"days": 11, "text": i18n.tr("%1 days").arg(11)})
            forecastDaysModel.append({"days": 12, "text": i18n.tr("%1 days").arg(12)})
            forecastDaysModel.append({"days": 13, "text": i18n.tr("%1 days").arg(13)})
            forecastDaysModel.append({"days": 14, "text": i18n.tr("%1 days").arg(14)})
            forecastDaysModel.append({"days": 15, "text": i18n.tr("%1 days").arg(15)})
        }
    }

    OptionSelector {
        id: forecastDaysSetting
        text: i18n.tr("Number of forecast days")
        model: forecastDaysModel
        containerHeight: itemHeight * forecastDaysModel.count
        delegate: OptionSelectorDelegate {
            text: model.text
            height: units.gu(4)
        }
        onDelegateClicked: {
            // offset setting value by 1, because the current day's data is counted as one day
            settings.forecastDays = model.get(index).days + 1
            refreshData(false, true);
        }
    }
    Component.onCompleted: {
        /*
        The Component.onCompleted of the OptionSelector finishes BEFORE
        the onCompleted events of the delegates or the model.
        That is why the initialize() needs to be called here rather than
        in the Component.onCompleted of the ListModel.
        */
        forecastDaysModel.initialize()
        for (var i = 0; i < forecastDaysModel.count; ++i) {
            // offset setting value by 1, because the current day's data is counted as one day
            if (forecastDaysModel.get(i).days === settings.forecastDays - 1) {
                forecastDaysSetting.selectedIndex = i
                return
            }
        }
        forecastDaysSetting.selectedIndex = 0  // in case no match is found due to broken settings
    }
}
