/* Light Unix I/O for Lua
 * Copyright 2012 Rob Kendrick <rjek+luxio@rjek.com>
 *
 * Distributed under the same terms as Lua itself (MIT).
 */

#ifndef LUXIO_CONFIG_H
#define LUXIO_CONFIG_H

#ifdef __linux__
# define HAVE_SENDFILE 1
# define HAVE_SPLICE 1
# define HAVE_D_TYPE 1
# define HAVE_FDATASYNC 1
# define _GNU_SOURCE
# define _LARGEFILE64_SOURCE
# define _POSIX_SOURCE
# define _POSIX_C_SOURCE 1
#endif

#ifdef __NetBSD__
# define ICONV_IN_TYPE const char **
#else
# define ICONV_IN_TYPE char **
#endif

#ifndef _POSIX_PTHREAD_SEMANTICS
 /* Solaris horror */
# define _POSIX_PTHREAD_SEMANTICS 1
#endif

#ifndef LOGIN_NAME_MAX
# define LOGIN_NAME_MAX 9
#endif

#ifndef IFNAMSIZ
/* MINIX does not have this */
# define IFNAMSIZ 128
#endif
#endif /* LUXIO_CONFIG_H */

