/*! 
* This Source Code Form is subject to the terms of the Mozilla Public
* License, v. 2.0. If a copy of the MPL was not distributed with this file,
* You can obtain one at http://mozilla.org/MPL/2.0/.
*
* Copyright(c) 2011 Apogee Imaging Systems, Inc. 
*
* \class AltaF 
* \brief class for the F serise cameras 
* 
*/ 


#ifndef ALTAF_INCLUDE_H__ 
#define ALTAF_INCLUDE_H__ 

#include "CamGen2Base.h" 
#include <string>

class DLL_EXPORT AltaF : public CamGen2Base
{ 
    public: 
        AltaF();

        virtual ~AltaF(); 

        void OpenConnection( const std::string & ioType,
             const std::string & DeviceAddr,
             const uint16_t FirmwareRev,
             const uint16_t Id );

        void CloseConnection();

        void StartExposure( double Duration, bool IsLight );

        int32_t GetNumAdChannels();
        
        void Init();

        Apg::FanMode GetFanMode();
        void SetFanMode( Apg::FanMode mode, bool PreCondCheck = true );

    protected:
        void FixImgFromCamera( const std::vector<uint16_t> & data,
            std::vector<uint16_t> & out,  int32_t rows, int32_t cols );

        void ExposureAndGetImgRC(uint16_t & r, uint16_t & c);

        void CreateCamIo(const std::string & ioType,
            const std::string & DeviceAddr);

        void CfgCamFromId( uint16_t CameraId );

        void VerifyCamId();

        /*! 
         * AltaF's do not have dip switches on them any more because
         * of space constriants on the PCB.  Thus we now save the ID 
         * in the StrDb.  But the camcom firmware still needs to know the
         * id, because there is information about how to drive the camera
         * embedded in the bits of the ID itself.  Thus after verifying the 
         * id we need to write this value to the ID_FROM_PROM register.
         * \exception std::runtime_error
         */
        void WriteId2CamReg();

        void SetIsInterlineBit();

        bool AreColsCentered();

        const std::string m_fileName;

    private:
        void UpdateCfgWithStrDbInfo();

        //disabling the copy ctor and assignment operator
        //generated by the compiler - don't want them
        //Effective C++ Item 6
        AltaF(const AltaF&);
        AltaF& operator=(AltaF&);
}; 

#endif
