#!/bin/sh

if test ! -d debian; then
    echo "This script must be started from the base directory"
    exit 1
fi

if test $# -ne 1; then
    echo "Version is expected"
fi

PACKAGE=libc++
SRC_VERSION=$1
SVN_REVISION=`echo ${SRC_VERSION} | awk -F'~' '{ print $2 }' | sed 's/svn//'`
LIBCXX_SVN=http://llvm.org/svn/llvm-project/libcxx/trunk
LIBCXXABI_SVN=http://llvm.org/svn/llvm-project/libcxxabi/trunk

rm -rf tmp $TARBALL

mkdir tmp

if [ -z "$SVN_REVISION" ]; then
	echo "No SVN revision specified, using current revision..."
	SVN_REVISION=`LANG=C svn info $LIBCXX_SVN| sed -ne 's/Revision: \([0-9]*\)/\1/p'`
	echo "Current revision is $SVN_REVISION."
	SRC_VERSION="${SRC_VERSION}~svn${SVN_REVISION}"
else
	echo "Using SVN revision ${SVN_REVISION}..."
	SRC_VERSION="${SRC_VERSION}"
fi

PKG_NAME=${PACKAGE}_${SRC_VERSION}
TARBALL=${PKG_NAME}.orig.tar.gz

svn co -r $SVN_REVISION $LIBCXX_SVN tmp/libcxx
svn co -r $SVN_REVISION $LIBCXXABI_SVN tmp/libcxxabi

cd libcxxabi
cp --parents include/unwind.h ../tmp/libcxxabi/
cd ../

cd libcxx
cp --parents bin/clang++-libc++ ../tmp/libcxx/
cp --parents bin/g++-libc++ ../tmp/libcxx/
cd ../

GZIP='--best --no-name' tar czf $TARBALL --exclude-vcs -C tmp libcxx libcxxabi

rm -rf tmp

echo "$TARBALL created; move it to the right destination to build the package"
