/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.javax.sql.rowset.serial;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialException;
import junit.framework.TestCase;
import org.apache.harmony.sql.tests.javax.sql.rowset.serial.SerialBlobTest;

/*
 * Exception performing whole class analysis ignored.
 */
public class SerialBlobTest
extends TestCase {
    public void testConstructorLBlob() throws Exception {
        boolean bl = false;
        MockSerialBlob mockSerialBlob = new MockSerialBlob(bl);
        SerialBlob serialBlob = new SerialBlob((Blob)mockSerialBlob);
        SerialBlobTest.assertTrue((boolean)mockSerialBlob.isGetBytesInvoked);
        SerialBlobTest.assertEquals((long)1L, (long)serialBlob.length());
        bl = true;
        mockSerialBlob = new MockSerialBlob(bl);
        try {
            new SerialBlob((Blob)mockSerialBlob);
            SerialBlobTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            new SerialBlob(null);
            SerialBlobTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testConstructor$B() throws Exception {
        byte[] byArray = new byte[8];
        SerialBlob serialBlob = new SerialBlob(byArray);
        SerialBlobTest.assertEquals((long)8L, (long)serialBlob.length());
        try {
            new SerialBlob(null);
            SerialBlobTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetBinaryStream() throws Exception {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        SerialBlob serialBlob = new SerialBlob(byArray);
        InputStream inputStream = serialBlob.getBinaryStream();
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = inputStream.read()) == -1) {
                if (n >= byArray.length) break;
                SerialBlobTest.fail((String)"returned input stream contains too few data");
                break;
            }
            if (n > byArray.length) {
                SerialBlobTest.fail((String)"returned input stream contains too much data");
            }
            SerialBlobTest.assertEquals((int)byArray[n++], (int)n2);
        }
    }

    public void testGetBytesJI() throws Exception {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        SerialBlob serialBlob = new SerialBlob(byArray);
        byte[] byArray2 = serialBlob.getBytes(1L, 1);
        SerialBlobTest.assertEquals((int)1, (int)byArray2.length);
        SerialBlobTest.assertEquals((int)1, (int)byArray2[0]);
        byArray2 = serialBlob.getBytes(2L, 3);
        SerialBlobTest.assertEquals((int)3, (int)byArray2.length);
        SerialBlobTest.assertEquals((int)2, (int)byArray2[0]);
        SerialBlobTest.assertEquals((int)3, (int)byArray2[1]);
        SerialBlobTest.assertEquals((int)4, (int)byArray2[2]);
        byArray2 = serialBlob.getBytes(2L, 1);
        SerialBlobTest.assertEquals((int)1, (int)byArray2.length);
        SerialBlobTest.assertEquals((int)2, (int)byArray2[0]);
        byArray2 = serialBlob.getBytes(1L, 10);
        SerialBlobTest.assertEquals((int)8, (int)byArray2.length);
        SerialBlobTest.assertTrue((boolean)Arrays.equals(byArray, byArray2));
        try {
            byArray2 = serialBlob.getBytes(2L, -1);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            byArray2 = serialBlob.getBytes(0L, 2);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            byArray2 = serialBlob.getBytes(-1L, 2);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            byArray2 = serialBlob.getBytes(10L, 11);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    public void testSetBytesJ$B() throws Exception {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] byArray2 = new byte[]{9, 10, 11};
        SerialBlob serialBlob = new SerialBlob(byArray);
        int n = serialBlob.setBytes(1L, byArray2);
        byte[] byArray3 = serialBlob.getBytes(1L, byArray.length);
        byte[] byArray4 = new byte[]{9, 10, 11, 4, 5, 6, 7, 8};
        SerialBlobTest.assertTrue((boolean)Arrays.equals(byArray4, byArray3));
        SerialBlobTest.assertEquals((int)3, (int)n);
        n = serialBlob.setBytes(2L, byArray2);
        byArray3 = serialBlob.getBytes(1L, byArray.length);
        byArray4 = new byte[]{9, 9, 10, 11, 5, 6, 7, 8};
        SerialBlobTest.assertTrue((boolean)Arrays.equals(byArray4, byArray3));
        SerialBlobTest.assertEquals((int)3, (int)n);
        n = serialBlob.setBytes(6L, byArray2);
        byArray3 = serialBlob.getBytes(1L, byArray.length);
        byArray4 = new byte[]{9, 9, 10, 11, 5, 9, 10, 11};
        SerialBlobTest.assertTrue((boolean)Arrays.equals(byArray4, byArray3));
        SerialBlobTest.assertEquals((int)3, (int)n);
        try {
            serialBlob.setBytes(-1L, byArray2);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialBlob.setBytes(10L, byArray2);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialBlob.setBytes(7L, byArray2);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    public void testSetBytesJ$BII() throws Exception {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] byArray2 = new byte[]{9, 10, 11};
        SerialBlob serialBlob = new SerialBlob(byArray);
        int n = serialBlob.setBytes(1L, byArray2, 0, 3);
        byte[] byArray3 = serialBlob.getBytes(1L, byArray.length);
        byte[] byArray4 = new byte[]{9, 10, 11, 4, 5, 6, 7, 8};
        SerialBlobTest.assertTrue((boolean)Arrays.equals(byArray4, byArray3));
        SerialBlobTest.assertEquals((int)3, (int)n);
        n = serialBlob.setBytes(3L, byArray2, 1, 2);
        byArray3 = serialBlob.getBytes(1L, byArray.length);
        byArray4 = new byte[]{9, 10, 10, 11, 5, 6, 7, 8};
        SerialBlobTest.assertTrue((boolean)Arrays.equals(byArray4, byArray3));
        SerialBlobTest.assertEquals((int)2, (int)n);
        n = serialBlob.setBytes(6L, byArray2, 0, 2);
        byArray3 = serialBlob.getBytes(1L, byArray.length);
        byArray4 = new byte[]{9, 10, 10, 11, 5, 9, 10, 8};
        SerialBlobTest.assertTrue((boolean)Arrays.equals(byArray4, byArray3));
        SerialBlobTest.assertEquals((int)2, (int)n);
        try {
            serialBlob.setBytes(7L, byArray2, 0, 10);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialBlob.setBytes(-1L, byArray2, 0, 2);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialBlob.setBytes(10L, byArray2, 0, 2);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialBlob.setBytes(1L, byArray2, -1, 2);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialBlob.setBytes(1L, byArray2, 0, 10);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialBlob.setBytes(7L, byArray2, 0, 3);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialBlob.setBytes(7L, byArray2, 0, -1);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    public void testPosition$BJ() throws Exception {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        SerialBlob serialBlob = new SerialBlob(byArray);
        this.assertBlobPosition_BytePattern((Blob)serialBlob);
        MockSerialBlob mockSerialBlob = new MockSerialBlob();
        mockSerialBlob.buf = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        serialBlob = new SerialBlob((Blob)mockSerialBlob);
        this.assertBlobPosition_BytePattern((Blob)serialBlob);
    }

    public void testPositionLBlobJ() throws Exception {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        SerialBlob serialBlob = new SerialBlob(byArray);
        this.assertBlobPosition_BlobPattern((Blob)serialBlob);
        MockSerialBlob mockSerialBlob = new MockSerialBlob();
        mockSerialBlob.buf = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        serialBlob = new SerialBlob((Blob)mockSerialBlob);
        this.assertBlobPosition_BlobPattern((Blob)serialBlob);
    }

    public void testTruncateJ() throws Exception {
        SerialBlob[] serialBlobArray;
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        SerialBlob serialBlob = new SerialBlob(byArray);
        MockSerialBlob mockSerialBlob = new MockSerialBlob();
        mockSerialBlob.buf = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        SerialBlob serialBlob2 = new SerialBlob((Blob)mockSerialBlob);
        SerialBlob[] serialBlobArray2 = serialBlobArray = new SerialBlob[]{serialBlob, serialBlob2};
        int n = 0;
        int n2 = serialBlobArray2.length;
        while (n < n2) {
            SerialBlob serialBlob3 = serialBlobArray2[n];
            serialBlob3.truncate(3L);
            SerialBlobTest.assertEquals((long)3L, (long)serialBlob3.length());
            byte[] byArray2 = serialBlob3.getBytes(1L, 3);
            SerialBlobTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, byArray2));
            try {
                serialBlob3.truncate(-1L);
                SerialBlobTest.fail((String)"should throw SerialException");
            }
            catch (SerialException serialException) {
                // empty catch block
            }
            SerialBlobTest.assertEquals((long)3L, (long)serialBlob3.length());
            try {
                serialBlob3.truncate(10L);
                SerialBlobTest.fail((String)"should throw SerialException");
            }
            catch (SerialException serialException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void testSetBinaryStreamJ() throws Exception {
        MockSerialBlob mockSerialBlob = new MockSerialBlob();
        mockSerialBlob.binaryStream = new ByteArrayOutputStream();
        SerialBlob serialBlob = new SerialBlob((Blob)mockSerialBlob);
        OutputStream outputStream = serialBlob.setBinaryStream(1L);
        SerialBlobTest.assertTrue((boolean)mockSerialBlob.isSetBinaryStreamInvoked);
        SerialBlobTest.assertEquals((long)1L, (long)mockSerialBlob.pos);
        SerialBlobTest.assertSame((Object)mockSerialBlob.binaryStream, (Object)outputStream);
        mockSerialBlob.binaryStream = null;
        try {
            serialBlob.setBinaryStream(1L);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        byte[] byArray = new byte[1];
        serialBlob = new SerialBlob(byArray);
        try {
            serialBlob.setBinaryStream(1L);
            SerialBlobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    private void assertBlobPosition_BytePattern(Blob blob) throws SerialException, SQLException {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        long l = blob.position(byArray, 1L);
        SerialBlobTest.assertEquals((long)1L, (long)l);
        byArray = new byte[]{2, 3, 4};
        l = blob.position(byArray, 1L);
        SerialBlobTest.assertEquals((long)2L, (long)l);
        l = blob.position(byArray, 2L);
        SerialBlobTest.assertEquals((long)2L, (long)l);
        l = blob.position(byArray, 3L);
        SerialBlobTest.assertEquals((long)-1L, (long)l);
        byArray = new byte[]{2, 4};
        l = blob.position(byArray, 1L);
        SerialBlobTest.assertEquals((long)-1L, (long)l);
        l = blob.position(byArray, 3L);
        SerialBlobTest.assertEquals((long)-1L, (long)l);
        byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        l = blob.position(byArray, 1L);
        SerialBlobTest.assertEquals((long)-1L, (long)l);
        l = blob.position(byArray, 3L);
        SerialBlobTest.assertEquals((long)-1L, (long)l);
        byArray = new byte[]{2, 3, 4};
        l = blob.position(byArray, 0L);
        SerialBlobTest.assertEquals((long)-1L, (long)l);
        l = blob.position(byArray, -1L);
        SerialBlobTest.assertEquals((long)-1L, (long)l);
        l = blob.position((byte[])null, -1L);
        SerialBlobTest.assertEquals((long)-1L, (long)l);
        try {
            l = blob.position((byte[])null, 1L);
            SerialBlobTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void assertBlobPosition_BlobPattern(Blob blob) throws SerialException, SQLException {
        MockSerialBlob mockSerialBlob = new MockSerialBlob();
        mockSerialBlob.buf = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        long l = blob.position((Blob)mockSerialBlob, 1L);
        SerialBlobTest.assertEquals((long)1L, (long)l);
        mockSerialBlob.buf = new byte[]{2, 3, 4};
        l = blob.position((Blob)mockSerialBlob, 1L);
        SerialBlobTest.assertEquals((long)2L, (long)l);
        l = blob.position((Blob)mockSerialBlob, 2L);
        SerialBlobTest.assertEquals((long)2L, (long)l);
        l = blob.position((Blob)mockSerialBlob, 3L);
        SerialBlobTest.assertEquals((long)-1L, (long)l);
        mockSerialBlob.buf = new byte[]{2, 4};
        l = blob.position((Blob)mockSerialBlob, 1L);
        SerialBlobTest.assertEquals((long)-1L, (long)l);
        l = blob.position((Blob)mockSerialBlob, 3L);
        SerialBlobTest.assertEquals((long)-1L, (long)l);
        mockSerialBlob.buf = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        l = blob.position((Blob)mockSerialBlob, 1L);
        SerialBlobTest.assertEquals((long)-1L, (long)l);
        l = blob.position((Blob)mockSerialBlob, 3L);
        SerialBlobTest.assertEquals((long)-1L, (long)l);
        mockSerialBlob.buf = new byte[]{2, 3, 4};
        l = blob.position((Blob)mockSerialBlob, 0L);
        SerialBlobTest.assertEquals((long)-1L, (long)l);
        l = blob.position((Blob)mockSerialBlob, -1L);
        SerialBlobTest.assertEquals((long)-1L, (long)l);
        try {
            l = blob.position((Blob)null, -1L);
            SerialBlobTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            l = blob.position((Blob)null, 1L);
            SerialBlobTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        MockSerialBlob mockSerialBlob2 = new MockSerialBlob(true);
        try {
            blob.position((Blob)mockSerialBlob2, 1L);
            SerialBlobTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            blob.position((Blob)mockSerialBlob2, -1L);
            SerialBlobTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

