/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.rmi.registry;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.rmi.registry.RegistryContext;
import org.apache.harmony.jndi.provider.rmi.rmiURLContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryContextFactory
implements InitialContextFactory,
ObjectFactory {
    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        Object obj;
        String url = null;
        if (environment != null) {
            url = (String)environment.get("java.naming.provider.url");
        }
        if (url == null) {
            url = "rmi:";
        }
        if ((obj = new rmiURLContextFactory().getObjectInstance(url, null, null, environment)) instanceof Context) {
            return (Context)obj;
        }
        throw new NotContextException(Messages.getString("jndi.76", url));
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (!(obj instanceof Reference)) {
            return null;
        }
        Reference reference = (Reference)obj;
        if (!reference.getFactoryClassName().equals(RegistryContextFactory.class.getName())) {
            return null;
        }
        int size = reference.size();
        if (size < 1) {
            throw new ConfigurationException(Messages.getString("jndi.77"));
        }
        Vector<Object> urls = new Vector<Object>(size);
        Enumeration<RefAddr> e = reference.getAll();
        while (e.hasMoreElements()) {
            RefAddr refAddr = e.nextElement();
            if (!(refAddr instanceof StringRefAddr) || !refAddr.getType().equals("URL")) continue;
            urls.add(refAddr.getContent());
        }
        size = urls.size();
        if (size < 1) {
            throw new ConfigurationException(Messages.getString("jndi.78"));
        }
        Object ret = new rmiURLContextFactory().getObjectInstance(urls.toArray(new String[size]), name, nameCtx, environment);
        if (ret instanceof RegistryContext) {
            ((RegistryContext)ret).setReference(reference);
        }
        return ret;
    }
}

