/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.util.Arrays;
import javax.naming.RefAddr;

public class BinaryRefAddr
extends RefAddr {
    private static final long serialVersionUID = -3415254970957330361L;
    private byte[] buf;

    public BinaryRefAddr(String type, byte[] address) {
        this(type, address, 0, address.length);
    }

    public BinaryRefAddr(String type, byte[] address, int index, int size) {
        super(type);
        this.buf = new byte[size];
        System.arraycopy(address, index, this.buf, 0, size);
    }

    public Object getContent() {
        return this.buf;
    }

    public boolean equals(Object o) {
        if (o instanceof BinaryRefAddr) {
            BinaryRefAddr a = (BinaryRefAddr)o;
            return this.addrType.equals(a.addrType) && Arrays.equals(this.buf, a.buf);
        }
        return false;
    }

    public int hashCode() {
        int i = this.addrType.hashCode();
        byte[] byArray = this.buf;
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            byte element = byArray[n];
            i += element;
            ++n;
        }
        return i;
    }

    public String toString() {
        String s = "The type of the address is: " + this.addrType + "\nThe content of the address is: ";
        int max = this.buf.length > 128 ? 128 : this.buf.length;
        int i = 0;
        while (i < max) {
            s = String.valueOf(s) + Integer.toHexString(this.buf[i]) + " ";
            ++i;
        }
        s = String.valueOf(s.substring(0, s.length() - 1)) + "\n";
        return s;
    }
}

