with Ada.Text_IO;
with GNATCOLL.SQL;          use GNATCOLL.SQL;
with GNATCOLL.SQL.Exec;     use GNATCOLL.SQL.Exec;
with GNATCOLL.SQL.Sqlite;
with GNATCOLL.Traces;       use GNATCOLL.Traces;

procedure SQLite_Test is
   Descr : Database_Description;
   DB    : Database_Connection;
begin
   GNATCOLL.Traces.Parse_Config_File;
   Descr := Sqlite.Setup (":memory:");
   DB := Descr.Build_Connection;
   
   DB.Execute ("create table bar (id string)");

   if not Check_Connection (DB) then
      Ada.Text_IO.Put_Line ("Check_Connection should return True");
   end if;
   
   DB.Commit;
end SQLite_Test;
