/*
 * @(#)DirectoryChannelLogReaderUTest.java
 *
 * Copyright (C) 2003-2004 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import junit.framework.Test;
import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import net.sourceforge.groboutils.codecoverage.v2.CCCreatorUtil;
import net.sourceforge.groboutils.codecoverage.v2.IChannelLogReaderUTestI;
import net.sourceforge.groboutils.codecoverage.v2.IClassChannelLogReader;
import net.sourceforge.groboutils.codecoverage.v2.IClassChannelLogReaderUTestI;
import net.sourceforge.groboutils.junit.v1.SubTestTestCase;
import net.sourceforge.groboutils.junit.v1.iftc.CxFactory;
import net.sourceforge.groboutils.junit.v1.iftc.InterfaceTestSuite;


/**
 * Tests the DirectoryChannelLogReader class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/07/07 09:39:13 $
 * @since     January 22, 2003
 */
public class DirectoryChannelLogReaderUTest extends SubTestTestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = DirectoryChannelLogReaderUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public DirectoryChannelLogReaderUTest( String name )
    {
        super( name );
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testConstructor1() throws Exception
    {
        Thread.sleep( 100 );
        File base = new File( ".",
            Long.toString( System.currentTimeMillis() ) );
        try
        {
            new DirectoryChannelLogReader( base, (short)0 );
            fail( "Didn't throw IllegalArgumentException." );
        }
        catch (IllegalArgumentException ex)
        {
            // test exception
        }
    }
    
    
    public void testConstructor2() throws Exception
    {
        Thread.sleep( 100 );
        File base = CCCreatorUtil.createNewDirectory();
        try
        {
            new DirectoryChannelLogReader( base, (short)0 );
            fail( "Didn't throw IllegalArgumentException." );
        }
        catch (IllegalArgumentException ex)
        {
            // test exception
        }
    }
    
    
    public void testGetReaderForClassSignature1() throws IOException
    {
        String classSig = "a.MyClass-1";
        File outdir = CCCreatorUtil.createNewDirectory();
        File fd1 = new File( outdir, "0" );
        fd1.mkdirs();
        File cd1 = new File( fd1, classSig +
            DirectoryChannelLogger.CLASS_LOG_EXTENTION );
        FileWriter fw = new FileWriter( cd1 );
        fw.write( "0001 0002\n" );
        fw.close();
        DirectoryChannelLogReader dclr = new DirectoryChannelLogReader(
            outdir, (short)0 );
        final IClassChannelLogReader cclr = dclr.
            getReaderForClassSignature( classSig );
        assertNotNull(
            "Returned null class channel log reader.",
            cclr );
        assertTrue(
            "Not correct type (was "+cclr.getClass().getName()+").",
            cclr instanceof DirectoryClassChannelLogReader );
        
        InterfaceTestSuite suite = IClassChannelLogReaderUTestI.suite();
        suite.addFactory( new CxFactory( "GetReader1" ) {
            public Object createImplObject() throws IOException {
                return cclr;
            }
        } );
        addSubTest( suite );
    }
    
    
    public void testGetReaderForClassSignature2() throws IOException
    {
        String classSig = "a.MyClass-1";
        File outdir = CCCreatorUtil.createNewDirectory();
        File fd1 = new File( outdir, "0" );
        fd1.mkdirs();
        DirectoryChannelLogReader dclr = new DirectoryChannelLogReader(
            outdir, (short)0 );
        final IClassChannelLogReader cclr = dclr.
            getReaderForClassSignature( classSig );
        assertNotNull(
            "Returned null class channel log reader.",
            cclr );
        assertTrue(
            "Not correct type (was "+cclr.getClass().getName()+").",
            cclr instanceof EmptyClassChannelLogReader );
        
        InterfaceTestSuite suite = IClassChannelLogReaderUTestI.suite();
        suite.addFactory( new CxFactory( "GetReader2" ) {
            public Object createImplObject() throws IOException {
                return cclr;
            }
        } );
        addSubTest( suite );
    }
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        InterfaceTestSuite suite = IChannelLogReaderUTestI.suite();
        suite.addTestSuite( THIS_CLASS );
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() throws IOException {
                File base = CCCreatorUtil.createNewDirectory();
                File zero = new File( base, "0" );
                zero.mkdirs();
                return new DirectoryChannelLogReader( base, (short)0 );
            }
        } );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();

       
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

