/*
 * @(#)JavaMakerUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.uicapture.v1.javamaker;

import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import java.io.*;
import net.sourceforge.groboutils.uicapture.v1.*;



/**
 * Tests the JavaMaker class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/05/29 13:05:56 $
 * @since     Oct 3, 2002
 */
public class JavaMakerUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = JavaMakerUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public JavaMakerUTest( String name )
    {
        super( name );
    }

    
    
    

    //-------------------------------------------------------------------------
    // Tests
    
    public void testInstantiation1()
            throws IOException
    {
        try
        {
            new JavaMaker( (File)null, null, null );
        }
        catch (IllegalArgumentException e)
        {
            // test exception?
        }
    }
    
    
    public void testInstantiation2()
    {
        try
        {
            new JavaMaker( (Writer)null, null, null );
        }
        catch (IllegalArgumentException e)
        {
            // test exception?
        }
    }
    
    
    public void testInstantiation3()
    {
        JavaMaker jm = new JavaMaker( new StringWriter(), "a", "b" );
    }
    
    
    public void testInstantiation4()
            throws IOException
    {
        File f = File.createTempFile( "JavaMakerUTest", ".tmp" );
        JavaMaker jm = new JavaMaker( f, "a", "b" );
    }
    
    
    
    
    public void testStartEnd1()
    {
        DOC.getIT().testsIssue( 618295 );
        StringWriter sw = new StringWriter();
        JavaMaker jm = new JavaMaker( sw, "a", "b" );
        
        jm.start();
        jm.end();
        
        assertTrue(
            "Did not create Java package header correctly.",
            sw.toString().indexOf( "package a;" ) >= 0 );
        assertTrue(
            "Did not create Java class definition header correctly.",
            sw.toString().indexOf( "public class b" ) >= 0 );
    }
    
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        InterfaceTestSuite suite = IScriptMakerUTestI.suite();
        
        // all tests are covered by the interface tests, so don't need this
        // line.  But will add it for insurance in case tests are needed later.
        suite.addTestSuite( THIS_CLASS );
        
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() {
                return new JavaMaker( new StringWriter(),
                    "my.package", "MyClass" );
            }
        } );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected synchronized void tearDown() throws Exception
    {
        // tear ourself down
        
        super.tearDown();
    }
}

