/*
 * @(#)ThrowableParserUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.util.throwable.v1;

import org.easymock.EasyMock;
import org.easymock.MockControl;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.apache.log4j.Logger;


/**
 * Tests the ThrowableParser class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/02/10 22:52:43 $
 * @since     March 17, 2002
 */
public class ThrowableParserUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = ThrowableParserUTest.class;
    private static final Logger LOG = Logger.getLogger( THIS_CLASS );
    
    public ThrowableParserUTest( String name )
    {
        super( name );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testConstructor1()
    {
        try
        {
            new ThrowableParser( null );
            fail("did not throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e)
        {
            // test exception?
        }
    }
    
    
    public void testConstructor2()
    {
        new ThrowableParser( new Throwable() );
    }
    
    
    /**
     * More of a UIT than a UT...
     */
    public void testTrace1()
    {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        ThrowableParser tp = new ThrowableParser( t );
        boolean foundMe = false;
        while (true)
        {
            StackTraceLineParser stlp = tp.next();
            if (stlp == null) break;
            
            LOG.info( "Stack trace: "+stlp );
            if (stlp.getClassName().equals( this.getClass().getName() ))
            {
                LOG.debug( "foundMe == true" );
                foundMe = true;
            }
            else
            {
                LOG.debug( "stack class name '"+stlp.getClassName()+
                    "' did not match this class name '"+
                    this.getClass().getName() + "'." );
            }
        }
        LOG.debug( "foundMe == "+foundMe );
        assertTrue(
            "Did not find this class in the stack trace.",
            foundMe );
    }
    
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        // Test the implementation's interface conformity.
        /*
        suite.addTest( IxUTestI.suite(
            new ImplementationCreator[] {
                new ImplementationCreator() {
                    public Object createImplementedObject() {
                        // XXXXXXXXXXXXXXXXXXXXXXXX
                    }
                },
            } ) );
        */
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

