

#ifndef SPDATA_H
#define SPDATA_H

struct SP_C {
    char strQP[5];
    char cJP;
};

struct SP_S {
    char strQP[3];
    char cJP;
};

static const SP_C SPMap_C_MS[] = {
    {"ai", 'l'},   {"an", 'j'},  {"ang", 'h'}, {"ao", 'k'},   {"ei", 'z'},
    {"en", 'f'},   {"eng", 'g'}, {"er", 'r'},  {"ia", 'w'},   {"ian", 'm'},
    {"iang", 'd'}, {"iao", 'c'}, {"ie", 'x'},  {"in", 'n'},   {"ing", ';'},
    {"iong", 's'}, {"iu", 'q'},  {"ng", 'g'},  {"ong", 's'},  {"ou", 'b'},
    {"ua", 'w'},   {"uai", 'y'}, {"uan", 'r'}, {"uang", 'd'}, {"ue", 't'},
    {"ui", 'v'},   {"un", 'p'},  {"uo", 'o'},  {"ve", 'v'},   {"v", 'y'},
    {"\0", '\0'}};

static const SP_S SPMap_S_MS[] = {
    {"ch", 'i'}, {"sh", 'u'}, {"zh", 'v'}, {"\0", '\0'}};

static const SP_C SPMap_C_Ziguang[] = {
    {"ai", 'p'},   {"an", 'r'},  {"ang", 's'}, {"ao", 'q'},   {"ei", 'k'},
    {"en", 'w'},   {"eng", 't'}, {"er", 'j'},  {"ia", 'x'},   {"ian", 'f'},
    {"iang", 'g'}, {"iao", 'b'}, {"ie", 'd'},  {"in", 'y'},   {"ing", ';'},
    {"iong", 'h'}, {"iu", 'j'},  {"ng", 'g'},  {"ong", 'h'},  {"ou", 'z'},
    {"ua", 'x'},   {"uai", 'y'}, {"uan", 'l'}, {"uang", 'g'}, {"ue", 'n'},
    {"ui", 'n'},   {"un", 'm'},  {"uo", 'o'},  {"ve", 'n'},   {"v", 'v'},
    {"\0", '\0'}};

static const SP_S SPMap_S_Ziguang[] = {
    {"ch", 'a'}, {"sh", 'i'}, {"zh", 'u'}, {"\0", '\0'}};

static const SP_C SPMap_C_ABC[] = {
    {"ai", 'l'},   {"an", 'j'},  {"ang", 'h'}, {"ao", 'k'},   {"ei", 'q'},
    {"en", 'f'},   {"eng", 'g'}, {"er", 'r'},  {"ia", 'd'},   {"ian", 'w'},
    {"iang", 't'}, {"iao", 'z'}, {"ie", 'x'},  {"in", 'c'},   {"ing", 'y'},
    {"iong", 's'}, {"iu", 'r'},  {"ng", 'g'},  {"ong", 's'},  {"ou", 'b'},
    {"ua", 'd'},   {"uai", 'c'}, {"uan", 'p'}, {"uang", 't'}, {"ue", 'm'},
    {"ui", 'm'},   {"un", 'n'},  {"uo", 'o'},  {"ve", 'm'},   {"v", 'v'},
    {"\0", '\0'}};

static const SP_S SPMap_S_ABC[] = {
    {"ch", 'e'}, {"sh", 'v'}, {"zh", 'a'}, {"\0", '\0'}};

static const SP_C SPMap_C_Zhongwenzhixing[] = {
    {"ai", 's'},   {"an", 'f'},  {"ang", 'g'}, {"ao", 'd'},   {"ei", 'w'},
    {"en", 'r'},   {"eng", 't'}, {"er", 'q'},  {"ia", 'b'},   {"ian", 'j'},
    {"iang", 'h'}, {"iao", 'k'}, {"ie", 'm'},  {"in", 'l'},   {"ing", 'q'},
    {"iong", 'y'}, {"iu", 'n'},  {"ng", 'g'},  {"ong", 'y'},  {"ou", 'p'},
    {"ua", 'b'},   {"uai", 'x'}, {"uan", 'c'}, {"uang", 'h'}, {"ue", 'x'},
    {"ui", 'v'},   {"un", 'z'},  {"uo", 'o'},  {"ve", 'x'},   {"v", 'v'},
    {"\0", '\0'}};

static const SP_S SPMap_S_Zhongwenzhixing[] = {
    {"ch", 'u'}, {"sh", 'i'}, {"zh", 'v'}, {"\0", '\0'}};

static const SP_C SPMap_C_PinyinJiaJia[] = {
    {"ai", 's'},   {"an", 'f'},  {"ang", 'g'}, {"ao", 'd'},   {"ei", 'w'},
    {"en", 'r'},   {"eng", 't'}, {"er", 'q'},  {"ia", 'b'},   {"ian", 'j'},
    {"iang", 'h'}, {"iao", 'k'}, {"ie", 'm'},  {"in", 'l'},   {"ing", 'q'},
    {"iong", 'y'}, {"iu", 'n'},  {"ng", 'g'},  {"ong", 'y'},  {"ou", 'p'},
    {"ua", 'b'},   {"uai", 'x'}, {"uan", 'c'}, {"uang", 'h'}, {"ue", 'x'},
    {"ui", 'v'},   {"un", 'z'},  {"uo", 'o'},  {"ve", 'x'},   {"v", 'v'},
    {"\0", '\0'}};

static const SP_S SPMap_S_PinyinJiaJia[] = {
    {"ch", 'u'}, {"sh", 'i'}, {"zh", 'v'}, {"\0", '\0'}};

static const SP_C SPMap_C_Ziranma[] = {
    {"ai", 'l'},   {"an", 'j'},  {"ang", 'h'}, {"ao", 'k'},   {"ei", 'z'},
    {"en", 'f'},   {"eng", 'g'}, {"er", 'r'},  {"ia", 'w'},   {"ian", 'm'},
    {"iang", 'd'}, {"iao", 'c'}, {"ie", 'x'},  {"in", 'n'},   {"ing", 'y'},
    {"iong", 's'}, {"iu", 'q'},  {"ng", 'g'},  {"ong", 's'},  {"ou", 'b'},
    {"ua", 'w'},   {"uai", 'y'}, {"uan", 'r'}, {"uang", 'd'}, {"ue", 't'},
    {"ui", 'v'},   {"un", 'p'},  {"uo", 'o'},  {"ve", 't'},   {"v", 'v'},
    {"\0", '\0'}};

static const SP_S SPMap_S_Ziranma[] = {
    {"ch", 'i'}, {"sh", 'u'}, {"zh", 'v'}, {"\0", '\0'}};

static const SP_C SPMap_C_XIAOHE[] = {
    {"ai", 'd'},  {"an", 'j'},  {"ang", 'h'},  {"ao", 'c'},  {"ei", 'w'},
    {"en", 'f'},  {"eng", 'g'}, {"ia", 'x'},   {"ian", 'm'}, {"iang", 'l'},
    {"iao", 'n'}, {"ie", 'p'},  {"in", 'b'},   {"ing", 'k'}, {"iong", 's'},
    {"iu", 'q'},  {"ng", 'g'},  {"ong", 's'},  {"ou", 'z'},  {"ua", 'x'},
    {"uai", 'k'}, {"uan", 'r'}, {"uang", 'l'}, {"ue", 't'},  {"ui", 'v'},
    {"un", 'y'},  {"uo", 'o'},  {"ve", 't'},   {"v", 'v'},   {"\0", '\0'}};

static const SP_S SPMap_S_XIAOHE[] = {
    {"ch", 'i'}, {"sh", 'u'}, {"zh", 'v'}, {"\0", '\0'}};

#endif
