package org.jboss.cache.loader;

import org.jboss.cache.AbstractSingleCacheTest;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.factories.UnitTestConfigurationFactory;
import org.jboss.cache.loader.testloaders.DummyInMemoryCacheLoader;
import org.testng.annotations.Test;

@Test(groups = "functional", testName = "loader.ParentDataLoadedTest")
public class ParentDataLoadedTest extends AbstractSingleCacheTest
{
   private static final Fqn<String> FQN = Fqn.fromElements("a", "a", "a");
   private CacheSPI<String, String> cache;

   public CacheSPI createCache() throws Exception
   {
      UnitTestCacheFactory<String, String> cf = new UnitTestCacheFactory<String, String>();
      cache = (CacheSPI<String, String>) cf.createCache("configs/local-tx.xml", false, getClass());
      cache.getConfiguration().setEvictionConfig(null);
      CacheLoaderConfig cacheLoaderConfig = UnitTestConfigurationFactory.buildSingleCacheLoaderConfig(false, "", DummyInMemoryCacheLoader.class.getName(), "", false, true, false, false, false);
      cache.getConfiguration().setCacheLoaderConfig(cacheLoaderConfig);

      cache.start();

      return cache;
   }

   public void testParents()
   {
      cache.put(FQN.getParent().getParent(), "test", "test");
      cache.put(FQN.getParent(), "test", "test");
      cache.put(FQN, "test", "test");

      cache.evict(FQN.ROOT, true);

      cache.put(FQN, "test", "new");

      assert cache.get(FQN, "test") != null;
      assert cache.get(FQN.getParent(), "test") != null;
      assert cache.get(FQN.getParent().getParent(), "test") != null;
   }
}
