/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFObject;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class PDFFont
extends PDFObject
implements Serializable {
    private final String name;
    private final String type;
    private String font;
    private String javaFont;
    private final int style;
    private static final String[][] base14 = new String[][]{{"Arial", "/Helvetica", "/Helvetica-Bold", "/Helvetica-Oblique", "/Helvetica-BoldOblique"}, {"SansSerif", "/Helvetica", "/Helvetica-Bold", "/Helvetica-Oblique", "/Helvetica-BoldOblique"}, {"Dialog", "/Helvetica", "/Helvetica-Bold", "/Helvetica-Oblique", "/Helvetica-BoldOblique"}, {"DialogInput", "/Helvetica", "/Helvetica-Bold", "/Helvetica-Oblique", "/Helvetica-BoldOblique"}, {"Monospaced", "/Courier", "/Courier-Bold", "/Courier-Oblique", "/Courier-BoldOblique"}, {"Serif", "/Times-Roman", "/Times-Bold", "/Times-Italic", "/Times-BoldItalic"}, {"Times", "/Times-Roman", "/Times-Bold", "/Times-Italic", "/Times-BoldItalic"}, {"Times New Roman", "/Times-Roman", "/Times-Bold", "/Times-Italic", "/Times-BoldItalic"}, {"Courier", "/Courier", "/Courier-Bold", "/Courier-Oblique", "/Courier-BoldOblique"}, {"Helvetica", "/Helvetica", "/Helvetica-Bold", "/Helvetica-Oblique", "/Helvetica-BoldOblique"}};

    protected PDFFont() {
        this("/F1", "/Type1", "Helvetica", 0);
    }

    public PDFFont(String string, String string2, String string3, int n) {
        super("/Font");
        this.name = string;
        this.type = string2;
        this.style = n;
        String string4 = string3.toLowerCase();
        this.font = base14[0][1];
        this.javaFont = base14[0][0];
        for (String[] stringArray : base14) {
            if (!stringArray[0].equals(string4)) continue;
            this.javaFont = stringArray[0];
            this.font = stringArray[1 + n];
            break;
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String getFont() {
        return this.font;
    }

    public int getStyle() {
        return this.style;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.writeStart(outputStream);
        outputStream.write("/Subtype ".getBytes());
        outputStream.write(this.type.getBytes());
        outputStream.write("\n/Name ".getBytes());
        outputStream.write(this.name.getBytes());
        outputStream.write("\n/BaseFont ".getBytes());
        outputStream.write(this.font.getBytes());
        outputStream.write("\n/Encoding ".getBytes());
        outputStream.write("/WinAnsiEncoding".getBytes());
        outputStream.write("\n".getBytes());
        this.writeEnd(outputStream);
    }

    protected boolean equals(String string, String string2, int n) {
        return this.type.equals(string) && (this.font.equalsIgnoreCase(string2) || this.javaFont.equalsIgnoreCase(string2));
    }
}

