/*
    Copyright (C) 2019 German Tischler-Höhle

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <libmaus2/exception/LibMausException.hpp>
#include <libmaus2/parallel/PosixSpinLock.hpp>

std::ostream & libmaus2::exception::LibMausException::print(std::ostream & out, libmaus2::parallel::PosixSpinLock & lock)
{
	libmaus2::parallel::ScopePosixSpinLock slock(lock);
	out << what() << std::endl;
	return out;
}
