// auto-generated by keccak.py

static const uint64_t roundconstant[24] = {
  0x0000000000000001,
  0x0000000000008082,
  0x800000000000808a,
  0x8000000080008000,
  0x000000000000808b,
  0x0000000080000001,
  0x8000000080008081,
  0x8000000000008009,
  0x000000000000008a,
  0x0000000000000088,
  0x0000000080008009,
  0x000000008000000a,
  0x000000008000808b,
  0x800000000000008b,
  0x8000000000008089,
  0x8000000000008003,
  0x8000000000008002,
  0x8000000000000080,
  0x000000000000800a,
  0x800000008000000a,
  0x8000000080008081,
  0x8000000000008080,
  0x0000000080000001,
  0x8000000080008008,
} ;

static void keccak(uint64_t *s)
{
  uint64_t s00 = s[0];
  uint64_t s01 = s[1];
  uint64_t s02 = s[2];
  uint64_t s03 = s[3];
  uint64_t s04 = s[4];
  uint64_t s10 = s[5];
  uint64_t s11 = s[6];
  uint64_t s12 = s[7];
  uint64_t s13 = s[8];
  uint64_t s14 = s[9];
  uint64_t s20 = s[10];
  uint64_t s21 = s[11];
  uint64_t s22 = s[12];
  uint64_t s23 = s[13];
  uint64_t s24 = s[14];
  uint64_t s30 = s[15];
  uint64_t s31 = s[16];
  uint64_t s32 = s[17];
  uint64_t s33 = s[18];
  uint64_t s34 = s[19];
  uint64_t s40 = s[20];
  uint64_t s41 = s[21];
  uint64_t s42 = s[22];
  uint64_t s43 = s[23];
  uint64_t s44 = s[24];
  uint64_t B0,B1,B2,B3,B4;
  uint64_t D0,D1,D2,D3,D4;
  uint64_t t00,t01,t02,t03,t04,t10,t11,t12,t13,t14,t20,t21,t22,t23,t24,t30,t31,t32,t33,t34,t40,t41,t42,t43,t44;

  for (int n = 0;n < 24;++n) {
    B0 = s00^s10^s20^s30^s40;
    B1 = s01^s11^s21^s31^s41;
    B2 = s02^s12^s22^s32^s42;
    B3 = s03^s13^s23^s33^s43;
    B4 = s04^s14^s24^s34^s44;

    D0 = B4^ROL(B1,1);
    s00 ^= D0;
    s10 ^= D0;
    s20 ^= D0;
    s30 ^= D0;
    s40 ^= D0;
    D1 = B0^ROL(B2,1);
    s01 ^= D1;
    s11 ^= D1;
    s21 ^= D1;
    s31 ^= D1;
    s41 ^= D1;
    D2 = B1^ROL(B3,1);
    s02 ^= D2;
    s12 ^= D2;
    s22 ^= D2;
    s32 ^= D2;
    s42 ^= D2;
    D3 = B2^ROL(B4,1);
    s03 ^= D3;
    s13 ^= D3;
    s23 ^= D3;
    s33 ^= D3;
    s43 ^= D3;
    D4 = B3^ROL(B0,1);
    s04 ^= D4;
    s14 ^= D4;
    s24 ^= D4;
    s34 ^= D4;
    s44 ^= D4;
    t20 = ROL(s01,1);
    t12 = ROL(s20,3);
    t21 = ROL(s12,6);
    t32 = ROL(s21,10);
    t33 = ROL(s32,15);
    t03 = ROL(s33,21);
    t10 = ROL(s03,28);
    t31 = ROL(s10,36);
    t13 = ROL(s31,45);
    t41 = ROL(s13,55);
    t44 = ROL(s41,2);
    t04 = ROL(s44,14);
    t30 = ROL(s04,27);
    t43 = ROL(s30,41);
    t34 = ROL(s43,56);
    t23 = ROL(s34,8);
    t22 = ROL(s23,25);
    t02 = ROL(s22,43);
    t40 = ROL(s02,62);
    t24 = ROL(s40,18);
    t42 = ROL(s24,39);
    t14 = ROL(s42,61);
    t11 = ROL(s14,20);
    t01 = ROL(s11,44);
    t00 = s00;

    s00 = t00^(t02&~t01);
    s01 = t01^(t03&~t02);
    s02 = t02^(t04&~t03);
    s03 = t03^(t00&~t04);
    s04 = t04^(t01&~t00);
    s10 = t10^(t12&~t11);
    s11 = t11^(t13&~t12);
    s12 = t12^(t14&~t13);
    s13 = t13^(t10&~t14);
    s14 = t14^(t11&~t10);
    s20 = t20^(t22&~t21);
    s21 = t21^(t23&~t22);
    s22 = t22^(t24&~t23);
    s23 = t23^(t20&~t24);
    s24 = t24^(t21&~t20);
    s30 = t30^(t32&~t31);
    s31 = t31^(t33&~t32);
    s32 = t32^(t34&~t33);
    s33 = t33^(t30&~t34);
    s34 = t34^(t31&~t30);
    s40 = t40^(t42&~t41);
    s41 = t41^(t43&~t42);
    s42 = t42^(t44&~t43);
    s43 = t43^(t40&~t44);
    s44 = t44^(t41&~t40);
    s00 ^= roundconstant[n];
  }

  s[0] = s00;
  s[1] = s01;
  s[2] = s02;
  s[3] = s03;
  s[4] = s04;
  s[5] = s10;
  s[6] = s11;
  s[7] = s12;
  s[8] = s13;
  s[9] = s14;
  s[10] = s20;
  s[11] = s21;
  s[12] = s22;
  s[13] = s23;
  s[14] = s24;
  s[15] = s30;
  s[16] = s31;
  s[17] = s32;
  s[18] = s33;
  s[19] = s34;
  s[20] = s40;
  s[21] = s41;
  s[22] = s42;
  s[23] = s43;
  s[24] = s44;
}
