/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.websvc.wsitmodelext.addressing.impl;

import org.netbeans.modules.websvc.wsitmodelext.addressing.Addressing10ReferenceProperties;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.w3c.dom.Element;

/**
 *
 * @author Martin Grebac
 */
public class Addressing10ReferencePropertiesImpl extends Addressing10ComponentImpl implements Addressing10ReferenceProperties {
    
    /**
     * Creates a new instance of AddressImpl
     */
    public Addressing10ReferencePropertiesImpl(WSDLModel model, Element e) {
        super(model, e);
    }
    
    public void setReferenceProperties(String referenceProperties) {
        setText(REFERENCEPROPERTIES_CONTENT_VALUE_PROPERTY, referenceProperties);
    }

    public String getReferenceProperties() {
        return getText();
    }
    
}
