/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.java.openjdk.project.customizer;

import javax.swing.JComponent;
import org.netbeans.modules.java.openjdk.project.JDKProject;
import org.netbeans.modules.java.openjdk.project.Settings;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;

/**
 *
 * @author lahvac
 */
public class BuildCategory extends javax.swing.JPanel {

    /**
     * Creates new form BuildCategory
     */
    public BuildCategory(boolean useAntBuild, String antBuildLocation) {
        initComponents();
        this.useAntBuild.setSelected(useAntBuild);
        this.antBuildLocation.setText(antBuildLocation);
        updateEnableDisable();
    }

    private void updateEnableDisable() {
        antBuildLocationLabel.setEnabled(useAntBuild.isSelected());
        antBuildLocation.setEnabled(useAntBuild.isSelected());
    }
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        useAntBuild = new javax.swing.JCheckBox();
        antBuildLocationLabel = new javax.swing.JLabel();
        antBuildLocation = new javax.swing.JTextField();

        org.openide.awt.Mnemonics.setLocalizedText(useAntBuild, org.openide.util.NbBundle.getMessage(BuildCategory.class, "BuildCategory.useAntBuild.text")); // NOI18N
        useAntBuild.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                useAntBuildActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(antBuildLocationLabel, org.openide.util.NbBundle.getMessage(BuildCategory.class, "BuildCategory.antBuildLocationLabel.text")); // NOI18N

        antBuildLocation.setText(org.openide.util.NbBundle.getMessage(BuildCategory.class, "BuildCategory.antBuildLocation.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(21, 21, 21)
                        .addComponent(antBuildLocationLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(antBuildLocation))
                    .addComponent(useAntBuild, javax.swing.GroupLayout.DEFAULT_SIZE, 380, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(useAntBuild)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(antBuildLocationLabel)
                    .addComponent(antBuildLocation, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(244, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void useAntBuildActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_useAntBuildActionPerformed
        updateEnableDisable();
    }//GEN-LAST:event_useAntBuildActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField antBuildLocation;
    private javax.swing.JLabel antBuildLocationLabel;
    private javax.swing.JCheckBox useAntBuild;
    // End of variables declaration//GEN-END:variables

    @ProjectCustomizer.CompositeCategoryProvider.Registration(projectType=JDKProject.PROJECT_KEY, position=100)
    public static ProjectCustomizer.CompositeCategoryProvider createCategoryProvider() {
        return new ProjectCustomizer.CompositeCategoryProvider() {
            @Override
            public ProjectCustomizer.Category createCategory(Lookup context) {
                if (context.lookup(Settings.class) != null)
                    return ProjectCustomizer.Category.create("build", "Build", null);
                return null;
            }
            @Override
            public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
                Settings settings = context.lookup(Settings.class);
                BuildCategory panel = new BuildCategory(settings.isUseAntBuild(), settings.getAntBuildLocation());
                category.setOkButtonListener(evt -> {
                    settings.setUseAntBuild(panel.useAntBuild.isSelected());
                    settings.setAntBuildLocation(panel.antBuildLocation.getText());
                });
                category.setStoreListener(evt -> settings.flush());
                return panel;
            }
        };
    }
}
