/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Color;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeSelectionModel;
import org.netbeans.api.autoupdate.UpdateElement;

/**
 *
 * @author  Jiri Rechtacek
 */
public class ValidationWarningPanel extends javax.swing.JPanel {
    
    /** Creates new form ValidationWarningPanel */
    public ValidationWarningPanel (List<UpdateElement> signedVerified, List<UpdateElement> signedUnverified, List<UpdateElement> unsigned, List<UpdateElement> modified, int total) {
        pluginModelRoot = new DefaultMutableTreeNode("Third-party Plugins");
        pluginsModel = new DefaultTreeModel(pluginModelRoot);
        initComponents ();
        tPlugins.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
        taHead.setBackground( new Color(0,0,0,0) );
        taHead.setBorder(BorderFactory.createEmptyBorder());
        taWarning.setBackground( new Color(0,0,0,0) );
        taWarning.setBorder(BorderFactory.createEmptyBorder());
        taError.setVisible(! modified.isEmpty());
        taHead.setVisible(modified.isEmpty());
        postInitComponents (signedVerified, signedUnverified, unsigned, modified, total);
    }
    
    private void postInitComponents (List<UpdateElement> signedVerified, List<UpdateElement> signedUnverified, List<UpdateElement> unsigned, List<UpdateElement> modified, int total) {
        DefaultMutableTreeNode signedAndValidNode = new DefaultMutableTreeNode("Signed and Valid (" + signedVerified.size() + ")");
        DefaultMutableTreeNode selfSignedNode = new DefaultMutableTreeNode("Self signed (" + signedUnverified.size() + ")");
        DefaultMutableTreeNode unsignedNode = new DefaultMutableTreeNode("Unsigned (" + unsigned.size() + ")");
        DefaultMutableTreeNode modifiedNode = new DefaultMutableTreeNode("Modified/Damaged (" + modified.size() + ")");
        
        for (UpdateElement el : signedVerified) {
            signedAndValidNode.add(new DefaultMutableTreeNode(el.getDisplayName()));
        }
        pluginModelRoot.add(signedAndValidNode);
        
        for (UpdateElement el : signedUnverified) {
            selfSignedNode.add(new DefaultMutableTreeNode(el.getDisplayName()));
        }       
        pluginModelRoot.add(selfSignedNode);
        
        for (UpdateElement el : unsigned) {
            unsignedNode.add(new DefaultMutableTreeNode(el.getDisplayName()));
        } 
        pluginModelRoot.add(unsignedNode);

        for (UpdateElement el : modified) {
            modifiedNode.add(new DefaultMutableTreeNode(el.getDisplayName()));
        }
        pluginModelRoot.add(modifiedNode);

        pluginsModel.reload();
        
        int requiresAttention = signedVerified.size() + signedUnverified.size() + unsigned.size();

        if (requiresAttention > 1) {
            taHead.setText(org.openide.util.NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taHead_NotTrustedTextPl",
                    requiresAttention, total));
        } else {
            taHead.setText(org.openide.util.NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taHead_NotTrustedTextSg", 
                    requiresAttention, total));
        }

        if(modified.size() > 0) {
            
        }
    }
    
    public String getSelectedNode() {
        Object o = tPlugins.getLastSelectedPathComponent();
        return o == null ? "" : o.toString();
    }
    
    public void addSelectionListener(TreeSelectionListener tsl) {
        tPlugins.getSelectionModel().addTreeSelectionListener(tsl);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        taHead = new javax.swing.JTextArea();
        taError = new javax.swing.JTextArea();
        spPlugins = new javax.swing.JScrollPane();
        tPlugins = new javax.swing.JTree();
        taWarning = new javax.swing.JTextArea();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(6, 6, 6, 6));
        setMinimumSize(new java.awt.Dimension(480, 400));
        setPreferredSize(new java.awt.Dimension(480, 400));
        setRequestFocusEnabled(false);
        setLayout(new java.awt.GridBagLayout());

        taHead.setEditable(false);
        taHead.setLineWrap(true);
        taHead.setWrapStyleWord(true);
        taHead.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 3, 0);
        add(taHead, gridBagConstraints);
        taHead.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taHead_ACN")); // NOI18N
        taHead.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taHead_ACN")); // NOI18N

        taError.setEditable(false);
        taError.setForeground(new java.awt.Color(204, 0, 18));
        taError.setLineWrap(true);
        taError.setText(org.openide.util.NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel.taError.text")); // NOI18N
        taError.setWrapStyleWord(true);
        taError.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 3, 0);
        add(taError, gridBagConstraints);

        tPlugins.setModel(pluginsModel);
        spPlugins.setViewportView(tPlugins);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(spPlugins, gridBagConstraints);

        taWarning.setEditable(false);
        taWarning.setLineWrap(true);
        taWarning.setText(org.openide.util.NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taWarning_Text")); // NOI18N
        taWarning.setWrapStyleWord(true);
        taWarning.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(taWarning, gridBagConstraints);
        taWarning.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taWarning_Text_ACN")); // NOI18N
        taWarning.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taWarning_Text_ACD")); // NOI18N

        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_ACD")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane spPlugins;
    private javax.swing.JTree tPlugins;
    private javax.swing.JTextArea taError;
    private javax.swing.JTextArea taHead;
    private javax.swing.JTextArea taWarning;
    // End of variables declaration//GEN-END:variables
    
    private final DefaultMutableTreeNode pluginModelRoot;
    private final DefaultTreeModel pluginsModel;
}
