# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20231210185945;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '1534[0-24-8]\\d{5}',
                'geographic' => '1534[0-24-8]\\d{5}',
                'mobile' => '
          7(?:
            (?:
              (?:
                50|
                82
              )9|
              937
            )\\d|
            7(?:
              00[378]|
              97[7-9]
            )
          )\\d{5}
        ',
                'pager' => '
          76(?:
            464|
            652
          )\\d{5}|
          76(?:
            0[0-28]|
            2[356]|
            34|
            4[01347]|
            5[49]|
            6[0-369]|
            77|
            8[14]|
            9[139]
          )\\d{6}
        ',
                'personal_number' => '701511\\d{4}',
                'specialrate' => '(
          (?:
            8(?:
              4(?:
                4(?:
                  4(?:
                    05|
                    42|
                    69
                  )|
                  703
                )|
                5(?:
                  041|
                  800
                )
              )|
              7(?:
                0002|
                1206
              )
            )|
            90(?:
              066[59]|
              1810|
              71(?:
                07|
                55
              )
            )
          )\\d{4}
        )|(
          (?:
            3(?:
              0(?:
                07(?:
                  35|
                  81
                )|
                8901
              )|
              3\\d{4}|
              4(?:
                4(?:
                  4(?:
                    05|
                    42|
                    69
                  )|
                  703
                )|
                5(?:
                  041|
                  800
                )
              )|
              7(?:
                0002|
                1206
              )
            )|
            55\\d{4}
          )\\d{4}
        )',
                'toll_free' => '
          80(?:
            07(?:
              35|
              81
            )|
            8901
          )\\d{4}
        ',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"441918", "Tyneside",
"441924", "Wakefield",
"441550", "Llandovery",
"4414349", "Bellingham",
"441709", "Rotherham",
"441636", "Newark\-on\-Trent",
"441205", "Boston",
"44247", "Coventry",
"441254", "Blackburn",
"441443", "Pontypridd",
"441290", "Cumnock",
"441379", "Diss",
"441594", "Lydney",
"441371", "Great\ Dunmow",
"441144", "Sheffield",
"441490", "Corwen",
"441896", "Galashiels",
"441243", "Chichester",
"441454", "Chipping\ Sodbury",
"441405", "Goole",
"442880", "Carrickmore",
"441624", "Isle\ of\ Man",
"4412295", "Barrow\-in\-Furness",
"441492", "Colwyn\ Bay",
"441233", "Ashford\ \(Kent\)",
"44115", "Nottingham",
"4418908", "Coldstream",
"441946", "Whitehaven",
"442882", "Omagh",
"441761", "Temple\ Cloud",
"441457", "Glossop",
"441285", "Cirencester",
"441465", "Girvan",
"441789", "Stratford\-upon\-Avon",
"441428", "Haslemere",
"441228", "Carlisle",
"4414379", "Haverfordwest",
"441769", "South\ Molton",
"441485", "Hunstanton",
"441257", "Coppull",
"441675", "Coleshill",
"4413396", "Ballater",
"441646", "Milford\ Haven",
"441859", "Harris",
"441433", "Hathersage",
"441597", "Llandrindod\ Wells",
"4418904", "Coldstream",
"441292", "Ayr",
"4414305", "North\ Cave",
"4418472", "Thurso",
"442895", "Belfast",
"4415242", "Hornby",
"442825", "Ballymena",
"441366", "Downham\ Market",
"441952", "Telford",
"442868", "Kesh",
"441844", "Thame",
"441558", "Llandeilo",
"441910", "Tyneside\/Durham\/Sunderland",
"441837", "Okehampton",
"441527", "Redditch",
"441997", "Strathpeffer",
"441298", "Buxton",
"441239", "Cardigan",
"441431", "Helmsdale",
"4414348", "Hexham",
"441439", "Helmsley",
"441697", "Brampton",
"441546", "Lochgilphead",
"441422", "Halifax",
"441763", "Royston",
"441575", "Kirriemuir",
"442877", "Limavady",
"4414344", "Bellingham",
"442888", "Northern\ Ireland",
"441652", "Brigg",
"441386", "Evesham",
"441241", "Arbroath",
"441694", "Church\ Stretton",
"4418909", "Ayton",
"441449", "Stowmarket",
"4419752", "Alford\ \(Aberdeen\)",
"441373", "Frome",
"4414374", "Clynderwen\ \(Clunderwen\)",
"4416863", "Llanidloes",
"441420", "Alton",
"441536", "Kettering",
"4418512", "Stornoway",
"4414235", "Harrogate",
"441650", "Cemmaes\ Road",
"441950", "Sandwick",
"441834", "Narberth",
"441524", "Lancaster",
"441306", "Dorking",
"441912", "Tyneside",
"4420", "London",
"4414378", "Haverfordwest",
"441776", "Stranraer",
"441249", "Chippenham",
"441994", "St\ Clears",
"4413391", "Aboyne\/Ballater",
"441745", "Rhyl",
"441630", "Market\ Drayton",
"441368", "Dunbar",
"44287", "Northern\ Ireland",
"441642", "Middlesbrough",
"4419754", "Alford\ \(Aberdeen\)",
"44114703", "Sheffield",
"4419641", "Hornsea\/Patrington",
"442866", "Enniskillen",
"441325", "Darlington",
"441556", "Castle\ Douglas",
"4418479", "Tongue",
"4415395", "Grange\-over\-Sands",
"441784", "Staines",
"4418514", "Great\ Bernera",
"4414372", "Clynderwen\ \(Clunderwen\)",
"441296", "Aylesbury",
"441843", "Thanet",
"4419758", "Strathdon",
"441496", "Port\ Ellen",
"441764", "Crieff",
"441707", "Welwyn\ Garden\ City",
"441548", "Kingsbridge",
"4417687", "Keswick",
"4412297", "Millom",
"442886", "Cookstown",
"441942", "Wigan",
"441377", "Driffield",
"441805", "Torrington",
"4418518", "Stornoway",
"441388", "Bishop\ Auckland",
"441854", "Ullapool",
"441259", "Alloa",
"441767", "Sandy",
"441704", "Southport",
"441451", "Stow\-on\-the\-Wold",
"441892", "Tunbridge\ Wells",
"441621", "Maldon",
"441929", "Wareham",
"441828", "Coupar\ Angus",
"441141", "Sheffield",
"441538", "Ipstones",
"441599", "Kyle",
"441865", "Oxford",
"441857", "Sanday",
"441932", "Weybridge",
"441993", "Witney",
"441591", "Llanwrtyd\ Wells",
"441308", "Bridport",
"4414230", "Harrogate\/Boroughbridge",
"441885", "Pencombe",
"4414342", "Bellingham",
"4415076", "Louth",
"441629", "Matlock",
"441778", "Bourne",
"441787", "Sudbury",
"441833", "Barnard\ Castle",
"4414307", "Market\ Weighton",
"441916", "Tyneside",
"4412290", "Barrow\-in\-Furness\/Millom",
"441302", "Doncaster",
"441593", "Lybster",
"441444", "Haywards\ Heath",
"441360", "Killearn",
"441638", "Newmarket",
"44141", "Glasgow",
"4419646", "Patrington",
"44113", "Leeds",
"441772", "Preston",
"441253", "Blackpool",
"441923", "Watford",
"4418478", "Thurso",
"442879", "Magherafelt",
"441623", "Mansfield",
"442311", "Southampton",
"442871", "Londonderry",
"4413882", "Stanhope\ \(Eastgate\)",
"441453", "Dursley",
"4418519", "Great\ Bernera",
"441529", "Sleaford",
"44121", "Birmingham",
"4419759", "Alford\ \(Aberdeen\)",
"441380", "Devizes",
"441938", "Welshpool",
"441691", "Oswestry",
"441244", "Chester",
"441822", "Tavistock",
"441540", "Kingussie",
"441237", "Bideford",
"4418474", "Thurso",
"441143", "Sheffield",
"4418902", "Coldstream",
"4414300", "North\ Cave\/Market\ Weighton",
"441382", "Dundee",
"441234", "Bedford",
"441948", "Whitchurch",
"441656", "Bridgend",
"441542", "Keith",
"441530", "Coalville",
"4414237", "Harrogate",
"441226", "Barnsley",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441300", "Cerne\ Abbas",
"441362", "Dereham",
"441841", "Newquay\ \(Padstow\)",
"441770", "Isle\ of\ Arran",
"4416974", "Raughton\ Head",
"441395", "Budleigh\ Salterton",
"441747", "Shaftesbury",
"441323", "Eastbourne",
"441845", "Thirsk",
"442824", "Northern\ Ireland",
"441876", "Lochmaddy",
"441902", "Wolverhampton",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"441508", "Brooke",
"441980", "Amesbury",
"441270", "Crewe",
"4412296", "Barrow\-in\-Furness",
"4414343", "Haltwhistle",
"441803", "Torquay",
"441726", "St\ Austell",
"4419640", "Hornsea\/Patrington",
"442846", "Northern\ Ireland",
"441982", "Builth\ Wells",
"4416864", "Llanidloes",
"4414373", "Clynderwen\ \(Clunderwen\)",
"441348", "Fishguard",
"441588", "Bishops\ Castle",
"441753", "Slough",
"441577", "Kinross",
"441600", "Monmouth",
"4414231", "Harrogate\/Boroughbridge",
"441695", "Skelmersdale",
"441863", "Ardgay",
"441737", "Redhill",
"4416868", "Newtown",
"4414306", "Market\ Weighton",
"441883", "Caterham",
"441744", "St\ Helens",
"4415077", "Louth",
"441995", "Garstang",
"441835", "St\ Boswells",
"441525", "Leighton\ Buzzard",
"441900", "Workington",
"441568", "Leominster",
"441472", "Grimsby",
"4413395", "Aboyne",
"441962", "Winchester",
"442827", "Ballymoney",
"441356", "Brechin",
"442897", "Saintfield",
"4419647", "Patrington",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"44118", "Reading",
"441869", "Bicester",
"441968", "Penicuik",
"441925", "Warrington",
"44291", "Cardiff",
"441677", "Bedale",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"441267", "Carmarthen",
"441204", "Bolton",
"441487", "Warboys",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"441255", "Clacton\-on\-Sea",
"441562", "Kidderminster",
"441759", "Pocklington",
"441455", "Hinckley",
"441278", "Bridgwater",
"441582", "Luton",
"441467", "Inverurie",
"441404", "Honiton",
"441287", "Guisborough",
"441751", "Pickering",
"441330", "Banchory",
"441668", "Bamburgh",
"441342", "East\ Grinstead",
"441625", "Macclesfield",
"441977", "Pontefract",
"441988", "Wigtown",
"441889", "Rugeley",
"44116", "Leicester",
"441145", "Sheffield",
"4412291", "Barrow\-in\-Furness\/Millom",
"441608", "Chipping\ Norton",
"441580", "Cranbrook",
"441974", "Llanon",
"4414236", "Harrogate",
"441796", "Pitlochry",
"441332", "Derby",
"441340", "Craigellachie\ \(Aberlour\)",
"441284", "Bury\ St\ Edmunds",
"441407", "Holyhead",
"441464", "Insch",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441329", "Fareham",
"4418903", "Coldstream",
"441809", "Tomdoun",
"442894", "Antrim",
"441484", "Huddersfield",
"441264", "Andover",
"441207", "Consett",
"4414301", "North\ Cave\/Market\ Weighton",
"441502", "Lowestoft",
"4416869", "Newtown",
"441908", "Milton\ Keynes",
"441560", "Moscow",
"441674", "Montrose",
"441397", "Fort\ William",
"441352", "Mold",
"44114704", "Sheffield",
"441870", "Isle\ of\ Benbecula",
"441476", "Grantham",
"441445", "Gairloch",
"4415396", "Sedbergh",
"441245", "Chelmsford",
"441276", "Camberley",
"441749", "Shepton\ Mallet",
"441666", "Malmesbury",
"4418473", "Thurso",
"442830", "Newry",
"441986", "Bungay",
"442842", "Kircubbin",
"441720", "Isles\ of\ Scilly",
"441403", "Horsham",
"441235", "Abingdon",
"441606", "Northwich",
"441798", "Pulborough",
"442840", "Banbridge",
"441722", "Salisbury",
"441283", "Burton\-on\-Trent",
"441571", "Lochinver",
"441463", "Inverness",
"442829", "Kilrea",
"442821", "Martinstown",
"441673", "Market\ Rasen",
"4415075", "Spilsby\ \(Horncastle\)",
"441483", "Guildford",
"441263", "Cromer",
"441394", "Felixstowe",
"441579", "Liskeard",
"4416973", "Wigton",
"441350", "Dunkeld",
"4413397", "Ballater",
"442893", "Ballyclare",
"441872", "Truro",
"441435", "Heathfield",
"441469", "Killingholme",
"4419645", "Hornsea",
"441289", "Berwick\-upon\-Tweed",
"441261", "Banff",
"441481", "Guernsey",
"441785", "Stafford",
"441671", "Newton\ Stewart",
"442823", "Northern\ Ireland",
"4418513", "Stornoway",
"4416862", "Llanidloes",
"441733", "Peterborough",
"441324", "Falkirk",
"4419753", "Strathdon",
"441878", "Lochboisdale",
"441887", "Aberfeldy",
"442891", "Bangor\ \(Co\.\ Down\)",
"441506", "Bathgate",
"442838", "Portadown",
"442899", "Northern\ Ireland",
"441792", "Swansea",
"441855", "Ballachulish",
"44238", "Southampton",
"441971", "Scourie",
"441765", "Ripon",
"441461", "Gretna",
"441573", "Kelso",
"441757", "Selby",
"441728", "Saxmundham",
"441269", "Ammanford",
"441489", "Bishops\ Waltham",
"441864", "Abington\ \(Crawford\)",
"441807", "Ballindalloch",
"441375", "Grays\ Thurrock",
"442848", "Northern\ Ireland",
"4413390", "Aboyne\/Ballater",
"441346", "Fraserburgh",
"441586", "Campbeltown",
"441790", "Spilsby",
"441754", "Skegness",
"441209", "Redruth",
"441409", "Holsworthy",
"441743", "Shrewsbury",
"441566", "Launceston",
"441327", "Daventry",
"441884", "Tiverton",
"441358", "Ellon",
"441752", "Plymouth",
"441895", "Uxbridge",
"441581", "New\ Luce",
"441273", "Brighton",
"441569", "Stonehaven",
"441983", "Isle\ of\ Wight",
"441341", "Barmouth",
"441663", "New\ Mills",
"441797", "Rye",
"44114709", "Sheffield",
"441862", "Tain",
"441406", "Holbeach",
"4415074", "Alford\ \(Lincs\)",
"441935", "Yeovil",
"441320", "Fort\ Augustus",
"441635", "Newbury",
"441206", "Colchester",
"441882", "Kinloch\ Rannoch",
"4416867", "Llanidloes",
"441683", "Moffat",
"441963", "Wincanton",
"441349", "Dingwall",
"441561", "Laurencekirk",
"4415078", "Alford\ \(Lincs\)",
"441473", "Ipswich",
"441676", "Meriden",
"441322", "Dartford",
"4418471", "Thurso\/Tongue",
"4419649", "Hornsea",
"441880", "Tarbert",
"442896", "Belfast",
"441501", "Harthill",
"441398", "Dulverton",
"441903", "Worthing",
"441750", "Selkirk",
"441603", "Norwich",
"4419756", "Strathdon",
"441509", "Loughborough",
"441466", "Huntly",
"441286", "Caernarfon",
"4418516", "Great\ Bernera",
"441794", "Romsey",
"441945", "Wisbech",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"441724", "Scunthorpe",
"4416860", "Newtown\/Llanidloes",
"441909", "Worksop",
"442847", "Northern\ Ireland",
"441808", "Tomatin",
"441545", "Llanarth",
"441576", "Lockerbie",
"441357", "Strathaven",
"441874", "Brecon",
"4415079", "Alford\ \(Lincs\)",
"442826", "Northern\ Ireland",
"441328", "Fakenham",
"441609", "Northallerton",
"441736", "Penzance",
"441392", "Exeter",
"441503", "Looe",
"441354", "Chatteris",
"441888", "Turriff",
"441305", "Dorchester",
"441877", "Callander",
"4413392", "Aboyne",
"441563", "Kilmarnock",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"441775", "Spalding",
"4418476", "Tongue",
"441279", "Bishops\ Stortford",
"441746", "Bridgnorth",
"441669", "Rothbury",
"4419648", "Hornsea",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"441989", "Ross\-on\-Wye",
"441343", "Elgin",
"4418511", "Great\ Bernera\/Stornoway",
"441969", "Leyburn",
"441661", "Prudhoe",
"441981", "Wormbridge",
"441689", "Orpington",
"441727", "St\ Albans",
"441479", "Grantown\-on\-Spey",
"441758", "Pwllheli",
"441271", "Barnstaple",
"441583", "Carradale",
"442837", "Armagh",
"441535", "Keighley",
"441825", "Uckfield",
"44281", "Northern\ Ireland",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"442844", "Downpatrick",
"4419644", "Patrington",
"4413394", "Ballater",
"441495", "Pontypool",
"442885", "Ballygawley",
"441347", "Easingwold",
"441400", "Honington",
"441806", "Shetland",
"441972", "Glenborrodale",
"441334", "St\ Andrews",
"4418906", "Ayton",
"441723", "Scarborough",
"441282", "Burnley",
"441578", "Lauder",
"441462", "Hitchin",
"4413398", "Aboyne",
"441567", "Killin",
"441482", "Kingston\-upon\-Hull",
"441555", "Lanark",
"441262", "Bridlington",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441200", "Clitheroe",
"442828", "Larne",
"441672", "Marlborough",
"441326", "Falmouth",
"441295", "Banbury",
"441873", "Abergavenny",
"441799", "Saffron\ Walden",
"4419642", "Hornsea",
"441738", "Perth",
"4416865", "Newtown",
"442892", "Lisburn",
"4414233", "Boroughbridge",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"441260", "Congleton",
"441480", "Huntingdon",
"441564", "Lapworth",
"441202", "Bournemouth",
"44283", "Northern\ Ireland",
"441670", "Morpeth",
"441748", "Richmond",
"441353", "Ely",
"442890", "Belfast",
"442843", "Newcastle\ \(Co\.\ Down\)",
"441756", "Skipton",
"44114702", "Sheffield",
"441337", "Ladybank",
"441970", "Aberystwyth",
"441584", "Ludlow",
"441344", "Bracknell",
"441460", "Chard",
"441280", "Buckingham",
"441866", "Kilchrenan",
"44131", "Edinburgh",
"442841", "Rostrevor",
"4418901", "Coldstream\/Ayton",
"441359", "Pakenham",
"441570", "Lampeter",
"441984", "Watchet\ \(Williton\)",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441664", "Melton\ Mowbray",
"441408", "Golspie",
"441274", "Bradford",
"4414303", "North\ Cave",
"441474", "Gravesend",
"442820", "Ballycastle",
"441208", "Bodmin",
"441684", "Malvern",
"441915", "Sunderland",
"44292", "Cardiff",
"4413873", "Langholm",
"442849", "Northern\ Ireland",
"4413399", "Ballater",
"441730", "Petersfield",
"4414376", "Haverfordwest",
"441687", "Mallaig",
"441678", "Bala",
"441955", "Wick",
"442822", "Northern\ Ireland",
"441967", "Strontian",
"441904", "York",
"441225", "Bath",
"441729", "Settle",
"441477", "Holmes\ Chapel",
"441268", "Basildon",
"441488", "Hungerford",
"442898", "Belfast",
"4415072", "Spilsby\ \(Horncastle\)",
"4412293", "Millom",
"44114701", "Sheffield",
"4417683", "Appleby",
"4414346", "Hexham",
"441740", "Sedgefield",
"441732", "Sevenoaks",
"44117", "Bristol",
"441871", "Castlebay",
"441793", "Swindon",
"441879", "Scarinish",
"441572", "Oakham",
"441288", "Bude",
"441277", "Brentwood",
"441425", "Ringwood",
"44241", "Coventry",
"441721", "Peebles",
"441987", "Ebbsfleet",
"441978", "Wrexham",
"441655", "Maybole",
"441604", "Northampton",
"441667", "Nairn",
"4418907", "Ayton",
"441858", "Market\ Harborough",
"441384", "Dudley",
"441493", "Great\ Yarmouth",
"44280", "Northern\ Ireland",
"441827", "Tamworth",
"44151", "Liverpool",
"441544", "Kington",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441768", "Penrith",
"441725", "Rockbourne",
"441651", "Oldmeldrum",
"442883", "Northern\ Ireland",
"44114705", "Sheffield",
"441959", "Westerham",
"441951", "Colonsay",
"441659", "Sanquhar",
"441788", "Rugby",
"441777", "Retford",
"441429", "Hartlepool",
"441553", "Kings\ Lynn",
"441432", "Hereford",
"441440", "Haverhill",
"441293", "Crawley",
"441875", "Tranent",
"441364", "Ashburton",
"441307", "Forfar",
"441911", "Tyneside\/Durham\/Sunderland",
"441355", "East\ Kilbride",
"441367", "Faringdon",
"441304", "Dover",
"441526", "Martin",
"441442", "Hemel\ Hempstead",
"4414232", "Harrogate",
"441242", "Cheltenham",
"4418515", "Stornoway",
"441547", "Knighton",
"442845", "Northern\ Ireland",
"441387", "Dumfries",
"4419643", "Patrington",
"44286", "Northern\ Ireland",
"441534", "Jersey",
"441824", "Ruthin",
"441919", "Durham",
"4415394", "Hawkshead",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"441708", "Romford",
"4419755", "Alford\ \(Aberdeen\)",
"441947", "Whitby",
"441372", "Esher",
"441626", "Newton\ Abbot",
"4412292", "Barrow\-in\-Furness",
"441248", "Bangor\ \(Gwynedd\)",
"441934", "Weston\-super\-Mare",
"4415073", "Louth",
"441456", "Glenurquhart",
"441702", "Southend\-on\-Sea",
"441146", "Sheffield",
"441760", "Swaffham",
"441780", "Stamford",
"4414377", "Haverfordwest",
"441913", "Durham",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441256", "Basingstoke",
"441634", "Medway",
"4418900", "Coldstream\/Ayton",
"441647", "Moretonhampstead",
"441926", "Warwick",
"441782", "Stoke\-on\-Trent",
"4414302", "North\ Cave",
"44239", "Portsmouth",
"4418475", "Thurso",
"441223", "Cambridge",
"441953", "Wymondham",
"442889", "Fivemiletown",
"4414347", "Hexham",
"441291", "Chepstow",
"441644", "New\ Galloway",
"441499", "Inveraray",
"441438", "Stevenage",
"44161", "Manchester",
"441637", "Newquay",
"441937", "Wetherby",
"441944", "West\ Heslerton",
"441299", "Bewdley",
"441795", "Sittingbourne",
"441852", "Kilmelford",
"441491", "Henley\-on\-Thames",
"442881", "Newtownstewart",
"441653", "Malton",
"441700", "Rothesay",
"441559", "Llandysul",
"44114707", "Sheffield",
"441665", "Alnwick",
"441985", "Warminster",
"441628", "Maidenhead",
"441427", "Gainsborough",
"441779", "Peterhead",
"441246", "Chesterfield",
"4418905", "Ayton",
"4414304", "North\ Cave",
"441275", "Clevedon",
"441458", "Glastonbury",
"4413885", "Stanhope\ \(Eastgate\)",
"441692", "North\ Walsham",
"441933", "Wellingborough",
"441531", "Ledbury",
"441309", "Forres",
"4414239", "Boroughbridge",
"441821", "Kinrossie",
"441829", "Tarporley",
"441539", "Kendal",
"441598", "Lynton",
"441301", "Arrochar",
"441992", "Lea\ Valley",
"4416866", "Newtown",
"441633", "Newport",
"4414308", "Market\ Weighton",
"441258", "Blandford",
"441475", "Greenock",
"441771", "Maud",
"441840", "Camelford",
"441522", "Lincoln",
"441227", "Canterbury",
"441832", "Clopton",
"441446", "Barry",
"441957", "Mid\ Yell",
"441685", "Merthyr\ Tydfil",
"441928", "Runcorn",
"441914", "Tyneside",
"441549", "Lairg",
"4417684", "Pooley\ Bridge",
"4412294", "Barrow\-in\-Furness",
"441643", "Minehead",
"441361", "Duns",
"441389", "Dumbarton",
"441954", "Madingley",
"441905", "Worcester",
"441520", "Lochcarron",
"441842", "Thetford",
"441436", "Helensburgh",
"441917", "Sunderland",
"441830", "Kirkwhelpington",
"441224", "Aberdeen",
"441424", "Hastings",
"442870", "Coleraine",
"4412298", "Barrow\-in\-Furness",
"442310", "Portsmouth",
"441654", "Machynlleth",
"441236", "Coatbridge",
"4418517", "Stornoway",
"441690", "Betws\-y\-Coed",
"4419467", "Gosforth",
"441369", "Dunoon",
"441943", "Guiseley",
"441381", "Fortrose",
"4419757", "Strathdon",
"4418470", "Thurso\/Tongue",
"441856", "Orkney",
"441450", "Hawick",
"442884", "Northern\ Ireland",
"44114700", "Sheffield",
"441620", "North\ Berwick",
"4414238", "Harrogate",
"441335", "Ashbourne",
"4413393", "Aboyne",
"441766", "Porthmadog",
"441140", "Sheffield",
"441543", "Cannock",
"441383", "Dunfermline",
"441494", "High\ Wycombe",
"441294", "Ardrossan",
"441641", "Strathy",
"441949", "Whatton",
"441363", "Crediton",
"4414234", "Boroughbridge",
"4414375", "Clynderwen\ \(Clunderwen\)",
"441786", "Stirling",
"441590", "Lymington",
"441920", "Ware",
"441505", "Johnstone",
"441554", "Llanelli",
"441848", "Thornhill",
"4414309", "Market\ Weighton",
"441250", "Blairgowrie",
"4416861", "Newtown\/Llanidloes",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"441939", "Wem",
"4414345", "Haltwhistle",
"441631", "Oban",
"4418477", "Tongue",
"441297", "Axminster",
"441303", "Folkestone",
"441592", "Kirkcaldy",
"441922", "Walsall",
"442867", "Lisnaskea",
"441528", "Laggan",
"4418510", "Great\ Bernera\/Stornoway",
"441899", "Biggar",
"441838", "Dalmally",
"441252", "Aldershot",
"441565", "Knutsford",
"441557", "Kirkcudbright",
"441773", "Ripley",
"441452", "Gloucester",
"441376", "Braintree",
"441622", "Maidstone",
"442887", "Dungannon",
"4412299", "Millom",
"441497", "Hay\-on\-Wye",
"441142", "Sheffield",
"441823", "Taunton",
"441706", "Rochdale",
"441698", "Motherwell",
"441639", "Neath",
"441931", "Shap",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:([0-24-8]\d{5})$|0)//;
      $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;