#################################################################################
# Note: This Copyright statement covers the OpenDRIM original parts of this file.
# It does NOT concern the parts generated by automake.
# 
# Linux Management Providers (LMP), Provider Common Library
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
#################################################################################

%define packageVersion 1
Version: %{version}
Release: %{packageVersion}%{?dist}

Vendor:    OpenDRIM
Summary:   OpenDRIM Providers Common Library
Name:      libopendrim
Group:     Systems Management/Base
License:   GPL
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
URL:       http://opendrim.sourceforge.net

Source:    %{name}-%{version}.tar.gz

BuildRequires: autoconf, tog-pegasus-devel, libxml2-devel
Requires: tog-pegasus, libxml2, coreutils, net-tools, awk, util-linux
Provides: libopendrim-smbios

%description


%global PEGASUS_ARCH_LIB %{_lib}
%global COMMONLIBDIR $RPM_BUILD_ROOT/usr/%PEGASUS_ARCH_LIB
%global OPENDRIMCOMMONINCLUDE $RPM_BUILD_ROOT/usr/include/OpenDRIM


%prep
%setup -q -n %{name}-%{version}

%build
autoreconf --install --force
./configure CIMSERVER=pegasus
make 

%install
#make install COMMONLIBDIR=$RPM_BUILD_ROOT/%PEGASUS_ARCH_LIB/ OPENDRIMCOMMONINCLUDE=$RPM_BUILD_ROOT/include/OpenDRIM
%{__rm} -rf %{buildroot}
%{__install} -d %OPENDRIMCOMMONINCLUDE/cmpi $RPM_BUILD_ROOT/var/lib/OpenDRIM
%{__install} -m 644 Association.h CMPIBroking.h Common.h Datastore.h Indication.h Instance.h Objectpath.h Transtype.h EmbeddedInstance.h net_dev.h SMBIOS.h %OPENDRIMCOMMONINCLUDE
%{__install} -m 644 cmpi/* %OPENDRIMCOMMONINCLUDE/cmpi/
%{__install} -Dp -m 755 -s .libs/libopendrim.so %COMMONLIBDIR/libopendrim.so

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && %{__rm} -rf $RPM_BUILD_ROOT;
[ "${RPM_BUILD_DIR}" != "/" ] && %{__rm} -rf ${RPM_BUILD_DIR}/%{name}-%{version};

%files
%defattr(-, root, root, 755)
%attr(755,root,pegasus) /usr/%PEGASUS_ARCH_LIB/libopendrim.so
%dir /var/lib/OpenDRIM
%dir /usr/include/OpenDRIM
%dir /usr/include/OpenDRIM/cmpi
%attr(644,root,root) /usr/include/OpenDRIM/*.h
%attr(644,root,root) /usr/include/OpenDRIM/cmpi/*

