#ifndef _MOVE_ACTION_CONCEPT_H
#define _MOVE_ACTION_CONCEPT_H

#include "osl/square.h"
#include "osl/player.h"
#include "osl/piece.h"
#include "osl/ptype.h"
#include "osl/move.h"
#include <boost/concept_check.hpp>

namespace osl
{
  namespace move_action
  {
    /**
     * interface 記述用
     */
    class MoveAction 
    {
    public:
      /** コマをとらないMove */
      void simpleMove(Square from,Square to,Ptype ptype, 
		      bool isPromote,Player p,Move move);

      /** コマを取るかもしれない Move */
      void unknownMove(Square from,Square to,Piece captured,
		       Ptype ptype,bool isPromote,Player p,Move move);
      /** コマを打つMove */
      void dropMove(Square to,Ptype ptype,Player p,Move move);
    };

    /**
     * MoveAction の制約.
     * http://www.boost.org/libs/concept_check/concept_check.htm
     */
    template <class T>
    struct Concept
    {
      /** 制約 */
      void constraints() 
      {
	// MoveAction must have the following three methods

	// 試行錯誤中
	// 呼出すとinline展開などでコンパイル時間が増えるので
	// アドレスをとるだけにしてみる
	simple  = &T::simpleMove;
	unknown = &T::unknownMove;
	drop    = &T::dropMove;
      }
      void (T::*simple)(Square, Square, Ptype, bool, Player,Move);
      void (T::*unknown)(Square, Square, Piece, Ptype, bool, Player,Move);
      void (T::*drop)(Square, Ptype, Player,Move);
    };
  } // namespace move_action
} // namespace osl


#endif /* _MOVE_ACTION_CONCEPT_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
