#include "osl/eval/pieceEval.h"
#include "osl/eval/pieceEval.tcc"
#include "osl/eval/evalTraits.h"
#include "osl/state/numEffectState.h"
#include "osl/effect_util/effectUtil.tcc"
#include "osl/pieceTable.h"

namespace osl
{
  // explicit template instantiation
  template int PieceEval::computeDiffAfterMove<BLACK>
  (const NumEffectState&, Move);
  template int PieceEval::computeDiffAfterMove<WHITE>
  (const NumEffectState&, Move);

#ifndef DFPNSTATONE
#ifndef MINIMAL
  template void
  EffectUtil::findThreat<PieceEval>(const NumEffectState& state,
				    Square position,
				    PtypeO ptypeo,
				    PieceVector& out);
#endif
#endif
}

osl::PieceEval::PieceEval(const NumEffectState& state)
{
  int ret=0;
  for (int num=0;num<Piece::SIZE;num++) {
    if (state.standMask(BLACK).test(num))
    {
      ret+=Ptype_Eval_Table.value(newPtypeO(BLACK,Piece_Table.getPtypeOf(num)));
    }
    else if (state.standMask(WHITE).test(num))
    {
      ret+=Ptype_Eval_Table.value(newPtypeO(WHITE,Piece_Table.getPtypeOf(num)));
    }
    else{
      assert(state.isOnBoard(num));
      Piece p=state.pieceOf(num);
      ret+=Ptype_Eval_Table.value(p.ptypeO());
    }
  }
  val=ret;
}

osl::eval::
PieceEval::PieceEval()
{
  *this = PieceEval(NumEffectState());
}

osl::eval::PtypeEvalTable::PtypeEvalTable()
{ 
  const CArray<int, PTYPE_SIZE> values = {{
      0, 0,
      PtypeEvalTraits<PPAWN>::val, PtypeEvalTraits<PLANCE>::val,
      PtypeEvalTraits<PKNIGHT>::val, PtypeEvalTraits<PSILVER>::val,
      PtypeEvalTraits<PBISHOP>::val, PtypeEvalTraits<PROOK>::val,
      //
      PtypeEvalTraits<KING>::val, PtypeEvalTraits<GOLD>::val,
      //
      PtypeEvalTraits<PAWN>::val, PtypeEvalTraits<LANCE>::val,
      PtypeEvalTraits<KNIGHT>::val, PtypeEvalTraits<SILVER>::val, 
      PtypeEvalTraits<BISHOP>::val, PtypeEvalTraits<ROOK>::val,
    }};
  reset(values);
}
osl::eval::PtypeEvalTable::~PtypeEvalTable()
{ 
}

void osl::eval::PtypeEvalTable::reset(const CArray<int,PTYPE_SIZE>& values)
{
  ptypeO2Val.fill(0);
  std::copy(values.begin(), values.end(), ptypeO2Val.begin()+16);
  for(int i=PTYPE_MIN;i<=PTYPE_MAX;i++)
  {
    Ptype ptype=static_cast<Ptype>(i);
    ptypeO2Val[newPtypeO(WHITE,ptype)-PTYPEO_MIN]=
      -ptypeO2Val[newPtypeO(BLACK,ptype)-PTYPEO_MIN];
  }
  for(int i=PTYPEO_MIN;i<=PTYPEO_MAX;i++)
  {
    PtypeO ptypeO=static_cast<PtypeO>(i);
    PtypeO basicPtypeO=unpromote(ptypeO);
    // note: value() depends on ptypeO2Val
    promoteVal[i-PTYPEO_MIN]=this->value(ptypeO)-this->value(basicPtypeO);
  }
  // EMPTYのcapture
  captureVal[0]=0;
  for(int i=PTYPEO_MIN;i<=PTYPEO_MAX;i++)
  {
    PtypeO ptypeO=static_cast<PtypeO>(i);
    // note: value() depends on ptypeO2Val
    if(isPiece(ptypeO))
      captureVal[i-PTYPEO_MIN]=this->value(captured(ptypeO))-
	this->value(ptypeO);
    else
      captureVal[i-PTYPEO_MIN]=0;
  }
}


// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; coding:utf-8
// ;;; End:
