/* text to boolean, for libreswan
 *
 * Copyright (C) 2023  Andrew Cagney
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <https://www.gnu.org/licenses/gpl2.txt>.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 */

#include "constants.h"		/* for ttobool() et.al. */

/* mimic parser.lex */

err_t ttobool(const char *t, bool *b)
{
	if (strcaseeq(t, "1") ||
	    strcaseeq(t, "yes") ||
	    strcaseeq(t, "true") ||
	    strcaseeq(t, "on")) {
		*b = true;
		return NULL;
	}

	if (strcaseeq(t, "0") ||
	    strcaseeq(t, "no") ||
	    strcaseeq(t, "false") ||
	    strcaseeq(t, "off")) {
		*b = false;
		return NULL;
	}

	*b = false;
	return "invalid";
}
