#include <stdlib.h>
#include <stdio.h>
#include <wchar.h>


#include <gmp.h>
#include <uninum/unicode.h>
#include <uninum/nsdefs.h>
#include <uninum/uninum.h>

/* Create two UTF-32 strings */
wchar_t *s1=L"\x0A67\x0A69\x0A68"; /* Gurmukhi */
wchar_t *s2=L"\x0ED5\x0ED7\x0ED6"; /* Lao */

int
main(int ac, char **av) {
  int ns;

  /* This is where the "return" value will be stored */
  union ns_rval val;

  /* So that we can check whether it has changed */
  uninum_err = 0;

  /* We already know what number system this should be */
  StringToInt(&val,		/* pointer to return receiver */
	     s1,		/* the string to convert */
	     NS_TYPE_STRING,	/* flag requesting result as an ascii string */
	     NS_GURMUKHI);	/* number system */

  /* The string is in the s member of union val */
  if(!uninum_err) printf("%s\n",val.s);

  /* Pretend we don't know what number system s2 is in */
  ns=GuessNumberSystem(s2);
  printf("The second number system is: %s\n",NumberSystemToString(ns));
  if(ns == NS_UNKNOWN) exit(2);
  if(ns == NS_ALLZERO) {
    printf("0\n");
    exit(0);
  }

  /* So that we can check whether it has changed */
  uninum_err = 0;
  StringToInt(&val,
	     s2,
	     NS_TYPE_ULONG,	/* flag requesting result as an unsigned long int */
	     ns);		/* number system value obtained from GuessNumberSystem */

  /* Unsigned long is in u member of union val */
  if(!uninum_err) printf("%u\n",val.u);

  exit(0);
}
