/*
 * Copyright 2013-2014  Rinat Ibragimov
 *
 * This file is part of libvdpau-va-gl
 *
 * libvdpau-va-gl is distributed under the terms of the LGPLv3. See COPYING for details.
 */

#include "reverse-constant.h"
#include <vdpau/vdpau.h>
#include <vdpau/vdpau_x11.h>

#define CASE(q) case q: return #q

const char *
reverse_func_id(VdpFuncId func_id)
{
    switch (func_id) {
    CASE(VDP_FUNC_ID_GET_ERROR_STRING);
    CASE(VDP_FUNC_ID_GET_PROC_ADDRESS);
    CASE(VDP_FUNC_ID_GET_API_VERSION);
    CASE(VDP_FUNC_ID_GET_INFORMATION_STRING);
    CASE(VDP_FUNC_ID_DEVICE_DESTROY);
    CASE(VDP_FUNC_ID_GENERATE_CSC_MATRIX);
    CASE(VDP_FUNC_ID_VIDEO_SURFACE_QUERY_CAPABILITIES);
    CASE(VDP_FUNC_ID_VIDEO_SURFACE_QUERY_GET_PUT_BITS_Y_CB_CR_CAPABILITIES);
    CASE(VDP_FUNC_ID_VIDEO_SURFACE_CREATE);
    CASE(VDP_FUNC_ID_VIDEO_SURFACE_DESTROY);
    CASE(VDP_FUNC_ID_VIDEO_SURFACE_GET_PARAMETERS);
    CASE(VDP_FUNC_ID_VIDEO_SURFACE_GET_BITS_Y_CB_CR);
    CASE(VDP_FUNC_ID_VIDEO_SURFACE_PUT_BITS_Y_CB_CR);
    CASE(VDP_FUNC_ID_OUTPUT_SURFACE_QUERY_CAPABILITIES);
    CASE(VDP_FUNC_ID_OUTPUT_SURFACE_QUERY_GET_PUT_BITS_NATIVE_CAPABILITIES);
    CASE(VDP_FUNC_ID_OUTPUT_SURFACE_QUERY_PUT_BITS_INDEXED_CAPABILITIES);
    CASE(VDP_FUNC_ID_OUTPUT_SURFACE_QUERY_PUT_BITS_Y_CB_CR_CAPABILITIES);
    CASE(VDP_FUNC_ID_OUTPUT_SURFACE_CREATE);
    CASE(VDP_FUNC_ID_OUTPUT_SURFACE_DESTROY);
    CASE(VDP_FUNC_ID_OUTPUT_SURFACE_GET_PARAMETERS);
    CASE(VDP_FUNC_ID_OUTPUT_SURFACE_GET_BITS_NATIVE);
    CASE(VDP_FUNC_ID_OUTPUT_SURFACE_PUT_BITS_NATIVE);
    CASE(VDP_FUNC_ID_OUTPUT_SURFACE_PUT_BITS_INDEXED);
    CASE(VDP_FUNC_ID_OUTPUT_SURFACE_PUT_BITS_Y_CB_CR);
    CASE(VDP_FUNC_ID_BITMAP_SURFACE_QUERY_CAPABILITIES);
    CASE(VDP_FUNC_ID_BITMAP_SURFACE_CREATE);
    CASE(VDP_FUNC_ID_BITMAP_SURFACE_DESTROY);
    CASE(VDP_FUNC_ID_BITMAP_SURFACE_GET_PARAMETERS);
    CASE(VDP_FUNC_ID_BITMAP_SURFACE_PUT_BITS_NATIVE);
    CASE(VDP_FUNC_ID_OUTPUT_SURFACE_RENDER_OUTPUT_SURFACE);
    CASE(VDP_FUNC_ID_OUTPUT_SURFACE_RENDER_BITMAP_SURFACE);
    CASE(VDP_FUNC_ID_OUTPUT_SURFACE_RENDER_VIDEO_SURFACE_LUMA);
    CASE(VDP_FUNC_ID_DECODER_QUERY_CAPABILITIES);
    CASE(VDP_FUNC_ID_DECODER_CREATE);
    CASE(VDP_FUNC_ID_DECODER_DESTROY);
    CASE(VDP_FUNC_ID_DECODER_GET_PARAMETERS);
    CASE(VDP_FUNC_ID_DECODER_RENDER);
    CASE(VDP_FUNC_ID_VIDEO_MIXER_QUERY_FEATURE_SUPPORT);
    CASE(VDP_FUNC_ID_VIDEO_MIXER_QUERY_PARAMETER_SUPPORT);
    CASE(VDP_FUNC_ID_VIDEO_MIXER_QUERY_ATTRIBUTE_SUPPORT);
    CASE(VDP_FUNC_ID_VIDEO_MIXER_QUERY_PARAMETER_VALUE_RANGE);
    CASE(VDP_FUNC_ID_VIDEO_MIXER_QUERY_ATTRIBUTE_VALUE_RANGE);
    CASE(VDP_FUNC_ID_VIDEO_MIXER_CREATE);
    CASE(VDP_FUNC_ID_VIDEO_MIXER_SET_FEATURE_ENABLES);
    CASE(VDP_FUNC_ID_VIDEO_MIXER_SET_ATTRIBUTE_VALUES);
    CASE(VDP_FUNC_ID_VIDEO_MIXER_GET_FEATURE_SUPPORT);
    CASE(VDP_FUNC_ID_VIDEO_MIXER_GET_FEATURE_ENABLES);
    CASE(VDP_FUNC_ID_VIDEO_MIXER_GET_PARAMETER_VALUES);
    CASE(VDP_FUNC_ID_VIDEO_MIXER_GET_ATTRIBUTE_VALUES);
    CASE(VDP_FUNC_ID_VIDEO_MIXER_DESTROY);
    CASE(VDP_FUNC_ID_VIDEO_MIXER_RENDER);
    CASE(VDP_FUNC_ID_PRESENTATION_QUEUE_TARGET_DESTROY);
    CASE(VDP_FUNC_ID_PRESENTATION_QUEUE_CREATE);
    CASE(VDP_FUNC_ID_PRESENTATION_QUEUE_DESTROY);
    CASE(VDP_FUNC_ID_PRESENTATION_QUEUE_SET_BACKGROUND_COLOR);
    CASE(VDP_FUNC_ID_PRESENTATION_QUEUE_GET_BACKGROUND_COLOR);
    CASE(VDP_FUNC_ID_PRESENTATION_QUEUE_GET_TIME);
    CASE(VDP_FUNC_ID_PRESENTATION_QUEUE_DISPLAY);
    CASE(VDP_FUNC_ID_PRESENTATION_QUEUE_BLOCK_UNTIL_SURFACE_IDLE);
    CASE(VDP_FUNC_ID_PRESENTATION_QUEUE_QUERY_SURFACE_STATUS);
    CASE(VDP_FUNC_ID_PREEMPTION_CALLBACK_REGISTER);
    CASE(VDP_FUNC_ID_PRESENTATION_QUEUE_TARGET_CREATE_X11);
    default:
        return "Unknown";
    }
}

const char *
reverse_video_mixer_feature(VdpVideoMixerFeature mixer_feature)
{
    switch (mixer_feature) {
    CASE(VDP_VIDEO_MIXER_FEATURE_DEINTERLACE_TEMPORAL);
    CASE(VDP_VIDEO_MIXER_FEATURE_DEINTERLACE_TEMPORAL_SPATIAL);
    CASE(VDP_VIDEO_MIXER_FEATURE_INVERSE_TELECINE);
    CASE(VDP_VIDEO_MIXER_FEATURE_NOISE_REDUCTION);
    CASE(VDP_VIDEO_MIXER_FEATURE_SHARPNESS);
    CASE(VDP_VIDEO_MIXER_FEATURE_LUMA_KEY);
    CASE(VDP_VIDEO_MIXER_FEATURE_HIGH_QUALITY_SCALING_L1);
    CASE(VDP_VIDEO_MIXER_FEATURE_HIGH_QUALITY_SCALING_L2);
    CASE(VDP_VIDEO_MIXER_FEATURE_HIGH_QUALITY_SCALING_L3);
    CASE(VDP_VIDEO_MIXER_FEATURE_HIGH_QUALITY_SCALING_L4);
    CASE(VDP_VIDEO_MIXER_FEATURE_HIGH_QUALITY_SCALING_L5);
    CASE(VDP_VIDEO_MIXER_FEATURE_HIGH_QUALITY_SCALING_L6);
    CASE(VDP_VIDEO_MIXER_FEATURE_HIGH_QUALITY_SCALING_L7);
    CASE(VDP_VIDEO_MIXER_FEATURE_HIGH_QUALITY_SCALING_L8);
    CASE(VDP_VIDEO_MIXER_FEATURE_HIGH_QUALITY_SCALING_L9);
    default:
        return "Unknown video mixer feature";
    }
}

const char *
reverse_video_mixer_attribute(VdpVideoMixerAttribute attr)
{
    switch (attr) {
    CASE(VDP_VIDEO_MIXER_ATTRIBUTE_BACKGROUND_COLOR);
    CASE(VDP_VIDEO_MIXER_ATTRIBUTE_CSC_MATRIX);
    CASE(VDP_VIDEO_MIXER_ATTRIBUTE_NOISE_REDUCTION_LEVEL);
    CASE(VDP_VIDEO_MIXER_ATTRIBUTE_SHARPNESS_LEVEL);
    CASE(VDP_VIDEO_MIXER_ATTRIBUTE_LUMA_KEY_MIN_LUMA);
    CASE(VDP_VIDEO_MIXER_ATTRIBUTE_LUMA_KEY_MAX_LUMA);
    CASE(VDP_VIDEO_MIXER_ATTRIBUTE_SKIP_CHROMA_DEINTERLACE);
    default:
        return "Unknown video mixer attribute";
    }
}

const char *
reverse_rgba_format(VdpRGBAFormat rgba_format)
{
    switch (rgba_format) {
    CASE(VDP_RGBA_FORMAT_B8G8R8A8);
    CASE(VDP_RGBA_FORMAT_R8G8B8A8);
    CASE(VDP_RGBA_FORMAT_R10G10B10A2);
    CASE(VDP_RGBA_FORMAT_B10G10R10A2);
    CASE(VDP_RGBA_FORMAT_A8);
    default:
        return "Unknown RGBA format";
    }
}

const char *
reverse_chroma_type(VdpChromaType chroma_type)
{
    switch (chroma_type) {
    CASE(VDP_CHROMA_TYPE_420);
    CASE(VDP_CHROMA_TYPE_422);
    CASE(VDP_CHROMA_TYPE_444);
    default:
        return "Unknown chroma type";
    }
}

const char *
reverse_ycbcr_format(VdpYCbCrFormat ycbcr_format)
{
    switch (ycbcr_format) {
    CASE(VDP_YCBCR_FORMAT_NV12);
    CASE(VDP_YCBCR_FORMAT_YV12);
    CASE(VDP_YCBCR_FORMAT_UYVY);
    CASE(VDP_YCBCR_FORMAT_YUYV);
    CASE(VDP_YCBCR_FORMAT_Y8U8V8A8);
    CASE(VDP_YCBCR_FORMAT_V8U8Y8A8);
    default:
        return "Unknown YCbCr format";
    }
}

const char *
reverser_video_mixer_picture_structure(VdpVideoMixerPictureStructure s)
{
    switch (s) {
    CASE(VDP_VIDEO_MIXER_PICTURE_STRUCTURE_TOP_FIELD);
    CASE(VDP_VIDEO_MIXER_PICTURE_STRUCTURE_BOTTOM_FIELD);
    CASE(VDP_VIDEO_MIXER_PICTURE_STRUCTURE_FRAME);
    default:
        return "Unknown video mixer picture structure";
    }
}

const char *
reverse_blend_factor(VdpOutputSurfaceRenderBlendFactor blend_factor)
{
    switch (blend_factor) {
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_FACTOR_ZERO);
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_FACTOR_ONE);
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_FACTOR_SRC_COLOR);
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_FACTOR_ONE_MINUS_SRC_COLOR);
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_FACTOR_SRC_ALPHA);
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA);
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_FACTOR_DST_ALPHA);
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_FACTOR_ONE_MINUS_DST_ALPHA);
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_FACTOR_DST_COLOR);
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_FACTOR_ONE_MINUS_DST_COLOR);
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_FACTOR_SRC_ALPHA_SATURATE);
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_FACTOR_CONSTANT_COLOR);
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR);
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_FACTOR_CONSTANT_ALPHA);
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA);
    default:
        return "Unknown blend factor";
    }
}

const char *
reverse_blend_equation(VdpOutputSurfaceRenderBlendEquation blend_equation)
{
    switch (blend_equation) {
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_EQUATION_SUBTRACT);
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_EQUATION_REVERSE_SUBTRACT);
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_EQUATION_ADD);
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_EQUATION_MIN);
    CASE(VDP_OUTPUT_SURFACE_RENDER_BLEND_EQUATION_MAX);
    default:
        return "Unknown blend equation";
    }
}

const char *
reverse_decoder_profile(VdpDecoderProfile profile)
{
    switch (profile) {
    CASE(VDP_DECODER_PROFILE_MPEG1);
    CASE(VDP_DECODER_PROFILE_MPEG2_SIMPLE);
    CASE(VDP_DECODER_PROFILE_MPEG2_MAIN);
    CASE(VDP_DECODER_PROFILE_H264_CONSTRAINED_BASELINE);
    CASE(VDP_DECODER_PROFILE_H264_BASELINE);
    CASE(VDP_DECODER_PROFILE_H264_MAIN);
    CASE(VDP_DECODER_PROFILE_H264_HIGH);
    CASE(VDP_DECODER_PROFILE_VC1_SIMPLE);
    CASE(VDP_DECODER_PROFILE_VC1_MAIN);
    CASE(VDP_DECODER_PROFILE_VC1_ADVANCED);
    CASE(VDP_DECODER_PROFILE_MPEG4_PART2_SP);
    CASE(VDP_DECODER_PROFILE_MPEG4_PART2_ASP);
    CASE(VDP_DECODER_PROFILE_DIVX4_QMOBILE);
    CASE(VDP_DECODER_PROFILE_DIVX4_MOBILE);
    CASE(VDP_DECODER_PROFILE_DIVX4_HOME_THEATER);
    CASE(VDP_DECODER_PROFILE_DIVX4_HD_1080P);
    CASE(VDP_DECODER_PROFILE_DIVX5_QMOBILE);
    CASE(VDP_DECODER_PROFILE_DIVX5_MOBILE);
    CASE(VDP_DECODER_PROFILE_DIVX5_HOME_THEATER);
    CASE(VDP_DECODER_PROFILE_DIVX5_HD_1080P);
    default:
        return "Unknown decoder profile";
    }
}

const char *
reverse_status(VdpStatus status)
{
    switch (status) {
    CASE(VDP_STATUS_OK);
    CASE(VDP_STATUS_NO_IMPLEMENTATION);
    CASE(VDP_STATUS_DISPLAY_PREEMPTED);
    CASE(VDP_STATUS_INVALID_HANDLE);
    CASE(VDP_STATUS_INVALID_POINTER);
    CASE(VDP_STATUS_INVALID_CHROMA_TYPE);
    CASE(VDP_STATUS_INVALID_Y_CB_CR_FORMAT);
    CASE(VDP_STATUS_INVALID_RGBA_FORMAT);
    CASE(VDP_STATUS_INVALID_INDEXED_FORMAT);
    CASE(VDP_STATUS_INVALID_COLOR_STANDARD);
    CASE(VDP_STATUS_INVALID_COLOR_TABLE_FORMAT);
    CASE(VDP_STATUS_INVALID_BLEND_FACTOR);
    CASE(VDP_STATUS_INVALID_BLEND_EQUATION);
    CASE(VDP_STATUS_INVALID_FLAG);
    CASE(VDP_STATUS_INVALID_DECODER_PROFILE);
    CASE(VDP_STATUS_INVALID_VIDEO_MIXER_FEATURE);
    CASE(VDP_STATUS_INVALID_VIDEO_MIXER_PARAMETER);
    CASE(VDP_STATUS_INVALID_VIDEO_MIXER_ATTRIBUTE);
    CASE(VDP_STATUS_INVALID_VIDEO_MIXER_PICTURE_STRUCTURE);
    CASE(VDP_STATUS_INVALID_FUNC_ID);
    CASE(VDP_STATUS_INVALID_SIZE);
    CASE(VDP_STATUS_INVALID_VALUE);
    CASE(VDP_STATUS_INVALID_STRUCT_VERSION);
    CASE(VDP_STATUS_RESOURCES);
    CASE(VDP_STATUS_HANDLE_DEVICE_MISMATCH);
    CASE(VDP_STATUS_ERROR);
    default:
        return "Unknown VDP error";
    }
}

const char *
reverse_indexed_format(VdpIndexedFormat indexed_format)
{
    switch (indexed_format) {
    CASE(VDP_INDEXED_FORMAT_A4I4);
    CASE(VDP_INDEXED_FORMAT_I4A4);
    CASE(VDP_INDEXED_FORMAT_A8I8);
    CASE(VDP_INDEXED_FORMAT_I8A8);
    default:
        return "Unknown indexed format";
    }
}

const char *
reverse_color_table_format(VdpColorTableFormat color_table_format)
{
    switch (color_table_format) {
    CASE(VDP_COLOR_TABLE_FORMAT_B8G8R8X8);
    default:
        return "Unknown color table format";
    }
}

const char *
reverse_video_mixer_parameter(VdpVideoMixerParameter parameter)
{
    switch (parameter) {
    CASE(VDP_VIDEO_MIXER_PARAMETER_VIDEO_SURFACE_WIDTH);
    CASE(VDP_VIDEO_MIXER_PARAMETER_VIDEO_SURFACE_HEIGHT);
    CASE(VDP_VIDEO_MIXER_PARAMETER_CHROMA_TYPE);
    CASE(VDP_VIDEO_MIXER_PARAMETER_LAYERS);
    default:
        return "Unknown video mixer parameter";
    }
}

const char *
reverse_color_standard(VdpColorStandard color_standard)
{
    switch (color_standard) {
    CASE(VDP_COLOR_STANDARD_ITUR_BT_601);
    CASE(VDP_COLOR_STANDARD_ITUR_BT_709);
    CASE(VDP_COLOR_STANDARD_SMPTE_240M);
    default:
        return "Unknown color standard";
    }
}

const char *
reverse_output_surface_render_rotate(int flags)
{
    switch (flags & 3) {
    CASE(VDP_OUTPUT_SURFACE_RENDER_ROTATE_0);
    CASE(VDP_OUTPUT_SURFACE_RENDER_ROTATE_90);
    CASE(VDP_OUTPUT_SURFACE_RENDER_ROTATE_180);
    CASE(VDP_OUTPUT_SURFACE_RENDER_ROTATE_270);
    default:
        return "Unknown rotate";
    }
}
