
/* The standard Maelstrom colormap + 8 levels of gamma correction */

#define MAX_GAMMA	8

static SDL_Color colors[1+MAX_GAMMA][256] = {
	/* Gamma level 0 */
	{
		{ 0xff, 0xff, 0xff, 0x00 },  /* Pixel 0 */
		{ 0xff, 0xff, 0xcc, 0x00 },  /* Pixel 1 */
		{ 0xff, 0xff, 0x99, 0x00 },  /* Pixel 2 */
		{ 0xff, 0xff, 0x66, 0x00 },  /* Pixel 3 */
		{ 0xff, 0xff, 0x33, 0x00 },  /* Pixel 4 */
		{ 0xff, 0xff, 0x00, 0x00 },  /* Pixel 5 */
		{ 0xff, 0xcc, 0xff, 0x00 },  /* Pixel 6 */
		{ 0xff, 0xcc, 0xcc, 0x00 },  /* Pixel 7 */
		{ 0xff, 0xcc, 0x99, 0x00 },  /* Pixel 8 */
		{ 0xff, 0xcc, 0x66, 0x00 },  /* Pixel 9 */
		{ 0xff, 0xcc, 0x33, 0x00 },  /* Pixel 10 */
		{ 0xff, 0xcc, 0x00, 0x00 },  /* Pixel 11 */
		{ 0xff, 0x99, 0xff, 0x00 },  /* Pixel 12 */
		{ 0xff, 0x99, 0xcc, 0x00 },  /* Pixel 13 */
		{ 0xff, 0x99, 0x99, 0x00 },  /* Pixel 14 */
		{ 0xff, 0x99, 0x66, 0x00 },  /* Pixel 15 */
		{ 0xff, 0x99, 0x33, 0x00 },  /* Pixel 16 */
		{ 0xff, 0x99, 0x00, 0x00 },  /* Pixel 17 */
		{ 0xff, 0x66, 0xff, 0x00 },  /* Pixel 18 */
		{ 0xff, 0x66, 0xcc, 0x00 },  /* Pixel 19 */
		{ 0xff, 0x66, 0x99, 0x00 },  /* Pixel 20 */
		{ 0xff, 0x66, 0x66, 0x00 },  /* Pixel 21 */
		{ 0xff, 0x66, 0x33, 0x00 },  /* Pixel 22 */
		{ 0xff, 0x66, 0x00, 0x00 },  /* Pixel 23 */
		{ 0xff, 0x33, 0xff, 0x00 },  /* Pixel 24 */
		{ 0xff, 0x33, 0xcc, 0x00 },  /* Pixel 25 */
		{ 0xff, 0x33, 0x99, 0x00 },  /* Pixel 26 */
		{ 0xff, 0x33, 0x66, 0x00 },  /* Pixel 27 */
		{ 0xff, 0x33, 0x33, 0x00 },  /* Pixel 28 */
		{ 0xff, 0x33, 0x00, 0x00 },  /* Pixel 29 */
		{ 0xff, 0x00, 0xff, 0x00 },  /* Pixel 30 */
		{ 0xff, 0x00, 0xcc, 0x00 },  /* Pixel 31 */
		{ 0xff, 0x00, 0x99, 0x00 },  /* Pixel 32 */
		{ 0xff, 0x00, 0x66, 0x00 },  /* Pixel 33 */
		{ 0xff, 0x00, 0x33, 0x00 },  /* Pixel 34 */
		{ 0xff, 0x00, 0x00, 0x00 },  /* Pixel 35 */
		{ 0xcc, 0xff, 0xff, 0x00 },  /* Pixel 36 */
		{ 0xcc, 0xff, 0xcc, 0x00 },  /* Pixel 37 */
		{ 0xcc, 0xff, 0x99, 0x00 },  /* Pixel 38 */
		{ 0xcc, 0xff, 0x66, 0x00 },  /* Pixel 39 */
		{ 0xcc, 0xff, 0x33, 0x00 },  /* Pixel 40 */
		{ 0xcc, 0xff, 0x00, 0x00 },  /* Pixel 41 */
		{ 0xcc, 0xcc, 0xff, 0x00 },  /* Pixel 42 */
		{ 0xcc, 0xcc, 0xcc, 0x00 },  /* Pixel 43 */
		{ 0xcc, 0xcc, 0x99, 0x00 },  /* Pixel 44 */
		{ 0xcc, 0xcc, 0x66, 0x00 },  /* Pixel 45 */
		{ 0xcc, 0xcc, 0x33, 0x00 },  /* Pixel 46 */
		{ 0xcc, 0xcc, 0x00, 0x00 },  /* Pixel 47 */
		{ 0xcc, 0x99, 0xff, 0x00 },  /* Pixel 48 */
		{ 0xcc, 0x99, 0xcc, 0x00 },  /* Pixel 49 */
		{ 0xcc, 0x99, 0x99, 0x00 },  /* Pixel 50 */
		{ 0xcc, 0x99, 0x66, 0x00 },  /* Pixel 51 */
		{ 0xcc, 0x99, 0x33, 0x00 },  /* Pixel 52 */
		{ 0xcc, 0x99, 0x00, 0x00 },  /* Pixel 53 */
		{ 0xcc, 0x66, 0xff, 0x00 },  /* Pixel 54 */
		{ 0xcc, 0x66, 0xcc, 0x00 },  /* Pixel 55 */
		{ 0xcc, 0x66, 0x99, 0x00 },  /* Pixel 56 */
		{ 0xcc, 0x66, 0x66, 0x00 },  /* Pixel 57 */
		{ 0xcc, 0x66, 0x33, 0x00 },  /* Pixel 58 */
		{ 0xcc, 0x66, 0x00, 0x00 },  /* Pixel 59 */
		{ 0xcc, 0x33, 0xff, 0x00 },  /* Pixel 60 */
		{ 0xcc, 0x33, 0xcc, 0x00 },  /* Pixel 61 */
		{ 0xcc, 0x33, 0x99, 0x00 },  /* Pixel 62 */
		{ 0xcc, 0x33, 0x66, 0x00 },  /* Pixel 63 */
		{ 0xcc, 0x33, 0x33, 0x00 },  /* Pixel 64 */
		{ 0xcc, 0x33, 0x00, 0x00 },  /* Pixel 65 */
		{ 0xcc, 0x00, 0xff, 0x00 },  /* Pixel 66 */
		{ 0xcc, 0x00, 0xcc, 0x00 },  /* Pixel 67 */
		{ 0xcc, 0x00, 0x99, 0x00 },  /* Pixel 68 */
		{ 0xcc, 0x00, 0x66, 0x00 },  /* Pixel 69 */
		{ 0xcc, 0x00, 0x33, 0x00 },  /* Pixel 70 */
		{ 0xcc, 0x00, 0x00, 0x00 },  /* Pixel 71 */
		{ 0x99, 0xff, 0xff, 0x00 },  /* Pixel 72 */
		{ 0x99, 0xff, 0xcc, 0x00 },  /* Pixel 73 */
		{ 0x99, 0xff, 0x99, 0x00 },  /* Pixel 74 */
		{ 0x99, 0xff, 0x66, 0x00 },  /* Pixel 75 */
		{ 0x99, 0xff, 0x33, 0x00 },  /* Pixel 76 */
		{ 0x99, 0xff, 0x00, 0x00 },  /* Pixel 77 */
		{ 0x99, 0xcc, 0xff, 0x00 },  /* Pixel 78 */
		{ 0x99, 0xcc, 0xcc, 0x00 },  /* Pixel 79 */
		{ 0x99, 0xcc, 0x99, 0x00 },  /* Pixel 80 */
		{ 0x99, 0xcc, 0x66, 0x00 },  /* Pixel 81 */
		{ 0x99, 0xcc, 0x33, 0x00 },  /* Pixel 82 */
		{ 0x99, 0xcc, 0x00, 0x00 },  /* Pixel 83 */
		{ 0x99, 0x99, 0xff, 0x00 },  /* Pixel 84 */
		{ 0x99, 0x99, 0xcc, 0x00 },  /* Pixel 85 */
		{ 0x99, 0x99, 0x99, 0x00 },  /* Pixel 86 */
		{ 0x99, 0x99, 0x66, 0x00 },  /* Pixel 87 */
		{ 0x99, 0x99, 0x33, 0x00 },  /* Pixel 88 */
		{ 0x99, 0x99, 0x00, 0x00 },  /* Pixel 89 */
		{ 0x99, 0x66, 0xff, 0x00 },  /* Pixel 90 */
		{ 0x99, 0x66, 0xcc, 0x00 },  /* Pixel 91 */
		{ 0x99, 0x66, 0x99, 0x00 },  /* Pixel 92 */
		{ 0x99, 0x66, 0x66, 0x00 },  /* Pixel 93 */
		{ 0x99, 0x66, 0x33, 0x00 },  /* Pixel 94 */
		{ 0x99, 0x66, 0x00, 0x00 },  /* Pixel 95 */
		{ 0x99, 0x33, 0xff, 0x00 },  /* Pixel 96 */
		{ 0x99, 0x33, 0xcc, 0x00 },  /* Pixel 97 */
		{ 0x99, 0x33, 0x99, 0x00 },  /* Pixel 98 */
		{ 0x99, 0x33, 0x66, 0x00 },  /* Pixel 99 */
		{ 0x99, 0x33, 0x33, 0x00 },  /* Pixel 100 */
		{ 0x99, 0x33, 0x00, 0x00 },  /* Pixel 101 */
		{ 0x99, 0x00, 0xff, 0x00 },  /* Pixel 102 */
		{ 0x99, 0x00, 0xcc, 0x00 },  /* Pixel 103 */
		{ 0x99, 0x00, 0x99, 0x00 },  /* Pixel 104 */
		{ 0x99, 0x00, 0x66, 0x00 },  /* Pixel 105 */
		{ 0x99, 0x00, 0x33, 0x00 },  /* Pixel 106 */
		{ 0x99, 0x00, 0x00, 0x00 },  /* Pixel 107 */
		{ 0x66, 0xff, 0xff, 0x00 },  /* Pixel 108 */
		{ 0x66, 0xff, 0xcc, 0x00 },  /* Pixel 109 */
		{ 0x66, 0xff, 0x99, 0x00 },  /* Pixel 110 */
		{ 0x66, 0xff, 0x66, 0x00 },  /* Pixel 111 */
		{ 0x66, 0xff, 0x33, 0x00 },  /* Pixel 112 */
		{ 0x66, 0xff, 0x00, 0x00 },  /* Pixel 113 */
		{ 0x66, 0xcc, 0xff, 0x00 },  /* Pixel 114 */
		{ 0x66, 0xcc, 0xcc, 0x00 },  /* Pixel 115 */
		{ 0x66, 0xcc, 0x99, 0x00 },  /* Pixel 116 */
		{ 0x66, 0xcc, 0x66, 0x00 },  /* Pixel 117 */
		{ 0x66, 0xcc, 0x33, 0x00 },  /* Pixel 118 */
		{ 0x66, 0xcc, 0x00, 0x00 },  /* Pixel 119 */
		{ 0x66, 0x99, 0xff, 0x00 },  /* Pixel 120 */
		{ 0x66, 0x99, 0xcc, 0x00 },  /* Pixel 121 */
		{ 0x66, 0x99, 0x99, 0x00 },  /* Pixel 122 */
		{ 0x66, 0x99, 0x66, 0x00 },  /* Pixel 123 */
		{ 0x66, 0x99, 0x33, 0x00 },  /* Pixel 124 */
		{ 0x66, 0x99, 0x00, 0x00 },  /* Pixel 125 */
		{ 0x66, 0x66, 0xff, 0x00 },  /* Pixel 126 */
		{ 0x66, 0x66, 0xcc, 0x00 },  /* Pixel 127 */
		{ 0x66, 0x66, 0x99, 0x00 },  /* Pixel 128 */
		{ 0x66, 0x66, 0x66, 0x00 },  /* Pixel 129 */
		{ 0x66, 0x66, 0x33, 0x00 },  /* Pixel 130 */
		{ 0x66, 0x66, 0x00, 0x00 },  /* Pixel 131 */
		{ 0x66, 0x33, 0xff, 0x00 },  /* Pixel 132 */
		{ 0x66, 0x33, 0xcc, 0x00 },  /* Pixel 133 */
		{ 0x66, 0x33, 0x99, 0x00 },  /* Pixel 134 */
		{ 0x66, 0x33, 0x66, 0x00 },  /* Pixel 135 */
		{ 0x66, 0x33, 0x33, 0x00 },  /* Pixel 136 */
		{ 0x66, 0x33, 0x00, 0x00 },  /* Pixel 137 */
		{ 0x66, 0x00, 0xff, 0x00 },  /* Pixel 138 */
		{ 0x66, 0x00, 0xcc, 0x00 },  /* Pixel 139 */
		{ 0x66, 0x00, 0x99, 0x00 },  /* Pixel 140 */
		{ 0x66, 0x00, 0x66, 0x00 },  /* Pixel 141 */
		{ 0x66, 0x00, 0x33, 0x00 },  /* Pixel 142 */
		{ 0x66, 0x00, 0x00, 0x00 },  /* Pixel 143 */
		{ 0x33, 0xff, 0xff, 0x00 },  /* Pixel 144 */
		{ 0x33, 0xff, 0xcc, 0x00 },  /* Pixel 145 */
		{ 0x33, 0xff, 0x99, 0x00 },  /* Pixel 146 */
		{ 0x33, 0xff, 0x66, 0x00 },  /* Pixel 147 */
		{ 0x33, 0xff, 0x33, 0x00 },  /* Pixel 148 */
		{ 0x33, 0xff, 0x00, 0x00 },  /* Pixel 149 */
		{ 0x33, 0xcc, 0xff, 0x00 },  /* Pixel 150 */
		{ 0x33, 0xcc, 0xcc, 0x00 },  /* Pixel 151 */
		{ 0x33, 0xcc, 0x99, 0x00 },  /* Pixel 152 */
		{ 0x33, 0xcc, 0x66, 0x00 },  /* Pixel 153 */
		{ 0x33, 0xcc, 0x33, 0x00 },  /* Pixel 154 */
		{ 0x33, 0xcc, 0x00, 0x00 },  /* Pixel 155 */
		{ 0x33, 0x99, 0xff, 0x00 },  /* Pixel 156 */
		{ 0x33, 0x99, 0xcc, 0x00 },  /* Pixel 157 */
		{ 0x33, 0x99, 0x99, 0x00 },  /* Pixel 158 */
		{ 0x33, 0x99, 0x66, 0x00 },  /* Pixel 159 */
		{ 0x33, 0x99, 0x33, 0x00 },  /* Pixel 160 */
		{ 0x33, 0x99, 0x00, 0x00 },  /* Pixel 161 */
		{ 0x33, 0x66, 0xff, 0x00 },  /* Pixel 162 */
		{ 0x33, 0x66, 0xcc, 0x00 },  /* Pixel 163 */
		{ 0x33, 0x66, 0x99, 0x00 },  /* Pixel 164 */
		{ 0x33, 0x66, 0x66, 0x00 },  /* Pixel 165 */
		{ 0x33, 0x66, 0x33, 0x00 },  /* Pixel 166 */
		{ 0x33, 0x66, 0x00, 0x00 },  /* Pixel 167 */
		{ 0x33, 0x33, 0xff, 0x00 },  /* Pixel 168 */
		{ 0x33, 0x33, 0xcc, 0x00 },  /* Pixel 169 */
		{ 0x33, 0x33, 0x99, 0x00 },  /* Pixel 170 */
		{ 0x33, 0x33, 0x66, 0x00 },  /* Pixel 171 */
		{ 0x33, 0x33, 0x33, 0x00 },  /* Pixel 172 */
		{ 0x33, 0x33, 0x00, 0x00 },  /* Pixel 173 */
		{ 0x33, 0x00, 0xff, 0x00 },  /* Pixel 174 */
		{ 0x33, 0x00, 0xcc, 0x00 },  /* Pixel 175 */
		{ 0x33, 0x00, 0x99, 0x00 },  /* Pixel 176 */
		{ 0x33, 0x00, 0x66, 0x00 },  /* Pixel 177 */
		{ 0x33, 0x00, 0x33, 0x00 },  /* Pixel 178 */
		{ 0x33, 0x00, 0x00, 0x00 },  /* Pixel 179 */
		{ 0x00, 0xff, 0xff, 0x00 },  /* Pixel 180 */
		{ 0x00, 0xff, 0xcc, 0x00 },  /* Pixel 181 */
		{ 0x00, 0xff, 0x99, 0x00 },  /* Pixel 182 */
		{ 0x00, 0xff, 0x66, 0x00 },  /* Pixel 183 */
		{ 0x00, 0xff, 0x33, 0x00 },  /* Pixel 184 */
		{ 0x00, 0xff, 0x00, 0x00 },  /* Pixel 185 */
		{ 0x00, 0xcc, 0xff, 0x00 },  /* Pixel 186 */
		{ 0x00, 0xcc, 0xcc, 0x00 },  /* Pixel 187 */
		{ 0x00, 0xcc, 0x99, 0x00 },  /* Pixel 188 */
		{ 0x00, 0xcc, 0x66, 0x00 },  /* Pixel 189 */
		{ 0x00, 0xcc, 0x33, 0x00 },  /* Pixel 190 */
		{ 0x00, 0xcc, 0x00, 0x00 },  /* Pixel 191 */
		{ 0x00, 0x99, 0xff, 0x00 },  /* Pixel 192 */
		{ 0x00, 0x99, 0xcc, 0x00 },  /* Pixel 193 */
		{ 0x00, 0x99, 0x99, 0x00 },  /* Pixel 194 */
		{ 0x00, 0x99, 0x66, 0x00 },  /* Pixel 195 */
		{ 0x00, 0x99, 0x33, 0x00 },  /* Pixel 196 */
		{ 0x00, 0x99, 0x00, 0x00 },  /* Pixel 197 */
		{ 0x00, 0x66, 0xff, 0x00 },  /* Pixel 198 */
		{ 0x00, 0x66, 0xcc, 0x00 },  /* Pixel 199 */
		{ 0x00, 0x66, 0x99, 0x00 },  /* Pixel 200 */
		{ 0x00, 0x66, 0x66, 0x00 },  /* Pixel 201 */
		{ 0x00, 0x66, 0x33, 0x00 },  /* Pixel 202 */
		{ 0x00, 0x66, 0x00, 0x00 },  /* Pixel 203 */
		{ 0x00, 0x33, 0xff, 0x00 },  /* Pixel 204 */
		{ 0x00, 0x33, 0xcc, 0x00 },  /* Pixel 205 */
		{ 0x00, 0x33, 0x99, 0x00 },  /* Pixel 206 */
		{ 0x00, 0x33, 0x66, 0x00 },  /* Pixel 207 */
		{ 0x00, 0x33, 0x33, 0x00 },  /* Pixel 208 */
		{ 0x00, 0x33, 0x00, 0x00 },  /* Pixel 209 */
		{ 0x00, 0x00, 0xff, 0x00 },  /* Pixel 210 */
		{ 0x00, 0x00, 0xcc, 0x00 },  /* Pixel 211 */
		{ 0x00, 0x00, 0x99, 0x00 },  /* Pixel 212 */
		{ 0x00, 0x00, 0x66, 0x00 },  /* Pixel 213 */
		{ 0x00, 0x00, 0x33, 0x00 },  /* Pixel 214 */
		{ 0xee, 0x00, 0x00, 0x00 },  /* Pixel 215 */
		{ 0xdd, 0x00, 0x00, 0x00 },  /* Pixel 216 */
		{ 0xbb, 0x00, 0x00, 0x00 },  /* Pixel 217 */
		{ 0xaa, 0x00, 0x00, 0x00 },  /* Pixel 218 */
		{ 0x88, 0x00, 0x00, 0x00 },  /* Pixel 219 */
		{ 0x77, 0x00, 0x00, 0x00 },  /* Pixel 220 */
		{ 0x55, 0x00, 0x00, 0x00 },  /* Pixel 221 */
		{ 0x44, 0x00, 0x00, 0x00 },  /* Pixel 222 */
		{ 0x22, 0x00, 0x00, 0x00 },  /* Pixel 223 */
		{ 0x11, 0x00, 0x00, 0x00 },  /* Pixel 224 */
		{ 0x00, 0xee, 0x00, 0x00 },  /* Pixel 225 */
		{ 0x00, 0xdd, 0x00, 0x00 },  /* Pixel 226 */
		{ 0x00, 0xbb, 0x00, 0x00 },  /* Pixel 227 */
		{ 0x00, 0xaa, 0x00, 0x00 },  /* Pixel 228 */
		{ 0x00, 0x88, 0x00, 0x00 },  /* Pixel 229 */
		{ 0x00, 0x77, 0x00, 0x00 },  /* Pixel 230 */
		{ 0x00, 0x55, 0x00, 0x00 },  /* Pixel 231 */
		{ 0x00, 0x44, 0x00, 0x00 },  /* Pixel 232 */
		{ 0x00, 0x22, 0x00, 0x00 },  /* Pixel 233 */
		{ 0x00, 0x11, 0x00, 0x00 },  /* Pixel 234 */
		{ 0x00, 0x00, 0xee, 0x00 },  /* Pixel 235 */
		{ 0x00, 0x00, 0xdd, 0x00 },  /* Pixel 236 */
		{ 0x00, 0x00, 0xbb, 0x00 },  /* Pixel 237 */
		{ 0x00, 0x00, 0xaa, 0x00 },  /* Pixel 238 */
		{ 0x00, 0x00, 0x88, 0x00 },  /* Pixel 239 */
		{ 0x00, 0x00, 0x77, 0x00 },  /* Pixel 240 */
		{ 0x00, 0x00, 0x55, 0x00 },  /* Pixel 241 */
		{ 0x00, 0x00, 0x44, 0x00 },  /* Pixel 242 */
		{ 0x00, 0x00, 0x22, 0x00 },  /* Pixel 243 */
		{ 0x00, 0x00, 0x11, 0x00 },  /* Pixel 244 */
		{ 0xee, 0xee, 0xee, 0x00 },  /* Pixel 245 */
		{ 0xdd, 0xdd, 0xdd, 0x00 },  /* Pixel 246 */
		{ 0xbb, 0xbb, 0xbb, 0x00 },  /* Pixel 247 */
		{ 0xaa, 0xaa, 0xaa, 0x00 },  /* Pixel 248 */
		{ 0x88, 0x88, 0x88, 0x00 },  /* Pixel 249 */
		{ 0x77, 0x77, 0x77, 0x00 },  /* Pixel 250 */
		{ 0x55, 0x55, 0x55, 0x00 },  /* Pixel 251 */
		{ 0x44, 0x44, 0x44, 0x00 },  /* Pixel 252 */
		{ 0x22, 0x22, 0x22, 0x00 },  /* Pixel 253 */
		{ 0x11, 0x11, 0x11, 0x00 },  /* Pixel 254 */
		{ 0x00, 0x00, 0x00, 0x00 },  /* Pixel 255 */
	},

	/* Gamma level 1 */
	{
		{ 0xff, 0xff, 0xff, 0x00 },  /* Pixel 0 */
		{ 0xff, 0xff, 0xcc, 0x00 },  /* Pixel 1 */
		{ 0xff, 0xff, 0x99, 0x00 },  /* Pixel 2 */
		{ 0xff, 0xff, 0x66, 0x00 },  /* Pixel 3 */
		{ 0xff, 0xff, 0x33, 0x00 },  /* Pixel 4 */
		{ 0xff, 0xff, 0x00, 0x00 },  /* Pixel 5 */
		{ 0xff, 0xcc, 0xff, 0x00 },  /* Pixel 6 */
		{ 0xff, 0xcc, 0xcc, 0x00 },  /* Pixel 7 */
		{ 0xff, 0xcc, 0x99, 0x00 },  /* Pixel 8 */
		{ 0xff, 0xcc, 0x66, 0x00 },  /* Pixel 9 */
		{ 0xff, 0xcc, 0x33, 0x00 },  /* Pixel 10 */
		{ 0xff, 0xcc, 0x00, 0x00 },  /* Pixel 11 */
		{ 0xff, 0x99, 0xff, 0x00 },  /* Pixel 12 */
		{ 0xff, 0x99, 0xcc, 0x00 },  /* Pixel 13 */
		{ 0xff, 0x99, 0x99, 0x00 },  /* Pixel 14 */
		{ 0xff, 0x99, 0x66, 0x00 },  /* Pixel 15 */
		{ 0xff, 0x99, 0x33, 0x00 },  /* Pixel 16 */
		{ 0xff, 0x99, 0x00, 0x00 },  /* Pixel 17 */
		{ 0xff, 0x66, 0xff, 0x00 },  /* Pixel 18 */
		{ 0xff, 0x66, 0xcc, 0x00 },  /* Pixel 19 */
		{ 0xff, 0x66, 0x99, 0x00 },  /* Pixel 20 */
		{ 0xff, 0x66, 0x66, 0x00 },  /* Pixel 21 */
		{ 0xff, 0x66, 0x33, 0x00 },  /* Pixel 22 */
		{ 0xff, 0x66, 0x00, 0x00 },  /* Pixel 23 */
		{ 0xff, 0x33, 0xff, 0x00 },  /* Pixel 24 */
		{ 0xff, 0x33, 0xcc, 0x00 },  /* Pixel 25 */
		{ 0xff, 0x33, 0x99, 0x00 },  /* Pixel 26 */
		{ 0xff, 0x33, 0x66, 0x00 },  /* Pixel 27 */
		{ 0xff, 0x33, 0x33, 0x00 },  /* Pixel 28 */
		{ 0xff, 0x33, 0x00, 0x00 },  /* Pixel 29 */
		{ 0xff, 0x00, 0xff, 0x00 },  /* Pixel 30 */
		{ 0xff, 0x00, 0xcc, 0x00 },  /* Pixel 31 */
		{ 0xff, 0x00, 0x99, 0x00 },  /* Pixel 32 */
		{ 0xff, 0x00, 0x66, 0x00 },  /* Pixel 33 */
		{ 0xff, 0x00, 0x33, 0x00 },  /* Pixel 34 */
		{ 0xff, 0x00, 0x00, 0x00 },  /* Pixel 35 */
		{ 0xcc, 0xff, 0xff, 0x00 },  /* Pixel 36 */
		{ 0xcc, 0xff, 0xcc, 0x00 },  /* Pixel 37 */
		{ 0xcc, 0xff, 0x99, 0x00 },  /* Pixel 38 */
		{ 0xcc, 0xff, 0x66, 0x00 },  /* Pixel 39 */
		{ 0xcc, 0xff, 0x33, 0x00 },  /* Pixel 40 */
		{ 0xcc, 0xff, 0x00, 0x00 },  /* Pixel 41 */
		{ 0xcc, 0xcc, 0xff, 0x00 },  /* Pixel 42 */
		{ 0xd5, 0xd5, 0xd5, 0x00 },  /* Pixel 43 */
		{ 0xd5, 0xd5, 0xa0, 0x00 },  /* Pixel 44 */
		{ 0xd5, 0xd5, 0x6b, 0x00 },  /* Pixel 45 */
		{ 0xd5, 0xd5, 0x35, 0x00 },  /* Pixel 46 */
		{ 0xd5, 0xd5, 0x00, 0x00 },  /* Pixel 47 */
		{ 0xcc, 0x99, 0xff, 0x00 },  /* Pixel 48 */
		{ 0xd5, 0xa0, 0xd5, 0x00 },  /* Pixel 49 */
		{ 0xd5, 0xa0, 0xa0, 0x00 },  /* Pixel 50 */
		{ 0xd5, 0xa0, 0x6b, 0x00 },  /* Pixel 51 */
		{ 0xd5, 0xa0, 0x35, 0x00 },  /* Pixel 52 */
		{ 0xd5, 0xa0, 0x00, 0x00 },  /* Pixel 53 */
		{ 0xcc, 0x66, 0xff, 0x00 },  /* Pixel 54 */
		{ 0xd5, 0x6b, 0xd5, 0x00 },  /* Pixel 55 */
		{ 0xd5, 0x6b, 0xa0, 0x00 },  /* Pixel 56 */
		{ 0xd5, 0x6b, 0x6b, 0x00 },  /* Pixel 57 */
		{ 0xd5, 0x6b, 0x35, 0x00 },  /* Pixel 58 */
		{ 0xd5, 0x6b, 0x00, 0x00 },  /* Pixel 59 */
		{ 0xcc, 0x33, 0xff, 0x00 },  /* Pixel 60 */
		{ 0xd5, 0x35, 0xd5, 0x00 },  /* Pixel 61 */
		{ 0xd5, 0x35, 0xa0, 0x00 },  /* Pixel 62 */
		{ 0xd5, 0x35, 0x6a, 0x00 },  /* Pixel 63 */
		{ 0xd5, 0x35, 0x35, 0x00 },  /* Pixel 64 */
		{ 0xd5, 0x35, 0x00, 0x00 },  /* Pixel 65 */
		{ 0xcc, 0x00, 0xff, 0x00 },  /* Pixel 66 */
		{ 0xd5, 0x00, 0xd5, 0x00 },  /* Pixel 67 */
		{ 0xd5, 0x00, 0xa0, 0x00 },  /* Pixel 68 */
		{ 0xd5, 0x00, 0x6b, 0x00 },  /* Pixel 69 */
		{ 0xd5, 0x00, 0x35, 0x00 },  /* Pixel 70 */
		{ 0xd5, 0x00, 0x00, 0x00 },  /* Pixel 71 */
		{ 0x99, 0xff, 0xff, 0x00 },  /* Pixel 72 */
		{ 0x99, 0xff, 0xcc, 0x00 },  /* Pixel 73 */
		{ 0x99, 0xff, 0x99, 0x00 },  /* Pixel 74 */
		{ 0x99, 0xff, 0x66, 0x00 },  /* Pixel 75 */
		{ 0x99, 0xff, 0x33, 0x00 },  /* Pixel 76 */
		{ 0x99, 0xff, 0x00, 0x00 },  /* Pixel 77 */
		{ 0x99, 0xcc, 0xff, 0x00 },  /* Pixel 78 */
		{ 0xa0, 0xd5, 0xd5, 0x00 },  /* Pixel 79 */
		{ 0xa0, 0xd5, 0xa0, 0x00 },  /* Pixel 80 */
		{ 0xa0, 0xd5, 0x6b, 0x00 },  /* Pixel 81 */
		{ 0xa0, 0xd5, 0x35, 0x00 },  /* Pixel 82 */
		{ 0xa0, 0xd5, 0x00, 0x00 },  /* Pixel 83 */
		{ 0x99, 0x99, 0xff, 0x00 },  /* Pixel 84 */
		{ 0xa0, 0xa0, 0xd5, 0x00 },  /* Pixel 85 */
		{ 0xa9, 0xa9, 0xa9, 0x00 },  /* Pixel 86 */
		{ 0xa9, 0xa9, 0x71, 0x00 },  /* Pixel 87 */
		{ 0xa9, 0xa9, 0x38, 0x00 },  /* Pixel 88 */
		{ 0xa9, 0xa9, 0x00, 0x00 },  /* Pixel 89 */
		{ 0x99, 0x66, 0xff, 0x00 },  /* Pixel 90 */
		{ 0xa0, 0x6b, 0xd5, 0x00 },  /* Pixel 91 */
		{ 0xa9, 0x71, 0xa9, 0x00 },  /* Pixel 92 */
		{ 0xa9, 0x71, 0x71, 0x00 },  /* Pixel 93 */
		{ 0xa9, 0x71, 0x38, 0x00 },  /* Pixel 94 */
		{ 0xa9, 0x71, 0x00, 0x00 },  /* Pixel 95 */
		{ 0x99, 0x33, 0xff, 0x00 },  /* Pixel 96 */
		{ 0xa0, 0x35, 0xd5, 0x00 },  /* Pixel 97 */
		{ 0xa9, 0x38, 0xa9, 0x00 },  /* Pixel 98 */
		{ 0xa9, 0x38, 0x71, 0x00 },  /* Pixel 99 */
		{ 0xa9, 0x38, 0x38, 0x00 },  /* Pixel 100 */
		{ 0xa9, 0x38, 0x00, 0x00 },  /* Pixel 101 */
		{ 0x99, 0x00, 0xff, 0x00 },  /* Pixel 102 */
		{ 0xa0, 0x00, 0xd5, 0x00 },  /* Pixel 103 */
		{ 0xa9, 0x00, 0xa9, 0x00 },  /* Pixel 104 */
		{ 0xa9, 0x00, 0x71, 0x00 },  /* Pixel 105 */
		{ 0xa9, 0x00, 0x38, 0x00 },  /* Pixel 106 */
		{ 0xa9, 0x00, 0x00, 0x00 },  /* Pixel 107 */
		{ 0x66, 0xff, 0xff, 0x00 },  /* Pixel 108 */
		{ 0x66, 0xff, 0xcc, 0x00 },  /* Pixel 109 */
		{ 0x66, 0xff, 0x99, 0x00 },  /* Pixel 110 */
		{ 0x66, 0xff, 0x66, 0x00 },  /* Pixel 111 */
		{ 0x66, 0xff, 0x33, 0x00 },  /* Pixel 112 */
		{ 0x66, 0xff, 0x00, 0x00 },  /* Pixel 113 */
		{ 0x66, 0xcc, 0xff, 0x00 },  /* Pixel 114 */
		{ 0x6b, 0xd5, 0xd5, 0x00 },  /* Pixel 115 */
		{ 0x6b, 0xd5, 0xa0, 0x00 },  /* Pixel 116 */
		{ 0x6b, 0xd5, 0x6b, 0x00 },  /* Pixel 117 */
		{ 0x6a, 0xd5, 0x35, 0x00 },  /* Pixel 118 */
		{ 0x6b, 0xd5, 0x00, 0x00 },  /* Pixel 119 */
		{ 0x66, 0x99, 0xff, 0x00 },  /* Pixel 120 */
		{ 0x6b, 0xa0, 0xd5, 0x00 },  /* Pixel 121 */
		{ 0x71, 0xa9, 0xa9, 0x00 },  /* Pixel 122 */
		{ 0x71, 0xa9, 0x71, 0x00 },  /* Pixel 123 */
		{ 0x71, 0xa9, 0x38, 0x00 },  /* Pixel 124 */
		{ 0x71, 0xa9, 0x00, 0x00 },  /* Pixel 125 */
		{ 0x66, 0x66, 0xff, 0x00 },  /* Pixel 126 */
		{ 0x6b, 0x6b, 0xd5, 0x00 },  /* Pixel 127 */
		{ 0x71, 0x71, 0xa9, 0x00 },  /* Pixel 128 */
		{ 0x7b, 0x7b, 0x7b, 0x00 },  /* Pixel 129 */
		{ 0x7b, 0x7b, 0x3e, 0x00 },  /* Pixel 130 */
		{ 0x7b, 0x7b, 0x00, 0x00 },  /* Pixel 131 */
		{ 0x66, 0x33, 0xff, 0x00 },  /* Pixel 132 */
		{ 0x6a, 0x35, 0xd5, 0x00 },  /* Pixel 133 */
		{ 0x71, 0x38, 0xa9, 0x00 },  /* Pixel 134 */
		{ 0x7b, 0x3e, 0x7b, 0x00 },  /* Pixel 135 */
		{ 0x7b, 0x3e, 0x3e, 0x00 },  /* Pixel 136 */
		{ 0x7b, 0x3e, 0x00, 0x00 },  /* Pixel 137 */
		{ 0x66, 0x00, 0xff, 0x00 },  /* Pixel 138 */
		{ 0x6b, 0x00, 0xd5, 0x00 },  /* Pixel 139 */
		{ 0x71, 0x00, 0xa9, 0x00 },  /* Pixel 140 */
		{ 0x7b, 0x00, 0x7b, 0x00 },  /* Pixel 141 */
		{ 0x7b, 0x00, 0x3e, 0x00 },  /* Pixel 142 */
		{ 0x7b, 0x00, 0x00, 0x00 },  /* Pixel 143 */
		{ 0x33, 0xff, 0xff, 0x00 },  /* Pixel 144 */
		{ 0x33, 0xff, 0xcc, 0x00 },  /* Pixel 145 */
		{ 0x33, 0xff, 0x99, 0x00 },  /* Pixel 146 */
		{ 0x33, 0xff, 0x66, 0x00 },  /* Pixel 147 */
		{ 0x33, 0xff, 0x33, 0x00 },  /* Pixel 148 */
		{ 0x33, 0xff, 0x00, 0x00 },  /* Pixel 149 */
		{ 0x33, 0xcc, 0xff, 0x00 },  /* Pixel 150 */
		{ 0x35, 0xd5, 0xd5, 0x00 },  /* Pixel 151 */
		{ 0x35, 0xd5, 0xa0, 0x00 },  /* Pixel 152 */
		{ 0x35, 0xd5, 0x6b, 0x00 },  /* Pixel 153 */
		{ 0x35, 0xd5, 0x35, 0x00 },  /* Pixel 154 */
		{ 0x35, 0xd5, 0x00, 0x00 },  /* Pixel 155 */
		{ 0x33, 0x99, 0xff, 0x00 },  /* Pixel 156 */
		{ 0x35, 0xa0, 0xd5, 0x00 },  /* Pixel 157 */
		{ 0x38, 0xa9, 0xa9, 0x00 },  /* Pixel 158 */
		{ 0x38, 0xa9, 0x71, 0x00 },  /* Pixel 159 */
		{ 0x38, 0xa9, 0x38, 0x00 },  /* Pixel 160 */
		{ 0x38, 0xa9, 0x00, 0x00 },  /* Pixel 161 */
		{ 0x33, 0x66, 0xff, 0x00 },  /* Pixel 162 */
		{ 0x35, 0x6b, 0xd5, 0x00 },  /* Pixel 163 */
		{ 0x38, 0x71, 0xa9, 0x00 },  /* Pixel 164 */
		{ 0x3e, 0x7b, 0x7b, 0x00 },  /* Pixel 165 */
		{ 0x3e, 0x7b, 0x3e, 0x00 },  /* Pixel 166 */
		{ 0x3e, 0x7b, 0x00, 0x00 },  /* Pixel 167 */
		{ 0x33, 0x33, 0xff, 0x00 },  /* Pixel 168 */
		{ 0x35, 0x35, 0xd5, 0x00 },  /* Pixel 169 */
		{ 0x38, 0x38, 0xa9, 0x00 },  /* Pixel 170 */
		{ 0x3e, 0x3e, 0x7b, 0x00 },  /* Pixel 171 */
		{ 0x46, 0x46, 0x46, 0x00 },  /* Pixel 172 */
		{ 0x46, 0x46, 0x00, 0x00 },  /* Pixel 173 */
		{ 0x33, 0x00, 0xff, 0x00 },  /* Pixel 174 */
		{ 0x35, 0x00, 0xd5, 0x00 },  /* Pixel 175 */
		{ 0x38, 0x00, 0xa9, 0x00 },  /* Pixel 176 */
		{ 0x3e, 0x00, 0x7b, 0x00 },  /* Pixel 177 */
		{ 0x46, 0x00, 0x46, 0x00 },  /* Pixel 178 */
		{ 0x46, 0x00, 0x00, 0x00 },  /* Pixel 179 */
		{ 0x00, 0xff, 0xff, 0x00 },  /* Pixel 180 */
		{ 0x00, 0xff, 0xcc, 0x00 },  /* Pixel 181 */
		{ 0x00, 0xff, 0x99, 0x00 },  /* Pixel 182 */
		{ 0x00, 0xff, 0x66, 0x00 },  /* Pixel 183 */
		{ 0x00, 0xff, 0x33, 0x00 },  /* Pixel 184 */
		{ 0x00, 0xff, 0x00, 0x00 },  /* Pixel 185 */
		{ 0x00, 0xcc, 0xff, 0x00 },  /* Pixel 186 */
		{ 0x00, 0xd5, 0xd5, 0x00 },  /* Pixel 187 */
		{ 0x00, 0xd5, 0xa0, 0x00 },  /* Pixel 188 */
		{ 0x00, 0xd5, 0x6b, 0x00 },  /* Pixel 189 */
		{ 0x00, 0xd5, 0x35, 0x00 },  /* Pixel 190 */
		{ 0x00, 0xd5, 0x00, 0x00 },  /* Pixel 191 */
		{ 0x00, 0x99, 0xff, 0x00 },  /* Pixel 192 */
		{ 0x00, 0xa0, 0xd5, 0x00 },  /* Pixel 193 */
		{ 0x00, 0xa9, 0xa9, 0x00 },  /* Pixel 194 */
		{ 0x00, 0xa9, 0x71, 0x00 },  /* Pixel 195 */
		{ 0x00, 0xa9, 0x38, 0x00 },  /* Pixel 196 */
		{ 0x00, 0xa9, 0x00, 0x00 },  /* Pixel 197 */
		{ 0x00, 0x66, 0xff, 0x00 },  /* Pixel 198 */
		{ 0x00, 0x6b, 0xd5, 0x00 },  /* Pixel 199 */
		{ 0x00, 0x71, 0xa9, 0x00 },  /* Pixel 200 */
		{ 0x00, 0x7b, 0x7b, 0x00 },  /* Pixel 201 */
		{ 0x00, 0x7b, 0x3e, 0x00 },  /* Pixel 202 */
		{ 0x00, 0x7b, 0x00, 0x00 },  /* Pixel 203 */
		{ 0x00, 0x33, 0xff, 0x00 },  /* Pixel 204 */
		{ 0x00, 0x35, 0xd5, 0x00 },  /* Pixel 205 */
		{ 0x00, 0x38, 0xa9, 0x00 },  /* Pixel 206 */
		{ 0x00, 0x3e, 0x7b, 0x00 },  /* Pixel 207 */
		{ 0x00, 0x46, 0x46, 0x00 },  /* Pixel 208 */
		{ 0x00, 0x46, 0x00, 0x00 },  /* Pixel 209 */
		{ 0x00, 0x00, 0xff, 0x00 },  /* Pixel 210 */
		{ 0x00, 0x00, 0xd5, 0x00 },  /* Pixel 211 */
		{ 0x00, 0x00, 0xa9, 0x00 },  /* Pixel 212 */
		{ 0x00, 0x00, 0x7b, 0x00 },  /* Pixel 213 */
		{ 0x00, 0x00, 0x46, 0x00 },  /* Pixel 214 */
		{ 0xf1, 0x00, 0x00, 0x00 },  /* Pixel 215 */
		{ 0xe3, 0x00, 0x00, 0x00 },  /* Pixel 216 */
		{ 0xc7, 0x00, 0x00, 0x00 },  /* Pixel 217 */
		{ 0xb8, 0x00, 0x00, 0x00 },  /* Pixel 218 */
		{ 0x9a, 0x00, 0x00, 0x00 },  /* Pixel 219 */
		{ 0x8b, 0x00, 0x00, 0x00 },  /* Pixel 220 */
		{ 0x6a, 0x00, 0x00, 0x00 },  /* Pixel 221 */
		{ 0x59, 0x00, 0x00, 0x00 },  /* Pixel 222 */
		{ 0x33, 0x00, 0x00, 0x00 },  /* Pixel 223 */
		{ 0x1d, 0x00, 0x00, 0x00 },  /* Pixel 224 */
		{ 0x00, 0xf1, 0x00, 0x00 },  /* Pixel 225 */
		{ 0x00, 0xe3, 0x00, 0x00 },  /* Pixel 226 */
		{ 0x00, 0xc7, 0x00, 0x00 },  /* Pixel 227 */
		{ 0x00, 0xb8, 0x00, 0x00 },  /* Pixel 228 */
		{ 0x00, 0x9a, 0x00, 0x00 },  /* Pixel 229 */
		{ 0x00, 0x8b, 0x00, 0x00 },  /* Pixel 230 */
		{ 0x00, 0x6a, 0x00, 0x00 },  /* Pixel 231 */
		{ 0x00, 0x59, 0x00, 0x00 },  /* Pixel 232 */
		{ 0x00, 0x33, 0x00, 0x00 },  /* Pixel 233 */
		{ 0x00, 0x1d, 0x00, 0x00 },  /* Pixel 234 */
		{ 0x00, 0x00, 0xf1, 0x00 },  /* Pixel 235 */
		{ 0x00, 0x00, 0xe3, 0x00 },  /* Pixel 236 */
		{ 0x00, 0x00, 0xc7, 0x00 },  /* Pixel 237 */
		{ 0x00, 0x00, 0xb8, 0x00 },  /* Pixel 238 */
		{ 0x00, 0x00, 0x9a, 0x00 },  /* Pixel 239 */
		{ 0x00, 0x00, 0x8b, 0x00 },  /* Pixel 240 */
		{ 0x00, 0x00, 0x6a, 0x00 },  /* Pixel 241 */
		{ 0x00, 0x00, 0x59, 0x00 },  /* Pixel 242 */
		{ 0x00, 0x00, 0x33, 0x00 },  /* Pixel 243 */
		{ 0x00, 0x00, 0x1d, 0x00 },  /* Pixel 244 */
		{ 0xf1, 0xf1, 0xf1, 0x00 },  /* Pixel 245 */
		{ 0xe3, 0xe3, 0xe3, 0x00 },  /* Pixel 246 */
		{ 0xc7, 0xc7, 0xc7, 0x00 },  /* Pixel 247 */
		{ 0xb8, 0xb8, 0xb8, 0x00 },  /* Pixel 248 */
		{ 0x9a, 0x9a, 0x9a, 0x00 },  /* Pixel 249 */
		{ 0x8b, 0x8b, 0x8b, 0x00 },  /* Pixel 250 */
		{ 0x6a, 0x6a, 0x6a, 0x00 },  /* Pixel 251 */
		{ 0x59, 0x59, 0x59, 0x00 },  /* Pixel 252 */
		{ 0x33, 0x33, 0x33, 0x00 },  /* Pixel 253 */
		{ 0x1d, 0x1d, 0x1d, 0x00 },  /* Pixel 254 */
		{ 0x00, 0x00, 0x00, 0x00 },  /* Pixel 255 */
	},

	/* Gamma level 2 */
	{
		{ 0xff, 0xff, 0xff, 0x00 },  /* Pixel 0 */
		{ 0xff, 0xff, 0xcc, 0x00 },  /* Pixel 1 */
		{ 0xff, 0xff, 0x99, 0x00 },  /* Pixel 2 */
		{ 0xff, 0xff, 0x66, 0x00 },  /* Pixel 3 */
		{ 0xff, 0xff, 0x33, 0x00 },  /* Pixel 4 */
		{ 0xff, 0xff, 0x00, 0x00 },  /* Pixel 5 */
		{ 0xff, 0xcc, 0xff, 0x00 },  /* Pixel 6 */
		{ 0xff, 0xcc, 0xcc, 0x00 },  /* Pixel 7 */
		{ 0xff, 0xcc, 0x99, 0x00 },  /* Pixel 8 */
		{ 0xff, 0xcc, 0x66, 0x00 },  /* Pixel 9 */
		{ 0xff, 0xcc, 0x33, 0x00 },  /* Pixel 10 */
		{ 0xff, 0xcc, 0x00, 0x00 },  /* Pixel 11 */
		{ 0xff, 0x99, 0xff, 0x00 },  /* Pixel 12 */
		{ 0xff, 0x99, 0xcc, 0x00 },  /* Pixel 13 */
		{ 0xff, 0x99, 0x99, 0x00 },  /* Pixel 14 */
		{ 0xff, 0x99, 0x66, 0x00 },  /* Pixel 15 */
		{ 0xff, 0x99, 0x33, 0x00 },  /* Pixel 16 */
		{ 0xff, 0x99, 0x00, 0x00 },  /* Pixel 17 */
		{ 0xff, 0x66, 0xff, 0x00 },  /* Pixel 18 */
		{ 0xff, 0x66, 0xcc, 0x00 },  /* Pixel 19 */
		{ 0xff, 0x66, 0x99, 0x00 },  /* Pixel 20 */
		{ 0xff, 0x66, 0x66, 0x00 },  /* Pixel 21 */
		{ 0xff, 0x66, 0x33, 0x00 },  /* Pixel 22 */
		{ 0xff, 0x66, 0x00, 0x00 },  /* Pixel 23 */
		{ 0xff, 0x33, 0xff, 0x00 },  /* Pixel 24 */
		{ 0xff, 0x33, 0xcc, 0x00 },  /* Pixel 25 */
		{ 0xff, 0x33, 0x99, 0x00 },  /* Pixel 26 */
		{ 0xff, 0x33, 0x66, 0x00 },  /* Pixel 27 */
		{ 0xff, 0x33, 0x33, 0x00 },  /* Pixel 28 */
		{ 0xff, 0x33, 0x00, 0x00 },  /* Pixel 29 */
		{ 0xff, 0x00, 0xff, 0x00 },  /* Pixel 30 */
		{ 0xff, 0x00, 0xcc, 0x00 },  /* Pixel 31 */
		{ 0xff, 0x00, 0x99, 0x00 },  /* Pixel 32 */
		{ 0xff, 0x00, 0x66, 0x00 },  /* Pixel 33 */
		{ 0xff, 0x00, 0x33, 0x00 },  /* Pixel 34 */
		{ 0xff, 0x00, 0x00, 0x00 },  /* Pixel 35 */
		{ 0xcc, 0xff, 0xff, 0x00 },  /* Pixel 36 */
		{ 0xcc, 0xff, 0xcc, 0x00 },  /* Pixel 37 */
		{ 0xcc, 0xff, 0x99, 0x00 },  /* Pixel 38 */
		{ 0xcc, 0xff, 0x66, 0x00 },  /* Pixel 39 */
		{ 0xcc, 0xff, 0x33, 0x00 },  /* Pixel 40 */
		{ 0xcc, 0xff, 0x00, 0x00 },  /* Pixel 41 */
		{ 0xcc, 0xcc, 0xff, 0x00 },  /* Pixel 42 */
		{ 0xdc, 0xdc, 0xdc, 0x00 },  /* Pixel 43 */
		{ 0xdc, 0xdc, 0xa5, 0x00 },  /* Pixel 44 */
		{ 0xdc, 0xdc, 0x6e, 0x00 },  /* Pixel 45 */
		{ 0xdc, 0xdc, 0x37, 0x00 },  /* Pixel 46 */
		{ 0xdc, 0xdc, 0x00, 0x00 },  /* Pixel 47 */
		{ 0xcc, 0x99, 0xff, 0x00 },  /* Pixel 48 */
		{ 0xdc, 0xa5, 0xdc, 0x00 },  /* Pixel 49 */
		{ 0xdc, 0xa5, 0xa5, 0x00 },  /* Pixel 50 */
		{ 0xdc, 0xa5, 0x6e, 0x00 },  /* Pixel 51 */
		{ 0xdc, 0xa5, 0x37, 0x00 },  /* Pixel 52 */
		{ 0xdc, 0xa5, 0x00, 0x00 },  /* Pixel 53 */
		{ 0xcc, 0x66, 0xff, 0x00 },  /* Pixel 54 */
		{ 0xdc, 0x6e, 0xdc, 0x00 },  /* Pixel 55 */
		{ 0xdc, 0x6e, 0xa5, 0x00 },  /* Pixel 56 */
		{ 0xdc, 0x6e, 0x6e, 0x00 },  /* Pixel 57 */
		{ 0xdc, 0x6e, 0x37, 0x00 },  /* Pixel 58 */
		{ 0xdc, 0x6e, 0x00, 0x00 },  /* Pixel 59 */
		{ 0xcc, 0x33, 0xff, 0x00 },  /* Pixel 60 */
		{ 0xdc, 0x37, 0xdc, 0x00 },  /* Pixel 61 */
		{ 0xdc, 0x37, 0xa5, 0x00 },  /* Pixel 62 */
		{ 0xdc, 0x37, 0x6e, 0x00 },  /* Pixel 63 */
		{ 0xdc, 0x37, 0x37, 0x00 },  /* Pixel 64 */
		{ 0xdc, 0x37, 0x00, 0x00 },  /* Pixel 65 */
		{ 0xcc, 0x00, 0xff, 0x00 },  /* Pixel 66 */
		{ 0xdc, 0x00, 0xdc, 0x00 },  /* Pixel 67 */
		{ 0xdc, 0x00, 0xa5, 0x00 },  /* Pixel 68 */
		{ 0xdc, 0x00, 0x6e, 0x00 },  /* Pixel 69 */
		{ 0xdc, 0x00, 0x37, 0x00 },  /* Pixel 70 */
		{ 0xdc, 0x00, 0x00, 0x00 },  /* Pixel 71 */
		{ 0x99, 0xff, 0xff, 0x00 },  /* Pixel 72 */
		{ 0x99, 0xff, 0xcc, 0x00 },  /* Pixel 73 */
		{ 0x99, 0xff, 0x99, 0x00 },  /* Pixel 74 */
		{ 0x99, 0xff, 0x66, 0x00 },  /* Pixel 75 */
		{ 0x99, 0xff, 0x33, 0x00 },  /* Pixel 76 */
		{ 0x99, 0xff, 0x00, 0x00 },  /* Pixel 77 */
		{ 0x99, 0xcc, 0xff, 0x00 },  /* Pixel 78 */
		{ 0xa5, 0xdc, 0xdc, 0x00 },  /* Pixel 79 */
		{ 0xa5, 0xdc, 0xa5, 0x00 },  /* Pixel 80 */
		{ 0xa5, 0xdc, 0x6e, 0x00 },  /* Pixel 81 */
		{ 0xa5, 0xdc, 0x37, 0x00 },  /* Pixel 82 */
		{ 0xa5, 0xdc, 0x00, 0x00 },  /* Pixel 83 */
		{ 0x99, 0x99, 0xff, 0x00 },  /* Pixel 84 */
		{ 0xa5, 0xa5, 0xdc, 0x00 },  /* Pixel 85 */
		{ 0xb5, 0xb5, 0xb5, 0x00 },  /* Pixel 86 */
		{ 0xb5, 0xb5, 0x79, 0x00 },  /* Pixel 87 */
		{ 0xb5, 0xb5, 0x3c, 0x00 },  /* Pixel 88 */
		{ 0xb5, 0xb5, 0x00, 0x00 },  /* Pixel 89 */
		{ 0x99, 0x66, 0xff, 0x00 },  /* Pixel 90 */
		{ 0xa5, 0x6e, 0xdc, 0x00 },  /* Pixel 91 */
		{ 0xb5, 0x79, 0xb5, 0x00 },  /* Pixel 92 */
		{ 0xb5, 0x79, 0x79, 0x00 },  /* Pixel 93 */
		{ 0xb5, 0x79, 0x3c, 0x00 },  /* Pixel 94 */
		{ 0xb5, 0x79, 0x00, 0x00 },  /* Pixel 95 */
		{ 0x99, 0x33, 0xff, 0x00 },  /* Pixel 96 */
		{ 0xa5, 0x37, 0xdc, 0x00 },  /* Pixel 97 */
		{ 0xb5, 0x3c, 0xb5, 0x00 },  /* Pixel 98 */
		{ 0xb5, 0x3c, 0x79, 0x00 },  /* Pixel 99 */
		{ 0xb5, 0x3c, 0x3c, 0x00 },  /* Pixel 100 */
		{ 0xb5, 0x3c, 0x00, 0x00 },  /* Pixel 101 */
		{ 0x99, 0x00, 0xff, 0x00 },  /* Pixel 102 */
		{ 0xa5, 0x00, 0xdc, 0x00 },  /* Pixel 103 */
		{ 0xb5, 0x00, 0xb5, 0x00 },  /* Pixel 104 */
		{ 0xb5, 0x00, 0x79, 0x00 },  /* Pixel 105 */
		{ 0xb5, 0x00, 0x3c, 0x00 },  /* Pixel 106 */
		{ 0xb5, 0x00, 0x00, 0x00 },  /* Pixel 107 */
		{ 0x66, 0xff, 0xff, 0x00 },  /* Pixel 108 */
		{ 0x66, 0xff, 0xcc, 0x00 },  /* Pixel 109 */
		{ 0x66, 0xff, 0x99, 0x00 },  /* Pixel 110 */
		{ 0x66, 0xff, 0x66, 0x00 },  /* Pixel 111 */
		{ 0x66, 0xff, 0x33, 0x00 },  /* Pixel 112 */
		{ 0x66, 0xff, 0x00, 0x00 },  /* Pixel 113 */
		{ 0x66, 0xcc, 0xff, 0x00 },  /* Pixel 114 */
		{ 0x6e, 0xdc, 0xdc, 0x00 },  /* Pixel 115 */
		{ 0x6e, 0xdc, 0xa5, 0x00 },  /* Pixel 116 */
		{ 0x6e, 0xdc, 0x6e, 0x00 },  /* Pixel 117 */
		{ 0x6e, 0xdc, 0x37, 0x00 },  /* Pixel 118 */
		{ 0x6e, 0xdc, 0x00, 0x00 },  /* Pixel 119 */
		{ 0x66, 0x99, 0xff, 0x00 },  /* Pixel 120 */
		{ 0x6e, 0xa5, 0xdc, 0x00 },  /* Pixel 121 */
		{ 0x79, 0xb5, 0xb5, 0x00 },  /* Pixel 122 */
		{ 0x79, 0xb5, 0x79, 0x00 },  /* Pixel 123 */
		{ 0x79, 0xb5, 0x3c, 0x00 },  /* Pixel 124 */
		{ 0x79, 0xb5, 0x00, 0x00 },  /* Pixel 125 */
		{ 0x66, 0x66, 0xff, 0x00 },  /* Pixel 126 */
		{ 0x6e, 0x6e, 0xdc, 0x00 },  /* Pixel 127 */
		{ 0x79, 0x79, 0xb5, 0x00 },  /* Pixel 128 */
		{ 0x8a, 0x8a, 0x8a, 0x00 },  /* Pixel 129 */
		{ 0x8a, 0x8a, 0x45, 0x00 },  /* Pixel 130 */
		{ 0x8a, 0x8a, 0x00, 0x00 },  /* Pixel 131 */
		{ 0x66, 0x33, 0xff, 0x00 },  /* Pixel 132 */
		{ 0x6e, 0x37, 0xdc, 0x00 },  /* Pixel 133 */
		{ 0x79, 0x3c, 0xb5, 0x00 },  /* Pixel 134 */
		{ 0x8a, 0x45, 0x8a, 0x00 },  /* Pixel 135 */
		{ 0x8a, 0x45, 0x45, 0x00 },  /* Pixel 136 */
		{ 0x8a, 0x45, 0x00, 0x00 },  /* Pixel 137 */
		{ 0x66, 0x00, 0xff, 0x00 },  /* Pixel 138 */
		{ 0x6e, 0x00, 0xdc, 0x00 },  /* Pixel 139 */
		{ 0x79, 0x00, 0xb5, 0x00 },  /* Pixel 140 */
		{ 0x8a, 0x00, 0x8a, 0x00 },  /* Pixel 141 */
		{ 0x8a, 0x00, 0x45, 0x00 },  /* Pixel 142 */
		{ 0x8a, 0x00, 0x00, 0x00 },  /* Pixel 143 */
		{ 0x33, 0xff, 0xff, 0x00 },  /* Pixel 144 */
		{ 0x33, 0xff, 0xcc, 0x00 },  /* Pixel 145 */
		{ 0x33, 0xff, 0x99, 0x00 },  /* Pixel 146 */
		{ 0x33, 0xff, 0x66, 0x00 },  /* Pixel 147 */
		{ 0x33, 0xff, 0x33, 0x00 },  /* Pixel 148 */
		{ 0x33, 0xff, 0x00, 0x00 },  /* Pixel 149 */
		{ 0x33, 0xcc, 0xff, 0x00 },  /* Pixel 150 */
		{ 0x37, 0xdc, 0xdc, 0x00 },  /* Pixel 151 */
		{ 0x37, 0xdc, 0xa5, 0x00 },  /* Pixel 152 */
		{ 0x37, 0xdc, 0x6e, 0x00 },  /* Pixel 153 */
		{ 0x37, 0xdc, 0x37, 0x00 },  /* Pixel 154 */
		{ 0x37, 0xdc, 0x00, 0x00 },  /* Pixel 155 */
		{ 0x33, 0x99, 0xff, 0x00 },  /* Pixel 156 */
		{ 0x37, 0xa5, 0xdc, 0x00 },  /* Pixel 157 */
		{ 0x3c, 0xb5, 0xb5, 0x00 },  /* Pixel 158 */
		{ 0x3c, 0xb5, 0x79, 0x00 },  /* Pixel 159 */
		{ 0x3c, 0xb5, 0x3c, 0x00 },  /* Pixel 160 */
		{ 0x3c, 0xb5, 0x00, 0x00 },  /* Pixel 161 */
		{ 0x33, 0x66, 0xff, 0x00 },  /* Pixel 162 */
		{ 0x37, 0x6e, 0xdc, 0x00 },  /* Pixel 163 */
		{ 0x3c, 0x79, 0xb5, 0x00 },  /* Pixel 164 */
		{ 0x45, 0x8a, 0x8a, 0x00 },  /* Pixel 165 */
		{ 0x45, 0x8a, 0x45, 0x00 },  /* Pixel 166 */
		{ 0x45, 0x8a, 0x00, 0x00 },  /* Pixel 167 */
		{ 0x33, 0x33, 0xff, 0x00 },  /* Pixel 168 */
		{ 0x37, 0x37, 0xdc, 0x00 },  /* Pixel 169 */
		{ 0x3c, 0x3c, 0xb5, 0x00 },  /* Pixel 170 */
		{ 0x45, 0x45, 0x8a, 0x00 },  /* Pixel 171 */
		{ 0x57, 0x57, 0x57, 0x00 },  /* Pixel 172 */
		{ 0x57, 0x57, 0x00, 0x00 },  /* Pixel 173 */
		{ 0x33, 0x00, 0xff, 0x00 },  /* Pixel 174 */
		{ 0x37, 0x00, 0xdc, 0x00 },  /* Pixel 175 */
		{ 0x3c, 0x00, 0xb5, 0x00 },  /* Pixel 176 */
		{ 0x45, 0x00, 0x8a, 0x00 },  /* Pixel 177 */
		{ 0x57, 0x00, 0x57, 0x00 },  /* Pixel 178 */
		{ 0x57, 0x00, 0x00, 0x00 },  /* Pixel 179 */
		{ 0x00, 0xff, 0xff, 0x00 },  /* Pixel 180 */
		{ 0x00, 0xff, 0xcc, 0x00 },  /* Pixel 181 */
		{ 0x00, 0xff, 0x99, 0x00 },  /* Pixel 182 */
		{ 0x00, 0xff, 0x66, 0x00 },  /* Pixel 183 */
		{ 0x00, 0xff, 0x33, 0x00 },  /* Pixel 184 */
		{ 0x00, 0xff, 0x00, 0x00 },  /* Pixel 185 */
		{ 0x00, 0xcc, 0xff, 0x00 },  /* Pixel 186 */
		{ 0x00, 0xdc, 0xdc, 0x00 },  /* Pixel 187 */
		{ 0x00, 0xdc, 0xa5, 0x00 },  /* Pixel 188 */
		{ 0x00, 0xdc, 0x6e, 0x00 },  /* Pixel 189 */
		{ 0x00, 0xdc, 0x37, 0x00 },  /* Pixel 190 */
		{ 0x00, 0xdc, 0x00, 0x00 },  /* Pixel 191 */
		{ 0x00, 0x99, 0xff, 0x00 },  /* Pixel 192 */
		{ 0x00, 0xa5, 0xdc, 0x00 },  /* Pixel 193 */
		{ 0x00, 0xb5, 0xb5, 0x00 },  /* Pixel 194 */
		{ 0x00, 0xb5, 0x79, 0x00 },  /* Pixel 195 */
		{ 0x00, 0xb5, 0x3c, 0x00 },  /* Pixel 196 */
		{ 0x00, 0xb5, 0x00, 0x00 },  /* Pixel 197 */
		{ 0x00, 0x66, 0xff, 0x00 },  /* Pixel 198 */
		{ 0x00, 0x6e, 0xdc, 0x00 },  /* Pixel 199 */
		{ 0x00, 0x79, 0xb5, 0x00 },  /* Pixel 200 */
		{ 0x00, 0x8a, 0x8a, 0x00 },  /* Pixel 201 */
		{ 0x00, 0x8a, 0x45, 0x00 },  /* Pixel 202 */
		{ 0x00, 0x8a, 0x00, 0x00 },  /* Pixel 203 */
		{ 0x00, 0x33, 0xff, 0x00 },  /* Pixel 204 */
		{ 0x00, 0x37, 0xdc, 0x00 },  /* Pixel 205 */
		{ 0x00, 0x3c, 0xb5, 0x00 },  /* Pixel 206 */
		{ 0x00, 0x45, 0x8a, 0x00 },  /* Pixel 207 */
		{ 0x00, 0x57, 0x57, 0x00 },  /* Pixel 208 */
		{ 0x00, 0x57, 0x00, 0x00 },  /* Pixel 209 */
		{ 0x00, 0x00, 0xff, 0x00 },  /* Pixel 210 */
		{ 0x00, 0x00, 0xdc, 0x00 },  /* Pixel 211 */
		{ 0x00, 0x00, 0xb5, 0x00 },  /* Pixel 212 */
		{ 0x00, 0x00, 0x8a, 0x00 },  /* Pixel 213 */
		{ 0x00, 0x00, 0x57, 0x00 },  /* Pixel 214 */
		{ 0xf4, 0x00, 0x00, 0x00 },  /* Pixel 215 */
		{ 0xe8, 0x00, 0x00, 0x00 },  /* Pixel 216 */
		{ 0xcf, 0x00, 0x00, 0x00 },  /* Pixel 217 */
		{ 0xc3, 0x00, 0x00, 0x00 },  /* Pixel 218 */
		{ 0xa8, 0x00, 0x00, 0x00 },  /* Pixel 219 */
		{ 0x99, 0x00, 0x00, 0x00 },  /* Pixel 220 */
		{ 0x7b, 0x00, 0x00, 0x00 },  /* Pixel 221 */
		{ 0x6a, 0x00, 0x00, 0x00 },  /* Pixel 222 */
		{ 0x43, 0x00, 0x00, 0x00 },  /* Pixel 223 */
		{ 0x2a, 0x00, 0x00, 0x00 },  /* Pixel 224 */
		{ 0x00, 0xf4, 0x00, 0x00 },  /* Pixel 225 */
		{ 0x00, 0xe8, 0x00, 0x00 },  /* Pixel 226 */
		{ 0x00, 0xcf, 0x00, 0x00 },  /* Pixel 227 */
		{ 0x00, 0xc3, 0x00, 0x00 },  /* Pixel 228 */
		{ 0x00, 0xa8, 0x00, 0x00 },  /* Pixel 229 */
		{ 0x00, 0x99, 0x00, 0x00 },  /* Pixel 230 */
		{ 0x00, 0x7b, 0x00, 0x00 },  /* Pixel 231 */
		{ 0x00, 0x6a, 0x00, 0x00 },  /* Pixel 232 */
		{ 0x00, 0x43, 0x00, 0x00 },  /* Pixel 233 */
		{ 0x00, 0x2a, 0x00, 0x00 },  /* Pixel 234 */
		{ 0x00, 0x00, 0xf4, 0x00 },  /* Pixel 235 */
		{ 0x00, 0x00, 0xe8, 0x00 },  /* Pixel 236 */
		{ 0x00, 0x00, 0xcf, 0x00 },  /* Pixel 237 */
		{ 0x00, 0x00, 0xc3, 0x00 },  /* Pixel 238 */
		{ 0x00, 0x00, 0xa8, 0x00 },  /* Pixel 239 */
		{ 0x00, 0x00, 0x99, 0x00 },  /* Pixel 240 */
		{ 0x00, 0x00, 0x7b, 0x00 },  /* Pixel 241 */
		{ 0x00, 0x00, 0x6a, 0x00 },  /* Pixel 242 */
		{ 0x00, 0x00, 0x43, 0x00 },  /* Pixel 243 */
		{ 0x00, 0x00, 0x2a, 0x00 },  /* Pixel 244 */
		{ 0xf4, 0xf4, 0xf4, 0x00 },  /* Pixel 245 */
		{ 0xe8, 0xe8, 0xe8, 0x00 },  /* Pixel 246 */
		{ 0xcf, 0xcf, 0xcf, 0x00 },  /* Pixel 247 */
		{ 0xc3, 0xc3, 0xc3, 0x00 },  /* Pixel 248 */
		{ 0xa8, 0xa8, 0xa8, 0x00 },  /* Pixel 249 */
		{ 0x99, 0x99, 0x99, 0x00 },  /* Pixel 250 */
		{ 0x7b, 0x7b, 0x7b, 0x00 },  /* Pixel 251 */
		{ 0x6a, 0x6a, 0x6a, 0x00 },  /* Pixel 252 */
		{ 0x43, 0x43, 0x43, 0x00 },  /* Pixel 253 */
		{ 0x2a, 0x2a, 0x2a, 0x00 },  /* Pixel 254 */
		{ 0x00, 0x00, 0x00, 0x00 },  /* Pixel 255 */
	},

	/* Gamma level 3 */
	{
		{ 0xff, 0xff, 0xff, 0x00 },  /* Pixel 0 */
		{ 0xff, 0xff, 0xcc, 0x00 },  /* Pixel 1 */
		{ 0xff, 0xff, 0x99, 0x00 },  /* Pixel 2 */
		{ 0xff, 0xff, 0x66, 0x00 },  /* Pixel 3 */
		{ 0xff, 0xff, 0x33, 0x00 },  /* Pixel 4 */
		{ 0xff, 0xff, 0x00, 0x00 },  /* Pixel 5 */
		{ 0xff, 0xcc, 0xff, 0x00 },  /* Pixel 6 */
		{ 0xff, 0xcc, 0xcc, 0x00 },  /* Pixel 7 */
		{ 0xff, 0xcc, 0x99, 0x00 },  /* Pixel 8 */
		{ 0xff, 0xcc, 0x66, 0x00 },  /* Pixel 9 */
		{ 0xff, 0xcc, 0x33, 0x00 },  /* Pixel 10 */
		{ 0xff, 0xcc, 0x00, 0x00 },  /* Pixel 11 */
		{ 0xff, 0x99, 0xff, 0x00 },  /* Pixel 12 */
		{ 0xff, 0x99, 0xcc, 0x00 },  /* Pixel 13 */
		{ 0xff, 0x99, 0x99, 0x00 },  /* Pixel 14 */
		{ 0xff, 0x99, 0x66, 0x00 },  /* Pixel 15 */
		{ 0xff, 0x99, 0x33, 0x00 },  /* Pixel 16 */
		{ 0xff, 0x99, 0x00, 0x00 },  /* Pixel 17 */
		{ 0xff, 0x66, 0xff, 0x00 },  /* Pixel 18 */
		{ 0xff, 0x66, 0xcc, 0x00 },  /* Pixel 19 */
		{ 0xff, 0x66, 0x99, 0x00 },  /* Pixel 20 */
		{ 0xff, 0x66, 0x66, 0x00 },  /* Pixel 21 */
		{ 0xff, 0x66, 0x33, 0x00 },  /* Pixel 22 */
		{ 0xff, 0x66, 0x00, 0x00 },  /* Pixel 23 */
		{ 0xff, 0x33, 0xff, 0x00 },  /* Pixel 24 */
		{ 0xff, 0x33, 0xcc, 0x00 },  /* Pixel 25 */
		{ 0xff, 0x33, 0x99, 0x00 },  /* Pixel 26 */
		{ 0xff, 0x33, 0x66, 0x00 },  /* Pixel 27 */
		{ 0xff, 0x33, 0x33, 0x00 },  /* Pixel 28 */
		{ 0xff, 0x33, 0x00, 0x00 },  /* Pixel 29 */
		{ 0xff, 0x00, 0xff, 0x00 },  /* Pixel 30 */
		{ 0xff, 0x00, 0xcc, 0x00 },  /* Pixel 31 */
		{ 0xff, 0x00, 0x99, 0x00 },  /* Pixel 32 */
		{ 0xff, 0x00, 0x66, 0x00 },  /* Pixel 33 */
		{ 0xff, 0x00, 0x33, 0x00 },  /* Pixel 34 */
		{ 0xff, 0x00, 0x00, 0x00 },  /* Pixel 35 */
		{ 0xcc, 0xff, 0xff, 0x00 },  /* Pixel 36 */
		{ 0xcc, 0xff, 0xcc, 0x00 },  /* Pixel 37 */
		{ 0xcc, 0xff, 0x99, 0x00 },  /* Pixel 38 */
		{ 0xcc, 0xff, 0x66, 0x00 },  /* Pixel 39 */
		{ 0xcc, 0xff, 0x33, 0x00 },  /* Pixel 40 */
		{ 0xcc, 0xff, 0x00, 0x00 },  /* Pixel 41 */
		{ 0xcc, 0xcc, 0xff, 0x00 },  /* Pixel 42 */
		{ 0xe0, 0xe0, 0xe0, 0x00 },  /* Pixel 43 */
		{ 0xe0, 0xe0, 0xa8, 0x00 },  /* Pixel 44 */
		{ 0xe0, 0xe0, 0x70, 0x00 },  /* Pixel 45 */
		{ 0xe0, 0xe0, 0x38, 0x00 },  /* Pixel 46 */
		{ 0xe0, 0xe0, 0x00, 0x00 },  /* Pixel 47 */
		{ 0xcc, 0x99, 0xff, 0x00 },  /* Pixel 48 */
		{ 0xe0, 0xa8, 0xe0, 0x00 },  /* Pixel 49 */
		{ 0xe0, 0xa8, 0xa8, 0x00 },  /* Pixel 50 */
		{ 0xe0, 0xa8, 0x70, 0x00 },  /* Pixel 51 */
		{ 0xe0, 0xa8, 0x38, 0x00 },  /* Pixel 52 */
		{ 0xe0, 0xa8, 0x00, 0x00 },  /* Pixel 53 */
		{ 0xcc, 0x66, 0xff, 0x00 },  /* Pixel 54 */
		{ 0xe0, 0x70, 0xe0, 0x00 },  /* Pixel 55 */
		{ 0xe0, 0x70, 0xa8, 0x00 },  /* Pixel 56 */
		{ 0xe0, 0x70, 0x70, 0x00 },  /* Pixel 57 */
		{ 0xe0, 0x70, 0x38, 0x00 },  /* Pixel 58 */
		{ 0xe0, 0x70, 0x00, 0x00 },  /* Pixel 59 */
		{ 0xcc, 0x33, 0xff, 0x00 },  /* Pixel 60 */
		{ 0xe0, 0x38, 0xe0, 0x00 },  /* Pixel 61 */
		{ 0xe0, 0x38, 0xa8, 0x00 },  /* Pixel 62 */
		{ 0xe0, 0x38, 0x70, 0x00 },  /* Pixel 63 */
		{ 0xe0, 0x38, 0x38, 0x00 },  /* Pixel 64 */
		{ 0xe0, 0x38, 0x00, 0x00 },  /* Pixel 65 */
		{ 0xcc, 0x00, 0xff, 0x00 },  /* Pixel 66 */
		{ 0xe0, 0x00, 0xe0, 0x00 },  /* Pixel 67 */
		{ 0xe0, 0x00, 0xa8, 0x00 },  /* Pixel 68 */
		{ 0xe0, 0x00, 0x70, 0x00 },  /* Pixel 69 */
		{ 0xe0, 0x00, 0x38, 0x00 },  /* Pixel 70 */
		{ 0xe0, 0x00, 0x00, 0x00 },  /* Pixel 71 */
		{ 0x99, 0xff, 0xff, 0x00 },  /* Pixel 72 */
		{ 0x99, 0xff, 0xcc, 0x00 },  /* Pixel 73 */
		{ 0x99, 0xff, 0x99, 0x00 },  /* Pixel 74 */
		{ 0x99, 0xff, 0x66, 0x00 },  /* Pixel 75 */
		{ 0x99, 0xff, 0x33, 0x00 },  /* Pixel 76 */
		{ 0x99, 0xff, 0x00, 0x00 },  /* Pixel 77 */
		{ 0x99, 0xcc, 0xff, 0x00 },  /* Pixel 78 */
		{ 0xa8, 0xe0, 0xe0, 0x00 },  /* Pixel 79 */
		{ 0xa8, 0xe0, 0xa8, 0x00 },  /* Pixel 80 */
		{ 0xa8, 0xe0, 0x70, 0x00 },  /* Pixel 81 */
		{ 0xa8, 0xe0, 0x38, 0x00 },  /* Pixel 82 */
		{ 0xa8, 0xe0, 0x00, 0x00 },  /* Pixel 83 */
		{ 0x99, 0x99, 0xff, 0x00 },  /* Pixel 84 */
		{ 0xa8, 0xa8, 0xe0, 0x00 },  /* Pixel 85 */
		{ 0xbe, 0xbe, 0xbe, 0x00 },  /* Pixel 86 */
		{ 0xbe, 0xbe, 0x7f, 0x00 },  /* Pixel 87 */
		{ 0xbe, 0xbe, 0x3f, 0x00 },  /* Pixel 88 */
		{ 0xbe, 0xbe, 0x00, 0x00 },  /* Pixel 89 */
		{ 0x99, 0x66, 0xff, 0x00 },  /* Pixel 90 */
		{ 0xa8, 0x70, 0xe0, 0x00 },  /* Pixel 91 */
		{ 0xbe, 0x7f, 0xbe, 0x00 },  /* Pixel 92 */
		{ 0xbe, 0x7f, 0x7f, 0x00 },  /* Pixel 93 */
		{ 0xbe, 0x7f, 0x3f, 0x00 },  /* Pixel 94 */
		{ 0xbe, 0x7f, 0x00, 0x00 },  /* Pixel 95 */
		{ 0x99, 0x33, 0xff, 0x00 },  /* Pixel 96 */
		{ 0xa8, 0x38, 0xe0, 0x00 },  /* Pixel 97 */
		{ 0xbe, 0x3f, 0xbe, 0x00 },  /* Pixel 98 */
		{ 0xbe, 0x3f, 0x7f, 0x00 },  /* Pixel 99 */
		{ 0xbe, 0x3f, 0x3f, 0x00 },  /* Pixel 100 */
		{ 0xbe, 0x3f, 0x00, 0x00 },  /* Pixel 101 */
		{ 0x99, 0x00, 0xff, 0x00 },  /* Pixel 102 */
		{ 0xa8, 0x00, 0xe0, 0x00 },  /* Pixel 103 */
		{ 0xbe, 0x00, 0xbe, 0x00 },  /* Pixel 104 */
		{ 0xbe, 0x00, 0x7f, 0x00 },  /* Pixel 105 */
		{ 0xbe, 0x00, 0x3f, 0x00 },  /* Pixel 106 */
		{ 0xbe, 0x00, 0x00, 0x00 },  /* Pixel 107 */
		{ 0x66, 0xff, 0xff, 0x00 },  /* Pixel 108 */
		{ 0x66, 0xff, 0xcc, 0x00 },  /* Pixel 109 */
		{ 0x66, 0xff, 0x99, 0x00 },  /* Pixel 110 */
		{ 0x66, 0xff, 0x66, 0x00 },  /* Pixel 111 */
		{ 0x66, 0xff, 0x33, 0x00 },  /* Pixel 112 */
		{ 0x66, 0xff, 0x00, 0x00 },  /* Pixel 113 */
		{ 0x66, 0xcc, 0xff, 0x00 },  /* Pixel 114 */
		{ 0x70, 0xe0, 0xe0, 0x00 },  /* Pixel 115 */
		{ 0x70, 0xe0, 0xa8, 0x00 },  /* Pixel 116 */
		{ 0x70, 0xe0, 0x70, 0x00 },  /* Pixel 117 */
		{ 0x70, 0xe0, 0x38, 0x00 },  /* Pixel 118 */
		{ 0x70, 0xe0, 0x00, 0x00 },  /* Pixel 119 */
		{ 0x66, 0x99, 0xff, 0x00 },  /* Pixel 120 */
		{ 0x70, 0xa8, 0xe0, 0x00 },  /* Pixel 121 */
		{ 0x7f, 0xbe, 0xbe, 0x00 },  /* Pixel 122 */
		{ 0x7f, 0xbe, 0x7f, 0x00 },  /* Pixel 123 */
		{ 0x7f, 0xbe, 0x3f, 0x00 },  /* Pixel 124 */
		{ 0x7f, 0xbe, 0x00, 0x00 },  /* Pixel 125 */
		{ 0x66, 0x66, 0xff, 0x00 },  /* Pixel 126 */
		{ 0x70, 0x70, 0xe0, 0x00 },  /* Pixel 127 */
		{ 0x7f, 0x7f, 0xbe, 0x00 },  /* Pixel 128 */
		{ 0x97, 0x97, 0x97, 0x00 },  /* Pixel 129 */
		{ 0x97, 0x97, 0x4c, 0x00 },  /* Pixel 130 */
		{ 0x97, 0x97, 0x00, 0x00 },  /* Pixel 131 */
		{ 0x66, 0x33, 0xff, 0x00 },  /* Pixel 132 */
		{ 0x70, 0x38, 0xe0, 0x00 },  /* Pixel 133 */
		{ 0x7f, 0x3f, 0xbe, 0x00 },  /* Pixel 134 */
		{ 0x97, 0x4c, 0x97, 0x00 },  /* Pixel 135 */
		{ 0x97, 0x4c, 0x4c, 0x00 },  /* Pixel 136 */
		{ 0x97, 0x4c, 0x00, 0x00 },  /* Pixel 137 */
		{ 0x66, 0x00, 0xff, 0x00 },  /* Pixel 138 */
		{ 0x70, 0x00, 0xe0, 0x00 },  /* Pixel 139 */
		{ 0x7f, 0x00, 0xbe, 0x00 },  /* Pixel 140 */
		{ 0x97, 0x00, 0x97, 0x00 },  /* Pixel 141 */
		{ 0x97, 0x00, 0x4c, 0x00 },  /* Pixel 142 */
		{ 0x97, 0x00, 0x00, 0x00 },  /* Pixel 143 */
		{ 0x33, 0xff, 0xff, 0x00 },  /* Pixel 144 */
		{ 0x33, 0xff, 0xcc, 0x00 },  /* Pixel 145 */
		{ 0x33, 0xff, 0x99, 0x00 },  /* Pixel 146 */
		{ 0x33, 0xff, 0x66, 0x00 },  /* Pixel 147 */
		{ 0x33, 0xff, 0x33, 0x00 },  /* Pixel 148 */
		{ 0x33, 0xff, 0x00, 0x00 },  /* Pixel 149 */
		{ 0x33, 0xcc, 0xff, 0x00 },  /* Pixel 150 */
		{ 0x38, 0xe0, 0xe0, 0x00 },  /* Pixel 151 */
		{ 0x38, 0xe0, 0xa8, 0x00 },  /* Pixel 152 */
		{ 0x38, 0xe0, 0x70, 0x00 },  /* Pixel 153 */
		{ 0x38, 0xe0, 0x38, 0x00 },  /* Pixel 154 */
		{ 0x38, 0xe0, 0x00, 0x00 },  /* Pixel 155 */
		{ 0x33, 0x99, 0xff, 0x00 },  /* Pixel 156 */
		{ 0x38, 0xa8, 0xe0, 0x00 },  /* Pixel 157 */
		{ 0x3f, 0xbe, 0xbe, 0x00 },  /* Pixel 158 */
		{ 0x3f, 0xbe, 0x7f, 0x00 },  /* Pixel 159 */
		{ 0x3f, 0xbe, 0x3f, 0x00 },  /* Pixel 160 */
		{ 0x3f, 0xbe, 0x00, 0x00 },  /* Pixel 161 */
		{ 0x33, 0x66, 0xff, 0x00 },  /* Pixel 162 */
		{ 0x38, 0x70, 0xe0, 0x00 },  /* Pixel 163 */
		{ 0x3f, 0x7f, 0xbe, 0x00 },  /* Pixel 164 */
		{ 0x4c, 0x97, 0x97, 0x00 },  /* Pixel 165 */
		{ 0x4c, 0x97, 0x4c, 0x00 },  /* Pixel 166 */
		{ 0x4c, 0x97, 0x00, 0x00 },  /* Pixel 167 */
		{ 0x33, 0x33, 0xff, 0x00 },  /* Pixel 168 */
		{ 0x38, 0x38, 0xe0, 0x00 },  /* Pixel 169 */
		{ 0x3f, 0x3f, 0xbe, 0x00 },  /* Pixel 170 */
		{ 0x4c, 0x4c, 0x97, 0x00 },  /* Pixel 171 */
		{ 0x66, 0x66, 0x66, 0x00 },  /* Pixel 172 */
		{ 0x66, 0x66, 0x00, 0x00 },  /* Pixel 173 */
		{ 0x33, 0x00, 0xff, 0x00 },  /* Pixel 174 */
		{ 0x38, 0x00, 0xe0, 0x00 },  /* Pixel 175 */
		{ 0x3f, 0x00, 0xbe, 0x00 },  /* Pixel 176 */
		{ 0x4c, 0x00, 0x97, 0x00 },  /* Pixel 177 */
		{ 0x66, 0x00, 0x66, 0x00 },  /* Pixel 178 */
		{ 0x66, 0x00, 0x00, 0x00 },  /* Pixel 179 */
		{ 0x00, 0xff, 0xff, 0x00 },  /* Pixel 180 */
		{ 0x00, 0xff, 0xcc, 0x00 },  /* Pixel 181 */
		{ 0x00, 0xff, 0x99, 0x00 },  /* Pixel 182 */
		{ 0x00, 0xff, 0x66, 0x00 },  /* Pixel 183 */
		{ 0x00, 0xff, 0x33, 0x00 },  /* Pixel 184 */
		{ 0x00, 0xff, 0x00, 0x00 },  /* Pixel 185 */
		{ 0x00, 0xcc, 0xff, 0x00 },  /* Pixel 186 */
		{ 0x00, 0xe0, 0xe0, 0x00 },  /* Pixel 187 */
		{ 0x00, 0xe0, 0xa8, 0x00 },  /* Pixel 188 */
		{ 0x00, 0xe0, 0x70, 0x00 },  /* Pixel 189 */
		{ 0x00, 0xe0, 0x38, 0x00 },  /* Pixel 190 */
		{ 0x00, 0xe0, 0x00, 0x00 },  /* Pixel 191 */
		{ 0x00, 0x99, 0xff, 0x00 },  /* Pixel 192 */
		{ 0x00, 0xa8, 0xe0, 0x00 },  /* Pixel 193 */
		{ 0x00, 0xbe, 0xbe, 0x00 },  /* Pixel 194 */
		{ 0x00, 0xbe, 0x7f, 0x00 },  /* Pixel 195 */
		{ 0x00, 0xbe, 0x3f, 0x00 },  /* Pixel 196 */
		{ 0x00, 0xbe, 0x00, 0x00 },  /* Pixel 197 */
		{ 0x00, 0x66, 0xff, 0x00 },  /* Pixel 198 */
		{ 0x00, 0x70, 0xe0, 0x00 },  /* Pixel 199 */
		{ 0x00, 0x7f, 0xbe, 0x00 },  /* Pixel 200 */
		{ 0x00, 0x97, 0x97, 0x00 },  /* Pixel 201 */
		{ 0x00, 0x97, 0x4c, 0x00 },  /* Pixel 202 */
		{ 0x00, 0x97, 0x00, 0x00 },  /* Pixel 203 */
		{ 0x00, 0x33, 0xff, 0x00 },  /* Pixel 204 */
		{ 0x00, 0x38, 0xe0, 0x00 },  /* Pixel 205 */
		{ 0x00, 0x3f, 0xbe, 0x00 },  /* Pixel 206 */
		{ 0x00, 0x4c, 0x97, 0x00 },  /* Pixel 207 */
		{ 0x00, 0x66, 0x66, 0x00 },  /* Pixel 208 */
		{ 0x00, 0x66, 0x00, 0x00 },  /* Pixel 209 */
		{ 0x00, 0x00, 0xff, 0x00 },  /* Pixel 210 */
		{ 0x00, 0x00, 0xe0, 0x00 },  /* Pixel 211 */
		{ 0x00, 0x00, 0xbe, 0x00 },  /* Pixel 212 */
		{ 0x00, 0x00, 0x97, 0x00 },  /* Pixel 213 */
		{ 0x00, 0x00, 0x66, 0x00 },  /* Pixel 214 */
		{ 0xf5, 0x00, 0x00, 0x00 },  /* Pixel 215 */
		{ 0xeb, 0x00, 0x00, 0x00 },  /* Pixel 216 */
		{ 0xd6, 0x00, 0x00, 0x00 },  /* Pixel 217 */
		{ 0xca, 0x00, 0x00, 0x00 },  /* Pixel 218 */
		{ 0xb2, 0x00, 0x00, 0x00 },  /* Pixel 219 */
		{ 0xa5, 0x00, 0x00, 0x00 },  /* Pixel 220 */
		{ 0x88, 0x00, 0x00, 0x00 },  /* Pixel 221 */
		{ 0x78, 0x00, 0x00, 0x00 },  /* Pixel 222 */
		{ 0x51, 0x00, 0x00, 0x00 },  /* Pixel 223 */
		{ 0x36, 0x00, 0x00, 0x00 },  /* Pixel 224 */
		{ 0x00, 0xf5, 0x00, 0x00 },  /* Pixel 225 */
		{ 0x00, 0xeb, 0x00, 0x00 },  /* Pixel 226 */
		{ 0x00, 0xd6, 0x00, 0x00 },  /* Pixel 227 */
		{ 0x00, 0xca, 0x00, 0x00 },  /* Pixel 228 */
		{ 0x00, 0xb2, 0x00, 0x00 },  /* Pixel 229 */
		{ 0x00, 0xa5, 0x00, 0x00 },  /* Pixel 230 */
		{ 0x00, 0x88, 0x00, 0x00 },  /* Pixel 231 */
		{ 0x00, 0x78, 0x00, 0x00 },  /* Pixel 232 */
		{ 0x00, 0x51, 0x00, 0x00 },  /* Pixel 233 */
		{ 0x00, 0x36, 0x00, 0x00 },  /* Pixel 234 */
		{ 0x00, 0x00, 0xf5, 0x00 },  /* Pixel 235 */
		{ 0x00, 0x00, 0xeb, 0x00 },  /* Pixel 236 */
		{ 0x00, 0x00, 0xd6, 0x00 },  /* Pixel 237 */
		{ 0x00, 0x00, 0xca, 0x00 },  /* Pixel 238 */
		{ 0x00, 0x00, 0xb2, 0x00 },  /* Pixel 239 */
		{ 0x00, 0x00, 0xa5, 0x00 },  /* Pixel 240 */
		{ 0x00, 0x00, 0x88, 0x00 },  /* Pixel 241 */
		{ 0x00, 0x00, 0x78, 0x00 },  /* Pixel 242 */
		{ 0x00, 0x00, 0x51, 0x00 },  /* Pixel 243 */
		{ 0x00, 0x00, 0x36, 0x00 },  /* Pixel 244 */
		{ 0xf5, 0xf5, 0xf5, 0x00 },  /* Pixel 245 */
		{ 0xeb, 0xeb, 0xeb, 0x00 },  /* Pixel 246 */
		{ 0xd6, 0xd6, 0xd6, 0x00 },  /* Pixel 247 */
		{ 0xca, 0xca, 0xca, 0x00 },  /* Pixel 248 */
		{ 0xb2, 0xb2, 0xb2, 0x00 },  /* Pixel 249 */
		{ 0xa5, 0xa5, 0xa5, 0x00 },  /* Pixel 250 */
		{ 0x88, 0x88, 0x88, 0x00 },  /* Pixel 251 */
		{ 0x78, 0x78, 0x78, 0x00 },  /* Pixel 252 */
		{ 0x51, 0x51, 0x51, 0x00 },  /* Pixel 253 */
		{ 0x36, 0x36, 0x36, 0x00 },  /* Pixel 254 */
		{ 0x00, 0x00, 0x00, 0x00 },  /* Pixel 255 */
	},

	/* Gamma level 4 */
	{
		{ 0xff, 0xff, 0xff, 0x00 },  /* Pixel 0 */
		{ 0xff, 0xff, 0xcc, 0x00 },  /* Pixel 1 */
		{ 0xff, 0xff, 0x99, 0x00 },  /* Pixel 2 */
		{ 0xff, 0xff, 0x66, 0x00 },  /* Pixel 3 */
		{ 0xff, 0xff, 0x33, 0x00 },  /* Pixel 4 */
		{ 0xff, 0xff, 0x00, 0x00 },  /* Pixel 5 */
		{ 0xff, 0xcc, 0xff, 0x00 },  /* Pixel 6 */
		{ 0xff, 0xcc, 0xcc, 0x00 },  /* Pixel 7 */
		{ 0xff, 0xcc, 0x99, 0x00 },  /* Pixel 8 */
		{ 0xff, 0xcc, 0x66, 0x00 },  /* Pixel 9 */
		{ 0xff, 0xcc, 0x33, 0x00 },  /* Pixel 10 */
		{ 0xff, 0xcc, 0x00, 0x00 },  /* Pixel 11 */
		{ 0xff, 0x99, 0xff, 0x00 },  /* Pixel 12 */
		{ 0xff, 0x99, 0xcc, 0x00 },  /* Pixel 13 */
		{ 0xff, 0x99, 0x99, 0x00 },  /* Pixel 14 */
		{ 0xff, 0x99, 0x66, 0x00 },  /* Pixel 15 */
		{ 0xff, 0x99, 0x33, 0x00 },  /* Pixel 16 */
		{ 0xff, 0x99, 0x00, 0x00 },  /* Pixel 17 */
		{ 0xff, 0x66, 0xff, 0x00 },  /* Pixel 18 */
		{ 0xff, 0x66, 0xcc, 0x00 },  /* Pixel 19 */
		{ 0xff, 0x66, 0x99, 0x00 },  /* Pixel 20 */
		{ 0xff, 0x66, 0x66, 0x00 },  /* Pixel 21 */
		{ 0xff, 0x66, 0x33, 0x00 },  /* Pixel 22 */
		{ 0xff, 0x66, 0x00, 0x00 },  /* Pixel 23 */
		{ 0xff, 0x33, 0xff, 0x00 },  /* Pixel 24 */
		{ 0xff, 0x33, 0xcc, 0x00 },  /* Pixel 25 */
		{ 0xff, 0x33, 0x99, 0x00 },  /* Pixel 26 */
		{ 0xff, 0x33, 0x66, 0x00 },  /* Pixel 27 */
		{ 0xff, 0x33, 0x33, 0x00 },  /* Pixel 28 */
		{ 0xff, 0x33, 0x00, 0x00 },  /* Pixel 29 */
		{ 0xff, 0x00, 0xff, 0x00 },  /* Pixel 30 */
		{ 0xff, 0x00, 0xcc, 0x00 },  /* Pixel 31 */
		{ 0xff, 0x00, 0x99, 0x00 },  /* Pixel 32 */
		{ 0xff, 0x00, 0x66, 0x00 },  /* Pixel 33 */
		{ 0xff, 0x00, 0x33, 0x00 },  /* Pixel 34 */
		{ 0xff, 0x00, 0x00, 0x00 },  /* Pixel 35 */
		{ 0xcc, 0xff, 0xff, 0x00 },  /* Pixel 36 */
		{ 0xcc, 0xff, 0xcc, 0x00 },  /* Pixel 37 */
		{ 0xcc, 0xff, 0x99, 0x00 },  /* Pixel 38 */
		{ 0xcc, 0xff, 0x66, 0x00 },  /* Pixel 39 */
		{ 0xcc, 0xff, 0x33, 0x00 },  /* Pixel 40 */
		{ 0xcc, 0xff, 0x00, 0x00 },  /* Pixel 41 */
		{ 0xcc, 0xcc, 0xff, 0x00 },  /* Pixel 42 */
		{ 0xe4, 0xe4, 0xe4, 0x00 },  /* Pixel 43 */
		{ 0xe4, 0xe4, 0xab, 0x00 },  /* Pixel 44 */
		{ 0xe4, 0xe4, 0x72, 0x00 },  /* Pixel 45 */
		{ 0xe4, 0xe4, 0x39, 0x00 },  /* Pixel 46 */
		{ 0xe4, 0xe4, 0x00, 0x00 },  /* Pixel 47 */
		{ 0xcc, 0x99, 0xff, 0x00 },  /* Pixel 48 */
		{ 0xe4, 0xab, 0xe4, 0x00 },  /* Pixel 49 */
		{ 0xe4, 0xab, 0xab, 0x00 },  /* Pixel 50 */
		{ 0xe4, 0xab, 0x72, 0x00 },  /* Pixel 51 */
		{ 0xe4, 0xab, 0x39, 0x00 },  /* Pixel 52 */
		{ 0xe4, 0xab, 0x00, 0x00 },  /* Pixel 53 */
		{ 0xcc, 0x66, 0xff, 0x00 },  /* Pixel 54 */
		{ 0xe4, 0x72, 0xe4, 0x00 },  /* Pixel 55 */
		{ 0xe4, 0x72, 0xab, 0x00 },  /* Pixel 56 */
		{ 0xe4, 0x72, 0x72, 0x00 },  /* Pixel 57 */
		{ 0xe4, 0x72, 0x39, 0x00 },  /* Pixel 58 */
		{ 0xe4, 0x72, 0x00, 0x00 },  /* Pixel 59 */
		{ 0xcc, 0x33, 0xff, 0x00 },  /* Pixel 60 */
		{ 0xe4, 0x39, 0xe4, 0x00 },  /* Pixel 61 */
		{ 0xe4, 0x39, 0xab, 0x00 },  /* Pixel 62 */
		{ 0xe4, 0x39, 0x72, 0x00 },  /* Pixel 63 */
		{ 0xe4, 0x39, 0x39, 0x00 },  /* Pixel 64 */
		{ 0xe4, 0x39, 0x00, 0x00 },  /* Pixel 65 */
		{ 0xcc, 0x00, 0xff, 0x00 },  /* Pixel 66 */
		{ 0xe4, 0x00, 0xe4, 0x00 },  /* Pixel 67 */
		{ 0xe4, 0x00, 0xab, 0x00 },  /* Pixel 68 */
		{ 0xe4, 0x00, 0x72, 0x00 },  /* Pixel 69 */
		{ 0xe4, 0x00, 0x39, 0x00 },  /* Pixel 70 */
		{ 0xe4, 0x00, 0x00, 0x00 },  /* Pixel 71 */
		{ 0x99, 0xff, 0xff, 0x00 },  /* Pixel 72 */
		{ 0x99, 0xff, 0xcc, 0x00 },  /* Pixel 73 */
		{ 0x99, 0xff, 0x99, 0x00 },  /* Pixel 74 */
		{ 0x99, 0xff, 0x66, 0x00 },  /* Pixel 75 */
		{ 0x99, 0xff, 0x33, 0x00 },  /* Pixel 76 */
		{ 0x99, 0xff, 0x00, 0x00 },  /* Pixel 77 */
		{ 0x99, 0xcc, 0xff, 0x00 },  /* Pixel 78 */
		{ 0xab, 0xe4, 0xe4, 0x00 },  /* Pixel 79 */
		{ 0xab, 0xe4, 0xab, 0x00 },  /* Pixel 80 */
		{ 0xab, 0xe4, 0x72, 0x00 },  /* Pixel 81 */
		{ 0xab, 0xe4, 0x39, 0x00 },  /* Pixel 82 */
		{ 0xab, 0xe4, 0x00, 0x00 },  /* Pixel 83 */
		{ 0x99, 0x99, 0xff, 0x00 },  /* Pixel 84 */
		{ 0xab, 0xab, 0xe4, 0x00 },  /* Pixel 85 */
		{ 0xc6, 0xc6, 0xc6, 0x00 },  /* Pixel 86 */
		{ 0xc6, 0xc6, 0x84, 0x00 },  /* Pixel 87 */
		{ 0xc6, 0xc6, 0x42, 0x00 },  /* Pixel 88 */
		{ 0xc6, 0xc6, 0x00, 0x00 },  /* Pixel 89 */
		{ 0x99, 0x66, 0xff, 0x00 },  /* Pixel 90 */
		{ 0xab, 0x72, 0xe4, 0x00 },  /* Pixel 91 */
		{ 0xc6, 0x84, 0xc6, 0x00 },  /* Pixel 92 */
		{ 0xc6, 0x84, 0x84, 0x00 },  /* Pixel 93 */
		{ 0xc6, 0x84, 0x42, 0x00 },  /* Pixel 94 */
		{ 0xc6, 0x84, 0x00, 0x00 },  /* Pixel 95 */
		{ 0x99, 0x33, 0xff, 0x00 },  /* Pixel 96 */
		{ 0xab, 0x39, 0xe4, 0x00 },  /* Pixel 97 */
		{ 0xc6, 0x42, 0xc6, 0x00 },  /* Pixel 98 */
		{ 0xc6, 0x42, 0x84, 0x00 },  /* Pixel 99 */
		{ 0xc6, 0x42, 0x42, 0x00 },  /* Pixel 100 */
		{ 0xc6, 0x42, 0x00, 0x00 },  /* Pixel 101 */
		{ 0x99, 0x00, 0xff, 0x00 },  /* Pixel 102 */
		{ 0xab, 0x00, 0xe4, 0x00 },  /* Pixel 103 */
		{ 0xc6, 0x00, 0xc6, 0x00 },  /* Pixel 104 */
		{ 0xc6, 0x00, 0x84, 0x00 },  /* Pixel 105 */
		{ 0xc6, 0x00, 0x42, 0x00 },  /* Pixel 106 */
		{ 0xc6, 0x00, 0x00, 0x00 },  /* Pixel 107 */
		{ 0x66, 0xff, 0xff, 0x00 },  /* Pixel 108 */
		{ 0x66, 0xff, 0xcc, 0x00 },  /* Pixel 109 */
		{ 0x66, 0xff, 0x99, 0x00 },  /* Pixel 110 */
		{ 0x66, 0xff, 0x66, 0x00 },  /* Pixel 111 */
		{ 0x66, 0xff, 0x33, 0x00 },  /* Pixel 112 */
		{ 0x66, 0xff, 0x00, 0x00 },  /* Pixel 113 */
		{ 0x66, 0xcc, 0xff, 0x00 },  /* Pixel 114 */
		{ 0x72, 0xe4, 0xe4, 0x00 },  /* Pixel 115 */
		{ 0x72, 0xe4, 0xab, 0x00 },  /* Pixel 116 */
		{ 0x72, 0xe4, 0x72, 0x00 },  /* Pixel 117 */
		{ 0x72, 0xe4, 0x39, 0x00 },  /* Pixel 118 */
		{ 0x72, 0xe4, 0x00, 0x00 },  /* Pixel 119 */
		{ 0x66, 0x99, 0xff, 0x00 },  /* Pixel 120 */
		{ 0x72, 0xab, 0xe4, 0x00 },  /* Pixel 121 */
		{ 0x84, 0xc6, 0xc6, 0x00 },  /* Pixel 122 */
		{ 0x84, 0xc6, 0x84, 0x00 },  /* Pixel 123 */
		{ 0x84, 0xc6, 0x42, 0x00 },  /* Pixel 124 */
		{ 0x84, 0xc6, 0x00, 0x00 },  /* Pixel 125 */
		{ 0x66, 0x66, 0xff, 0x00 },  /* Pixel 126 */
		{ 0x72, 0x72, 0xe4, 0x00 },  /* Pixel 127 */
		{ 0x84, 0x84, 0xc6, 0x00 },  /* Pixel 128 */
		{ 0xa1, 0xa1, 0xa1, 0x00 },  /* Pixel 129 */
		{ 0xa1, 0xa1, 0x51, 0x00 },  /* Pixel 130 */
		{ 0xa1, 0xa1, 0x00, 0x00 },  /* Pixel 131 */
		{ 0x66, 0x33, 0xff, 0x00 },  /* Pixel 132 */
		{ 0x72, 0x39, 0xe4, 0x00 },  /* Pixel 133 */
		{ 0x84, 0x42, 0xc6, 0x00 },  /* Pixel 134 */
		{ 0xa1, 0x51, 0xa1, 0x00 },  /* Pixel 135 */
		{ 0xa1, 0x51, 0x51, 0x00 },  /* Pixel 136 */
		{ 0xa1, 0x51, 0x00, 0x00 },  /* Pixel 137 */
		{ 0x66, 0x00, 0xff, 0x00 },  /* Pixel 138 */
		{ 0x72, 0x00, 0xe4, 0x00 },  /* Pixel 139 */
		{ 0x84, 0x00, 0xc6, 0x00 },  /* Pixel 140 */
		{ 0xa1, 0x00, 0xa1, 0x00 },  /* Pixel 141 */
		{ 0xa1, 0x00, 0x51, 0x00 },  /* Pixel 142 */
		{ 0xa1, 0x00, 0x00, 0x00 },  /* Pixel 143 */
		{ 0x33, 0xff, 0xff, 0x00 },  /* Pixel 144 */
		{ 0x33, 0xff, 0xcc, 0x00 },  /* Pixel 145 */
		{ 0x33, 0xff, 0x99, 0x00 },  /* Pixel 146 */
		{ 0x33, 0xff, 0x66, 0x00 },  /* Pixel 147 */
		{ 0x33, 0xff, 0x33, 0x00 },  /* Pixel 148 */
		{ 0x33, 0xff, 0x00, 0x00 },  /* Pixel 149 */
		{ 0x33, 0xcc, 0xff, 0x00 },  /* Pixel 150 */
		{ 0x39, 0xe4, 0xe4, 0x00 },  /* Pixel 151 */
		{ 0x39, 0xe4, 0xab, 0x00 },  /* Pixel 152 */
		{ 0x39, 0xe4, 0x72, 0x00 },  /* Pixel 153 */
		{ 0x39, 0xe4, 0x39, 0x00 },  /* Pixel 154 */
		{ 0x39, 0xe4, 0x00, 0x00 },  /* Pixel 155 */
		{ 0x33, 0x99, 0xff, 0x00 },  /* Pixel 156 */
		{ 0x39, 0xab, 0xe4, 0x00 },  /* Pixel 157 */
		{ 0x42, 0xc6, 0xc6, 0x00 },  /* Pixel 158 */
		{ 0x42, 0xc6, 0x84, 0x00 },  /* Pixel 159 */
		{ 0x42, 0xc6, 0x42, 0x00 },  /* Pixel 160 */
		{ 0x42, 0xc6, 0x00, 0x00 },  /* Pixel 161 */
		{ 0x33, 0x66, 0xff, 0x00 },  /* Pixel 162 */
		{ 0x39, 0x72, 0xe4, 0x00 },  /* Pixel 163 */
		{ 0x42, 0x84, 0xc6, 0x00 },  /* Pixel 164 */
		{ 0x51, 0xa1, 0xa1, 0x00 },  /* Pixel 165 */
		{ 0x51, 0xa1, 0x51, 0x00 },  /* Pixel 166 */
		{ 0x51, 0xa1, 0x00, 0x00 },  /* Pixel 167 */
		{ 0x33, 0x33, 0xff, 0x00 },  /* Pixel 168 */
		{ 0x39, 0x39, 0xe4, 0x00 },  /* Pixel 169 */
		{ 0x42, 0x42, 0xc6, 0x00 },  /* Pixel 170 */
		{ 0x51, 0x51, 0xa1, 0x00 },  /* Pixel 171 */
		{ 0x72, 0x72, 0x72, 0x00 },  /* Pixel 172 */
		{ 0x72, 0x72, 0x00, 0x00 },  /* Pixel 173 */
		{ 0x33, 0x00, 0xff, 0x00 },  /* Pixel 174 */
		{ 0x39, 0x00, 0xe4, 0x00 },  /* Pixel 175 */
		{ 0x42, 0x00, 0xc6, 0x00 },  /* Pixel 176 */
		{ 0x51, 0x00, 0xa1, 0x00 },  /* Pixel 177 */
		{ 0x72, 0x00, 0x72, 0x00 },  /* Pixel 178 */
		{ 0x72, 0x00, 0x00, 0x00 },  /* Pixel 179 */
		{ 0x00, 0xff, 0xff, 0x00 },  /* Pixel 180 */
		{ 0x00, 0xff, 0xcc, 0x00 },  /* Pixel 181 */
		{ 0x00, 0xff, 0x99, 0x00 },  /* Pixel 182 */
		{ 0x00, 0xff, 0x66, 0x00 },  /* Pixel 183 */
		{ 0x00, 0xff, 0x33, 0x00 },  /* Pixel 184 */
		{ 0x00, 0xff, 0x00, 0x00 },  /* Pixel 185 */
		{ 0x00, 0xcc, 0xff, 0x00 },  /* Pixel 186 */
		{ 0x00, 0xe4, 0xe4, 0x00 },  /* Pixel 187 */
		{ 0x00, 0xe4, 0xab, 0x00 },  /* Pixel 188 */
		{ 0x00, 0xe4, 0x72, 0x00 },  /* Pixel 189 */
		{ 0x00, 0xe4, 0x39, 0x00 },  /* Pixel 190 */
		{ 0x00, 0xe4, 0x00, 0x00 },  /* Pixel 191 */
		{ 0x00, 0x99, 0xff, 0x00 },  /* Pixel 192 */
		{ 0x00, 0xab, 0xe4, 0x00 },  /* Pixel 193 */
		{ 0x00, 0xc6, 0xc6, 0x00 },  /* Pixel 194 */
		{ 0x00, 0xc6, 0x84, 0x00 },  /* Pixel 195 */
		{ 0x00, 0xc6, 0x42, 0x00 },  /* Pixel 196 */
		{ 0x00, 0xc6, 0x00, 0x00 },  /* Pixel 197 */
		{ 0x00, 0x66, 0xff, 0x00 },  /* Pixel 198 */
		{ 0x00, 0x72, 0xe4, 0x00 },  /* Pixel 199 */
		{ 0x00, 0x84, 0xc6, 0x00 },  /* Pixel 200 */
		{ 0x00, 0xa1, 0xa1, 0x00 },  /* Pixel 201 */
		{ 0x00, 0xa1, 0x51, 0x00 },  /* Pixel 202 */
		{ 0x00, 0xa1, 0x00, 0x00 },  /* Pixel 203 */
		{ 0x00, 0x33, 0xff, 0x00 },  /* Pixel 204 */
		{ 0x00, 0x39, 0xe4, 0x00 },  /* Pixel 205 */
		{ 0x00, 0x42, 0xc6, 0x00 },  /* Pixel 206 */
		{ 0x00, 0x51, 0xa1, 0x00 },  /* Pixel 207 */
		{ 0x00, 0x72, 0x72, 0x00 },  /* Pixel 208 */
		{ 0x00, 0x72, 0x00, 0x00 },  /* Pixel 209 */
		{ 0x00, 0x00, 0xff, 0x00 },  /* Pixel 210 */
		{ 0x00, 0x00, 0xe4, 0x00 },  /* Pixel 211 */
		{ 0x00, 0x00, 0xc6, 0x00 },  /* Pixel 212 */
		{ 0x00, 0x00, 0xa1, 0x00 },  /* Pixel 213 */
		{ 0x00, 0x00, 0x72, 0x00 },  /* Pixel 214 */
		{ 0xf6, 0x00, 0x00, 0x00 },  /* Pixel 215 */
		{ 0xed, 0x00, 0x00, 0x00 },  /* Pixel 216 */
		{ 0xda, 0x00, 0x00, 0x00 },  /* Pixel 217 */
		{ 0xd0, 0x00, 0x00, 0x00 },  /* Pixel 218 */
		{ 0xba, 0x00, 0x00, 0x00 },  /* Pixel 219 */
		{ 0xae, 0x00, 0x00, 0x00 },  /* Pixel 220 */
		{ 0x93, 0x00, 0x00, 0x00 },  /* Pixel 221 */
		{ 0x84, 0x00, 0x00, 0x00 },  /* Pixel 222 */
		{ 0x5d, 0x00, 0x00, 0x00 },  /* Pixel 223 */
		{ 0x42, 0x00, 0x00, 0x00 },  /* Pixel 224 */
		{ 0x00, 0xf6, 0x00, 0x00 },  /* Pixel 225 */
		{ 0x00, 0xed, 0x00, 0x00 },  /* Pixel 226 */
		{ 0x00, 0xda, 0x00, 0x00 },  /* Pixel 227 */
		{ 0x00, 0xd0, 0x00, 0x00 },  /* Pixel 228 */
		{ 0x00, 0xba, 0x00, 0x00 },  /* Pixel 229 */
		{ 0x00, 0xae, 0x00, 0x00 },  /* Pixel 230 */
		{ 0x00, 0x93, 0x00, 0x00 },  /* Pixel 231 */
		{ 0x00, 0x84, 0x00, 0x00 },  /* Pixel 232 */
		{ 0x00, 0x5d, 0x00, 0x00 },  /* Pixel 233 */
		{ 0x00, 0x42, 0x00, 0x00 },  /* Pixel 234 */
		{ 0x00, 0x00, 0xf6, 0x00 },  /* Pixel 235 */
		{ 0x00, 0x00, 0xed, 0x00 },  /* Pixel 236 */
		{ 0x00, 0x00, 0xda, 0x00 },  /* Pixel 237 */
		{ 0x00, 0x00, 0xd0, 0x00 },  /* Pixel 238 */
		{ 0x00, 0x00, 0xba, 0x00 },  /* Pixel 239 */
		{ 0x00, 0x00, 0xae, 0x00 },  /* Pixel 240 */
		{ 0x00, 0x00, 0x93, 0x00 },  /* Pixel 241 */
		{ 0x00, 0x00, 0x84, 0x00 },  /* Pixel 242 */
		{ 0x00, 0x00, 0x5d, 0x00 },  /* Pixel 243 */
		{ 0x00, 0x00, 0x42, 0x00 },  /* Pixel 244 */
		{ 0xf6, 0xf6, 0xf6, 0x00 },  /* Pixel 245 */
		{ 0xed, 0xed, 0xed, 0x00 },  /* Pixel 246 */
		{ 0xda, 0xda, 0xda, 0x00 },  /* Pixel 247 */
		{ 0xd0, 0xd0, 0xd0, 0x00 },  /* Pixel 248 */
		{ 0xba, 0xba, 0xba, 0x00 },  /* Pixel 249 */
		{ 0xae, 0xae, 0xae, 0x00 },  /* Pixel 250 */
		{ 0x93, 0x93, 0x93, 0x00 },  /* Pixel 251 */
		{ 0x84, 0x84, 0x84, 0x00 },  /* Pixel 252 */
		{ 0x5d, 0x5d, 0x5d, 0x00 },  /* Pixel 253 */
		{ 0x42, 0x42, 0x42, 0x00 },  /* Pixel 254 */
		{ 0x00, 0x00, 0x00, 0x00 },  /* Pixel 255 */
	},

	/* Gamma level 5 */
	{
		{ 0xff, 0xff, 0xff, 0x00 },  /* Pixel 0 */
		{ 0xff, 0xff, 0xcc, 0x00 },  /* Pixel 1 */
		{ 0xff, 0xff, 0x99, 0x00 },  /* Pixel 2 */
		{ 0xff, 0xff, 0x66, 0x00 },  /* Pixel 3 */
		{ 0xff, 0xff, 0x33, 0x00 },  /* Pixel 4 */
		{ 0xff, 0xff, 0x00, 0x00 },  /* Pixel 5 */
		{ 0xff, 0xcc, 0xff, 0x00 },  /* Pixel 6 */
		{ 0xff, 0xcc, 0xcc, 0x00 },  /* Pixel 7 */
		{ 0xff, 0xcc, 0x99, 0x00 },  /* Pixel 8 */
		{ 0xff, 0xcc, 0x66, 0x00 },  /* Pixel 9 */
		{ 0xff, 0xcc, 0x33, 0x00 },  /* Pixel 10 */
		{ 0xff, 0xcc, 0x00, 0x00 },  /* Pixel 11 */
		{ 0xff, 0x99, 0xff, 0x00 },  /* Pixel 12 */
		{ 0xff, 0x99, 0xcc, 0x00 },  /* Pixel 13 */
		{ 0xff, 0x99, 0x99, 0x00 },  /* Pixel 14 */
		{ 0xff, 0x99, 0x66, 0x00 },  /* Pixel 15 */
		{ 0xff, 0x99, 0x33, 0x00 },  /* Pixel 16 */
		{ 0xff, 0x99, 0x00, 0x00 },  /* Pixel 17 */
		{ 0xff, 0x66, 0xff, 0x00 },  /* Pixel 18 */
		{ 0xff, 0x66, 0xcc, 0x00 },  /* Pixel 19 */
		{ 0xff, 0x66, 0x99, 0x00 },  /* Pixel 20 */
		{ 0xff, 0x66, 0x66, 0x00 },  /* Pixel 21 */
		{ 0xff, 0x66, 0x33, 0x00 },  /* Pixel 22 */
		{ 0xff, 0x66, 0x00, 0x00 },  /* Pixel 23 */
		{ 0xff, 0x33, 0xff, 0x00 },  /* Pixel 24 */
		{ 0xff, 0x33, 0xcc, 0x00 },  /* Pixel 25 */
		{ 0xff, 0x33, 0x99, 0x00 },  /* Pixel 26 */
		{ 0xff, 0x33, 0x66, 0x00 },  /* Pixel 27 */
		{ 0xff, 0x33, 0x33, 0x00 },  /* Pixel 28 */
		{ 0xff, 0x33, 0x00, 0x00 },  /* Pixel 29 */
		{ 0xff, 0x00, 0xff, 0x00 },  /* Pixel 30 */
		{ 0xff, 0x00, 0xcc, 0x00 },  /* Pixel 31 */
		{ 0xff, 0x00, 0x99, 0x00 },  /* Pixel 32 */
		{ 0xff, 0x00, 0x66, 0x00 },  /* Pixel 33 */
		{ 0xff, 0x00, 0x33, 0x00 },  /* Pixel 34 */
		{ 0xff, 0x00, 0x00, 0x00 },  /* Pixel 35 */
		{ 0xcc, 0xff, 0xff, 0x00 },  /* Pixel 36 */
		{ 0xcc, 0xff, 0xcc, 0x00 },  /* Pixel 37 */
		{ 0xcc, 0xff, 0x99, 0x00 },  /* Pixel 38 */
		{ 0xcc, 0xff, 0x66, 0x00 },  /* Pixel 39 */
		{ 0xcc, 0xff, 0x33, 0x00 },  /* Pixel 40 */
		{ 0xcc, 0xff, 0x00, 0x00 },  /* Pixel 41 */
		{ 0xcc, 0xcc, 0xff, 0x00 },  /* Pixel 42 */
		{ 0xe7, 0xe7, 0xe7, 0x00 },  /* Pixel 43 */
		{ 0xe7, 0xe7, 0xad, 0x00 },  /* Pixel 44 */
		{ 0xe7, 0xe7, 0x74, 0x00 },  /* Pixel 45 */
		{ 0xe7, 0xe7, 0x3a, 0x00 },  /* Pixel 46 */
		{ 0xe7, 0xe7, 0x00, 0x00 },  /* Pixel 47 */
		{ 0xcc, 0x99, 0xff, 0x00 },  /* Pixel 48 */
		{ 0xe7, 0xad, 0xe7, 0x00 },  /* Pixel 49 */
		{ 0xe7, 0xad, 0xad, 0x00 },  /* Pixel 50 */
		{ 0xe7, 0xad, 0x74, 0x00 },  /* Pixel 51 */
		{ 0xe7, 0xad, 0x3a, 0x00 },  /* Pixel 52 */
		{ 0xe7, 0xad, 0x00, 0x00 },  /* Pixel 53 */
		{ 0xcc, 0x66, 0xff, 0x00 },  /* Pixel 54 */
		{ 0xe7, 0x74, 0xe7, 0x00 },  /* Pixel 55 */
		{ 0xe7, 0x74, 0xad, 0x00 },  /* Pixel 56 */
		{ 0xe7, 0x74, 0x74, 0x00 },  /* Pixel 57 */
		{ 0xe7, 0x74, 0x3a, 0x00 },  /* Pixel 58 */
		{ 0xe7, 0x74, 0x00, 0x00 },  /* Pixel 59 */
		{ 0xcc, 0x33, 0xff, 0x00 },  /* Pixel 60 */
		{ 0xe7, 0x3a, 0xe7, 0x00 },  /* Pixel 61 */
		{ 0xe7, 0x3a, 0xad, 0x00 },  /* Pixel 62 */
		{ 0xe7, 0x3a, 0x73, 0x00 },  /* Pixel 63 */
		{ 0xe7, 0x3a, 0x3a, 0x00 },  /* Pixel 64 */
		{ 0xe7, 0x3a, 0x00, 0x00 },  /* Pixel 65 */
		{ 0xcc, 0x00, 0xff, 0x00 },  /* Pixel 66 */
		{ 0xe7, 0x00, 0xe7, 0x00 },  /* Pixel 67 */
		{ 0xe7, 0x00, 0xad, 0x00 },  /* Pixel 68 */
		{ 0xe7, 0x00, 0x74, 0x00 },  /* Pixel 69 */
		{ 0xe7, 0x00, 0x3a, 0x00 },  /* Pixel 70 */
		{ 0xe7, 0x00, 0x00, 0x00 },  /* Pixel 71 */
		{ 0x99, 0xff, 0xff, 0x00 },  /* Pixel 72 */
		{ 0x99, 0xff, 0xcc, 0x00 },  /* Pixel 73 */
		{ 0x99, 0xff, 0x99, 0x00 },  /* Pixel 74 */
		{ 0x99, 0xff, 0x66, 0x00 },  /* Pixel 75 */
		{ 0x99, 0xff, 0x33, 0x00 },  /* Pixel 76 */
		{ 0x99, 0xff, 0x00, 0x00 },  /* Pixel 77 */
		{ 0x99, 0xcc, 0xff, 0x00 },  /* Pixel 78 */
		{ 0xad, 0xe7, 0xe7, 0x00 },  /* Pixel 79 */
		{ 0xad, 0xe7, 0xad, 0x00 },  /* Pixel 80 */
		{ 0xad, 0xe7, 0x74, 0x00 },  /* Pixel 81 */
		{ 0xad, 0xe7, 0x3a, 0x00 },  /* Pixel 82 */
		{ 0xad, 0xe7, 0x00, 0x00 },  /* Pixel 83 */
		{ 0x99, 0x99, 0xff, 0x00 },  /* Pixel 84 */
		{ 0xad, 0xad, 0xe7, 0x00 },  /* Pixel 85 */
		{ 0xcb, 0xcb, 0xcb, 0x00 },  /* Pixel 86 */
		{ 0xcb, 0xcb, 0x87, 0x00 },  /* Pixel 87 */
		{ 0xcb, 0xcb, 0x44, 0x00 },  /* Pixel 88 */
		{ 0xcb, 0xcb, 0x00, 0x00 },  /* Pixel 89 */
		{ 0x99, 0x66, 0xff, 0x00 },  /* Pixel 90 */
		{ 0xad, 0x74, 0xe7, 0x00 },  /* Pixel 91 */
		{ 0xcb, 0x87, 0xcb, 0x00 },  /* Pixel 92 */
		{ 0xcb, 0x87, 0x87, 0x00 },  /* Pixel 93 */
		{ 0xcb, 0x87, 0x44, 0x00 },  /* Pixel 94 */
		{ 0xcb, 0x87, 0x00, 0x00 },  /* Pixel 95 */
		{ 0x99, 0x33, 0xff, 0x00 },  /* Pixel 96 */
		{ 0xad, 0x3a, 0xe7, 0x00 },  /* Pixel 97 */
		{ 0xcb, 0x44, 0xcb, 0x00 },  /* Pixel 98 */
		{ 0xcb, 0x44, 0x87, 0x00 },  /* Pixel 99 */
		{ 0xcb, 0x44, 0x44, 0x00 },  /* Pixel 100 */
		{ 0xcb, 0x44, 0x00, 0x00 },  /* Pixel 101 */
		{ 0x99, 0x00, 0xff, 0x00 },  /* Pixel 102 */
		{ 0xad, 0x00, 0xe7, 0x00 },  /* Pixel 103 */
		{ 0xcb, 0x00, 0xcb, 0x00 },  /* Pixel 104 */
		{ 0xcb, 0x00, 0x87, 0x00 },  /* Pixel 105 */
		{ 0xcb, 0x00, 0x44, 0x00 },  /* Pixel 106 */
		{ 0xcb, 0x00, 0x00, 0x00 },  /* Pixel 107 */
		{ 0x66, 0xff, 0xff, 0x00 },  /* Pixel 108 */
		{ 0x66, 0xff, 0xcc, 0x00 },  /* Pixel 109 */
		{ 0x66, 0xff, 0x99, 0x00 },  /* Pixel 110 */
		{ 0x66, 0xff, 0x66, 0x00 },  /* Pixel 111 */
		{ 0x66, 0xff, 0x33, 0x00 },  /* Pixel 112 */
		{ 0x66, 0xff, 0x00, 0x00 },  /* Pixel 113 */
		{ 0x66, 0xcc, 0xff, 0x00 },  /* Pixel 114 */
		{ 0x74, 0xe7, 0xe7, 0x00 },  /* Pixel 115 */
		{ 0x74, 0xe7, 0xad, 0x00 },  /* Pixel 116 */
		{ 0x74, 0xe7, 0x74, 0x00 },  /* Pixel 117 */
		{ 0x73, 0xe7, 0x3a, 0x00 },  /* Pixel 118 */
		{ 0x74, 0xe7, 0x00, 0x00 },  /* Pixel 119 */
		{ 0x66, 0x99, 0xff, 0x00 },  /* Pixel 120 */
		{ 0x74, 0xad, 0xe7, 0x00 },  /* Pixel 121 */
		{ 0x87, 0xcb, 0xcb, 0x00 },  /* Pixel 122 */
		{ 0x87, 0xcb, 0x87, 0x00 },  /* Pixel 123 */
		{ 0x87, 0xcb, 0x44, 0x00 },  /* Pixel 124 */
		{ 0x87, 0xcb, 0x00, 0x00 },  /* Pixel 125 */
		{ 0x66, 0x66, 0xff, 0x00 },  /* Pixel 126 */
		{ 0x74, 0x74, 0xe7, 0x00 },  /* Pixel 127 */
		{ 0x87, 0x87, 0xcb, 0x00 },  /* Pixel 128 */
		{ 0xaa, 0xaa, 0xaa, 0x00 },  /* Pixel 129 */
		{ 0xaa, 0xaa, 0x55, 0x00 },  /* Pixel 130 */
		{ 0xaa, 0xaa, 0x00, 0x00 },  /* Pixel 131 */
		{ 0x66, 0x33, 0xff, 0x00 },  /* Pixel 132 */
		{ 0x73, 0x3a, 0xe7, 0x00 },  /* Pixel 133 */
		{ 0x87, 0x44, 0xcb, 0x00 },  /* Pixel 134 */
		{ 0xaa, 0x55, 0xaa, 0x00 },  /* Pixel 135 */
		{ 0xaa, 0x55, 0x55, 0x00 },  /* Pixel 136 */
		{ 0xaa, 0x55, 0x00, 0x00 },  /* Pixel 137 */
		{ 0x66, 0x00, 0xff, 0x00 },  /* Pixel 138 */
		{ 0x74, 0x00, 0xe7, 0x00 },  /* Pixel 139 */
		{ 0x87, 0x00, 0xcb, 0x00 },  /* Pixel 140 */
		{ 0xaa, 0x00, 0xaa, 0x00 },  /* Pixel 141 */
		{ 0xaa, 0x00, 0x55, 0x00 },  /* Pixel 142 */
		{ 0xaa, 0x00, 0x00, 0x00 },  /* Pixel 143 */
		{ 0x33, 0xff, 0xff, 0x00 },  /* Pixel 144 */
		{ 0x33, 0xff, 0xcc, 0x00 },  /* Pixel 145 */
		{ 0x33, 0xff, 0x99, 0x00 },  /* Pixel 146 */
		{ 0x33, 0xff, 0x66, 0x00 },  /* Pixel 147 */
		{ 0x33, 0xff, 0x33, 0x00 },  /* Pixel 148 */
		{ 0x33, 0xff, 0x00, 0x00 },  /* Pixel 149 */
		{ 0x33, 0xcc, 0xff, 0x00 },  /* Pixel 150 */
		{ 0x3a, 0xe7, 0xe7, 0x00 },  /* Pixel 151 */
		{ 0x3a, 0xe7, 0xad, 0x00 },  /* Pixel 152 */
		{ 0x3a, 0xe7, 0x74, 0x00 },  /* Pixel 153 */
		{ 0x3a, 0xe7, 0x3a, 0x00 },  /* Pixel 154 */
		{ 0x3a, 0xe7, 0x00, 0x00 },  /* Pixel 155 */
		{ 0x33, 0x99, 0xff, 0x00 },  /* Pixel 156 */
		{ 0x3a, 0xad, 0xe7, 0x00 },  /* Pixel 157 */
		{ 0x44, 0xcb, 0xcb, 0x00 },  /* Pixel 158 */
		{ 0x44, 0xcb, 0x87, 0x00 },  /* Pixel 159 */
		{ 0x44, 0xcb, 0x44, 0x00 },  /* Pixel 160 */
		{ 0x44, 0xcb, 0x00, 0x00 },  /* Pixel 161 */
		{ 0x33, 0x66, 0xff, 0x00 },  /* Pixel 162 */
		{ 0x3a, 0x74, 0xe7, 0x00 },  /* Pixel 163 */
		{ 0x44, 0x87, 0xcb, 0x00 },  /* Pixel 164 */
		{ 0x55, 0xaa, 0xaa, 0x00 },  /* Pixel 165 */
		{ 0x55, 0xaa, 0x55, 0x00 },  /* Pixel 166 */
		{ 0x55, 0xaa, 0x00, 0x00 },  /* Pixel 167 */
		{ 0x33, 0x33, 0xff, 0x00 },  /* Pixel 168 */
		{ 0x3a, 0x3a, 0xe7, 0x00 },  /* Pixel 169 */
		{ 0x44, 0x44, 0xcb, 0x00 },  /* Pixel 170 */
		{ 0x55, 0x55, 0xaa, 0x00 },  /* Pixel 171 */
		{ 0x7d, 0x7d, 0x7d, 0x00 },  /* Pixel 172 */
		{ 0x7d, 0x7d, 0x00, 0x00 },  /* Pixel 173 */
		{ 0x33, 0x00, 0xff, 0x00 },  /* Pixel 174 */
		{ 0x3a, 0x00, 0xe7, 0x00 },  /* Pixel 175 */
		{ 0x44, 0x00, 0xcb, 0x00 },  /* Pixel 176 */
		{ 0x55, 0x00, 0xaa, 0x00 },  /* Pixel 177 */
		{ 0x7d, 0x00, 0x7d, 0x00 },  /* Pixel 178 */
		{ 0x7d, 0x00, 0x00, 0x00 },  /* Pixel 179 */
		{ 0x00, 0xff, 0xff, 0x00 },  /* Pixel 180 */
		{ 0x00, 0xff, 0xcc, 0x00 },  /* Pixel 181 */
		{ 0x00, 0xff, 0x99, 0x00 },  /* Pixel 182 */
		{ 0x00, 0xff, 0x66, 0x00 },  /* Pixel 183 */
		{ 0x00, 0xff, 0x33, 0x00 },  /* Pixel 184 */
		{ 0x00, 0xff, 0x00, 0x00 },  /* Pixel 185 */
		{ 0x00, 0xcc, 0xff, 0x00 },  /* Pixel 186 */
		{ 0x00, 0xe7, 0xe7, 0x00 },  /* Pixel 187 */
		{ 0x00, 0xe7, 0xad, 0x00 },  /* Pixel 188 */
		{ 0x00, 0xe7, 0x74, 0x00 },  /* Pixel 189 */
		{ 0x00, 0xe7, 0x3a, 0x00 },  /* Pixel 190 */
		{ 0x00, 0xe7, 0x00, 0x00 },  /* Pixel 191 */
		{ 0x00, 0x99, 0xff, 0x00 },  /* Pixel 192 */
		{ 0x00, 0xad, 0xe7, 0x00 },  /* Pixel 193 */
		{ 0x00, 0xcb, 0xcb, 0x00 },  /* Pixel 194 */
		{ 0x00, 0xcb, 0x87, 0x00 },  /* Pixel 195 */
		{ 0x00, 0xcb, 0x44, 0x00 },  /* Pixel 196 */
		{ 0x00, 0xcb, 0x00, 0x00 },  /* Pixel 197 */
		{ 0x00, 0x66, 0xff, 0x00 },  /* Pixel 198 */
		{ 0x00, 0x74, 0xe7, 0x00 },  /* Pixel 199 */
		{ 0x00, 0x87, 0xcb, 0x00 },  /* Pixel 200 */
		{ 0x00, 0xaa, 0xaa, 0x00 },  /* Pixel 201 */
		{ 0x00, 0xaa, 0x55, 0x00 },  /* Pixel 202 */
		{ 0x00, 0xaa, 0x00, 0x00 },  /* Pixel 203 */
		{ 0x00, 0x33, 0xff, 0x00 },  /* Pixel 204 */
		{ 0x00, 0x3a, 0xe7, 0x00 },  /* Pixel 205 */
		{ 0x00, 0x44, 0xcb, 0x00 },  /* Pixel 206 */
		{ 0x00, 0x55, 0xaa, 0x00 },  /* Pixel 207 */
		{ 0x00, 0x7d, 0x7d, 0x00 },  /* Pixel 208 */
		{ 0x00, 0x7d, 0x00, 0x00 },  /* Pixel 209 */
		{ 0x00, 0x00, 0xff, 0x00 },  /* Pixel 210 */
		{ 0x00, 0x00, 0xe7, 0x00 },  /* Pixel 211 */
		{ 0x00, 0x00, 0xcb, 0x00 },  /* Pixel 212 */
		{ 0x00, 0x00, 0xaa, 0x00 },  /* Pixel 213 */
		{ 0x00, 0x00, 0x7d, 0x00 },  /* Pixel 214 */
		{ 0xf7, 0x00, 0x00, 0x00 },  /* Pixel 215 */
		{ 0xef, 0x00, 0x00, 0x00 },  /* Pixel 216 */
		{ 0xde, 0x00, 0x00, 0x00 },  /* Pixel 217 */
		{ 0xd5, 0x00, 0x00, 0x00 },  /* Pixel 218 */
		{ 0xc1, 0x00, 0x00, 0x00 },  /* Pixel 219 */
		{ 0xb6, 0x00, 0x00, 0x00 },  /* Pixel 220 */
		{ 0x9c, 0x00, 0x00, 0x00 },  /* Pixel 221 */
		{ 0x8e, 0x00, 0x00, 0x00 },  /* Pixel 222 */
		{ 0x68, 0x00, 0x00, 0x00 },  /* Pixel 223 */
		{ 0x4d, 0x00, 0x00, 0x00 },  /* Pixel 224 */
		{ 0x00, 0xf7, 0x00, 0x00 },  /* Pixel 225 */
		{ 0x00, 0xef, 0x00, 0x00 },  /* Pixel 226 */
		{ 0x00, 0xde, 0x00, 0x00 },  /* Pixel 227 */
		{ 0x00, 0xd5, 0x00, 0x00 },  /* Pixel 228 */
		{ 0x00, 0xc1, 0x00, 0x00 },  /* Pixel 229 */
		{ 0x00, 0xb6, 0x00, 0x00 },  /* Pixel 230 */
		{ 0x00, 0x9c, 0x00, 0x00 },  /* Pixel 231 */
		{ 0x00, 0x8e, 0x00, 0x00 },  /* Pixel 232 */
		{ 0x00, 0x68, 0x00, 0x00 },  /* Pixel 233 */
		{ 0x00, 0x4d, 0x00, 0x00 },  /* Pixel 234 */
		{ 0x00, 0x00, 0xf7, 0x00 },  /* Pixel 235 */
		{ 0x00, 0x00, 0xef, 0x00 },  /* Pixel 236 */
		{ 0x00, 0x00, 0xde, 0x00 },  /* Pixel 237 */
		{ 0x00, 0x00, 0xd5, 0x00 },  /* Pixel 238 */
		{ 0x00, 0x00, 0xc1, 0x00 },  /* Pixel 239 */
		{ 0x00, 0x00, 0xb6, 0x00 },  /* Pixel 240 */
		{ 0x00, 0x00, 0x9c, 0x00 },  /* Pixel 241 */
		{ 0x00, 0x00, 0x8e, 0x00 },  /* Pixel 242 */
		{ 0x00, 0x00, 0x68, 0x00 },  /* Pixel 243 */
		{ 0x00, 0x00, 0x4d, 0x00 },  /* Pixel 244 */
		{ 0xf7, 0xf7, 0xf7, 0x00 },  /* Pixel 245 */
		{ 0xef, 0xef, 0xef, 0x00 },  /* Pixel 246 */
		{ 0xde, 0xde, 0xde, 0x00 },  /* Pixel 247 */
		{ 0xd5, 0xd5, 0xd5, 0x00 },  /* Pixel 248 */
		{ 0xc1, 0xc1, 0xc1, 0x00 },  /* Pixel 249 */
		{ 0xb6, 0xb6, 0xb6, 0x00 },  /* Pixel 250 */
		{ 0x9c, 0x9c, 0x9c, 0x00 },  /* Pixel 251 */
		{ 0x8e, 0x8e, 0x8e, 0x00 },  /* Pixel 252 */
		{ 0x68, 0x68, 0x68, 0x00 },  /* Pixel 253 */
		{ 0x4d, 0x4d, 0x4d, 0x00 },  /* Pixel 254 */
		{ 0x00, 0x00, 0x00, 0x00 },  /* Pixel 255 */
	},

	/* Gamma level 6 */
	{
		{ 0xff, 0xff, 0xff, 0x00 },  /* Pixel 0 */
		{ 0xff, 0xff, 0xcc, 0x00 },  /* Pixel 1 */
		{ 0xff, 0xff, 0x99, 0x00 },  /* Pixel 2 */
		{ 0xff, 0xff, 0x66, 0x00 },  /* Pixel 3 */
		{ 0xff, 0xff, 0x33, 0x00 },  /* Pixel 4 */
		{ 0xff, 0xff, 0x00, 0x00 },  /* Pixel 5 */
		{ 0xff, 0xcc, 0xff, 0x00 },  /* Pixel 6 */
		{ 0xff, 0xcc, 0xcc, 0x00 },  /* Pixel 7 */
		{ 0xff, 0xcc, 0x99, 0x00 },  /* Pixel 8 */
		{ 0xff, 0xcc, 0x66, 0x00 },  /* Pixel 9 */
		{ 0xff, 0xcc, 0x33, 0x00 },  /* Pixel 10 */
		{ 0xff, 0xcc, 0x00, 0x00 },  /* Pixel 11 */
		{ 0xff, 0x99, 0xff, 0x00 },  /* Pixel 12 */
		{ 0xff, 0x99, 0xcc, 0x00 },  /* Pixel 13 */
		{ 0xff, 0x99, 0x99, 0x00 },  /* Pixel 14 */
		{ 0xff, 0x99, 0x66, 0x00 },  /* Pixel 15 */
		{ 0xff, 0x99, 0x33, 0x00 },  /* Pixel 16 */
		{ 0xff, 0x99, 0x00, 0x00 },  /* Pixel 17 */
		{ 0xff, 0x66, 0xff, 0x00 },  /* Pixel 18 */
		{ 0xff, 0x66, 0xcc, 0x00 },  /* Pixel 19 */
		{ 0xff, 0x66, 0x99, 0x00 },  /* Pixel 20 */
		{ 0xff, 0x66, 0x66, 0x00 },  /* Pixel 21 */
		{ 0xff, 0x66, 0x33, 0x00 },  /* Pixel 22 */
		{ 0xff, 0x66, 0x00, 0x00 },  /* Pixel 23 */
		{ 0xff, 0x33, 0xff, 0x00 },  /* Pixel 24 */
		{ 0xff, 0x33, 0xcc, 0x00 },  /* Pixel 25 */
		{ 0xff, 0x33, 0x99, 0x00 },  /* Pixel 26 */
		{ 0xff, 0x33, 0x66, 0x00 },  /* Pixel 27 */
		{ 0xff, 0x33, 0x33, 0x00 },  /* Pixel 28 */
		{ 0xff, 0x33, 0x00, 0x00 },  /* Pixel 29 */
		{ 0xff, 0x00, 0xff, 0x00 },  /* Pixel 30 */
		{ 0xff, 0x00, 0xcc, 0x00 },  /* Pixel 31 */
		{ 0xff, 0x00, 0x99, 0x00 },  /* Pixel 32 */
		{ 0xff, 0x00, 0x66, 0x00 },  /* Pixel 33 */
		{ 0xff, 0x00, 0x33, 0x00 },  /* Pixel 34 */
		{ 0xff, 0x00, 0x00, 0x00 },  /* Pixel 35 */
		{ 0xcc, 0xff, 0xff, 0x00 },  /* Pixel 36 */
		{ 0xcc, 0xff, 0xcc, 0x00 },  /* Pixel 37 */
		{ 0xcc, 0xff, 0x99, 0x00 },  /* Pixel 38 */
		{ 0xcc, 0xff, 0x66, 0x00 },  /* Pixel 39 */
		{ 0xcc, 0xff, 0x33, 0x00 },  /* Pixel 40 */
		{ 0xcc, 0xff, 0x00, 0x00 },  /* Pixel 41 */
		{ 0xcc, 0xcc, 0xff, 0x00 },  /* Pixel 42 */
		{ 0xe9, 0xe9, 0xe9, 0x00 },  /* Pixel 43 */
		{ 0xe9, 0xe9, 0xaf, 0x00 },  /* Pixel 44 */
		{ 0xe9, 0xe9, 0x75, 0x00 },  /* Pixel 45 */
		{ 0xe9, 0xe9, 0x3a, 0x00 },  /* Pixel 46 */
		{ 0xe9, 0xe9, 0x00, 0x00 },  /* Pixel 47 */
		{ 0xcc, 0x99, 0xff, 0x00 },  /* Pixel 48 */
		{ 0xe9, 0xaf, 0xe9, 0x00 },  /* Pixel 49 */
		{ 0xe9, 0xaf, 0xaf, 0x00 },  /* Pixel 50 */
		{ 0xe9, 0xaf, 0x75, 0x00 },  /* Pixel 51 */
		{ 0xe9, 0xaf, 0x3a, 0x00 },  /* Pixel 52 */
		{ 0xe9, 0xaf, 0x00, 0x00 },  /* Pixel 53 */
		{ 0xcc, 0x66, 0xff, 0x00 },  /* Pixel 54 */
		{ 0xe9, 0x75, 0xe9, 0x00 },  /* Pixel 55 */
		{ 0xe9, 0x75, 0xaf, 0x00 },  /* Pixel 56 */
		{ 0xe9, 0x75, 0x75, 0x00 },  /* Pixel 57 */
		{ 0xe9, 0x75, 0x3a, 0x00 },  /* Pixel 58 */
		{ 0xe9, 0x75, 0x00, 0x00 },  /* Pixel 59 */
		{ 0xcc, 0x33, 0xff, 0x00 },  /* Pixel 60 */
		{ 0xe9, 0x3a, 0xe9, 0x00 },  /* Pixel 61 */
		{ 0xe9, 0x3a, 0xaf, 0x00 },  /* Pixel 62 */
		{ 0xe9, 0x3a, 0x74, 0x00 },  /* Pixel 63 */
		{ 0xe9, 0x3a, 0x3a, 0x00 },  /* Pixel 64 */
		{ 0xe9, 0x3a, 0x00, 0x00 },  /* Pixel 65 */
		{ 0xcc, 0x00, 0xff, 0x00 },  /* Pixel 66 */
		{ 0xe9, 0x00, 0xe9, 0x00 },  /* Pixel 67 */
		{ 0xe9, 0x00, 0xaf, 0x00 },  /* Pixel 68 */
		{ 0xe9, 0x00, 0x75, 0x00 },  /* Pixel 69 */
		{ 0xe9, 0x00, 0x3a, 0x00 },  /* Pixel 70 */
		{ 0xe9, 0x00, 0x00, 0x00 },  /* Pixel 71 */
		{ 0x99, 0xff, 0xff, 0x00 },  /* Pixel 72 */
		{ 0x99, 0xff, 0xcc, 0x00 },  /* Pixel 73 */
		{ 0x99, 0xff, 0x99, 0x00 },  /* Pixel 74 */
		{ 0x99, 0xff, 0x66, 0x00 },  /* Pixel 75 */
		{ 0x99, 0xff, 0x33, 0x00 },  /* Pixel 76 */
		{ 0x99, 0xff, 0x00, 0x00 },  /* Pixel 77 */
		{ 0x99, 0xcc, 0xff, 0x00 },  /* Pixel 78 */
		{ 0xaf, 0xe9, 0xe9, 0x00 },  /* Pixel 79 */
		{ 0xaf, 0xe9, 0xaf, 0x00 },  /* Pixel 80 */
		{ 0xaf, 0xe9, 0x75, 0x00 },  /* Pixel 81 */
		{ 0xaf, 0xe9, 0x3a, 0x00 },  /* Pixel 82 */
		{ 0xaf, 0xe9, 0x00, 0x00 },  /* Pixel 83 */
		{ 0x99, 0x99, 0xff, 0x00 },  /* Pixel 84 */
		{ 0xaf, 0xaf, 0xe9, 0x00 },  /* Pixel 85 */
		{ 0xd0, 0xd0, 0xd0, 0x00 },  /* Pixel 86 */
		{ 0xd0, 0xd0, 0x8b, 0x00 },  /* Pixel 87 */
		{ 0xd0, 0xd0, 0x45, 0x00 },  /* Pixel 88 */
		{ 0xd0, 0xd0, 0x00, 0x00 },  /* Pixel 89 */
		{ 0x99, 0x66, 0xff, 0x00 },  /* Pixel 90 */
		{ 0xaf, 0x75, 0xe9, 0x00 },  /* Pixel 91 */
		{ 0xd0, 0x8b, 0xd0, 0x00 },  /* Pixel 92 */
		{ 0xd0, 0x8b, 0x8b, 0x00 },  /* Pixel 93 */
		{ 0xd0, 0x8b, 0x45, 0x00 },  /* Pixel 94 */
		{ 0xd0, 0x8b, 0x00, 0x00 },  /* Pixel 95 */
		{ 0x99, 0x33, 0xff, 0x00 },  /* Pixel 96 */
		{ 0xaf, 0x3a, 0xe9, 0x00 },  /* Pixel 97 */
		{ 0xd0, 0x45, 0xd0, 0x00 },  /* Pixel 98 */
		{ 0xd0, 0x45, 0x8b, 0x00 },  /* Pixel 99 */
		{ 0xd0, 0x45, 0x45, 0x00 },  /* Pixel 100 */
		{ 0xd0, 0x45, 0x00, 0x00 },  /* Pixel 101 */
		{ 0x99, 0x00, 0xff, 0x00 },  /* Pixel 102 */
		{ 0xaf, 0x00, 0xe9, 0x00 },  /* Pixel 103 */
		{ 0xd0, 0x00, 0xd0, 0x00 },  /* Pixel 104 */
		{ 0xd0, 0x00, 0x8b, 0x00 },  /* Pixel 105 */
		{ 0xd0, 0x00, 0x45, 0x00 },  /* Pixel 106 */
		{ 0xd0, 0x00, 0x00, 0x00 },  /* Pixel 107 */
		{ 0x66, 0xff, 0xff, 0x00 },  /* Pixel 108 */
		{ 0x66, 0xff, 0xcc, 0x00 },  /* Pixel 109 */
		{ 0x66, 0xff, 0x99, 0x00 },  /* Pixel 110 */
		{ 0x66, 0xff, 0x66, 0x00 },  /* Pixel 111 */
		{ 0x66, 0xff, 0x33, 0x00 },  /* Pixel 112 */
		{ 0x66, 0xff, 0x00, 0x00 },  /* Pixel 113 */
		{ 0x66, 0xcc, 0xff, 0x00 },  /* Pixel 114 */
		{ 0x75, 0xe9, 0xe9, 0x00 },  /* Pixel 115 */
		{ 0x75, 0xe9, 0xaf, 0x00 },  /* Pixel 116 */
		{ 0x75, 0xe9, 0x75, 0x00 },  /* Pixel 117 */
		{ 0x74, 0xe9, 0x3a, 0x00 },  /* Pixel 118 */
		{ 0x75, 0xe9, 0x00, 0x00 },  /* Pixel 119 */
		{ 0x66, 0x99, 0xff, 0x00 },  /* Pixel 120 */
		{ 0x75, 0xaf, 0xe9, 0x00 },  /* Pixel 121 */
		{ 0x8b, 0xd0, 0xd0, 0x00 },  /* Pixel 122 */
		{ 0x8b, 0xd0, 0x8b, 0x00 },  /* Pixel 123 */
		{ 0x8b, 0xd0, 0x45, 0x00 },  /* Pixel 124 */
		{ 0x8b, 0xd0, 0x00, 0x00 },  /* Pixel 125 */
		{ 0x66, 0x66, 0xff, 0x00 },  /* Pixel 126 */
		{ 0x75, 0x75, 0xe9, 0x00 },  /* Pixel 127 */
		{ 0x8b, 0x8b, 0xd0, 0x00 },  /* Pixel 128 */
		{ 0xb1, 0xb1, 0xb1, 0x00 },  /* Pixel 129 */
		{ 0xb1, 0xb1, 0x59, 0x00 },  /* Pixel 130 */
		{ 0xb1, 0xb1, 0x00, 0x00 },  /* Pixel 131 */
		{ 0x66, 0x33, 0xff, 0x00 },  /* Pixel 132 */
		{ 0x74, 0x3a, 0xe9, 0x00 },  /* Pixel 133 */
		{ 0x8b, 0x45, 0xd0, 0x00 },  /* Pixel 134 */
		{ 0xb1, 0x59, 0xb1, 0x00 },  /* Pixel 135 */
		{ 0xb1, 0x59, 0x59, 0x00 },  /* Pixel 136 */
		{ 0xb1, 0x59, 0x00, 0x00 },  /* Pixel 137 */
		{ 0x66, 0x00, 0xff, 0x00 },  /* Pixel 138 */
		{ 0x75, 0x00, 0xe9, 0x00 },  /* Pixel 139 */
		{ 0x8b, 0x00, 0xd0, 0x00 },  /* Pixel 140 */
		{ 0xb1, 0x00, 0xb1, 0x00 },  /* Pixel 141 */
		{ 0xb1, 0x00, 0x59, 0x00 },  /* Pixel 142 */
		{ 0xb1, 0x00, 0x00, 0x00 },  /* Pixel 143 */
		{ 0x33, 0xff, 0xff, 0x00 },  /* Pixel 144 */
		{ 0x33, 0xff, 0xcc, 0x00 },  /* Pixel 145 */
		{ 0x33, 0xff, 0x99, 0x00 },  /* Pixel 146 */
		{ 0x33, 0xff, 0x66, 0x00 },  /* Pixel 147 */
		{ 0x33, 0xff, 0x33, 0x00 },  /* Pixel 148 */
		{ 0x33, 0xff, 0x00, 0x00 },  /* Pixel 149 */
		{ 0x33, 0xcc, 0xff, 0x00 },  /* Pixel 150 */
		{ 0x3a, 0xe9, 0xe9, 0x00 },  /* Pixel 151 */
		{ 0x3a, 0xe9, 0xaf, 0x00 },  /* Pixel 152 */
		{ 0x3a, 0xe9, 0x75, 0x00 },  /* Pixel 153 */
		{ 0x3a, 0xe9, 0x3a, 0x00 },  /* Pixel 154 */
		{ 0x3a, 0xe9, 0x00, 0x00 },  /* Pixel 155 */
		{ 0x33, 0x99, 0xff, 0x00 },  /* Pixel 156 */
		{ 0x3a, 0xaf, 0xe9, 0x00 },  /* Pixel 157 */
		{ 0x45, 0xd0, 0xd0, 0x00 },  /* Pixel 158 */
		{ 0x45, 0xd0, 0x8b, 0x00 },  /* Pixel 159 */
		{ 0x45, 0xd0, 0x45, 0x00 },  /* Pixel 160 */
		{ 0x45, 0xd0, 0x00, 0x00 },  /* Pixel 161 */
		{ 0x33, 0x66, 0xff, 0x00 },  /* Pixel 162 */
		{ 0x3a, 0x75, 0xe9, 0x00 },  /* Pixel 163 */
		{ 0x45, 0x8b, 0xd0, 0x00 },  /* Pixel 164 */
		{ 0x59, 0xb1, 0xb1, 0x00 },  /* Pixel 165 */
		{ 0x59, 0xb1, 0x59, 0x00 },  /* Pixel 166 */
		{ 0x59, 0xb1, 0x00, 0x00 },  /* Pixel 167 */
		{ 0x33, 0x33, 0xff, 0x00 },  /* Pixel 168 */
		{ 0x3a, 0x3a, 0xe9, 0x00 },  /* Pixel 169 */
		{ 0x45, 0x45, 0xd0, 0x00 },  /* Pixel 170 */
		{ 0x59, 0x59, 0xb1, 0x00 },  /* Pixel 171 */
		{ 0x86, 0x86, 0x86, 0x00 },  /* Pixel 172 */
		{ 0x86, 0x86, 0x00, 0x00 },  /* Pixel 173 */
		{ 0x33, 0x00, 0xff, 0x00 },  /* Pixel 174 */
		{ 0x3a, 0x00, 0xe9, 0x00 },  /* Pixel 175 */
		{ 0x45, 0x00, 0xd0, 0x00 },  /* Pixel 176 */
		{ 0x59, 0x00, 0xb1, 0x00 },  /* Pixel 177 */
		{ 0x86, 0x00, 0x86, 0x00 },  /* Pixel 178 */
		{ 0x86, 0x00, 0x00, 0x00 },  /* Pixel 179 */
		{ 0x00, 0xff, 0xff, 0x00 },  /* Pixel 180 */
		{ 0x00, 0xff, 0xcc, 0x00 },  /* Pixel 181 */
		{ 0x00, 0xff, 0x99, 0x00 },  /* Pixel 182 */
		{ 0x00, 0xff, 0x66, 0x00 },  /* Pixel 183 */
		{ 0x00, 0xff, 0x33, 0x00 },  /* Pixel 184 */
		{ 0x00, 0xff, 0x00, 0x00 },  /* Pixel 185 */
		{ 0x00, 0xcc, 0xff, 0x00 },  /* Pixel 186 */
		{ 0x00, 0xe9, 0xe9, 0x00 },  /* Pixel 187 */
		{ 0x00, 0xe9, 0xaf, 0x00 },  /* Pixel 188 */
		{ 0x00, 0xe9, 0x75, 0x00 },  /* Pixel 189 */
		{ 0x00, 0xe9, 0x3a, 0x00 },  /* Pixel 190 */
		{ 0x00, 0xe9, 0x00, 0x00 },  /* Pixel 191 */
		{ 0x00, 0x99, 0xff, 0x00 },  /* Pixel 192 */
		{ 0x00, 0xaf, 0xe9, 0x00 },  /* Pixel 193 */
		{ 0x00, 0xd0, 0xd0, 0x00 },  /* Pixel 194 */
		{ 0x00, 0xd0, 0x8b, 0x00 },  /* Pixel 195 */
		{ 0x00, 0xd0, 0x45, 0x00 },  /* Pixel 196 */
		{ 0x00, 0xd0, 0x00, 0x00 },  /* Pixel 197 */
		{ 0x00, 0x66, 0xff, 0x00 },  /* Pixel 198 */
		{ 0x00, 0x75, 0xe9, 0x00 },  /* Pixel 199 */
		{ 0x00, 0x8b, 0xd0, 0x00 },  /* Pixel 200 */
		{ 0x00, 0xb1, 0xb1, 0x00 },  /* Pixel 201 */
		{ 0x00, 0xb1, 0x59, 0x00 },  /* Pixel 202 */
		{ 0x00, 0xb1, 0x00, 0x00 },  /* Pixel 203 */
		{ 0x00, 0x33, 0xff, 0x00 },  /* Pixel 204 */
		{ 0x00, 0x3a, 0xe9, 0x00 },  /* Pixel 205 */
		{ 0x00, 0x45, 0xd0, 0x00 },  /* Pixel 206 */
		{ 0x00, 0x59, 0xb1, 0x00 },  /* Pixel 207 */
		{ 0x00, 0x86, 0x86, 0x00 },  /* Pixel 208 */
		{ 0x00, 0x86, 0x00, 0x00 },  /* Pixel 209 */
		{ 0x00, 0x00, 0xff, 0x00 },  /* Pixel 210 */
		{ 0x00, 0x00, 0xe9, 0x00 },  /* Pixel 211 */
		{ 0x00, 0x00, 0xd0, 0x00 },  /* Pixel 212 */
		{ 0x00, 0x00, 0xb1, 0x00 },  /* Pixel 213 */
		{ 0x00, 0x00, 0x86, 0x00 },  /* Pixel 214 */
		{ 0xf8, 0x00, 0x00, 0x00 },  /* Pixel 215 */
		{ 0xf1, 0x00, 0x00, 0x00 },  /* Pixel 216 */
		{ 0xe1, 0x00, 0x00, 0x00 },  /* Pixel 217 */
		{ 0xd9, 0x00, 0x00, 0x00 },  /* Pixel 218 */
		{ 0xc6, 0x00, 0x00, 0x00 },  /* Pixel 219 */
		{ 0xbc, 0x00, 0x00, 0x00 },  /* Pixel 220 */
		{ 0xa4, 0x00, 0x00, 0x00 },  /* Pixel 221 */
		{ 0x96, 0x00, 0x00, 0x00 },  /* Pixel 222 */
		{ 0x72, 0x00, 0x00, 0x00 },  /* Pixel 223 */
		{ 0x56, 0x00, 0x00, 0x00 },  /* Pixel 224 */
		{ 0x00, 0xf8, 0x00, 0x00 },  /* Pixel 225 */
		{ 0x00, 0xf1, 0x00, 0x00 },  /* Pixel 226 */
		{ 0x00, 0xe1, 0x00, 0x00 },  /* Pixel 227 */
		{ 0x00, 0xd9, 0x00, 0x00 },  /* Pixel 228 */
		{ 0x00, 0xc6, 0x00, 0x00 },  /* Pixel 229 */
		{ 0x00, 0xbc, 0x00, 0x00 },  /* Pixel 230 */
		{ 0x00, 0xa4, 0x00, 0x00 },  /* Pixel 231 */
		{ 0x00, 0x96, 0x00, 0x00 },  /* Pixel 232 */
		{ 0x00, 0x72, 0x00, 0x00 },  /* Pixel 233 */
		{ 0x00, 0x56, 0x00, 0x00 },  /* Pixel 234 */
		{ 0x00, 0x00, 0xf8, 0x00 },  /* Pixel 235 */
		{ 0x00, 0x00, 0xf1, 0x00 },  /* Pixel 236 */
		{ 0x00, 0x00, 0xe1, 0x00 },  /* Pixel 237 */
		{ 0x00, 0x00, 0xd9, 0x00 },  /* Pixel 238 */
		{ 0x00, 0x00, 0xc6, 0x00 },  /* Pixel 239 */
		{ 0x00, 0x00, 0xbc, 0x00 },  /* Pixel 240 */
		{ 0x00, 0x00, 0xa4, 0x00 },  /* Pixel 241 */
		{ 0x00, 0x00, 0x96, 0x00 },  /* Pixel 242 */
		{ 0x00, 0x00, 0x72, 0x00 },  /* Pixel 243 */
		{ 0x00, 0x00, 0x56, 0x00 },  /* Pixel 244 */
		{ 0xf8, 0xf8, 0xf8, 0x00 },  /* Pixel 245 */
		{ 0xf1, 0xf1, 0xf1, 0x00 },  /* Pixel 246 */
		{ 0xe1, 0xe1, 0xe1, 0x00 },  /* Pixel 247 */
		{ 0xd9, 0xd9, 0xd9, 0x00 },  /* Pixel 248 */
		{ 0xc6, 0xc6, 0xc6, 0x00 },  /* Pixel 249 */
		{ 0xbc, 0xbc, 0xbc, 0x00 },  /* Pixel 250 */
		{ 0xa4, 0xa4, 0xa4, 0x00 },  /* Pixel 251 */
		{ 0x96, 0x96, 0x96, 0x00 },  /* Pixel 252 */
		{ 0x72, 0x72, 0x72, 0x00 },  /* Pixel 253 */
		{ 0x56, 0x56, 0x56, 0x00 },  /* Pixel 254 */
		{ 0x00, 0x00, 0x00, 0x00 },  /* Pixel 255 */
	},

	/* Gamma level 7 */
	{
		{ 0xff, 0xff, 0xff, 0x00 },  /* Pixel 0 */
		{ 0xff, 0xff, 0xcc, 0x00 },  /* Pixel 1 */
		{ 0xff, 0xff, 0x99, 0x00 },  /* Pixel 2 */
		{ 0xff, 0xff, 0x66, 0x00 },  /* Pixel 3 */
		{ 0xff, 0xff, 0x33, 0x00 },  /* Pixel 4 */
		{ 0xff, 0xff, 0x00, 0x00 },  /* Pixel 5 */
		{ 0xff, 0xcc, 0xff, 0x00 },  /* Pixel 6 */
		{ 0xff, 0xcc, 0xcc, 0x00 },  /* Pixel 7 */
		{ 0xff, 0xcc, 0x99, 0x00 },  /* Pixel 8 */
		{ 0xff, 0xcc, 0x66, 0x00 },  /* Pixel 9 */
		{ 0xff, 0xcc, 0x33, 0x00 },  /* Pixel 10 */
		{ 0xff, 0xcc, 0x00, 0x00 },  /* Pixel 11 */
		{ 0xff, 0x99, 0xff, 0x00 },  /* Pixel 12 */
		{ 0xff, 0x99, 0xcc, 0x00 },  /* Pixel 13 */
		{ 0xff, 0x99, 0x99, 0x00 },  /* Pixel 14 */
		{ 0xff, 0x99, 0x66, 0x00 },  /* Pixel 15 */
		{ 0xff, 0x99, 0x33, 0x00 },  /* Pixel 16 */
		{ 0xff, 0x99, 0x00, 0x00 },  /* Pixel 17 */
		{ 0xff, 0x66, 0xff, 0x00 },  /* Pixel 18 */
		{ 0xff, 0x66, 0xcc, 0x00 },  /* Pixel 19 */
		{ 0xff, 0x66, 0x99, 0x00 },  /* Pixel 20 */
		{ 0xff, 0x66, 0x66, 0x00 },  /* Pixel 21 */
		{ 0xff, 0x66, 0x33, 0x00 },  /* Pixel 22 */
		{ 0xff, 0x66, 0x00, 0x00 },  /* Pixel 23 */
		{ 0xff, 0x33, 0xff, 0x00 },  /* Pixel 24 */
		{ 0xff, 0x33, 0xcc, 0x00 },  /* Pixel 25 */
		{ 0xff, 0x33, 0x99, 0x00 },  /* Pixel 26 */
		{ 0xff, 0x33, 0x66, 0x00 },  /* Pixel 27 */
		{ 0xff, 0x33, 0x33, 0x00 },  /* Pixel 28 */
		{ 0xff, 0x33, 0x00, 0x00 },  /* Pixel 29 */
		{ 0xff, 0x00, 0xff, 0x00 },  /* Pixel 30 */
		{ 0xff, 0x00, 0xcc, 0x00 },  /* Pixel 31 */
		{ 0xff, 0x00, 0x99, 0x00 },  /* Pixel 32 */
		{ 0xff, 0x00, 0x66, 0x00 },  /* Pixel 33 */
		{ 0xff, 0x00, 0x33, 0x00 },  /* Pixel 34 */
		{ 0xff, 0x00, 0x00, 0x00 },  /* Pixel 35 */
		{ 0xcc, 0xff, 0xff, 0x00 },  /* Pixel 36 */
		{ 0xcc, 0xff, 0xcc, 0x00 },  /* Pixel 37 */
		{ 0xcc, 0xff, 0x99, 0x00 },  /* Pixel 38 */
		{ 0xcc, 0xff, 0x66, 0x00 },  /* Pixel 39 */
		{ 0xcc, 0xff, 0x33, 0x00 },  /* Pixel 40 */
		{ 0xcc, 0xff, 0x00, 0x00 },  /* Pixel 41 */
		{ 0xcc, 0xcc, 0xff, 0x00 },  /* Pixel 42 */
		{ 0xeb, 0xeb, 0xeb, 0x00 },  /* Pixel 43 */
		{ 0xeb, 0xeb, 0xb0, 0x00 },  /* Pixel 44 */
		{ 0xeb, 0xeb, 0x76, 0x00 },  /* Pixel 45 */
		{ 0xeb, 0xeb, 0x3b, 0x00 },  /* Pixel 46 */
		{ 0xeb, 0xeb, 0x00, 0x00 },  /* Pixel 47 */
		{ 0xcc, 0x99, 0xff, 0x00 },  /* Pixel 48 */
		{ 0xeb, 0xb0, 0xeb, 0x00 },  /* Pixel 49 */
		{ 0xeb, 0xb0, 0xb0, 0x00 },  /* Pixel 50 */
		{ 0xeb, 0xb0, 0x76, 0x00 },  /* Pixel 51 */
		{ 0xeb, 0xb0, 0x3b, 0x00 },  /* Pixel 52 */
		{ 0xeb, 0xb0, 0x00, 0x00 },  /* Pixel 53 */
		{ 0xcc, 0x66, 0xff, 0x00 },  /* Pixel 54 */
		{ 0xeb, 0x76, 0xeb, 0x00 },  /* Pixel 55 */
		{ 0xeb, 0x76, 0xb0, 0x00 },  /* Pixel 56 */
		{ 0xeb, 0x76, 0x76, 0x00 },  /* Pixel 57 */
		{ 0xeb, 0x76, 0x3b, 0x00 },  /* Pixel 58 */
		{ 0xeb, 0x76, 0x00, 0x00 },  /* Pixel 59 */
		{ 0xcc, 0x33, 0xff, 0x00 },  /* Pixel 60 */
		{ 0xeb, 0x3b, 0xeb, 0x00 },  /* Pixel 61 */
		{ 0xeb, 0x3b, 0xb0, 0x00 },  /* Pixel 62 */
		{ 0xeb, 0x3b, 0x75, 0x00 },  /* Pixel 63 */
		{ 0xeb, 0x3b, 0x3b, 0x00 },  /* Pixel 64 */
		{ 0xeb, 0x3b, 0x00, 0x00 },  /* Pixel 65 */
		{ 0xcc, 0x00, 0xff, 0x00 },  /* Pixel 66 */
		{ 0xeb, 0x00, 0xeb, 0x00 },  /* Pixel 67 */
		{ 0xeb, 0x00, 0xb0, 0x00 },  /* Pixel 68 */
		{ 0xeb, 0x00, 0x76, 0x00 },  /* Pixel 69 */
		{ 0xeb, 0x00, 0x3b, 0x00 },  /* Pixel 70 */
		{ 0xeb, 0x00, 0x00, 0x00 },  /* Pixel 71 */
		{ 0x99, 0xff, 0xff, 0x00 },  /* Pixel 72 */
		{ 0x99, 0xff, 0xcc, 0x00 },  /* Pixel 73 */
		{ 0x99, 0xff, 0x99, 0x00 },  /* Pixel 74 */
		{ 0x99, 0xff, 0x66, 0x00 },  /* Pixel 75 */
		{ 0x99, 0xff, 0x33, 0x00 },  /* Pixel 76 */
		{ 0x99, 0xff, 0x00, 0x00 },  /* Pixel 77 */
		{ 0x99, 0xcc, 0xff, 0x00 },  /* Pixel 78 */
		{ 0xb0, 0xeb, 0xeb, 0x00 },  /* Pixel 79 */
		{ 0xb0, 0xeb, 0xb0, 0x00 },  /* Pixel 80 */
		{ 0xb0, 0xeb, 0x76, 0x00 },  /* Pixel 81 */
		{ 0xb0, 0xeb, 0x3b, 0x00 },  /* Pixel 82 */
		{ 0xb0, 0xeb, 0x00, 0x00 },  /* Pixel 83 */
		{ 0x99, 0x99, 0xff, 0x00 },  /* Pixel 84 */
		{ 0xb0, 0xb0, 0xeb, 0x00 },  /* Pixel 85 */
		{ 0xd4, 0xd4, 0xd4, 0x00 },  /* Pixel 86 */
		{ 0xd4, 0xd4, 0x8d, 0x00 },  /* Pixel 87 */
		{ 0xd4, 0xd4, 0x47, 0x00 },  /* Pixel 88 */
		{ 0xd4, 0xd4, 0x00, 0x00 },  /* Pixel 89 */
		{ 0x99, 0x66, 0xff, 0x00 },  /* Pixel 90 */
		{ 0xb0, 0x76, 0xeb, 0x00 },  /* Pixel 91 */
		{ 0xd4, 0x8d, 0xd4, 0x00 },  /* Pixel 92 */
		{ 0xd4, 0x8d, 0x8d, 0x00 },  /* Pixel 93 */
		{ 0xd4, 0x8d, 0x47, 0x00 },  /* Pixel 94 */
		{ 0xd4, 0x8d, 0x00, 0x00 },  /* Pixel 95 */
		{ 0x99, 0x33, 0xff, 0x00 },  /* Pixel 96 */
		{ 0xb0, 0x3b, 0xeb, 0x00 },  /* Pixel 97 */
		{ 0xd4, 0x47, 0xd4, 0x00 },  /* Pixel 98 */
		{ 0xd4, 0x47, 0x8d, 0x00 },  /* Pixel 99 */
		{ 0xd4, 0x47, 0x47, 0x00 },  /* Pixel 100 */
		{ 0xd4, 0x47, 0x00, 0x00 },  /* Pixel 101 */
		{ 0x99, 0x00, 0xff, 0x00 },  /* Pixel 102 */
		{ 0xb0, 0x00, 0xeb, 0x00 },  /* Pixel 103 */
		{ 0xd4, 0x00, 0xd4, 0x00 },  /* Pixel 104 */
		{ 0xd4, 0x00, 0x8d, 0x00 },  /* Pixel 105 */
		{ 0xd4, 0x00, 0x47, 0x00 },  /* Pixel 106 */
		{ 0xd4, 0x00, 0x00, 0x00 },  /* Pixel 107 */
		{ 0x66, 0xff, 0xff, 0x00 },  /* Pixel 108 */
		{ 0x66, 0xff, 0xcc, 0x00 },  /* Pixel 109 */
		{ 0x66, 0xff, 0x99, 0x00 },  /* Pixel 110 */
		{ 0x66, 0xff, 0x66, 0x00 },  /* Pixel 111 */
		{ 0x66, 0xff, 0x33, 0x00 },  /* Pixel 112 */
		{ 0x66, 0xff, 0x00, 0x00 },  /* Pixel 113 */
		{ 0x66, 0xcc, 0xff, 0x00 },  /* Pixel 114 */
		{ 0x76, 0xeb, 0xeb, 0x00 },  /* Pixel 115 */
		{ 0x76, 0xeb, 0xb0, 0x00 },  /* Pixel 116 */
		{ 0x76, 0xeb, 0x76, 0x00 },  /* Pixel 117 */
		{ 0x75, 0xeb, 0x3b, 0x00 },  /* Pixel 118 */
		{ 0x76, 0xeb, 0x00, 0x00 },  /* Pixel 119 */
		{ 0x66, 0x99, 0xff, 0x00 },  /* Pixel 120 */
		{ 0x76, 0xb0, 0xeb, 0x00 },  /* Pixel 121 */
		{ 0x8d, 0xd4, 0xd4, 0x00 },  /* Pixel 122 */
		{ 0x8d, 0xd4, 0x8d, 0x00 },  /* Pixel 123 */
		{ 0x8d, 0xd4, 0x47, 0x00 },  /* Pixel 124 */
		{ 0x8d, 0xd4, 0x00, 0x00 },  /* Pixel 125 */
		{ 0x66, 0x66, 0xff, 0x00 },  /* Pixel 126 */
		{ 0x76, 0x76, 0xeb, 0x00 },  /* Pixel 127 */
		{ 0x8d, 0x8d, 0xd4, 0x00 },  /* Pixel 128 */
		{ 0xb7, 0xb7, 0xb7, 0x00 },  /* Pixel 129 */
		{ 0xb7, 0xb7, 0x5c, 0x00 },  /* Pixel 130 */
		{ 0xb7, 0xb7, 0x00, 0x00 },  /* Pixel 131 */
		{ 0x66, 0x33, 0xff, 0x00 },  /* Pixel 132 */
		{ 0x75, 0x3b, 0xeb, 0x00 },  /* Pixel 133 */
		{ 0x8d, 0x47, 0xd4, 0x00 },  /* Pixel 134 */
		{ 0xb7, 0x5c, 0xb7, 0x00 },  /* Pixel 135 */
		{ 0xb7, 0x5c, 0x5c, 0x00 },  /* Pixel 136 */
		{ 0xb7, 0x5c, 0x00, 0x00 },  /* Pixel 137 */
		{ 0x66, 0x00, 0xff, 0x00 },  /* Pixel 138 */
		{ 0x76, 0x00, 0xeb, 0x00 },  /* Pixel 139 */
		{ 0x8d, 0x00, 0xd4, 0x00 },  /* Pixel 140 */
		{ 0xb7, 0x00, 0xb7, 0x00 },  /* Pixel 141 */
		{ 0xb7, 0x00, 0x5c, 0x00 },  /* Pixel 142 */
		{ 0xb7, 0x00, 0x00, 0x00 },  /* Pixel 143 */
		{ 0x33, 0xff, 0xff, 0x00 },  /* Pixel 144 */
		{ 0x33, 0xff, 0xcc, 0x00 },  /* Pixel 145 */
		{ 0x33, 0xff, 0x99, 0x00 },  /* Pixel 146 */
		{ 0x33, 0xff, 0x66, 0x00 },  /* Pixel 147 */
		{ 0x33, 0xff, 0x33, 0x00 },  /* Pixel 148 */
		{ 0x33, 0xff, 0x00, 0x00 },  /* Pixel 149 */
		{ 0x33, 0xcc, 0xff, 0x00 },  /* Pixel 150 */
		{ 0x3b, 0xeb, 0xeb, 0x00 },  /* Pixel 151 */
		{ 0x3b, 0xeb, 0xb0, 0x00 },  /* Pixel 152 */
		{ 0x3b, 0xeb, 0x76, 0x00 },  /* Pixel 153 */
		{ 0x3b, 0xeb, 0x3b, 0x00 },  /* Pixel 154 */
		{ 0x3b, 0xeb, 0x00, 0x00 },  /* Pixel 155 */
		{ 0x33, 0x99, 0xff, 0x00 },  /* Pixel 156 */
		{ 0x3b, 0xb0, 0xeb, 0x00 },  /* Pixel 157 */
		{ 0x47, 0xd4, 0xd4, 0x00 },  /* Pixel 158 */
		{ 0x47, 0xd4, 0x8d, 0x00 },  /* Pixel 159 */
		{ 0x47, 0xd4, 0x47, 0x00 },  /* Pixel 160 */
		{ 0x47, 0xd4, 0x00, 0x00 },  /* Pixel 161 */
		{ 0x33, 0x66, 0xff, 0x00 },  /* Pixel 162 */
		{ 0x3b, 0x76, 0xeb, 0x00 },  /* Pixel 163 */
		{ 0x47, 0x8d, 0xd4, 0x00 },  /* Pixel 164 */
		{ 0x5c, 0xb7, 0xb7, 0x00 },  /* Pixel 165 */
		{ 0x5c, 0xb7, 0x5c, 0x00 },  /* Pixel 166 */
		{ 0x5c, 0xb7, 0x00, 0x00 },  /* Pixel 167 */
		{ 0x33, 0x33, 0xff, 0x00 },  /* Pixel 168 */
		{ 0x3b, 0x3b, 0xeb, 0x00 },  /* Pixel 169 */
		{ 0x47, 0x47, 0xd4, 0x00 },  /* Pixel 170 */
		{ 0x5c, 0x5c, 0xb7, 0x00 },  /* Pixel 171 */
		{ 0x8e, 0x8e, 0x8e, 0x00 },  /* Pixel 172 */
		{ 0x8e, 0x8e, 0x00, 0x00 },  /* Pixel 173 */
		{ 0x33, 0x00, 0xff, 0x00 },  /* Pixel 174 */
		{ 0x3b, 0x00, 0xeb, 0x00 },  /* Pixel 175 */
		{ 0x47, 0x00, 0xd4, 0x00 },  /* Pixel 176 */
		{ 0x5c, 0x00, 0xb7, 0x00 },  /* Pixel 177 */
		{ 0x8e, 0x00, 0x8e, 0x00 },  /* Pixel 178 */
		{ 0x8e, 0x00, 0x00, 0x00 },  /* Pixel 179 */
		{ 0x00, 0xff, 0xff, 0x00 },  /* Pixel 180 */
		{ 0x00, 0xff, 0xcc, 0x00 },  /* Pixel 181 */
		{ 0x00, 0xff, 0x99, 0x00 },  /* Pixel 182 */
		{ 0x00, 0xff, 0x66, 0x00 },  /* Pixel 183 */
		{ 0x00, 0xff, 0x33, 0x00 },  /* Pixel 184 */
		{ 0x00, 0xff, 0x00, 0x00 },  /* Pixel 185 */
		{ 0x00, 0xcc, 0xff, 0x00 },  /* Pixel 186 */
		{ 0x00, 0xeb, 0xeb, 0x00 },  /* Pixel 187 */
		{ 0x00, 0xeb, 0xb0, 0x00 },  /* Pixel 188 */
		{ 0x00, 0xeb, 0x76, 0x00 },  /* Pixel 189 */
		{ 0x00, 0xeb, 0x3b, 0x00 },  /* Pixel 190 */
		{ 0x00, 0xeb, 0x00, 0x00 },  /* Pixel 191 */
		{ 0x00, 0x99, 0xff, 0x00 },  /* Pixel 192 */
		{ 0x00, 0xb0, 0xeb, 0x00 },  /* Pixel 193 */
		{ 0x00, 0xd4, 0xd4, 0x00 },  /* Pixel 194 */
		{ 0x00, 0xd4, 0x8d, 0x00 },  /* Pixel 195 */
		{ 0x00, 0xd4, 0x47, 0x00 },  /* Pixel 196 */
		{ 0x00, 0xd4, 0x00, 0x00 },  /* Pixel 197 */
		{ 0x00, 0x66, 0xff, 0x00 },  /* Pixel 198 */
		{ 0x00, 0x76, 0xeb, 0x00 },  /* Pixel 199 */
		{ 0x00, 0x8d, 0xd4, 0x00 },  /* Pixel 200 */
		{ 0x00, 0xb7, 0xb7, 0x00 },  /* Pixel 201 */
		{ 0x00, 0xb7, 0x5c, 0x00 },  /* Pixel 202 */
		{ 0x00, 0xb7, 0x00, 0x00 },  /* Pixel 203 */
		{ 0x00, 0x33, 0xff, 0x00 },  /* Pixel 204 */
		{ 0x00, 0x3b, 0xeb, 0x00 },  /* Pixel 205 */
		{ 0x00, 0x47, 0xd4, 0x00 },  /* Pixel 206 */
		{ 0x00, 0x5c, 0xb7, 0x00 },  /* Pixel 207 */
		{ 0x00, 0x8e, 0x8e, 0x00 },  /* Pixel 208 */
		{ 0x00, 0x8e, 0x00, 0x00 },  /* Pixel 209 */
		{ 0x00, 0x00, 0xff, 0x00 },  /* Pixel 210 */
		{ 0x00, 0x00, 0xeb, 0x00 },  /* Pixel 211 */
		{ 0x00, 0x00, 0xd4, 0x00 },  /* Pixel 212 */
		{ 0x00, 0x00, 0xb7, 0x00 },  /* Pixel 213 */
		{ 0x00, 0x00, 0x8e, 0x00 },  /* Pixel 214 */
		{ 0xf9, 0x00, 0x00, 0x00 },  /* Pixel 215 */
		{ 0xf2, 0x00, 0x00, 0x00 },  /* Pixel 216 */
		{ 0xe4, 0x00, 0x00, 0x00 },  /* Pixel 217 */
		{ 0xdc, 0x00, 0x00, 0x00 },  /* Pixel 218 */
		{ 0xcb, 0x00, 0x00, 0x00 },  /* Pixel 219 */
		{ 0xc1, 0x00, 0x00, 0x00 },  /* Pixel 220 */
		{ 0xab, 0x00, 0x00, 0x00 },  /* Pixel 221 */
		{ 0x9e, 0x00, 0x00, 0x00 },  /* Pixel 222 */
		{ 0x7b, 0x00, 0x00, 0x00 },  /* Pixel 223 */
		{ 0x5f, 0x00, 0x00, 0x00 },  /* Pixel 224 */
		{ 0x00, 0xf9, 0x00, 0x00 },  /* Pixel 225 */
		{ 0x00, 0xf2, 0x00, 0x00 },  /* Pixel 226 */
		{ 0x00, 0xe4, 0x00, 0x00 },  /* Pixel 227 */
		{ 0x00, 0xdc, 0x00, 0x00 },  /* Pixel 228 */
		{ 0x00, 0xcb, 0x00, 0x00 },  /* Pixel 229 */
		{ 0x00, 0xc1, 0x00, 0x00 },  /* Pixel 230 */
		{ 0x00, 0xab, 0x00, 0x00 },  /* Pixel 231 */
		{ 0x00, 0x9e, 0x00, 0x00 },  /* Pixel 232 */
		{ 0x00, 0x7b, 0x00, 0x00 },  /* Pixel 233 */
		{ 0x00, 0x5f, 0x00, 0x00 },  /* Pixel 234 */
		{ 0x00, 0x00, 0xf9, 0x00 },  /* Pixel 235 */
		{ 0x00, 0x00, 0xf2, 0x00 },  /* Pixel 236 */
		{ 0x00, 0x00, 0xe4, 0x00 },  /* Pixel 237 */
		{ 0x00, 0x00, 0xdc, 0x00 },  /* Pixel 238 */
		{ 0x00, 0x00, 0xcb, 0x00 },  /* Pixel 239 */
		{ 0x00, 0x00, 0xc1, 0x00 },  /* Pixel 240 */
		{ 0x00, 0x00, 0xab, 0x00 },  /* Pixel 241 */
		{ 0x00, 0x00, 0x9e, 0x00 },  /* Pixel 242 */
		{ 0x00, 0x00, 0x7b, 0x00 },  /* Pixel 243 */
		{ 0x00, 0x00, 0x5f, 0x00 },  /* Pixel 244 */
		{ 0xf9, 0xf9, 0xf9, 0x00 },  /* Pixel 245 */
		{ 0xf2, 0xf2, 0xf2, 0x00 },  /* Pixel 246 */
		{ 0xe4, 0xe4, 0xe4, 0x00 },  /* Pixel 247 */
		{ 0xdc, 0xdc, 0xdc, 0x00 },  /* Pixel 248 */
		{ 0xcb, 0xcb, 0xcb, 0x00 },  /* Pixel 249 */
		{ 0xc1, 0xc1, 0xc1, 0x00 },  /* Pixel 250 */
		{ 0xab, 0xab, 0xab, 0x00 },  /* Pixel 251 */
		{ 0x9e, 0x9e, 0x9e, 0x00 },  /* Pixel 252 */
		{ 0x7b, 0x7b, 0x7b, 0x00 },  /* Pixel 253 */
		{ 0x5f, 0x5f, 0x5f, 0x00 },  /* Pixel 254 */
		{ 0x00, 0x00, 0x00, 0x00 },  /* Pixel 255 */
	},

	/* Gamma level 8 */
	{
		{ 0xff, 0xff, 0xff, 0x00 },  /* Pixel 0 */
		{ 0xff, 0xff, 0xcc, 0x00 },  /* Pixel 1 */
		{ 0xff, 0xff, 0x99, 0x00 },  /* Pixel 2 */
		{ 0xff, 0xff, 0x66, 0x00 },  /* Pixel 3 */
		{ 0xff, 0xff, 0x33, 0x00 },  /* Pixel 4 */
		{ 0xff, 0xff, 0x00, 0x00 },  /* Pixel 5 */
		{ 0xff, 0xcc, 0xff, 0x00 },  /* Pixel 6 */
		{ 0xff, 0xcc, 0xcc, 0x00 },  /* Pixel 7 */
		{ 0xff, 0xcc, 0x99, 0x00 },  /* Pixel 8 */
		{ 0xff, 0xcc, 0x66, 0x00 },  /* Pixel 9 */
		{ 0xff, 0xcc, 0x33, 0x00 },  /* Pixel 10 */
		{ 0xff, 0xcc, 0x00, 0x00 },  /* Pixel 11 */
		{ 0xff, 0x99, 0xff, 0x00 },  /* Pixel 12 */
		{ 0xff, 0x99, 0xcc, 0x00 },  /* Pixel 13 */
		{ 0xff, 0x99, 0x99, 0x00 },  /* Pixel 14 */
		{ 0xff, 0x99, 0x66, 0x00 },  /* Pixel 15 */
		{ 0xff, 0x99, 0x33, 0x00 },  /* Pixel 16 */
		{ 0xff, 0x99, 0x00, 0x00 },  /* Pixel 17 */
		{ 0xff, 0x66, 0xff, 0x00 },  /* Pixel 18 */
		{ 0xff, 0x66, 0xcc, 0x00 },  /* Pixel 19 */
		{ 0xff, 0x66, 0x99, 0x00 },  /* Pixel 20 */
		{ 0xff, 0x66, 0x66, 0x00 },  /* Pixel 21 */
		{ 0xff, 0x66, 0x33, 0x00 },  /* Pixel 22 */
		{ 0xff, 0x66, 0x00, 0x00 },  /* Pixel 23 */
		{ 0xff, 0x33, 0xff, 0x00 },  /* Pixel 24 */
		{ 0xff, 0x33, 0xcc, 0x00 },  /* Pixel 25 */
		{ 0xff, 0x33, 0x99, 0x00 },  /* Pixel 26 */
		{ 0xff, 0x33, 0x66, 0x00 },  /* Pixel 27 */
		{ 0xff, 0x33, 0x33, 0x00 },  /* Pixel 28 */
		{ 0xff, 0x33, 0x00, 0x00 },  /* Pixel 29 */
		{ 0xff, 0x00, 0xff, 0x00 },  /* Pixel 30 */
		{ 0xff, 0x00, 0xcc, 0x00 },  /* Pixel 31 */
		{ 0xff, 0x00, 0x99, 0x00 },  /* Pixel 32 */
		{ 0xff, 0x00, 0x66, 0x00 },  /* Pixel 33 */
		{ 0xff, 0x00, 0x33, 0x00 },  /* Pixel 34 */
		{ 0xff, 0x00, 0x00, 0x00 },  /* Pixel 35 */
		{ 0xcc, 0xff, 0xff, 0x00 },  /* Pixel 36 */
		{ 0xcc, 0xff, 0xcc, 0x00 },  /* Pixel 37 */
		{ 0xcc, 0xff, 0x99, 0x00 },  /* Pixel 38 */
		{ 0xcc, 0xff, 0x66, 0x00 },  /* Pixel 39 */
		{ 0xcc, 0xff, 0x33, 0x00 },  /* Pixel 40 */
		{ 0xcc, 0xff, 0x00, 0x00 },  /* Pixel 41 */
		{ 0xcc, 0xcc, 0xff, 0x00 },  /* Pixel 42 */
		{ 0xed, 0xed, 0xed, 0x00 },  /* Pixel 43 */
		{ 0xed, 0xed, 0xb2, 0x00 },  /* Pixel 44 */
		{ 0xed, 0xed, 0x77, 0x00 },  /* Pixel 45 */
		{ 0xed, 0xed, 0x3b, 0x00 },  /* Pixel 46 */
		{ 0xed, 0xed, 0x00, 0x00 },  /* Pixel 47 */
		{ 0xcc, 0x99, 0xff, 0x00 },  /* Pixel 48 */
		{ 0xed, 0xb2, 0xed, 0x00 },  /* Pixel 49 */
		{ 0xed, 0xb2, 0xb2, 0x00 },  /* Pixel 50 */
		{ 0xed, 0xb2, 0x77, 0x00 },  /* Pixel 51 */
		{ 0xed, 0xb2, 0x3b, 0x00 },  /* Pixel 52 */
		{ 0xed, 0xb2, 0x00, 0x00 },  /* Pixel 53 */
		{ 0xcc, 0x66, 0xff, 0x00 },  /* Pixel 54 */
		{ 0xed, 0x77, 0xed, 0x00 },  /* Pixel 55 */
		{ 0xed, 0x77, 0xb2, 0x00 },  /* Pixel 56 */
		{ 0xed, 0x77, 0x77, 0x00 },  /* Pixel 57 */
		{ 0xed, 0x77, 0x3b, 0x00 },  /* Pixel 58 */
		{ 0xed, 0x77, 0x00, 0x00 },  /* Pixel 59 */
		{ 0xcc, 0x33, 0xff, 0x00 },  /* Pixel 60 */
		{ 0xed, 0x3b, 0xed, 0x00 },  /* Pixel 61 */
		{ 0xed, 0x3b, 0xb2, 0x00 },  /* Pixel 62 */
		{ 0xed, 0x3b, 0x76, 0x00 },  /* Pixel 63 */
		{ 0xed, 0x3b, 0x3b, 0x00 },  /* Pixel 64 */
		{ 0xed, 0x3b, 0x00, 0x00 },  /* Pixel 65 */
		{ 0xcc, 0x00, 0xff, 0x00 },  /* Pixel 66 */
		{ 0xed, 0x00, 0xed, 0x00 },  /* Pixel 67 */
		{ 0xed, 0x00, 0xb2, 0x00 },  /* Pixel 68 */
		{ 0xed, 0x00, 0x77, 0x00 },  /* Pixel 69 */
		{ 0xed, 0x00, 0x3b, 0x00 },  /* Pixel 70 */
		{ 0xed, 0x00, 0x00, 0x00 },  /* Pixel 71 */
		{ 0x99, 0xff, 0xff, 0x00 },  /* Pixel 72 */
		{ 0x99, 0xff, 0xcc, 0x00 },  /* Pixel 73 */
		{ 0x99, 0xff, 0x99, 0x00 },  /* Pixel 74 */
		{ 0x99, 0xff, 0x66, 0x00 },  /* Pixel 75 */
		{ 0x99, 0xff, 0x33, 0x00 },  /* Pixel 76 */
		{ 0x99, 0xff, 0x00, 0x00 },  /* Pixel 77 */
		{ 0x99, 0xcc, 0xff, 0x00 },  /* Pixel 78 */
		{ 0xb2, 0xed, 0xed, 0x00 },  /* Pixel 79 */
		{ 0xb2, 0xed, 0xb2, 0x00 },  /* Pixel 80 */
		{ 0xb2, 0xed, 0x77, 0x00 },  /* Pixel 81 */
		{ 0xb2, 0xed, 0x3b, 0x00 },  /* Pixel 82 */
		{ 0xb2, 0xed, 0x00, 0x00 },  /* Pixel 83 */
		{ 0x99, 0x99, 0xff, 0x00 },  /* Pixel 84 */
		{ 0xb2, 0xb2, 0xed, 0x00 },  /* Pixel 85 */
		{ 0xd7, 0xd7, 0xd7, 0x00 },  /* Pixel 86 */
		{ 0xd7, 0xd7, 0x8f, 0x00 },  /* Pixel 87 */
		{ 0xd7, 0xd7, 0x48, 0x00 },  /* Pixel 88 */
		{ 0xd7, 0xd7, 0x00, 0x00 },  /* Pixel 89 */
		{ 0x99, 0x66, 0xff, 0x00 },  /* Pixel 90 */
		{ 0xb2, 0x77, 0xed, 0x00 },  /* Pixel 91 */
		{ 0xd7, 0x8f, 0xd7, 0x00 },  /* Pixel 92 */
		{ 0xd7, 0x8f, 0x8f, 0x00 },  /* Pixel 93 */
		{ 0xd7, 0x8f, 0x48, 0x00 },  /* Pixel 94 */
		{ 0xd7, 0x8f, 0x00, 0x00 },  /* Pixel 95 */
		{ 0x99, 0x33, 0xff, 0x00 },  /* Pixel 96 */
		{ 0xb2, 0x3b, 0xed, 0x00 },  /* Pixel 97 */
		{ 0xd7, 0x48, 0xd7, 0x00 },  /* Pixel 98 */
		{ 0xd7, 0x48, 0x8f, 0x00 },  /* Pixel 99 */
		{ 0xd7, 0x48, 0x48, 0x00 },  /* Pixel 100 */
		{ 0xd7, 0x48, 0x00, 0x00 },  /* Pixel 101 */
		{ 0x99, 0x00, 0xff, 0x00 },  /* Pixel 102 */
		{ 0xb2, 0x00, 0xed, 0x00 },  /* Pixel 103 */
		{ 0xd7, 0x00, 0xd7, 0x00 },  /* Pixel 104 */
		{ 0xd7, 0x00, 0x8f, 0x00 },  /* Pixel 105 */
		{ 0xd7, 0x00, 0x48, 0x00 },  /* Pixel 106 */
		{ 0xd7, 0x00, 0x00, 0x00 },  /* Pixel 107 */
		{ 0x66, 0xff, 0xff, 0x00 },  /* Pixel 108 */
		{ 0x66, 0xff, 0xcc, 0x00 },  /* Pixel 109 */
		{ 0x66, 0xff, 0x99, 0x00 },  /* Pixel 110 */
		{ 0x66, 0xff, 0x66, 0x00 },  /* Pixel 111 */
		{ 0x66, 0xff, 0x33, 0x00 },  /* Pixel 112 */
		{ 0x66, 0xff, 0x00, 0x00 },  /* Pixel 113 */
		{ 0x66, 0xcc, 0xff, 0x00 },  /* Pixel 114 */
		{ 0x77, 0xed, 0xed, 0x00 },  /* Pixel 115 */
		{ 0x77, 0xed, 0xb2, 0x00 },  /* Pixel 116 */
		{ 0x77, 0xed, 0x77, 0x00 },  /* Pixel 117 */
		{ 0x76, 0xed, 0x3b, 0x00 },  /* Pixel 118 */
		{ 0x77, 0xed, 0x00, 0x00 },  /* Pixel 119 */
		{ 0x66, 0x99, 0xff, 0x00 },  /* Pixel 120 */
		{ 0x77, 0xb2, 0xed, 0x00 },  /* Pixel 121 */
		{ 0x8f, 0xd7, 0xd7, 0x00 },  /* Pixel 122 */
		{ 0x8f, 0xd7, 0x8f, 0x00 },  /* Pixel 123 */
		{ 0x8f, 0xd7, 0x48, 0x00 },  /* Pixel 124 */
		{ 0x8f, 0xd7, 0x00, 0x00 },  /* Pixel 125 */
		{ 0x66, 0x66, 0xff, 0x00 },  /* Pixel 126 */
		{ 0x77, 0x77, 0xed, 0x00 },  /* Pixel 127 */
		{ 0x8f, 0x8f, 0xd7, 0x00 },  /* Pixel 128 */
		{ 0xbc, 0xbc, 0xbc, 0x00 },  /* Pixel 129 */
		{ 0xbc, 0xbc, 0x5e, 0x00 },  /* Pixel 130 */
		{ 0xbc, 0xbc, 0x00, 0x00 },  /* Pixel 131 */
		{ 0x66, 0x33, 0xff, 0x00 },  /* Pixel 132 */
		{ 0x76, 0x3b, 0xed, 0x00 },  /* Pixel 133 */
		{ 0x8f, 0x48, 0xd7, 0x00 },  /* Pixel 134 */
		{ 0xbc, 0x5e, 0xbc, 0x00 },  /* Pixel 135 */
		{ 0xbc, 0x5e, 0x5e, 0x00 },  /* Pixel 136 */
		{ 0xbc, 0x5e, 0x00, 0x00 },  /* Pixel 137 */
		{ 0x66, 0x00, 0xff, 0x00 },  /* Pixel 138 */
		{ 0x77, 0x00, 0xed, 0x00 },  /* Pixel 139 */
		{ 0x8f, 0x00, 0xd7, 0x00 },  /* Pixel 140 */
		{ 0xbc, 0x00, 0xbc, 0x00 },  /* Pixel 141 */
		{ 0xbc, 0x00, 0x5e, 0x00 },  /* Pixel 142 */
		{ 0xbc, 0x00, 0x00, 0x00 },  /* Pixel 143 */
		{ 0x33, 0xff, 0xff, 0x00 },  /* Pixel 144 */
		{ 0x33, 0xff, 0xcc, 0x00 },  /* Pixel 145 */
		{ 0x33, 0xff, 0x99, 0x00 },  /* Pixel 146 */
		{ 0x33, 0xff, 0x66, 0x00 },  /* Pixel 147 */
		{ 0x33, 0xff, 0x33, 0x00 },  /* Pixel 148 */
		{ 0x33, 0xff, 0x00, 0x00 },  /* Pixel 149 */
		{ 0x33, 0xcc, 0xff, 0x00 },  /* Pixel 150 */
		{ 0x3b, 0xed, 0xed, 0x00 },  /* Pixel 151 */
		{ 0x3b, 0xed, 0xb2, 0x00 },  /* Pixel 152 */
		{ 0x3b, 0xed, 0x77, 0x00 },  /* Pixel 153 */
		{ 0x3b, 0xed, 0x3b, 0x00 },  /* Pixel 154 */
		{ 0x3b, 0xed, 0x00, 0x00 },  /* Pixel 155 */
		{ 0x33, 0x99, 0xff, 0x00 },  /* Pixel 156 */
		{ 0x3b, 0xb2, 0xed, 0x00 },  /* Pixel 157 */
		{ 0x48, 0xd7, 0xd7, 0x00 },  /* Pixel 158 */
		{ 0x48, 0xd7, 0x8f, 0x00 },  /* Pixel 159 */
		{ 0x48, 0xd7, 0x48, 0x00 },  /* Pixel 160 */
		{ 0x48, 0xd7, 0x00, 0x00 },  /* Pixel 161 */
		{ 0x33, 0x66, 0xff, 0x00 },  /* Pixel 162 */
		{ 0x3b, 0x77, 0xed, 0x00 },  /* Pixel 163 */
		{ 0x48, 0x8f, 0xd7, 0x00 },  /* Pixel 164 */
		{ 0x5e, 0xbc, 0xbc, 0x00 },  /* Pixel 165 */
		{ 0x5e, 0xbc, 0x5e, 0x00 },  /* Pixel 166 */
		{ 0x5e, 0xbc, 0x00, 0x00 },  /* Pixel 167 */
		{ 0x33, 0x33, 0xff, 0x00 },  /* Pixel 168 */
		{ 0x3b, 0x3b, 0xed, 0x00 },  /* Pixel 169 */
		{ 0x48, 0x48, 0xd7, 0x00 },  /* Pixel 170 */
		{ 0x5e, 0x5e, 0xbc, 0x00 },  /* Pixel 171 */
		{ 0x95, 0x95, 0x95, 0x00 },  /* Pixel 172 */
		{ 0x95, 0x95, 0x00, 0x00 },  /* Pixel 173 */
		{ 0x33, 0x00, 0xff, 0x00 },  /* Pixel 174 */
		{ 0x3b, 0x00, 0xed, 0x00 },  /* Pixel 175 */
		{ 0x48, 0x00, 0xd7, 0x00 },  /* Pixel 176 */
		{ 0x5e, 0x00, 0xbc, 0x00 },  /* Pixel 177 */
		{ 0x95, 0x00, 0x95, 0x00 },  /* Pixel 178 */
		{ 0x95, 0x00, 0x00, 0x00 },  /* Pixel 179 */
		{ 0x00, 0xff, 0xff, 0x00 },  /* Pixel 180 */
		{ 0x00, 0xff, 0xcc, 0x00 },  /* Pixel 181 */
		{ 0x00, 0xff, 0x99, 0x00 },  /* Pixel 182 */
		{ 0x00, 0xff, 0x66, 0x00 },  /* Pixel 183 */
		{ 0x00, 0xff, 0x33, 0x00 },  /* Pixel 184 */
		{ 0x00, 0xff, 0x00, 0x00 },  /* Pixel 185 */
		{ 0x00, 0xcc, 0xff, 0x00 },  /* Pixel 186 */
		{ 0x00, 0xed, 0xed, 0x00 },  /* Pixel 187 */
		{ 0x00, 0xed, 0xb2, 0x00 },  /* Pixel 188 */
		{ 0x00, 0xed, 0x77, 0x00 },  /* Pixel 189 */
		{ 0x00, 0xed, 0x3b, 0x00 },  /* Pixel 190 */
		{ 0x00, 0xed, 0x00, 0x00 },  /* Pixel 191 */
		{ 0x00, 0x99, 0xff, 0x00 },  /* Pixel 192 */
		{ 0x00, 0xb2, 0xed, 0x00 },  /* Pixel 193 */
		{ 0x00, 0xd7, 0xd7, 0x00 },  /* Pixel 194 */
		{ 0x00, 0xd7, 0x8f, 0x00 },  /* Pixel 195 */
		{ 0x00, 0xd7, 0x48, 0x00 },  /* Pixel 196 */
		{ 0x00, 0xd7, 0x00, 0x00 },  /* Pixel 197 */
		{ 0x00, 0x66, 0xff, 0x00 },  /* Pixel 198 */
		{ 0x00, 0x77, 0xed, 0x00 },  /* Pixel 199 */
		{ 0x00, 0x8f, 0xd7, 0x00 },  /* Pixel 200 */
		{ 0x00, 0xbc, 0xbc, 0x00 },  /* Pixel 201 */
		{ 0x00, 0xbc, 0x5e, 0x00 },  /* Pixel 202 */
		{ 0x00, 0xbc, 0x00, 0x00 },  /* Pixel 203 */
		{ 0x00, 0x33, 0xff, 0x00 },  /* Pixel 204 */
		{ 0x00, 0x3b, 0xed, 0x00 },  /* Pixel 205 */
		{ 0x00, 0x48, 0xd7, 0x00 },  /* Pixel 206 */
		{ 0x00, 0x5e, 0xbc, 0x00 },  /* Pixel 207 */
		{ 0x00, 0x95, 0x95, 0x00 },  /* Pixel 208 */
		{ 0x00, 0x95, 0x00, 0x00 },  /* Pixel 209 */
		{ 0x00, 0x00, 0xff, 0x00 },  /* Pixel 210 */
		{ 0x00, 0x00, 0xed, 0x00 },  /* Pixel 211 */
		{ 0x00, 0x00, 0xd7, 0x00 },  /* Pixel 212 */
		{ 0x00, 0x00, 0xbc, 0x00 },  /* Pixel 213 */
		{ 0x00, 0x00, 0x95, 0x00 },  /* Pixel 214 */
		{ 0xf9, 0x00, 0x00, 0x00 },  /* Pixel 215 */
		{ 0xf3, 0x00, 0x00, 0x00 },  /* Pixel 216 */
		{ 0xe6, 0x00, 0x00, 0x00 },  /* Pixel 217 */
		{ 0xdf, 0x00, 0x00, 0x00 },  /* Pixel 218 */
		{ 0xcf, 0x00, 0x00, 0x00 },  /* Pixel 219 */
		{ 0xc6, 0x00, 0x00, 0x00 },  /* Pixel 220 */
		{ 0xb1, 0x00, 0x00, 0x00 },  /* Pixel 221 */
		{ 0xa4, 0x00, 0x00, 0x00 },  /* Pixel 222 */
		{ 0x82, 0x00, 0x00, 0x00 },  /* Pixel 223 */
		{ 0x67, 0x00, 0x00, 0x00 },  /* Pixel 224 */
		{ 0x00, 0xf9, 0x00, 0x00 },  /* Pixel 225 */
		{ 0x00, 0xf3, 0x00, 0x00 },  /* Pixel 226 */
		{ 0x00, 0xe6, 0x00, 0x00 },  /* Pixel 227 */
		{ 0x00, 0xdf, 0x00, 0x00 },  /* Pixel 228 */
		{ 0x00, 0xcf, 0x00, 0x00 },  /* Pixel 229 */
		{ 0x00, 0xc6, 0x00, 0x00 },  /* Pixel 230 */
		{ 0x00, 0xb1, 0x00, 0x00 },  /* Pixel 231 */
		{ 0x00, 0xa4, 0x00, 0x00 },  /* Pixel 232 */
		{ 0x00, 0x82, 0x00, 0x00 },  /* Pixel 233 */
		{ 0x00, 0x67, 0x00, 0x00 },  /* Pixel 234 */
		{ 0x00, 0x00, 0xf9, 0x00 },  /* Pixel 235 */
		{ 0x00, 0x00, 0xf3, 0x00 },  /* Pixel 236 */
		{ 0x00, 0x00, 0xe6, 0x00 },  /* Pixel 237 */
		{ 0x00, 0x00, 0xdf, 0x00 },  /* Pixel 238 */
		{ 0x00, 0x00, 0xcf, 0x00 },  /* Pixel 239 */
		{ 0x00, 0x00, 0xc6, 0x00 },  /* Pixel 240 */
		{ 0x00, 0x00, 0xb1, 0x00 },  /* Pixel 241 */
		{ 0x00, 0x00, 0xa4, 0x00 },  /* Pixel 242 */
		{ 0x00, 0x00, 0x82, 0x00 },  /* Pixel 243 */
		{ 0x00, 0x00, 0x67, 0x00 },  /* Pixel 244 */
		{ 0xf9, 0xf9, 0xf9, 0x00 },  /* Pixel 245 */
		{ 0xf3, 0xf3, 0xf3, 0x00 },  /* Pixel 246 */
		{ 0xe6, 0xe6, 0xe6, 0x00 },  /* Pixel 247 */
		{ 0xdf, 0xdf, 0xdf, 0x00 },  /* Pixel 248 */
		{ 0xcf, 0xcf, 0xcf, 0x00 },  /* Pixel 249 */
		{ 0xc6, 0xc6, 0xc6, 0x00 },  /* Pixel 250 */
		{ 0xb1, 0xb1, 0xb1, 0x00 },  /* Pixel 251 */
		{ 0xa4, 0xa4, 0xa4, 0x00 },  /* Pixel 252 */
		{ 0x82, 0x82, 0x82, 0x00 },  /* Pixel 253 */
		{ 0x67, 0x67, 0x67, 0x00 },  /* Pixel 254 */
		{ 0x00, 0x00, 0x00, 0x00 },  /* Pixel 255 */
	},
};
