/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-mailbox-properties-dialog.h"

#include "mn-mailbox-properties-dialog-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 29 "src/mn-mailbox-properties-dialog.gob"

#include <glib/gi18n.h>
#include "mn-autodetect-mailbox-properties.h"
#if WITH_MBOX || WITH_MOZILLA || WITH_MH || WITH_MAILDIR || WITH_SYLPHEED
#include "mn-system-vfs-mailbox-properties.h"
#endif
#if WITH_POP3
#include "mn-pop3-mailbox-properties.h"
#endif
#if WITH_IMAP
#include "mn-imap-mailbox-properties.h"
#endif
#if WITH_GMAIL
#include "mn-gmail-mailbox-properties.h"
#endif
#if WITH_YAHOO
#include "mn-yahoo-mailbox-properties.h"
#endif
#if WITH_HOTMAIL
#include "mn-hotmail-mailbox-properties.h"
#endif
#if WITH_EVOLUTION
#include "mn-evolution-mailbox-properties.h"
#endif
#include "mn-util.h"
#include "mn-mailboxes.h"
#include "mn-shell.h"
#include "mn-non-linear-range.h"

#define HELP_SECTION "mn-mailbox-properties-help-section"

enum {
  COLUMN_PROPERTIES,
  COLUMN_STOCK_ID,
  COLUMN_LABEL,
  N_COLUMNS
};

static GType selected_type = 0;

static const MNNonLinearRangeBlock delay_blocks[] = {
  { MN_SECS(10),	MN_SECS(60),	MN_SECS(10)	},
  { MN_MINS(2),		MN_MINS(10),	MN_MINS(1)	},
  { MN_MINS(15),	MN_MINS(60),	MN_MINS(5)	},
  { MN_HOURS(2),	MN_HOURS(24),	MN_HOURS(1)	}
};

#line 74 "mn-mailbox-properties-dialog.c"
/* self casting macros */
#define SELF(x) MN_MAILBOX_PROPERTIES_DIALOG(x)
#define SELF_CONST(x) MN_MAILBOX_PROPERTIES_DIALOG_CONST(x)
#define IS_SELF(x) MN_IS_MAILBOX_PROPERTIES_DIALOG(x)
#define TYPE_SELF MN_TYPE_MAILBOX_PROPERTIES_DIALOG
#define SELF_CLASS(x) MN_MAILBOX_PROPERTIES_DIALOG_CLASS(x)

#define SELF_GET_CLASS(x) MN_MAILBOX_PROPERTIES_DIALOG_GET_CLASS(x)

/* self typedefs */
typedef MNMailboxPropertiesDialog Self;
typedef MNMailboxPropertiesDialogClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
#line 0 "src/mn-mailbox-properties-dialog.gob"
static void mn_mailbox_properties_dialog_init (MNMailboxPropertiesDialog * o);
#line 93 "mn-mailbox-properties-dialog.c"
#line 0 "src/mn-mailbox-properties-dialog.gob"
static void mn_mailbox_properties_dialog_class_init (MNMailboxPropertiesDialogClass * c);
#line 96 "mn-mailbox-properties-dialog.c"
#line 144 "src/mn-mailbox-properties-dialog.gob"
static void mn_mailbox_properties_dialog_constructor (MNMailboxPropertiesDialog * self);
#line 99 "mn-mailbox-properties-dialog.c"
#line 253 "src/mn-mailbox-properties-dialog.gob"
static void mn_mailbox_properties_dialog_setup_type_combo (MNMailboxPropertiesDialog * self);
#line 102 "mn-mailbox-properties-dialog.c"
#line 305 "src/mn-mailbox-properties-dialog.gob"
static void mn_mailbox_properties_dialog_response_h (GtkDialog * dialog, int response, gpointer user_data);
#line 105 "mn-mailbox-properties-dialog.c"
#line 330 "src/mn-mailbox-properties-dialog.gob"
static void mn_mailbox_properties_dialog_add_type (MNMailboxPropertiesDialog * self, GType type);
#line 108 "mn-mailbox-properties-dialog.c"
#line 361 "src/mn-mailbox-properties-dialog.gob"
static void mn_mailbox_properties_dialog_set_active_properties (MNMailboxPropertiesDialog * self, MNMailboxProperties * properties);
#line 111 "mn-mailbox-properties-dialog.c"
#line 383 "src/mn-mailbox-properties-dialog.gob"
static MNMailboxProperties * mn_mailbox_properties_dialog_get_active_properties (MNMailboxPropertiesDialog * self);
#line 114 "mn-mailbox-properties-dialog.c"
#line 395 "src/mn-mailbox-properties-dialog.gob"
static MNMailboxProperties * mn_mailbox_properties_dialog_get_properties_by_type (MNMailboxPropertiesDialog * self, const char * type);
#line 117 "mn-mailbox-properties-dialog.c"
#line 419 "src/mn-mailbox-properties-dialog.gob"
static MNMailboxProperties * mn_mailbox_properties_dialog_get_properties_by_g_type (MNMailboxPropertiesDialog * self, GType type);
#line 120 "mn-mailbox-properties-dialog.c"
#line 496 "src/mn-mailbox-properties-dialog.gob"
static void mn_mailbox_properties_dialog_update_complete (MNMailboxPropertiesDialog * self);
#line 123 "mn-mailbox-properties-dialog.c"
#line 515 "src/mn-mailbox-properties-dialog.gob"
static void mn_mailbox_properties_dialog_update_name_sensitivity (MNMailboxPropertiesDialog * self);
#line 126 "mn-mailbox-properties-dialog.c"
#line 521 "src/mn-mailbox-properties-dialog.gob"
static void mn_mailbox_properties_dialog_update_delay_sensitivity (MNMailboxPropertiesDialog * self);
#line 129 "mn-mailbox-properties-dialog.c"
#line 527 "src/mn-mailbox-properties-dialog.gob"
static void mn_mailbox_properties_dialog_update_delay_visibility (MNMailboxPropertiesDialog * self);
#line 132 "mn-mailbox-properties-dialog.c"
#line 560 "src/mn-mailbox-properties-dialog.gob"
static void mn_mailbox_properties_dialog_update_default_name (MNMailboxPropertiesDialog * self);
#line 135 "mn-mailbox-properties-dialog.c"
#line 595 "src/mn-mailbox-properties-dialog.gob"
static void mn_mailbox_properties_dialog_update_default_check_delay (MNMailboxPropertiesDialog * self);
#line 138 "mn-mailbox-properties-dialog.c"

enum {
	PROP_0,
	PROP_DIALOG_PARENT,
	PROP_MAILBOX
};

/* pointer to the class of our parent */
static MNDialogClass *parent_class = NULL;

/* Short form macros */
#define self_get_mailbox mn_mailbox_properties_dialog_get_mailbox
#define self_set_mailbox mn_mailbox_properties_dialog_set_mailbox
#define self_setup_type_combo mn_mailbox_properties_dialog_setup_type_combo
#define self_response_h mn_mailbox_properties_dialog_response_h
#define self_add_type mn_mailbox_properties_dialog_add_type
#define self_set_active_properties mn_mailbox_properties_dialog_set_active_properties
#define self_get_active_properties mn_mailbox_properties_dialog_get_active_properties
#define self_get_properties_by_type mn_mailbox_properties_dialog_get_properties_by_type
#define self_get_properties_by_g_type mn_mailbox_properties_dialog_get_properties_by_g_type
#define self_get_current_mailbox mn_mailbox_properties_dialog_get_current_mailbox
#define self_apply mn_mailbox_properties_dialog_apply
#define self_cancel mn_mailbox_properties_dialog_cancel
#define self_update_complete mn_mailbox_properties_dialog_update_complete
#define self_update_name_sensitivity mn_mailbox_properties_dialog_update_name_sensitivity
#define self_update_delay_sensitivity mn_mailbox_properties_dialog_update_delay_sensitivity
#define self_update_delay_visibility mn_mailbox_properties_dialog_update_delay_visibility
#define self_update_default_name mn_mailbox_properties_dialog_update_default_name
#define self_update_default_check_delay mn_mailbox_properties_dialog_update_default_check_delay
#define self_set_help_section mn_mailbox_properties_dialog_set_help_section
#define self_new mn_mailbox_properties_dialog_new
#define self_type_changed_h mn_mailbox_properties_dialog_type_changed_h
#define self_name_toggled_h mn_mailbox_properties_dialog_name_toggled_h
#define self_delay_toggled_h mn_mailbox_properties_dialog_delay_toggled_h
#define self_delay_format_value_h mn_mailbox_properties_dialog_delay_format_value_h
#define self_entry_activate_h mn_mailbox_properties_dialog_entry_activate_h
GType
mn_mailbox_properties_dialog_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMailboxPropertiesDialogClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_mailbox_properties_dialog_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMailboxPropertiesDialog),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_mailbox_properties_dialog_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_DIALOG, "MNMailboxPropertiesDialog", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMailboxPropertiesDialog *)g_object_new(mn_mailbox_properties_dialog_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMailboxPropertiesDialog * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMailboxPropertiesDialog *
GET_NEW_VARG (const char *first, ...)
{
	MNMailboxPropertiesDialog *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMailboxPropertiesDialog *)g_object_new_valist (mn_mailbox_properties_dialog_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static GObject *
___constructor (GType type, guint n_construct_properties, GObjectConstructParam *construct_properties)
{
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::constructor"
	GObject *obj_self;
	MNMailboxPropertiesDialog *self;
	obj_self = G_OBJECT_CLASS (parent_class)->constructor (type, n_construct_properties, construct_properties);
	self = MN_MAILBOX_PROPERTIES_DIALOG (obj_self);
#line 144 "src/mn-mailbox-properties-dialog.gob"
	mn_mailbox_properties_dialog_constructor (self);
#line 228 "mn-mailbox-properties-dialog.c"
	return obj_self;
}
#undef __GOB_FUNCTION__


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::dispose"
	MNMailboxPropertiesDialog *self G_GNUC_UNUSED = MN_MAILBOX_PROPERTIES_DIALOG (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 83 "src/mn-mailbox-properties-dialog.gob"
	if(self->_priv->mailbox) { g_object_unref ((gpointer) self->_priv->mailbox); self->_priv->mailbox = NULL; }
#line 243 "mn-mailbox-properties-dialog.c"
#line 138 "src/mn-mailbox-properties-dialog.gob"
	if(self->_priv->store) { g_object_unref ((gpointer) self->_priv->store); self->_priv->store = NULL; }
#line 246 "mn-mailbox-properties-dialog.c"
#line 140 "src/mn-mailbox-properties-dialog.gob"
	if(self->_priv->active_properties) { g_object_unref ((gpointer) self->_priv->active_properties); self->_priv->active_properties = NULL; }
#line 249 "mn-mailbox-properties-dialog.c"
#line 142 "src/mn-mailbox-properties-dialog.gob"
	if(self->_priv->details_size_group) { g_object_unref ((gpointer) self->_priv->details_size_group); self->_priv->details_size_group = NULL; }
#line 252 "mn-mailbox-properties-dialog.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::finalize"
	MNMailboxPropertiesDialog *self G_GNUC_UNUSED = MN_MAILBOX_PROPERTIES_DIALOG (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 119 "src/mn-mailbox-properties-dialog.gob"
	if(self->_priv->orig_mailbox_configuration) { mn_mailbox_configuration_free ((gpointer) self->_priv->orig_mailbox_configuration); self->_priv->orig_mailbox_configuration = NULL; }
#line 267 "mn-mailbox-properties-dialog.c"
}
#undef __GOB_FUNCTION__

static void 
mn_mailbox_properties_dialog_init (MNMailboxPropertiesDialog * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,MN_TYPE_MAILBOX_PROPERTIES_DIALOG,MNMailboxPropertiesDialogPrivate);
#line 142 "src/mn-mailbox-properties-dialog.gob"
	o->_priv->details_size_group = gtk_size_group_new(GTK_SIZE_GROUP_HORIZONTAL);
#line 278 "mn-mailbox-properties-dialog.c"
}
#undef __GOB_FUNCTION__
static void 
mn_mailbox_properties_dialog_class_init (MNMailboxPropertiesDialogClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(MNMailboxPropertiesDialogPrivate));

	parent_class = g_type_class_ref (MN_TYPE_DIALOG);

	g_object_class->constructor = ___constructor;
	g_object_class->dispose = ___dispose;
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_pointer
		("dialog_parent" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_DIALOG_PARENT,
		param_spec);
	param_spec = g_param_spec_object
		("mailbox" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 MN_TYPE_MAILBOX /* object_type */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_MAILBOX,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::set_property"
{
	MNMailboxPropertiesDialog *self G_GNUC_UNUSED;

	self = MN_MAILBOX_PROPERTIES_DIALOG (object);

	switch (property_id) {
	case PROP_DIALOG_PARENT:
		{
#line 81 "src/mn-mailbox-properties-dialog.gob"
self->_priv->dialog_parent = g_value_get_pointer (VAL);
#line 336 "mn-mailbox-properties-dialog.c"
		}
		break;
	case PROP_MAILBOX:
		{
#line 89 "src/mn-mailbox-properties-dialog.gob"

      GObject *obj;

      if (selfp->mailbox)
	{
	  g_object_unref(selfp->mailbox);
	  selfp->mailbox = NULL;
	}

      obj = g_value_dup_object(VAL);
      if (obj)
	{
	  char *title;

	  selfp->mailbox = MN_MAILBOX(obj);

	  /* translators: header capitalization */
	  title = g_strdup_printf(_("%s Properties"), selfp->mailbox->runtime_name);
	  gtk_window_set_title(GTK_WINDOW(self), title);
	  g_free(title);
	}
    
#line 364 "mn-mailbox-properties-dialog.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::get_property"
{
	MNMailboxPropertiesDialog *self G_GNUC_UNUSED;

	self = MN_MAILBOX_PROPERTIES_DIALOG (object);

	switch (property_id) {
	case PROP_DIALOG_PARENT:
		{
#line 81 "src/mn-mailbox-properties-dialog.gob"
g_value_set_pointer (VAL, self->_priv->dialog_parent);
#line 395 "mn-mailbox-properties-dialog.c"
		}
		break;
	case PROP_MAILBOX:
		{
#line 112 "src/mn-mailbox-properties-dialog.gob"

      g_value_set_object(VAL, selfp->mailbox);
    
#line 404 "mn-mailbox-properties-dialog.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 112 "src/mn-mailbox-properties-dialog.gob"
MNMailbox * 
mn_mailbox_properties_dialog_get_mailbox (MNMailboxPropertiesDialog * self)
{
#line 425 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::get_mailbox"
{
#line 84 "src/mn-mailbox-properties-dialog.gob"
		MNMailbox* val; g_object_get (G_OBJECT (self), "mailbox", &val, NULL); return val;
}}
#line 431 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 89 "src/mn-mailbox-properties-dialog.gob"
void 
mn_mailbox_properties_dialog_set_mailbox (MNMailboxPropertiesDialog * self, MNMailbox * val)
{
#line 438 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::set_mailbox"
{
#line 84 "src/mn-mailbox-properties-dialog.gob"
		g_object_set (G_OBJECT (self), "mailbox", val, NULL);
}}
#line 444 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 144 "src/mn-mailbox-properties-dialog.gob"
static void 
mn_mailbox_properties_dialog_constructor (MNMailboxPropertiesDialog * self)
{
#line 451 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::constructor"
{
#line 145 "src/mn-mailbox-properties-dialog.gob"
	
    GtkWidget *page;
    MNMailboxProperties *properties;

    mn_container_create_interface(GTK_CONTAINER(self),
				  PKGDATADIR G_DIR_SEPARATOR_S "mailbox-properties-dialog.glade",
				  "notebook",
				  "mn_mailbox_properties_dialog_",
				  "notebook", &self->notebook,
				  "general_vbox", &self->general_vbox,
				  "type_label", &selfp->type_label,
				  "type_combo", &selfp->type_combo,
				  "name_default_radio", &selfp->name_default_radio,
				  "name_default_label", &selfp->name_default_label,
				  "name_other_radio", &selfp->name_other_radio,
				  "name_entry", &selfp->name_entry,
				  "delay_vbox", &selfp->delay_vbox,
				  "delay_default_radio", &selfp->delay_default_radio,
				  "delay_default_label", &selfp->delay_default_label,
				  "delay_other_radio", &selfp->delay_other_radio,
				  "delay_scale", &selfp->delay_scale,
				  NULL);

    gtk_window_set_resizable(GTK_WINDOW(self), FALSE);

    if (selfp->dialog_parent)
      gtk_window_set_transient_for(GTK_WINDOW(self), selfp->dialog_parent);

    page = gtk_notebook_get_nth_page(GTK_NOTEBOOK(self->notebook), 0);
    self_set_help_section(page, "mailbox-properties-general");

    page = gtk_notebook_get_nth_page(GTK_NOTEBOOK(self->notebook), 1);
    self_set_help_section(page, "mailbox-properties-details");

    self_setup_type_combo(self);

    mn_non_linear_range_setup_static(GTK_RANGE(selfp->delay_scale), delay_blocks, G_N_ELEMENTS(delay_blocks));

    /* set a good general default value */
    mn_non_linear_range_set_value(GTK_RANGE(selfp->delay_scale), MN_MINS(5));

    gtk_size_group_add_widget(selfp->details_size_group, selfp->name_default_radio);
    gtk_size_group_add_widget(selfp->details_size_group, selfp->name_other_radio);

    /* setup the dialog depending on the mode (edit or add) */
    gtk_dialog_add_button(GTK_DIALOG(self), GTK_STOCK_HELP, GTK_RESPONSE_HELP);
    if (selfp->mailbox)
      {
	selfp->apply_button = gtk_dialog_add_button(GTK_DIALOG(self), GTK_STOCK_APPLY, GTK_RESPONSE_APPLY);
	gtk_dialog_add_button(GTK_DIALOG(self), GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL);
	selfp->accept_button = gtk_dialog_add_button(GTK_DIALOG(self), GTK_STOCK_OK, GTK_RESPONSE_OK);

	properties = self_get_properties_by_type(self, MN_MAILBOX_GET_CLASS(selfp->mailbox)->type);
      }
    else
      {
	gtk_dialog_add_button(GTK_DIALOG(self), GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL);
	selfp->accept_button = gtk_dialog_add_button(GTK_DIALOG(self), GTK_STOCK_ADD, GTK_RESPONSE_ACCEPT);

	if (! selected_type)
	  selected_type = MN_TYPE_AUTODETECT_MAILBOX_PROPERTIES;

	properties = self_get_properties_by_g_type(self, selected_type);

	/* translators: header capitalization */
	gtk_window_set_title(GTK_WINDOW(self), _("Add a Mailbox"));
      }

    self_set_active_properties(self, properties);

    if (selfp->mailbox)
      {
	selfp->orig_mailbox_configuration = mn_mailbox_get_configuration(selfp->mailbox);

	mn_mailbox_properties_set_mailbox(properties, selfp->mailbox);

	if (selfp->mailbox->name)
	  {
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(selfp->name_other_radio), TRUE);
	    gtk_entry_set_text(GTK_ENTRY(selfp->name_entry), selfp->mailbox->name);
	  }

	if (selfp->mailbox->check_delay != -1)
	  {
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(selfp->delay_other_radio), TRUE);
	    mn_non_linear_range_set_value(GTK_RANGE(selfp->delay_scale), selfp->mailbox->check_delay);
	  }
      }

    g_object_unref(properties);

    gtk_widget_grab_default(selfp->accept_button);

    /*
     * HIG chapter 3:
     * "When opening a dialog, provide initial keyboard focus to the
     * component that you expect users to operate first. This focus is
     * especially important for users who must use a keyboard to
     * navigate your application."
     */
    gtk_widget_grab_focus(selfp->type_combo);

    self_update_name_sensitivity(self);
    self_update_delay_sensitivity(self);

    g_signal_connect(self, "response", G_CALLBACK(self_response_h), NULL);
  }}
#line 562 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 253 "src/mn-mailbox-properties-dialog.gob"
static void 
mn_mailbox_properties_dialog_setup_type_combo (MNMailboxPropertiesDialog * self)
{
#line 569 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::setup_type_combo"
#line 253 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (self != NULL);
#line 253 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self));
#line 575 "mn-mailbox-properties-dialog.c"
{
#line 255 "src/mn-mailbox-properties-dialog.gob"
	
    GtkCellRenderer *renderer;

    selfp->store = gtk_list_store_new(N_COLUMNS,
				      MN_TYPE_MAILBOX_PROPERTIES,
				      G_TYPE_STRING,
				      G_TYPE_STRING);

    self_add_type(self, MN_TYPE_AUTODETECT_MAILBOX_PROPERTIES);
#if WITH_MBOX || WITH_MOZILLA || WITH_MH || WITH_MAILDIR || WITH_SYLPHEED
    self_add_type(self, MN_TYPE_SYSTEM_VFS_MAILBOX_PROPERTIES);
#endif
#if WITH_POP3
    self_add_type(self, MN_TYPE_POP3_MAILBOX_PROPERTIES);
#endif
#if WITH_IMAP
    self_add_type(self, MN_TYPE_IMAP_MAILBOX_PROPERTIES);
#endif
#if WITH_GMAIL
    self_add_type(self, MN_TYPE_GMAIL_MAILBOX_PROPERTIES);
#endif
#if WITH_YAHOO
    self_add_type(self, MN_TYPE_YAHOO_MAILBOX_PROPERTIES);
#endif
#if WITH_HOTMAIL
    self_add_type(self, MN_TYPE_HOTMAIL_MAILBOX_PROPERTIES);
#endif
#if WITH_EVOLUTION
    self_add_type(self, MN_TYPE_EVOLUTION_MAILBOX_PROPERTIES);
#endif

    gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(selfp->store), COLUMN_LABEL, GTK_SORT_ASCENDING);

    renderer = gtk_cell_renderer_pixbuf_new();
    g_object_set(renderer, "stock-size", GTK_ICON_SIZE_MENU, NULL);
    gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(selfp->type_combo), renderer, FALSE);
    gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(selfp->type_combo), renderer,
				   "stock-id", COLUMN_STOCK_ID,
				   NULL);

    renderer = gtk_cell_renderer_text_new();
    g_object_set(renderer, "xpad", 6, NULL);
    gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(selfp->type_combo), renderer, TRUE);
    gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(selfp->type_combo), renderer,
				   "text", COLUMN_LABEL,
				   NULL);

    gtk_combo_box_set_model(GTK_COMBO_BOX(selfp->type_combo), GTK_TREE_MODEL(selfp->store));
  }}
#line 627 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 305 "src/mn-mailbox-properties-dialog.gob"
static void 
mn_mailbox_properties_dialog_response_h (GtkDialog * dialog, int response, gpointer user_data)
{
#line 634 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::response_h"
{
#line 307 "src/mn-mailbox-properties-dialog.gob"
	
    Self *self = SELF(dialog);

    if (response == GTK_RESPONSE_HELP)
      {
	int page_number;
	GtkWidget *page;
	const char *section;

	page_number = gtk_notebook_get_current_page(GTK_NOTEBOOK(self->notebook));

	page = gtk_notebook_get_nth_page(GTK_NOTEBOOK(self->notebook), page_number);
	g_assert(page != NULL);

	section = g_object_get_data(G_OBJECT(page), HELP_SECTION);
	g_assert(section != NULL);

	mn_show_help(GTK_WINDOW(self), section);
      }

    /* other responses are handled by the client */
  }}
#line 660 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 330 "src/mn-mailbox-properties-dialog.gob"
static void 
mn_mailbox_properties_dialog_add_type (MNMailboxPropertiesDialog * self, GType type)
{
#line 667 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::add_type"
#line 330 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (self != NULL);
#line 330 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self));
#line 330 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (type != 0);
#line 675 "mn-mailbox-properties-dialog.c"
{
#line 332 "src/mn-mailbox-properties-dialog.gob"
	
    MNMailboxProperties *properties;
    MNMailboxPropertiesClass *p_class;
    GtkTreeIter iter;
    GSList *l;

    properties = g_object_new(type, MN_MAILBOX_PROPERTIES_PROP_DIALOG(GTK_WIDGET(self)), NULL);

    p_class = MN_MAILBOX_PROPERTIES_GET_CLASS(properties);

    gtk_list_store_append(selfp->store, &iter);
    gtk_list_store_set(selfp->store, &iter,
		       COLUMN_PROPERTIES, properties,
		       COLUMN_STOCK_ID, p_class->stock_id,
		       COLUMN_LABEL, p_class->combo_label,
		       -1);

    g_object_connect(properties,
		     "swapped-signal::notify::complete", self_update_complete, self,
		     "swapped-signal::notify::default-name", self_update_default_name, self,
		     "swapped-signal::notify::default-check-delay", self_update_default_check_delay, self,
		     NULL);

    MN_LIST_FOREACH(l, properties->entries)
      g_signal_connect_swapped(l->data, "activate", G_CALLBACK(self_entry_activate_h), self);

    g_object_unref(properties);	/* now it belongs to the store */
  }}
#line 706 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 361 "src/mn-mailbox-properties-dialog.gob"
static void 
mn_mailbox_properties_dialog_set_active_properties (MNMailboxPropertiesDialog * self, MNMailboxProperties * properties)
{
#line 713 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::set_active_properties"
#line 361 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (self != NULL);
#line 361 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self));
#line 361 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (properties != NULL);
#line 361 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES (properties));
#line 723 "mn-mailbox-properties-dialog.c"
{
#line 364 "src/mn-mailbox-properties-dialog.gob"
	
    gboolean valid;
    GtkTreeIter iter;

    MN_TREE_MODEL_FOREACH(valid, &iter, GTK_TREE_MODEL(selfp->store))
      {
	MNMailboxProperties *these_properties;

	gtk_tree_model_get(GTK_TREE_MODEL(selfp->store), &iter, COLUMN_PROPERTIES, &these_properties, -1);
	g_object_unref(these_properties);

	if (these_properties == properties)
	  {
	    gtk_combo_box_set_active_iter(GTK_COMBO_BOX(selfp->type_combo), &iter);
	    break;
	  }
      }
  }}
#line 744 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 383 "src/mn-mailbox-properties-dialog.gob"
static MNMailboxProperties * 
mn_mailbox_properties_dialog_get_active_properties (MNMailboxPropertiesDialog * self)
{
#line 751 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::get_active_properties"
#line 383 "src/mn-mailbox-properties-dialog.gob"
	g_return_val_if_fail (self != NULL, (MNMailboxProperties * )0);
#line 383 "src/mn-mailbox-properties-dialog.gob"
	g_return_val_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self), (MNMailboxProperties * )0);
#line 757 "mn-mailbox-properties-dialog.c"
{
#line 385 "src/mn-mailbox-properties-dialog.gob"
	
    GtkTreeIter iter;
    MNMailboxProperties *properties = NULL;

    if (gtk_combo_box_get_active_iter(GTK_COMBO_BOX(selfp->type_combo), &iter))
      gtk_tree_model_get(GTK_TREE_MODEL(selfp->store), &iter, COLUMN_PROPERTIES, &properties, -1);

    return properties;
  }}
#line 769 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 395 "src/mn-mailbox-properties-dialog.gob"
static MNMailboxProperties * 
mn_mailbox_properties_dialog_get_properties_by_type (MNMailboxPropertiesDialog * self, const char * type)
{
#line 776 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::get_properties_by_type"
#line 395 "src/mn-mailbox-properties-dialog.gob"
	g_return_val_if_fail (self != NULL, (MNMailboxProperties * )0);
#line 395 "src/mn-mailbox-properties-dialog.gob"
	g_return_val_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self), (MNMailboxProperties * )0);
#line 395 "src/mn-mailbox-properties-dialog.gob"
	g_return_val_if_fail (type != NULL, (MNMailboxProperties * )0);
#line 784 "mn-mailbox-properties-dialog.c"
{
#line 397 "src/mn-mailbox-properties-dialog.gob"
	
    gboolean valid;
    GtkTreeIter iter;

    MN_TREE_MODEL_FOREACH(valid, &iter, GTK_TREE_MODEL(selfp->store))
      {
	MNMailboxProperties *properties;
	MNMailboxPropertiesClass *class;

	gtk_tree_model_get(GTK_TREE_MODEL(selfp->store), &iter, COLUMN_PROPERTIES, &properties, -1);

	class = MN_MAILBOX_PROPERTIES_GET_CLASS(properties);

	if (class->type && ! strcmp(class->type, type))
	  return properties;

	g_object_unref(properties);
      }

    return NULL;
  }}
#line 808 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 419 "src/mn-mailbox-properties-dialog.gob"
static MNMailboxProperties * 
mn_mailbox_properties_dialog_get_properties_by_g_type (MNMailboxPropertiesDialog * self, GType type)
{
#line 815 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::get_properties_by_g_type"
#line 419 "src/mn-mailbox-properties-dialog.gob"
	g_return_val_if_fail (self != NULL, (MNMailboxProperties * )0);
#line 419 "src/mn-mailbox-properties-dialog.gob"
	g_return_val_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self), (MNMailboxProperties * )0);
#line 419 "src/mn-mailbox-properties-dialog.gob"
	g_return_val_if_fail (type != 0, (MNMailboxProperties * )0);
#line 823 "mn-mailbox-properties-dialog.c"
{
#line 421 "src/mn-mailbox-properties-dialog.gob"
	
    gboolean valid;
    GtkTreeIter iter;

    MN_TREE_MODEL_FOREACH(valid, &iter, GTK_TREE_MODEL(selfp->store))
      {
	MNMailboxProperties *properties;

	gtk_tree_model_get(GTK_TREE_MODEL(selfp->store), &iter, COLUMN_PROPERTIES, &properties, -1);

	if (G_TYPE_CHECK_INSTANCE_TYPE(properties, type))
	  return properties;

	g_object_unref(properties);
      }

    return NULL;
  }}
#line 844 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 440 "src/mn-mailbox-properties-dialog.gob"
MNMailbox * 
mn_mailbox_properties_dialog_get_current_mailbox (MNMailboxPropertiesDialog * self)
{
#line 851 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::get_current_mailbox"
#line 440 "src/mn-mailbox-properties-dialog.gob"
	g_return_val_if_fail (self != NULL, (MNMailbox * )0);
#line 440 "src/mn-mailbox-properties-dialog.gob"
	g_return_val_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self), (MNMailbox * )0);
#line 857 "mn-mailbox-properties-dialog.c"
{
#line 442 "src/mn-mailbox-properties-dialog.gob"
	
    MNMailboxProperties *properties;
    MNMailbox *mailbox;

    properties = self_get_active_properties(self);
    mailbox = mn_mailbox_properties_get_mailbox(properties);
    g_object_unref(properties);

    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(selfp->name_other_radio)))
      g_object_set(G_OBJECT(mailbox), MN_MAILBOX_PROP_NAME((char *) gtk_entry_get_text(GTK_ENTRY(selfp->name_entry))), NULL);

    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(selfp->delay_other_radio)))
      g_object_set(G_OBJECT(mailbox), MN_MAILBOX_PROP_CHECK_DELAY(mn_non_linear_range_get_value(GTK_RANGE(selfp->delay_scale))), NULL);

    return mailbox;
  }}
#line 876 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 459 "src/mn-mailbox-properties-dialog.gob"
void 
mn_mailbox_properties_dialog_apply (MNMailboxPropertiesDialog * self)
{
#line 883 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::apply"
#line 459 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (self != NULL);
#line 459 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self));
#line 889 "mn-mailbox-properties-dialog.c"
{
#line 461 "src/mn-mailbox-properties-dialog.gob"
	
    MNMailbox *new_mailbox;

    selfp->apply_used = TRUE;

    new_mailbox = self_get_current_mailbox(self);
    g_assert(MN_IS_MAILBOX(new_mailbox));

    mn_mailbox_seal(new_mailbox);

    mn_mailboxes_queue_remove(mn_shell->mailboxes, selfp->mailbox);
    mn_mailboxes_queue_add(mn_shell->mailboxes, new_mailbox);

    self_set_mailbox(self, new_mailbox);
    g_object_unref(new_mailbox);
  }}
#line 908 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 478 "src/mn-mailbox-properties-dialog.gob"
void 
mn_mailbox_properties_dialog_cancel (MNMailboxPropertiesDialog * self)
{
#line 915 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::cancel"
#line 478 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (self != NULL);
#line 478 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self));
#line 921 "mn-mailbox-properties-dialog.c"
{
#line 480 "src/mn-mailbox-properties-dialog.gob"
	
    MNMailbox *orig_mailbox;

    if (! selfp->apply_used)
      return;

    orig_mailbox = mn_mailbox_new_from_configuration(selfp->orig_mailbox_configuration);

    mn_mailbox_seal(orig_mailbox);

    mn_mailboxes_queue_remove(mn_shell->mailboxes, selfp->mailbox);
    mn_mailboxes_queue_add(mn_shell->mailboxes, orig_mailbox);

    g_object_unref(orig_mailbox);
  }}
#line 939 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 496 "src/mn-mailbox-properties-dialog.gob"
static void 
mn_mailbox_properties_dialog_update_complete (MNMailboxPropertiesDialog * self)
{
#line 946 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::update_complete"
#line 496 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (self != NULL);
#line 496 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self));
#line 952 "mn-mailbox-properties-dialog.c"
{
#line 498 "src/mn-mailbox-properties-dialog.gob"
	
    MNMailboxProperties *properties;

    properties = self_get_active_properties(self);
    if (properties)
      {
	gboolean complete;

	g_object_get(G_OBJECT(properties), MN_MAILBOX_PROPERTIES_GET_PROP_COMPLETE(&complete), NULL);
	g_object_unref(properties);

	if (selfp->apply_button)
	  gtk_widget_set_sensitive(selfp->apply_button, complete);
	gtk_widget_set_sensitive(selfp->accept_button, complete);
      }
  }}
#line 971 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 515 "src/mn-mailbox-properties-dialog.gob"
static void 
mn_mailbox_properties_dialog_update_name_sensitivity (MNMailboxPropertiesDialog * self)
{
#line 978 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::update_name_sensitivity"
#line 515 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (self != NULL);
#line 515 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self));
#line 984 "mn-mailbox-properties-dialog.c"
{
#line 517 "src/mn-mailbox-properties-dialog.gob"
	
    gtk_widget_set_sensitive(selfp->name_entry, gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(selfp->name_other_radio)));
  }}
#line 990 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 521 "src/mn-mailbox-properties-dialog.gob"
static void 
mn_mailbox_properties_dialog_update_delay_sensitivity (MNMailboxPropertiesDialog * self)
{
#line 997 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::update_delay_sensitivity"
#line 521 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (self != NULL);
#line 521 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self));
#line 1003 "mn-mailbox-properties-dialog.c"
{
#line 523 "src/mn-mailbox-properties-dialog.gob"
	
    gtk_widget_set_sensitive(selfp->delay_scale, gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(selfp->delay_other_radio)));
  }}
#line 1009 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 527 "src/mn-mailbox-properties-dialog.gob"
static void 
mn_mailbox_properties_dialog_update_delay_visibility (MNMailboxPropertiesDialog * self)
{
#line 1016 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::update_delay_visibility"
#line 527 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (self != NULL);
#line 527 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self));
#line 1022 "mn-mailbox-properties-dialog.c"
{
#line 529 "src/mn-mailbox-properties-dialog.gob"
	
    MNMailboxProperties *properties;
    gboolean visible = TRUE;

    properties = self_get_active_properties(self);
    if (properties)
      {
	visible = MN_MAILBOX_PROPERTIES_GET_CLASS(properties)->enable_check_delay;
	g_object_unref(properties);
      }

    if (visible)
      {
	if (! g_slist_find(gtk_size_group_get_widgets(selfp->details_size_group), selfp->delay_default_radio))
	  gtk_size_group_add_widget(selfp->details_size_group, selfp->delay_default_radio);
	if (! g_slist_find(gtk_size_group_get_widgets(selfp->details_size_group), selfp->delay_other_radio))
	  gtk_size_group_add_widget(selfp->details_size_group, selfp->delay_other_radio);

	gtk_widget_show(selfp->delay_vbox);
      }
    else
      {
	if (g_slist_find(gtk_size_group_get_widgets(selfp->details_size_group), selfp->delay_default_radio))
	  gtk_size_group_remove_widget(selfp->details_size_group, selfp->delay_default_radio);
	if (g_slist_find(gtk_size_group_get_widgets(selfp->details_size_group), selfp->delay_other_radio))
	  gtk_size_group_remove_widget(selfp->details_size_group, selfp->delay_other_radio);

	gtk_widget_hide(selfp->delay_vbox);
      }
  }}
#line 1055 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 560 "src/mn-mailbox-properties-dialog.gob"
static void 
mn_mailbox_properties_dialog_update_default_name (MNMailboxPropertiesDialog * self)
{
#line 1062 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::update_default_name"
#line 560 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (self != NULL);
#line 560 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self));
#line 1068 "mn-mailbox-properties-dialog.c"
{
#line 562 "src/mn-mailbox-properties-dialog.gob"
	
    MNMailboxProperties *properties;
    char *name = NULL;
    const char *radio_label;

    properties = self_get_active_properties(self);
    if (properties)
      {
	gboolean complete;

	g_object_get(G_OBJECT(properties),
		     MN_MAILBOX_PROPERTIES_GET_PROP_COMPLETE(&complete),
		     NULL);

	if (complete)
	  g_object_get(G_OBJECT(properties),
		       MN_MAILBOX_PROPERTIES_GET_PROP_DEFAULT_NAME(&name),
		       NULL);

	g_object_unref(properties);
      }

    if (name)
      radio_label = _("_Default:");
    else
      radio_label = _("_Default");

    gtk_button_set_label(GTK_BUTTON(selfp->name_default_radio), radio_label);
    gtk_label_set_text(GTK_LABEL(selfp->name_default_label), name);

    g_free(name);
  }}
#line 1103 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 595 "src/mn-mailbox-properties-dialog.gob"
static void 
mn_mailbox_properties_dialog_update_default_check_delay (MNMailboxPropertiesDialog * self)
{
#line 1110 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::update_default_check_delay"
#line 595 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (self != NULL);
#line 595 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self));
#line 1116 "mn-mailbox-properties-dialog.c"
{
#line 597 "src/mn-mailbox-properties-dialog.gob"
	
    MNMailboxProperties *properties;
    int delay = -1;
    const char *radio_label;
    char *delay_str = NULL;

    properties = self_get_active_properties(self);
    if (properties)
      {
	g_object_get(G_OBJECT(properties),
		     MN_MAILBOX_PROPERTIES_GET_PROP_DEFAULT_CHECK_DELAY(&delay),
		     NULL);
	g_object_unref(properties);
      }

    if (delay != -1)
      {
	radio_label = _("D_efault:");
	delay_str = mn_format_seconds(delay);
      }
    else
      radio_label = _("D_efault");

    gtk_button_set_label(GTK_BUTTON(selfp->delay_default_radio), radio_label);
    gtk_label_set_text(GTK_LABEL(selfp->delay_default_label), delay_str);

    g_free(delay_str);
  }}
#line 1147 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 626 "src/mn-mailbox-properties-dialog.gob"
void 
mn_mailbox_properties_dialog_set_help_section (GtkWidget * page, const char * section)
{
#line 1154 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::set_help_section"
#line 626 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (page != NULL);
#line 626 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (GTK_IS_WIDGET (page));
#line 626 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (section != NULL);
#line 1162 "mn-mailbox-properties-dialog.c"
{
#line 629 "src/mn-mailbox-properties-dialog.gob"
	
    g_object_set_data_full(G_OBJECT(page), HELP_SECTION, g_strdup(section), g_free);
  }}
#line 1168 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 633 "src/mn-mailbox-properties-dialog.gob"
GtkWidget * 
mn_mailbox_properties_dialog_new (GtkWindow * parent, MNMailbox * mailbox)
{
#line 1175 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::new"
{
#line 635 "src/mn-mailbox-properties-dialog.gob"
	
    return GTK_WIDGET(GET_NEW_VARG(MN_MAILBOX_PROPERTIES_DIALOG_PROP_DIALOG_PARENT(parent),
				   MN_MAILBOX_PROPERTIES_DIALOG_PROP_MAILBOX(mailbox),
				   NULL));
  }}
#line 1184 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 643 "src/mn-mailbox-properties-dialog.gob"
void 
mn_mailbox_properties_dialog_type_changed_h (MNMailboxPropertiesDialog * self, GtkComboBox * combobox)
{
#line 1191 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::type_changed_h"
#line 643 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (self != NULL);
#line 643 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self));
#line 1197 "mn-mailbox-properties-dialog.c"
{
#line 645 "src/mn-mailbox-properties-dialog.gob"
	
    if (selfp->active_properties)
      {
	mn_mailbox_properties_deactivate(selfp->active_properties);
	gtk_size_group_remove_widget(selfp->active_properties->label_size_group, selfp->type_label);
	g_object_unref(selfp->active_properties);
      }

    selfp->active_properties = self_get_active_properties(self);
    mn_mailbox_properties_activate(selfp->active_properties);
    gtk_size_group_add_widget(selfp->active_properties->label_size_group, selfp->type_label);

    if (! selfp->mailbox)	/* mode is add */
      selected_type = G_OBJECT_TYPE(selfp->active_properties);

    self_update_complete(self);
    self_update_delay_visibility(self);
    self_update_default_name(self);
    self_update_default_check_delay(self);
  }}
#line 1220 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 666 "src/mn-mailbox-properties-dialog.gob"
void 
mn_mailbox_properties_dialog_name_toggled_h (MNMailboxPropertiesDialog * self, GtkToggleButton * button)
{
#line 1227 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::name_toggled_h"
#line 666 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (self != NULL);
#line 666 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self));
#line 1233 "mn-mailbox-properties-dialog.c"
{
#line 668 "src/mn-mailbox-properties-dialog.gob"
	
    self_update_name_sensitivity(self);
  }}
#line 1239 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 672 "src/mn-mailbox-properties-dialog.gob"
void 
mn_mailbox_properties_dialog_delay_toggled_h (MNMailboxPropertiesDialog * self, GtkToggleButton * button)
{
#line 1246 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::delay_toggled_h"
#line 672 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (self != NULL);
#line 672 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self));
#line 1252 "mn-mailbox-properties-dialog.c"
{
#line 674 "src/mn-mailbox-properties-dialog.gob"
	
    self_update_delay_sensitivity(self);
  }}
#line 1258 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 678 "src/mn-mailbox-properties-dialog.gob"
char * 
mn_mailbox_properties_dialog_delay_format_value_h (MNMailboxPropertiesDialog * self, double arg, GtkScale * scale)
{
#line 1265 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::delay_format_value_h"
#line 678 "src/mn-mailbox-properties-dialog.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 678 "src/mn-mailbox-properties-dialog.gob"
	g_return_val_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self), (char * )0);
#line 1271 "mn-mailbox-properties-dialog.c"
{
#line 680 "src/mn-mailbox-properties-dialog.gob"
	
    return mn_format_seconds(mn_non_linear_range_get_value(GTK_RANGE(scale)));
  }}
#line 1277 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__

#line 684 "src/mn-mailbox-properties-dialog.gob"
void 
mn_mailbox_properties_dialog_entry_activate_h (MNMailboxPropertiesDialog * self, GtkEntry * entry)
{
#line 1284 "mn-mailbox-properties-dialog.c"
#define __GOB_FUNCTION__ "MN:Mailbox:Properties:Dialog::entry_activate_h"
#line 684 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (self != NULL);
#line 684 "src/mn-mailbox-properties-dialog.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (self));
#line 1290 "mn-mailbox-properties-dialog.c"
{
#line 686 "src/mn-mailbox-properties-dialog.gob"
	
    if (GTK_WIDGET_IS_SENSITIVE(GTK_WINDOW(self)->default_widget))
      gtk_window_activate_default(GTK_WINDOW(self));
    else
      {
	MNMailboxProperties *properties;
	GtkWidget *next = NULL;
	GSList *elem;

	properties = self_get_active_properties(self);
	g_assert(properties != NULL);

	elem = g_slist_find(properties->entries, entry);
	g_assert(elem != NULL);

	do
	  {
	    elem = elem->next;
	    if (! elem)
	      elem = properties->entries;

	    if (elem->data == entry)
	      break;

	    if (GTK_WIDGET_MAPPED(elem->data)
		&& GTK_WIDGET_VISIBLE(elem->data)
		&& GTK_WIDGET_SENSITIVE(elem->data))
	      next = elem->data;
	  }
	while (! next);

	if (next)
	  gtk_widget_grab_focus(next);

	g_object_unref(properties);
      }
  }}
#line 1330 "mn-mailbox-properties-dialog.c"
#undef __GOB_FUNCTION__
