/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File RequestPanelItem.h
// Sylvie Thepaut - ECMWF Sep 99

#ifndef RequestPanelItem_H
#define RequestPanelItem_H


class Request;
class RequestPanel;
class Parameter;

#include <Xm/Xm.h>
#include "IconObject.h"

class RequestPanelItem {
public:

// -- Contructors

	RequestPanelItem(RequestPanel&,const Parameter&);

// -- Destructor

	virtual ~RequestPanelItem();


// -- Methods
	 
	virtual void getSizes(Dimension&,Dimension&);
	virtual void setSizes(Dimension,Dimension);

	// Overide those for a fine control
	virtual void reset();
	virtual void update();
	virtual void apply();
	virtual void set(Request&);

	virtual void grey();

	// Or those for simple Items
	virtual long flags();
	virtual void refresh(const vector<string>&);

	//--------------------------

	virtual void mark(bool);
	virtual void gray(bool);

	//--------------------------

	virtual void edit(IconObject*);

protected:

// -- Members

	RequestPanel&    owner_;
	const Parameter& param_;
	IconObjectH      currentObject_;

// -- Methods
	
	void decache();

private:

// No copy allowed

	RequestPanelItem(const RequestPanelItem&);
	RequestPanelItem& operator=(const RequestPanelItem&);

// -- Members

	vector<string> cache_;

};


#endif
