/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File ColourEditor.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef ColourEditor_H
#define ColourEditor_H

#ifndef InternalEditor_H
#include "InternalEditor.h"
#endif

#include "UIColourEditor.h"

#ifndef Rainbow_H
#include "Rainbow.h"
#endif

#ifndef XPalette_H
#include "XPalette.h"
#endif

#include <Palette.h>

class ColorName;


class ColourEditor : public XEditor<UIColourEditor_c>, public PaletteScanner {
public:

// -- Exceptions
	// None

// -- Contructors

	ColourEditor(const IconClass&,const string&);

// -- Destructor

	virtual ~ColourEditor(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	void magics(const string&);
	Widget where();

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members


// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	ColourEditor(const ColourEditor&);
	ColourEditor& operator=(const ColourEditor&);

// -- Members
	
	RGBColor rgb_;
	HSLColor hsl_;
	string   name_;

	Rainbow rainbow_r_;
	Rainbow rainbow_g_;
	Rainbow rainbow_b_;
	Rainbow rainbow_h_;
	Rainbow rainbow_s_;
	Rainbow rainbow_l_;

	map<string,ColorName*> magics_;

// -- Methods

	void refresh();

// -- Overridden methods

	virtual void apply();
	virtual void reset();
	virtual void close();
	virtual void merge(IconObject*);
	virtual void replace(IconObject*);

	virtual void rgbCB(Widget,XtPointer);
	virtual void hslCB(Widget,XtPointer);

	virtual void tabCB(Widget,XtPointer);

	virtual void exposeCB(Widget,XtPointer);

	// From PaletteScanner
	void next(const string&);

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const ColourEditor& p)
	//	{ p.print(s); return s; }

};

inline void destroy(ColourEditor**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(ColourEditor);
//#endif

#endif
