/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File FolderWindow.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef FolderWindow_H
#define FolderWindow_H


#include "UIFolderWindow.h"
#ifndef Timeout_H
#include "Timeout.h"
#endif

#ifndef Path_H
#include "Path.h"
#endif

#ifndef Folder_H
#include "Folder.h"
#endif

#ifndef FolderViewer_H
#include "FolderViewer.h"
#endif

#ifndef StationaryDrawers_H
#include "StationaryDrawers.h"
#endif

#ifndef Recents_H
#include "Recents.h"
#endif

#ifndef IconObserver_H
#include "IconObserver.h"
#endif


class IconObject;

class FolderWindow : public UIFolderWindow_c, public Timeout, 
	public FolderViewer, public IconObserver {
public:

// -- Exceptions
	// None


// -- Destructor

	virtual ~FolderWindow(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods



	// ---

	void raise();
	void close();

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods

	static void start();
	static void open(Folder*);
	static void close(Folder*);
	static void stop();

protected:

// -- Contructors

	FolderWindow(Folder*);

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	FolderWindow(const FolderWindow&);
	FolderWindow& operator=(const FolderWindow&);

// -- Members

	StationaryDrawers drawers_;
	Recents recents_;

// -- Methods

	void scan();
	void loadResources();
	void saveResources();
	Path prefFile();

	void color(IconObject*, const char*);

// -- Overridden methods


	// From XDesigner

	void closeCB(Widget,XtPointer);
	void exitCB(Widget,XtPointer);
	void commandCB(Widget,XtPointer);
	void fileMapCB(Widget,XtPointer);
	void sortByNameCB(Widget,XtPointer);
	void sortByClassCB(Widget,XtPointer);

	void showLastCB(Widget,XtPointer);
	void recentCB(Widget,XtPointer);
	void newIconCB(Widget,XtPointer);
	void newLinkCB(Widget,XtPointer);
	void prefCB(Widget,XtPointer);

	void rescanCB(Widget,XtPointer);
	void toggleSizeCB(Widget,XtPointer);

	void messagesCB(Widget,XtPointer);
	void helpMenuCB(Widget,XtPointer);

	// From timeout
	virtual void run();

	// From DragWindow

	virtual Widget menu();

	virtual void move(IconObject*,int,int,IconObject*);
	virtual void copy(IconObject*,int,int,IconObject*);

	virtual bool dropCopy() { return false; }
	virtual void doubleClick(IconObject*);

	// From FolderViewer

	virtual void where(IconObject*,int&,int&);
	virtual bool clone();

	// From IconObserver

	virtual void changed(IconObject*);
	virtual void destroyed(IconObject*);

	// From DropSite

	virtual void drop(Dropping&);

// -- Class members
// -- Class methods
	
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const FolderWindow& p)
	//	{ p.print(s); return s; }

};

inline void destroy(FolderWindow**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(FolderWindow);
//#endif

#endif
