#!/usr/bin/env python3

# Test whether a client sends a pingreq after the keepalive time
# Client sets a keepalive of 60 seconds, but receives a server keepalive to set
# it back to 4 seconds.

from mosq_test_helper import *

port = mosq_test.get_lib_port()

rc = 1
keepalive = 60
server_keepalive = 4
connect_packet = mosq_test.gen_connect("01-server-keepalive-pingreq", keepalive=keepalive, proto_ver=5)

props = mqtt5_props.gen_uint16_prop(mqtt5_props.PROP_SERVER_KEEP_ALIVE, server_keepalive)
connack_packet = mosq_test.gen_connack(rc=0, proto_ver=5, properties=props)

pingreq_packet = mosq_test.gen_pingreq()
pingresp_packet = mosq_test.gen_pingresp()

sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
sock.settimeout(10)
sock.bind(('', port))
sock.listen(5)

client_args = sys.argv[1:]
env = dict(os.environ)
env['LD_LIBRARY_PATH'] = '../../lib:../../lib/cpp'
try:
    pp = env['PYTHONPATH']
except KeyError:
    pp = ''
env['PYTHONPATH'] = '../../lib/python:'+pp
client = mosq_test.start_client(filename=sys.argv[1].replace('/', '-'), cmd=client_args, env=env, port=port)

try:
    (conn, address) = sock.accept()
    conn.settimeout(server_keepalive+10)

    if mosq_test.expect_packet(conn, "connect", connect_packet):
        conn.send(connack_packet)

        if mosq_test.expect_packet(conn, "pingreq", pingreq_packet):
            time.sleep(1.0)
            conn.send(pingresp_packet)

            if mosq_test.expect_packet(conn, "pingreq", pingreq_packet):
                rc = 0

    conn.close()
finally:
    client.terminate()
    client.wait()
    sock.close()

exit(rc)

