.\"                              hey, Emacs:   -*- nroff -*-
.\" multispeech is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program; see the file COPYING.  If not, write to
.\" the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.TH MULTISPEECH 1 "January 6, 2009"
.\" Please update the above date whenever this man page is modified.
.\"
.\" Some roff macros, for reference:
.\" .nh        disable hyphenation
.\" .hy        enable hyphenation
.\" .ad l      left justify
.\" .ad b      justify to both left and right margins (default)
.\" .nf        disable filling
.\" .fi        enable filling
.\" .br        insert line break
.\" .sp <n>    insert n+1 empty lines
.\" for manpage-specific macros, see man(7)
.SH NAME
multispeech \- Multilingual speech server
.SH SYNOPSIS
.B multispeech
.RI [ options ]
.SH DESCRIPTION
\fBMultispeech\fP was primarily designed as a multilingual speech server
for \fBemacspeak\fP, but it can be useful in some other circumstances
as well, when multilingual speech feedback is needed.
\fBMultispeech\fP produces audible speech, sounds and tone signals
according to the commands passed by it's client. It utilizes third
party speech synthesis software to perform actual TTS transformation.
.PP
All aspects of \fBmultispeech\fP behaviour are highly customizable via
configuration files \fI<sysconfdir>/multispeech.conf\fP and
\fI~/.multispeechrc\fP. See the \fBmultispeech.conf\fP(5) man page for
syntax information. The user settings provided by
\fI~/.multispeechrc\fP always take precedence over the system\-wide
ones from \fI<sysconfdir>/multispeech.conf\fP. And all these settings in turn
can be overridden by an extra configuration file specified via the
command line. Some configuration options are mandatory, so at least
one of these files must exist.
.PP
In case of errors or other important situations \fBmultispeech\fP
sends messages to \fBsyslog\fP using facility \fBuser\fP.
.SH OPTIONS
\fBMultispeech\fP accepts the following options:
.TP
.B \-c, \-\-config \fIfile\fP
.br
Read configuration from specified file.
.TP
.B \-v, \-\-verbose
.br
Print diagnostic messages on stderr. All diagnostic is logged via
syslog and nothing is output on stderr or stdout by default.
.TP
.B \-d, \-\-debug
.br
Allow some extra diagnostic info to be logged.
.TP
.B \-l, \-\-list\-devices
.br
Print list of all available audio output devices and exit.
.TP
.B \-h, \-\-help
.br
Show summary of options and exit.
.TP
.B \-V, \-\-version
.br
Show program version and exit.
.SH "FILES"
.TP
.B <sysconfdir>/multispeech.conf
provides system\-wide configuration.
.TP
.B ~/.multispeechrc
provides user configuration.
.SH "SEE ALSO"
.BR espeak(1),
.BR freephone(1),
.BR mbrola(1),
.BR multispeech.conf(5),
.BR ru_tts(1),
.BR syslog.conf(5).
.SH AUTHOR
Igor B. Poretsky <poretsky@mlbox.ru>.
