# -*- coding: utf-8 -*-
#
# installer - Functions for use in Mythbuntu ubiquity plugins
#
# Copyright (C) 2010, Mario Limonciello, for Mythbuntu
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

from ubiquity.plugin import *
from ubiquity.misc import create_bool
from gi.repository import Gtk

class MythPageGtk(PluginUI):
    def __init__(self, controller, *args, **kwargs):
        def add_widget(plugin, widget):
            """Make a widget callable by a plugin."""
            if not isinstance(widget, Gtk.Widget):
                return
            widget.set_name(Gtk.Buildable.get_name(widget))
            setattr(plugin, widget.get_name(), widget)
            if isinstance(widget, Gtk.Label):
                widget.set_property('can-focus', False)

        self.controller=controller
        try:
            builder = Gtk.Builder()
            builder.add_from_file('/usr/share/ubiquity/gtk/%s.ui' % self.ui_file)
            builder.connect_signals(self)
            for widget in builder.get_objects():
                add_widget(self, widget)
            self.plugin_widgets = builder.get_object(self.ui_file)
            self.controller.add_builder(builder)
        except Exception as e:
            self.debug('Could not create mythbuntu page: %s', e)
            self.plugin_widgets = None

def preseed_list(lists,names,value):
    """Helper function for preseeding dictionary based lists"""
    new_value = create_bool(value)
    for list in lists:
        for item in list:
            for name in names.split():
                if item == name:
                    #be careful what type of item we are dealing with
                    if type(list[item]) == Gtk.CheckButton:
                        list[item].set_active(new_value)
                    elif type(list[item]) == Gtk.Entry:
                        list[item].set_text(new_value)
                    elif type(list[item]) == Gtk.ComboBox:
                        model = list[item].get_model()
                        for iteration in range(len(list[item]),0):
                            list[item].set_active(iteration)
                            iterator = list[item].get_active_iter()
                            active = model.get_value(iterator, 0)
                            if active == new_value:
                                break
                    else:
                        list[item].set_active_text(new_value)

def build_static_list(lists):
    """Creates a flat list"""
    total_list= {}
    for list in lists:
        for item in list:
            if type(list[item]) == str:
                total_list[item]=list[item]
            elif type(list[item]) == Gtk.CheckButton:
                total_list[item]=list[item].get_active()
            elif type(list[item]) == Gtk.Entry:
                total_list[item]=list[item].get_text()
            else:
                model = list[item].get_model()
                row = list[item].get_selection().get_selected_rows()[1]
                iterator = model.get_iter(row[0])
                active = model.get_value(iterator, 0)
                total_list[item]=active
    return total_list
