.TH RMM %manext1% "March 18, 2013" "%nmhversion%"
.\"
.\" %nmhwarning%
.\"
.SH NAME
rmm \- remove messages
.SH SYNOPSIS
.HP 5
.na
.B rmm
.RI [ +folder ]
.RI [ msgs ]
.RB [ \-unlink " | " \-nounlink ]
.RB [ \-rmmproc
.IR program ]
.RB [ \-normmproc ]
.RB [ \-version ]
.RB [ \-help ]
.ad
.SH DESCRIPTION
By default,
.B rmm
will remove the specified messages by renaming
each of the message files with a site-dependent prefix (usually a
comma).  Such files will then need to
be removed in some manner after a certain amount of time.  Many sites
arrange for
.B cron
to remove these files once a day, so check
with your system administrator.
.PP
Alternately, if you wish for
.B rmm
to really remove the files
representing these messages, you can use the
.B \-unlink
switch.  But
messages removed by this method cannot be later recovered.
.PP
If you prefer a more sophisticated method of `removing' messages, you
can define the
.I rmmproc
profile component.  For example, you can
add a profile component such as
.PP
.RS 5
rmmproc:	/home/foouser/bin/rmm_msgs
.RE
.PP
Then instead of simply renaming the message file,
.B rmm
will call
the named program or script to handle the files that represent the
messages to be deleted.
The
.B \-rmmproc
switch may be used to override this profile component.  The
.B \-normmproc
switch disables the use of any
.I rmmproc
profile component and negates all prior
.B \-rmmproc
switches.
.PP
An example of a
.I rmmproc
script that saves a message based in its Message-ID is provided in
%etcdir%/rmmproc.messageid.  To enable it, simply add a
.I rmmproc
component that names it to your profile.
.PP
Some users of
.B csh
prefer the following:
.PP
.RS 5
alias rmm 'refile +d'
.RE
.PP
where folder `+d' is a folder for deleted messages, and
.PP
.RS 5
alias mexp 'rm `mhpath +d all`'
.RE
.PP
is used to \*(lqexpunge\*(rq deleted messages.
.PP
The current message is not changed by
.BR rmm ,
so a
.B next
will
advance to the next message in the folder as expected.
.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
.fi
.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Current\-Folder:~^To find the default current folder
^rmmproc:~^Program to delete the message
.fi
.SH "SEE ALSO"
.IR rmf (1)
.SH DEFAULTS
.nf
.RB ` +folder "' defaults to the current folder"
.RB ` msgs "' defaults to cur"
.RB ` -nounlink '
.fi
.SH CONTEXT
If a folder is given, it will become the current folder.
.SH BUGS
Since
.B rmm
and
.B refile
use your
.I rmmproc
to delete the message,
the
.I rmmproc
must
.B NOT
call
.B rmm
or
.B refile
without specifying
.BR \-normmproc ,
or you will create an infinite loop.
