# Jasmine Core 5.10.0 Release Notes

## New Features

* Optionally detect promise rejections that are handled after an initial
  unhandled promise rejection event and don't report them as errors.
  This is off by default because it comes with a performance cost. It can be
  enabled by setting the `detectLateRejectionHandling` config property to true.
* Add `getSpecProperty` to retrieve data that was set with `setSpecProperty`.
    * Merges [#2072](https://github.com/jasmine/jasmine/pull/2072) from @bonkevin
* Show spec duration in the HTML reporter.
    * Merges [#2073](https://github.com/jasmine/jasmine/pull/2073) from @bonkevin
* Protect `GlobalErrors` against monkey patching.
  
  All currently shipped versions of zone.js contain a monkey patch that fails
  to pass constructor arguments on to `GlobalErrors`. This patch normally has
  no effect because zone.js is normally installed after `GlobalErrors` is
  instantiated, but it would crash Jasmine if it was applied early enough.

## Deprecations

* Issue a deprecation warning if the suite/spec order passed as a parameter to
  `Env#execute` causes a suite to be re-entered.

## Changes to supported environments

* Added Firefox 140 (current ESR) to supported environments
* Demoted Firefox 128 (previous ESR) to best-effort support

## Internal improvements

* Core suite/spec execution flow has been significantly simplified.

## Supported environments

This version has been tested in the following environments.

| Environment       | Supported versions             |
|-------------------|--------------------------------|
| Node              | 18.20.5**, 20, 22, 24          |
| Safari            | 15**, 16**, 17**               |
| Chrome            | 139*                           |
| Firefox           | 102**, 115**, 128**, 140, 142* |
| Edge              | 139*                           |

\* Evergreen browser. Each version of Jasmine is tested against the latest
version available at release time.<br>
\** Supported on a best-effort basis. Support for these versions may be dropped
if it becomes impractical, and bugs affecting only these versions may not be
treated as release blockers.

------

_Release Notes generated with _[Anchorman](http://github.com/infews/anchorman)_
