---
id: fast-foundation.combobox
title: Combobox class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [Combobox](./fast-foundation.combobox.md)

## Combobox class

A Combobox Custom HTML Element. Implements the [ARIA combobox](https://w3c.github.io/aria-practices/#combobox)<!-- -->.


start - Content which can be provided before the input


end - Content which can be provided after the input


control - Used to replace the input element representing the combobox


indicator - The visual indicator representing the expanded state


- The default slot for the options


control - The wrapper element containing the input area, including start and end


selected-value - The input element representing the selected value


indicator - The element wrapping the indicator slot


listbox - The wrapper for the listbox slotted options


change - Fires a custom 'change' event when the value updates

<b>Signature:</b>

```typescript
export declare class Combobox extends FormAssociatedCombobox 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [autocomplete](./fast-foundation.combobox.autocomplete.md) |  | [ComboboxAutocomplete](./fast-foundation.comboboxautocomplete.md) \| undefined | The autocomplete attribute. |
|  [filteredOptions](./fast-foundation.combobox.filteredoptions.md) |  | [ListboxOption](./fast-foundation.listboxoption.md)<!-- -->\[\] | The collection of currently filtered options. |
|  [open](./fast-foundation.combobox.open.md) |  | boolean | The open attribute. |
|  [options](./fast-foundation.combobox.options.md) |  | [ListboxOption](./fast-foundation.listboxoption.md)<!-- -->\[\] | The list of options. |
|  [placeholder](./fast-foundation.combobox.placeholder.md) |  | string | Sets the placeholder value of the element, generally used to provide a hint to the user. |
|  [position](./fast-foundation.combobox.position.md) |  | [SelectPosition](./fast-foundation.selectposition.md) | The current state of the calculated position of the listbox. |
|  [positionAttribute](./fast-foundation.combobox.positionattribute.md) |  | [SelectPosition](./fast-foundation.selectposition.md) | The placement for the listbox when the combobox is open. |
|  [value](./fast-foundation.combobox.value.md) |  | string | The value property. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [connectedCallback()](./fast-foundation.combobox.connectedcallback.md) |  |  |
|  [filterOptions()](./fast-foundation.combobox.filteroptions.md) |  | Filter available options by text value. |
|  [positionChanged(prev, next)](./fast-foundation.combobox.positionchanged.md) |  |  |
|  [setPositioning()](./fast-foundation.combobox.setpositioning.md) |  | Calculate and apply listbox positioning based on available viewport space. |
