---
id: fast-foundation.select
title: Select class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [Select](./fast-foundation.select.md)

## Select class

A Select Custom HTML Element. Implements the [ARIA select](https://www.w3.org/TR/wai-aria-1.1/#select)<!-- -->.


start - Content which can be provided before the button content


end - Content which can be provided after the button content


button-container - The element representing the select button


selected-value - The selected value


indicator - The visual indicator for the expand/collapse state of the button


- The default slot for slotted options


control - The element representing the select invoking element


selected-value - The element wrapping the selected value


indicator - The element wrapping the visual indicator


listbox - The listbox element


input - Fires a custom 'input' event when the value updates


change - Fires a custom 'change' event when the value updates

<b>Signature:</b>

```typescript
export declare class Select extends FormAssociatedSelect 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [displayValue](./fast-foundation.select.displayvalue.md) |  | string | The value displayed on the button. |
|  [open](./fast-foundation.select.open.md) |  | boolean | The open attribute. |
|  [position](./fast-foundation.select.position.md) |  | [SelectPosition](./fast-foundation.selectposition.md) | Holds the current state for the calculated position of the listbox. |
|  [positionAttribute](./fast-foundation.select.positionattribute.md) |  | [SelectPosition](./fast-foundation.selectposition.md) | Reflects the placement for the listbox when the select is open. |
|  [value](./fast-foundation.select.value.md) |  | string | The value property. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [connectedCallback()](./fast-foundation.select.connectedcallback.md) |  |  |
|  [disconnectedCallback()](./fast-foundation.select.disconnectedcallback.md) |  |  |
|  [multipleChanged(prev, next)](./fast-foundation.select.multiplechanged.md) |  | Sets the multiple property on the proxy element. |
|  [positionChanged(prev, next)](./fast-foundation.select.positionchanged.md) |  |  |
|  [setPositioning()](./fast-foundation.select.setpositioning.md) |  | Calculate and apply listbox positioning based on available viewport space. |
