// Generated by LiveScript 1.6.0
(function(){
  var ref$, id, ref1$, split, join, lines, unlines, words, unwords, chars, unchars, empty, reverse, repeat, capitalize, camelize, dasherize, slice,
  take, drop, splitAt, takeWhile, dropWhile, span, breakStr, eq, deepEq, ok;
  ref$ = require('../..'), id = ref$.id, ref1$ = ref$.Str, split = ref1$.split, join = ref1$.join, lines = ref1$.lines, unlines = ref1$.unlines,
  words = ref1$.words, unwords = ref1$.unwords, chars = ref1$.chars, unchars = ref1$.unchars, empty = ref1$.empty, reverse = ref1$.reverse, repeat = ref1$.repeat,
  capitalize = ref1$.capitalize, camelize = ref1$.camelize, dasherize = ref1$.dasherize, slice = ref1$.slice, take = ref1$.take, drop = ref1$.drop, splitAt = ref1$.splitAt,
  takeWhile = ref1$.takeWhile, dropWhile = ref1$.dropWhile, span = ref1$.span, breakStr = ref1$.breakStr;
  ref$ = require('assert'), eq = ref$.strictEqual, deepEq = ref$.deepEqual, ok = ref$.ok;
  describe('split', function(){
    it('empty string as input', function(){
      return deepEq([], split('', ''));
    });
    it('string of some length', function(){
      return deepEq(['1', '2', '3'], split('|', '1|2|3'));
    });
    return it('curried', function(){
      var f;
      f = split('|');
      return deepEq(['1', '2', '3'], f('1|2|3'));
    });
  });
  describe('join', function(){
    it('empty list as input', function(){
      return eq('', join('', []));
    });
    it('list as input', function(){
      return eq('1,2,3', join(',', [1, 2, 3]));
    });
    it('empty string as seperator', function(){
      return eq('123', join('', [1, 2, 3]));
    });
    return it('curried', function(){
      var f;
      f = join(',');
      return eq('1,2,3', f([1, 2, 3]));
    });
  });
  describe('lines', function(){
    it('empty string as input', function(){
      return deepEq([], lines(''));
    });
    return it('string as input', function(){
      return deepEq(['one', 'two', 'three'], lines('one\ntwo\nthree'));
    });
  });
  describe('unlines', function(){
    it('empty array as input', function(){
      return eq('', unlines([]));
    });
    return it('array as input', function(){
      return eq('one\ntwo\nthree', unlines(['one', 'two', 'three']));
    });
  });
  describe('words', function(){
    it('empty string as input', function(){
      return deepEq([], words(''));
    });
    return it('string as input', function(){
      return deepEq(['what', 'is', 'this'], words('what   is  this'));
    });
  });
  describe('unwords', function(){
    it('empty array as input', function(){
      return eq('', unwords([]));
    });
    return it('array as input', function(){
      return eq('what is this', unwords(['what', 'is', 'this']));
    });
  });
  describe('chars', function(){
    it('empty string as input', function(){
      return deepEq([], chars(''));
    });
    return it('string as input', function(){
      return deepEq(['h', 'e', 'l', 'l', 'o'], chars('hello'));
    });
  });
  describe('unchars', function(){
    it('empty array as input', function(){
      return eq('', unchars([]));
    });
    return it('array as input', function(){
      return eq('there', unchars(['t', 'h', 'e', 'r', 'e']));
    });
  });
  describe('empty', function(){
    it('empty string as input', function(){
      return ok(empty(''));
    });
    return it('string as input', function(){
      return ok(!empty('a'));
    });
  });
  describe('reverse', function(){
    it('empty string as input', function(){
      return eq('', reverse(''));
    });
    return it('a string', function(){
      eq('cba', reverse('abc'));
      return eq('olleh', reverse('hello'));
    });
  });
  describe('repeat', function(){
    it('zero times', function(){
      return eq('', repeat(0, 'hi'));
    });
    it('empty string as input', function(){
      return eq('', repeat(2, ''));
    });
    it('a string several times', function(){
      eq('aa', repeat(2, 'a'));
      eq('hihihi', repeat(3, 'hi'));
      return eq('hihihihihihihihihihi', repeat(10, 'hi'));
    });
    return it('curried', function(){
      var f;
      f = repeat(2);
      return eq('aa', f('a'));
    });
  });
  describe('capitalize', function(){
    it('empty string as input', function(){
      return eq('', capitalize(''));
    });
    return it('basic', function(){
      return eq('Foo', capitalize('foo'));
    });
  });
  describe('camelize', function(){
    it('empty string as input', function(){
      return eq('', camelize(''));
    });
    it('no change', function(){
      return eq('fooBar', camelize('fooBar'));
    });
    it('dashes', function(){
      return eq('fooBar', camelize('foo-bar'));
    });
    it('underscore', function(){
      return eq('fooBar', camelize('foo_bar'));
    });
    it('ending dash', function(){
      return eq('fooBar', camelize('foo-bar-'));
    });
    return it('more than one', function(){
      return eq('fooBar', camelize('foo--bar'));
    });
  });
  describe('dasherize', function(){
    it('empty string as input', function(){
      return eq('', dasherize(''));
    });
    it('no change', function(){
      return eq('foo-bar', dasherize('foo-bar'));
    });
    it('basic', function(){
      return eq('foo-bar', dasherize('fooBar'));
    });
    it('with numbers', function(){
      return eq('f1-bar', dasherize('f1Bar'));
    });
    it('repeated capitals', function(){
      return eq('set-JSON', dasherize('setJSON'));
    });
    it('starting with capital', function(){
      return eq('foo-bar', dasherize('FooBar'));
    });
    return it('starting with repeated capitals', function(){
      return eq('JSON-get', dasherize('JSONget'));
    });
  });
  describe('slice', function(){
    it('zero to zero', function(){
      return eq('', slice(0, 0, 'hello'));
    });
    it('empty string as input', function(){
      return eq('', slice(2, 3, ''));
    });
    it('parts', function(){
      return eq('ll', slice(2, 4, 'hello'));
    });
    return it('curried', function(){
      var f, g;
      f = slice(2);
      eq('ll', f(4, 'hello'));
      g = slice(2, 4);
      return eq('ll', g('hello'));
    });
  });
  describe('take', function(){
    it('empty string as input', function(){
      return eq('', take(3, ''));
    });
    it('zero on string', function(){
      return eq('', take(0, 'abcde'));
    });
    it('string', function(){
      return eq('ab', take(2, 'abcde'));
    });
    return it('curried', function(){
      var f;
      f = take(2);
      return eq('ab', f('abcde'));
    });
  });
  describe('drop', function(){
    it('empty string as input', function(){
      return eq('', drop(3, ''));
    });
    it('zero on string', function(){
      return eq('abcde', drop(0, 'abcde'));
    });
    it('string', function(){
      return eq('cde', drop(2, 'abcde'));
    });
    return it('curried', function(){
      var f;
      f = drop(2);
      return eq('cde', f('abcde'));
    });
  });
  describe('split-at', function(){
    it('empty string as input', function(){
      return deepEq(['', ''], splitAt(3, ''));
    });
    it('zero on string', function(){
      return deepEq(['', 'abcde'], splitAt(0, 'abcde'));
    });
    it('string', function(){
      return deepEq(['ab', 'cde'], splitAt(2, 'abcde'));
    });
    return it('curried', function(){
      var f;
      f = splitAt(2);
      return deepEq(['ab', 'cde'], f('abcde'));
    });
  });
  describe('take-while', function(){
    it('empty string as input', function(){
      return eq('', takeWhile(id, ''));
    });
    it('string', function(){
      return eq('mmmmm', takeWhile((function(it){
        return it === 'm';
      }), 'mmmmmhmm'));
    });
    return it('curried', function(){
      var f;
      f = takeWhile((function(it){
        return it === 'm';
      }));
      return eq('mmmmm', f('mmmmmhmm'));
    });
  });
  describe('drop-while', function(){
    it('empty string as input', function(){
      return eq('', dropWhile(id, ''));
    });
    it('string', function(){
      return eq('hmm', dropWhile((function(it){
        return it === 'm';
      }), 'mmmmmhmm'));
    });
    return it('curried', function(){
      var f;
      f = dropWhile((function(it){
        return it === 'm';
      }));
      return eq('hmm', f('mmmmmhmm'));
    });
  });
  describe('span', function(){
    it('empty string as input', function(){
      return deepEq(['', ''], span(id, ''));
    });
    it('string', function(){
      return deepEq(['mmmmm', 'hmm'], span((function(it){
        return it === 'm';
      }), 'mmmmmhmm'));
    });
    return it('curried', function(){
      var f;
      f = span((function(it){
        return it === 'm';
      }));
      return deepEq(['mmmmm', 'hmm'], f('mmmmmhmm'));
    });
  });
  describe('break-str', function(){
    it('empty string as input', function(){
      return deepEq(['', ''], breakStr(id, ''));
    });
    it('string', function(){
      return deepEq(['mmmmm', 'hmm'], breakStr((function(it){
        return it === 'h';
      }), 'mmmmmhmm'));
    });
    return it('curried', function(){
      var f;
      f = breakStr((function(it){
        return it === 'h';
      }));
      return deepEq(['mmmmm', 'hmm'], f('mmmmmhmm'));
    });
  });
}).call(this);
