import ldap
from arcnagios import arcinfosys, ldaputils, ldapnagutils, nagutils
from arcnagios.arcinfosys import MdsServiceLdap
from arcnagios.confargparse import UsageError

class Check_egiis(ldapnagutils.LDAPNagiosPlugin):

    main_config_section = 'arcinfosys'

    def __init__(self):
	ldapnagutils.LDAPNagiosPlugin.__init__(self,
		use_port = True, default_port = 2135)
	ap = self.argparser.add_argument_group('EGIIS Options')
	ap.add_argument('--index-name', dest = 'index_name',
		help = 'The name of the information index to query.')

    def parse_args(self, args):
	ldapnagutils.LDAPNagiosPlugin.parse_args(self, args)
	if not self.opts.ldap_basedn and not self.opts.index_name:
	    raise UsageError('--ldap-basedn or --index-name must be specified.')

    def valid_egiis_entry(self, dn, ent):
	"""Validate a single EGIIS entry and return an pair of the number of
	errors and an `EGIIS_Object` for the entry or None."""

	try:
	    return MdsServiceLdap(self.subschema, dn, ent)
	except ldaputils.LDAPValidationError, xc:
	    self.log.error(str(xc))
	    self.nagios_report.update_status_code(nagutils.CRITICAL)
	    return None

    def check(self):
	self.prepare_check()

	# Query the EGIIS for subschema and entries.
	basedn = self.opts.ldap_basedn \
		or 'Mds-Vo-name=%s, o=grid'%self.opts.index_name
	self.subschema = self.fetch_subschema()
	sr = self.search_s(basedn, ldap.SCOPE_BASE,
			   'objectClass=MdsServiceLdap')
	if len(sr) == 0:
	    raise nagutils.ServiceWARNING('No EGIIS entries found.')

	# Check the entries.
	entcnts = {}
	for dn, ent in sr:
	    egiis = self.valid_egiis_entry(dn, ent)
	    if egiis:
		self.log.info('Good entry for %s'%egiis.ldap_suffix)
		entcnts[egiis.reg_status] = 1 + entcnts.get(egiis.reg_status, 0)

	# Report the result.
	entcnts = entcnts.items()
	entcnts.sort(lambda a, b: cmp(a[0], b[0]))
	countstrings = \
	    ['%d %s'%(cnt, arcinfosys.egiis_reg_status_to_string(st).lower())
	     for st, cnt in entcnts]
	self.nagios_report.update_status(
		nagutils.OK, 'EGIIS ok: %s.'%', '.join(countstrings))
	return self.nagios_exit(subject = 'EGIIS service')
