import logging
from arcutils import ParseError

log = logging.getLogger(__name__)

# Type Descriptors of the form (decode, encode, required).
#
def pt_t(t_of_str, str_of_t = str, required = True):
    return (t_of_str, str_of_t, required)

def pt_list(pt_elt):
    def decode(s):
	if s.strip():
	    return map(pt_elt[0], s.split(', '))
	else:
	    return []
    def encode(xs):
	return ', '.join(map(pt_elt[1], xs))
    return (decode, encode, False)

pt_int = (int, str, True)
pt_int_opt = (int, str, False)

pt_str = (str, str, True)
pt_str_opt = (str, str, False)
pt_str_list = pt_list(pt_str)

# Persistent Objects
#
class PersistentObject(object):
    """A class which represents a simple collection of attributes with
    human-readable pickeling.  The pickeling is limited to what is needed by
    the Nagios plugins.  The main point of this is to make the data
    presentable to Nagios operator."""

    persistent_attributes = {}

    def __init__(self, **kwargs):
	for k, _ in self.persistent_attributes.iteritems():
	    v = kwargs.pop(k, None)
	    setattr(self, k, v)
	if kwargs:
	    raise TypeError('Invalid keyword argument(s) %s.'
			    % ', '.join(kwargs))

    def persistent_load(self, path, log = log):
	fh = open(path)
	lnno = 0
	for ln in fh:
	    lnno += 1
	    kv = ln.split(': ', 1)
	    if len(kv) != 2:
		log.error('%s:%d: Invalid or old file format.' \
			  % (path, lnno))
		raise ParseError('Invalid format for PersistentObject.')
	    k, v = kv
	    v = v.strip()
	    if not k in self.persistent_attributes:
		log.warning('%s:%d: Ignoring unknown attribute.'%(path, lnno))
		continue
	    try:
		setattr(self, k, self.persistent_attributes[k][0](v))
	    except Exception, xc:
		log.error('%s:%d: %s'%(path, lnno, xc))
	fh.close()
	for k, (_, _, req) in self.persistent_attributes.iteritems():
	    if req:
		if getattr(self, k) is None:
		    raise ParseError('Missing required attribute %s.'%k)

    def persistent_save(self, path):
	for k, (_, _, req) in self.persistent_attributes.iteritems():
	    if req:
		if getattr(self, k) is None:
		    raise ValueError('Tried to save incomplete persistent '
				     'object; missing attribute %s.'%k)
	fh = open(path, 'w')
	for k, c in self.persistent_attributes.iteritems():
	    v = getattr(self, k)
	    if not v is None:
		fh.write('%s: %s\n'%(k, c[1](v)))
	fh.close()
