C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_c_vwn1.F 
C> The nwxcm_c_vwn1 functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_c_vwn1 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{\sqrt{{\it t_2}}}}\\\\ 
C>   {\it t_4} &=& 1.575246635799487\,{\it t_3}\\\\ 
C>   {\it t_5} &=& \arctan \left({{6.15199081975908}\over{{\it t_4}
C>    +3.72744}}\right)\\\\ 
C>   {\it t_6} &=& 0.7876233178997433\,{\it t_3}\\\\ 
C>   {\it t_7} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_8} &=& 0.6203504908994001\,{\it t_7}\\\\ 
C>   {\it t_9} &=& {{1}\over{\left| 2.935818660072219\,{\it t_3}+{
C>    \it t_8}+12.9352\right| }}\\\\ 
C>   {\it t_{10}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.10498\right)^2\,{\it t_9}\right)\\\\ 
C>   {\it t_{11}} &=& \left| {\it t_7}\right| \\\\ 
C>   {\it t_{12}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_9}\right)\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{15}} &=& {{1}\over{\left| 5.560951426165705\,{\it t_3}
C>    +{\it t_8}+18.0578\right| }}\\\\ 
C>   {\it t_{16}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{17}} &=& {{1}\over{\sqrt{{\it t_{16}}}}}\\\\ 
C>   {\it t_{18}} &=& {{1}\over{{\it t_{16}}}}\\\\ 
C>   {\it t_{19}} &=& 0.6203504908994001\,{\it t_{18}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\left| {\it t_{19}}
C>    +2.935818660072219\,{\it t_{17}}+12.9352\right| }}\\\\ 
C>   {\it t_{21}} &=& \left| {\it t_{18}}\right| \\\\ 
C>   {\it t_{22}} &=& \log \left(0.6203504908994001\,{\it t_{20}}
C>    \,{\it t_{21}}\right)\\\\ 
C>   {\it t_{23}} &=& 0.7876233178997433\,{\it t_{17}}\\\\ 
C>   {\it t_{24}} &=& \log \left(1.0\,{\it t_{20}}\,\left({\it t_{23}}
C>    +0.10498\right)^2\right)\\\\ 
C>   {\it t_{25}} &=& 1.575246635799487\,{\it t_{17}}\\\\ 
C>   {\it t_{26}} &=& \arctan \left({{6.15199081975908}\over{{
C>    \it t_{25}}+3.72744}}\right)\\\\ 
C>   {\it t_{27}} &=& {{1}\over{\left| {\it t_{19}}
C>    +5.560951426165705\,{\it t_{17}}+18.0578\right| }}\\\\ 
C>   f &=& 1.0\,{\it t_1}\,\left(1.923661050931536\,\left(\left({
C>    \it t_{13}}\,{\it t_{14}}+1.0\right)^{{{4}\over{3}}}+\left(1.0
C>    -{\it t_{13}}\,{\it t_{14}}\right)^{{{4}\over{3}}}-2.0\right)
C>    \,\left(0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{11}}\,{\it t_{15}}\right)+0.002247867095542611
C>    \,\log \left(1.0\,\left({\it t_6}+0.325\right)^2\,{
C>    \it t_{15}}\right)-0.0310907\,{\it t_{12}}
C>    -9.690227711544375 \times 10^{-4}\,{\it t_{10}}
C>    +0.05249139316978092\,\arctan \left({{4.730926909560114}
C>    \over{{\it t_4}+7.06042}}\right)-0.03878329487811301\,{
C>    \it t_5}\right)+0.0310907\,{\it t_{12}}
C>    +9.690227711544375 \times 10^{-4}\,{\it t_{10}}
C>    +0.03878329487811301\,{\it t_5}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.999999999999999\,\left(0.05249139316978092
C>    \,\arctan \left({{4.730926909560114}\over{{\it t_{25}}
C>    +7.06042}}\right)-0.03878329487811301\,{\it t_{26}}
C>    +0.002247867095542611\,\log \left(1.0\,{\it t_{27}}\,\left({
C>    \it t_{23}}+0.325\right)^2\right)-9.690227711544375 \times 10^{
C>    -4}\,{\it t_{24}}+0.01554535\,\log \left(0.6203504908994001
C>    \,{\it t_{27}}\,{\it t_{21}}\right)-0.0310907\,{
C>    \it t_{22}}\right)+0.03878329487811301\,{\it t_{26}}
C>    +9.690227711544375 \times 10^{-4}\,{\it t_{24}}+0.0310907\,{
C>    \it t_{22}}\right)\,\rho_s\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] SH Vosko, L Wilk, M Nusair, Can.J.Phys. 58, 1200 (1980)  , DOI: 
C> <a href="http://dx.doi.org/10.1139/p80-159 "> 
C> 10.1139/p80-159 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_vwn1(param,tol_rho,ipol,nq,wght, 
     +rho,fnc,Amat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 4.9237251092134837d-1*t4
            t6 = 1/abs(t5+2.615517080950829d+0*t3+1.29352d+1)
            t7 = abs(t4)
            t8 = t5+2.615517080950828d+0*t3+1.29352d+1
            t9 = abs(t8)
            t10 = 1/t9
            t11 = 7.016926042943222d-1*t3+1.0498d-1
            t12 = t11**2
            t13 = 1.4033852085886445d+0*t3+3.72744d+0
            t14 = 1/t7
            t15 = 1/t2**3
            t16 = 1/rhoa**6.666666666666667d-1
            t17 = -2.1795975674590234d-1*t15*t16-8.206208515355806d-2/rh
     1         oa**1.3333333333333333d+0
            t18 = 1/t8
            t19 = 1/t13**2
            fnc(iq) = 2.0d+0*rhoa*(3.10907d-2*log(4.9237251092134837d-1*
     1         t6*t7)+9.690227711544375d-4*log(1.0d+0*(7.016926042943223
     2         d-1*t3+1.0498d-1)**2*t6)+3.8783294878113006d-2*atan(6.151
     3         99081975908d+0/(1.4033852085886447d+0*t3+3.72744d+0)))*wg
     4         ht+fnc(iq)
            Amat(iq,D1_RA) = 2.0d+0*rhoa*(6.314467057030004d-2*t14*(-4.9
     1         237251092134837d-1*t10*t17*t18*t7-8.206208515355806d-2*t1
     2         0*t14/rhoa**1.6666666666666666d+0)*t9+9.690227711544375d-
     3         4*(-1.0d+0*t10*t12*t17*t18-1.1694876738238703d-1*t10*t11*
     4         t15*t16)*t9/t12+2.790332964441521d-2*t15*t16*t19/(3.78469
     5         9104639999d+1*t19+1))*wght+1.0d+0*(3.10907d-2*log(4.92372
     6         51092134837d-1*t10*t7)+3.8783294878113006d-2*atan(6.15199
     7         081975908d+0/t13)+9.690227711544375d-4*log(1.0d+0*t10*t12
     8         ))*wght+Amat(iq,D1_RA)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = t2**5.0d-1
            t4 = 1/t3
            t5 = 1.5752466357994865d+0*t4
            t6 = t5+3.72744d+0
            t7 = atan(6.15199081975908d+0/t6)
            t8 = 7.876233178997433d-1*t4
            t9 = t8+1.0498d-1
            t10 = t9**2
            t11 = 1/t2
            t12 = 6.203504908994001d-1*t11
            t13 = 2.935818660072219d+0*t4+t12+1.29352d+1
            t14 = abs(t13)
            t15 = 1/t14
            t16 = log(1.0d+0*t10*t15)
            t17 = abs(t11)
            t18 = log(6.203504908994001d-1*t15*t17)
            t19 = rhoa-rhob
            t20 = 1/t1
            t21 = 1.0d+0-t19*t20
            t22 = t19*t20+1.0d+0
            t23 = t22**1.3333333333333333d+0+t21**1.3333333333333333d+0-
     1         2.0d+0
            t24 = t5+7.06042d+0
            t25 = t8+3.25d-1
            t26 = t25**2
            t27 = 5.560951426165704d+0*t4+t12+1.8057800000000002d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = -3.8783294878113006d-2*t7+2.2478670955426108d-3*log(1.
     1         0d+0*t26*t29)+1.554535d-2*log(6.203504908994001d-1*t17*t2
     2         9)+5.249139316978092d-2*atan(4.7309269095601136d+0/t24)-3
     3         .10907d-2*t18-9.690227711544375d-4*t16
            t31 = 3.8783294878113006d-2*t7+1.923661050931536d+0*t23*t30+
     1         3.10907d-2*t18+9.690227711544375d-4*t16
            t32 = 1/t1**6.666666666666667d-1
            t33 = 1/t3**3
            t34 = 1/t6**2
            t35 = 1/(3.784699104639999d+1*t34+1)
            t36 = 6.264085709464389d-2*t32*t33*t34*t35
            t37 = 1/t10
            t38 = -2.067834969664667d-1/t1**1.3333333333333333d+0
            t39 = t38-4.8930311001203647d-1*t32*t33
            t40 = 1/t13
            t41 = -2.625411059665811d-1*t15*t32*t33*t9-1.0d+0*t10*t15*t3
     1         9*t40
            t42 = 9.690227711544375d-4*t14*t37*t41
            t43 = 1/t17
            t44 = 1/t1**1.6666666666666666d+0
            t45 = -2.067834969664667d-1*t15*t43*t44-6.203504908994001d-1
     1         *t15*t17*t39*t40
            t46 = 5.011795824473985d-2*t14*t43*t45
            t47 = 1/t24**2
            t48 = t38-9.26825237694284d-1*t32*t33
            t49 = 1/t27
            t50 = 1.923661050931536d+0*t23*(2.2478670955426108d-3*t28*(-
     1         1.0d+0*t26*t29*t48*t49-2.625411059665811d-1*t25*t29*t32*t
     2         33)/t26+2.5058979122369923d-2*t28*t43*(-6.203504908994001
     3         d-1*t17*t29*t48*t49-2.067834969664667d-1*t29*t43*t44)+6.5
     4         19760588836059d-2*t32*t33*t47/(2.238166942360001d+1*t47+1
     5         )-5.011795824473985d-2*t14*t43*t45-9.690227711544375d-4*t
     6         14*t37*t41-6.264085709464389d-2*t32*t33*t34*t35)
            t51 = 1/t1**2
            t52 = t19*t51
            t53 = -t20
            t54 = t21**3.333333333333333d-1
            t55 = -t19*t51
            t56 = t22**3.333333333333333d-1
            t57 = 1.0d+0*t31*wght
            fnc(iq) = 1.0d+0*t1*t31*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t1*(1.923661050931536d+0*t30*(1.3333
     1         333333333333d+0*(t55+t20)*t56+1.3333333333333333d+0*(t53+
     2         t52)*t54)+t50+t46+t42+t36)*wght+t57+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*t1*(1.923661050931536d+0*t30*(1.3333
     1         333333333333d+0*(t55+t53)*t56+1.3333333333333333d+0*(t52+
     2         t20)*t54)+t50+t46+t42+t36)*wght+t57+Amat(iq,D1_RB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = t11+3.25d-1
            t22 = t21**2
            t23 = t15+7.06042d+0
            t24 = 9.99999999999999d-1*(1.554535d-2*log(6.203504908994001
     1         d-1*t20*t9)+5.249139316978092d-2*atan(4.7309269095601136d
     2         +0/t23)+2.2478670955426108d-3*log(1.0d+0*t20*t22)-3.87832
     3         94878113006d-2*t17-9.690227711544375d-4*t14-3.10907d-2*t1
     4         0)+3.8783294878113006d-2*t17+9.690227711544375d-4*t14+3.1
     5         0907d-2*t10
            t25 = 1/t9
            t26 = -2.067834969664667d-1/rhoa**1.3333333333333333d+0
            t27 = 1/t2**3
            t28 = 1/rhoa**6.666666666666667d-1
            t29 = t26-4.8930311001203647d-1*t27*t28
            t30 = 1/t6
            t31 = 1/rhoa**1.6666666666666666d+0
            t32 = -6.203504908994001d-1*t29*t30*t8*t9-2.067834969664667d
     1         -1*t25*t31*t8
            t33 = 1/t16**2
            t34 = 1/(3.784699104639999d+1*t33+1)
            t35 = 1/t13
            t36 = -1.0d+0*t13*t29*t30*t8-2.625411059665811d-1*t12*t27*t2
     1         8*t8
            t37 = t26-9.26825237694284d-1*t27*t28
            t38 = 1/t18
            t39 = 1/t23**2
            fnc(iq) = 1.0d+0*rhoa*t24*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*(9.99999999999999d-1*(2.5058979
     1         122369923d-2*t19*t25*(-6.203504908994001d-1*t20*t37*t38*t
     2         9-2.067834969664667d-1*t20*t25*t31)-9.690227711544375d-4*
     3         t35*t36*t7-5.011795824473985d-2*t25*t32*t7+6.519760588836
     4         059d-2*t27*t28*t39/(2.238166942360001d+1*t39+1)+2.2478670
     5         955426108d-3*t19*(-1.0d+0*t20*t22*t37*t38-2.6254110596658
     6         11d-1*t20*t21*t27*t28)/t22-6.264085709464389d-2*t27*t28*t
     7         33*t34)+9.690227711544375d-4*t35*t36*t7+5.011795824473985
     8         d-2*t25*t32*t7+6.264085709464389d-2*t27*t28*t33*t34)*wght
     9         +1.0d+0*t24*wght+Amat(iq,D1_RA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = t11+3.25d-1
            t22 = t21**2
            t23 = t15+7.06042d+0
            t24 = 9.99999999999999d-1*(1.554535d-2*log(6.203504908994001
     1         d-1*t20*t9)+5.249139316978092d-2*atan(4.7309269095601136d
     2         +0/t23)+2.2478670955426108d-3*log(1.0d+0*t20*t22)-3.87832
     3         94878113006d-2*t17-9.690227711544375d-4*t14-3.10907d-2*t1
     4         0)+3.8783294878113006d-2*t17+9.690227711544375d-4*t14+3.1
     5         0907d-2*t10
            t25 = 1/t9
            t26 = -2.067834969664667d-1/rhob**1.3333333333333333d+0
            t27 = 1/t2**3
            t28 = 1/rhob**6.666666666666667d-1
            t29 = t26-4.8930311001203647d-1*t27*t28
            t30 = 1/t6
            t31 = 1/rhob**1.6666666666666666d+0
            t32 = -6.203504908994001d-1*t29*t30*t8*t9-2.067834969664667d
     1         -1*t25*t31*t8
            t33 = 1/t16**2
            t34 = 1/(3.784699104639999d+1*t33+1)
            t35 = 1/t13
            t36 = -1.0d+0*t13*t29*t30*t8-2.625411059665811d-1*t12*t27*t2
     1         8*t8
            t37 = t26-9.26825237694284d-1*t27*t28
            t38 = 1/t18
            t39 = 1/t23**2
            fnc(iq) = 1.0d+0*rhob*t24*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*(9.99999999999999d-1*(2.5058979
     1         122369923d-2*t19*t25*(-6.203504908994001d-1*t20*t37*t38*t
     2         9-2.067834969664667d-1*t20*t25*t31)-9.690227711544375d-4*
     3         t35*t36*t7-5.011795824473985d-2*t25*t32*t7+6.519760588836
     4         059d-2*t27*t28*t39/(2.238166942360001d+1*t39+1)+2.2478670
     5         955426108d-3*t19*(-1.0d+0*t20*t22*t37*t38-2.6254110596658
     6         11d-1*t20*t21*t27*t28)/t22-6.264085709464389d-2*t27*t28*t
     7         33*t34)+9.690227711544375d-4*t35*t36*t7+5.011795824473985
     8         d-2*t25*t32*t7+6.264085709464389d-2*t27*t28*t33*t34)*wght
     9         +1.0d+0*t24*wght+Amat(iq,D1_RB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_vwn1 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{\sqrt{{\it t_2}}}}\\\\ 
C>   {\it t_4} &=& 1.575246635799487\,{\it t_3}\\\\ 
C>   {\it t_5} &=& \arctan \left({{6.15199081975908}\over{{\it t_4}
C>    +3.72744}}\right)\\\\ 
C>   {\it t_6} &=& 0.7876233178997433\,{\it t_3}\\\\ 
C>   {\it t_7} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_8} &=& 0.6203504908994001\,{\it t_7}\\\\ 
C>   {\it t_9} &=& {{1}\over{\left| 2.935818660072219\,{\it t_3}+{
C>    \it t_8}+12.9352\right| }}\\\\ 
C>   {\it t_{10}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.10498\right)^2\,{\it t_9}\right)\\\\ 
C>   {\it t_{11}} &=& \left| {\it t_7}\right| \\\\ 
C>   {\it t_{12}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_9}\right)\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{15}} &=& {{1}\over{\left| 5.560951426165705\,{\it t_3}
C>    +{\it t_8}+18.0578\right| }}\\\\ 
C>   {\it t_{16}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{17}} &=& {{1}\over{\sqrt{{\it t_{16}}}}}\\\\ 
C>   {\it t_{18}} &=& {{1}\over{{\it t_{16}}}}\\\\ 
C>   {\it t_{19}} &=& 0.6203504908994001\,{\it t_{18}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\left| {\it t_{19}}
C>    +2.935818660072219\,{\it t_{17}}+12.9352\right| }}\\\\ 
C>   {\it t_{21}} &=& \left| {\it t_{18}}\right| \\\\ 
C>   {\it t_{22}} &=& \log \left(0.6203504908994001\,{\it t_{20}}
C>    \,{\it t_{21}}\right)\\\\ 
C>   {\it t_{23}} &=& 0.7876233178997433\,{\it t_{17}}\\\\ 
C>   {\it t_{24}} &=& \log \left(1.0\,{\it t_{20}}\,\left({\it t_{23}}
C>    +0.10498\right)^2\right)\\\\ 
C>   {\it t_{25}} &=& 1.575246635799487\,{\it t_{17}}\\\\ 
C>   {\it t_{26}} &=& \arctan \left({{6.15199081975908}\over{{
C>    \it t_{25}}+3.72744}}\right)\\\\ 
C>   {\it t_{27}} &=& {{1}\over{\left| {\it t_{19}}
C>    +5.560951426165705\,{\it t_{17}}+18.0578\right| }}\\\\ 
C>   f &=& 1.0\,{\it t_1}\,\left(1.923661050931536\,\left(\left({
C>    \it t_{13}}\,{\it t_{14}}+1.0\right)^{{{4}\over{3}}}+\left(1.0
C>    -{\it t_{13}}\,{\it t_{14}}\right)^{{{4}\over{3}}}-2.0\right)
C>    \,\left(0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{11}}\,{\it t_{15}}\right)+0.002247867095542611
C>    \,\log \left(1.0\,\left({\it t_6}+0.325\right)^2\,{
C>    \it t_{15}}\right)-0.0310907\,{\it t_{12}}
C>    -9.690227711544375 \times 10^{-4}\,{\it t_{10}}
C>    +0.05249139316978092\,\arctan \left({{4.730926909560114}
C>    \over{{\it t_4}+7.06042}}\right)-0.03878329487811301\,{
C>    \it t_5}\right)+0.0310907\,{\it t_{12}}
C>    +9.690227711544375 \times 10^{-4}\,{\it t_{10}}
C>    +0.03878329487811301\,{\it t_5}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.999999999999999\,\left(0.05249139316978092
C>    \,\arctan \left({{4.730926909560114}\over{{\it t_{25}}
C>    +7.06042}}\right)-0.03878329487811301\,{\it t_{26}}
C>    +0.002247867095542611\,\log \left(1.0\,{\it t_{27}}\,\left({
C>    \it t_{23}}+0.325\right)^2\right)-9.690227711544375 \times 10^{
C>    -4}\,{\it t_{24}}+0.01554535\,\log \left(0.6203504908994001
C>    \,{\it t_{27}}\,{\it t_{21}}\right)-0.0310907\,{
C>    \it t_{22}}\right)+0.03878329487811301\,{\it t_{26}}
C>    +9.690227711544375 \times 10^{-4}\,{\it t_{24}}+0.0310907\,{
C>    \it t_{22}}\right)\,\rho_s\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] SH Vosko, L Wilk, M Nusair, Can.J.Phys. 58, 1200 (1980)  , DOI: 
C> <a href="http://dx.doi.org/10.1139/p80-159 "> 
C> 10.1139/p80-159 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_vwn1_d2(param,tol_rho,ipol,nq,wght, 
     +rho,fnc,Amat,Amat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
c 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 4.9237251092134837d-1*t4
            t6 = 1/abs(t5+2.615517080950829d+0*t3+1.29352d+1)
            t7 = abs(t4)
            t8 = t5+2.615517080950828d+0*t3+1.29352d+1
            t9 = abs(t8)
            t10 = 1/t9
            t11 = log(4.9237251092134837d-1*t10*t7)
            t12 = 7.016926042943222d-1*t3
            t13 = t12+1.0498d-1
            t14 = t13**2
            t15 = log(1.0d+0*t10*t14)
            t16 = 1.4033852085886445d+0*t3
            t17 = t16+3.72744d+0
            t18 = atan(6.15199081975908d+0/t17)
            t19 = 1/t7
            t20 = 1/t2**3
            t21 = 1/rhoa**6.666666666666667d-1
            t22 = -2.1795975674590234d-1*t20*t21-8.206208515355806d-2/rh
     1         oa**1.3333333333333333d+0
            t23 = 1/t8
            t24 = 1/rhoa**1.6666666666666666d+0
            t25 = -4.9237251092134837d-1*t10*t22*t23*t7-8.20620851535580
     1         6d-2*t10*t19*t24
            t26 = 1/t17**2
            t27 = 3.784699104639999d+1*t26+1
            t28 = 1/t27
            t29 = 1/t14
            t30 = -1.0d+0*t10*t14*t22*t23-1.1694876738238703d-1*t10*t13*
     1         t20*t21
            t31 = 9.690227711544375d-4*t29*t30*t9+6.314467057030004d-2*t
     1         19*t25*t9+2.790332964441521d-2*t20*t21*t26*t28
            t32 = 2.0d+0*t31*wght
            t33 = 1/rhoa**2.3333333333333334d+0
            t34 = -2.470091445929572d-1*t33/(t17**5*t27**2)
            t35 = 6.526520015557556d-3*t28*t33/t17**3
            t36 = 1/abs(t5+4.9542444972117183d+0*t3+1.8057800000000002d+
     1         1)
            t37 = 1.554535d-2*log(4.9237251092134837d-1*t36*t7)+2.247867
     1         0955426108d-3*log(1.0d+0*(t12+3.25d-1)**2*t36)-3.87832948
     2         78113006d-2*t18+5.249139316978092d-2*atan(4.7309269095601
     3         136d+0/(t16+7.06042d+0))-9.690227711544375d-4*t15-3.10907
     4         d-2*t11
            t38 = 1/rhoa**2
            t39 = 1/rhoa**1.6666666666666669d+0
            t40 = -9.301109881471736d-3*t20*t26*t28*t39
            t41 = t22**2
            t42 = 1/t8**2
            t43 = 1/t2**5
            t44 = 1/rhoa**1.3333333333333336d+0
            t45 = 5.448993918647558d-2*t43*t44+7.265325224863413d-2*t20*
     1         t39+5.470805676903872d-2/rhoa**2.333333333333333d+0
            t46 = 6.314467057030004d-2*t19*(-4.9237251092134837d-1*t10*t
     1         23*t45*t7+9.847450218426967d-1*t10*t41*t42*t7+1.641241703
     2         0711612d-1*t10*t19*t22*t23*t24+5.470805676903869d-2*t10*t
     3         19/rhoa**2.6666666666666666d+0)*t9
            t47 = -6.975832411103801d-3*t26*t28*t43*t44
            t48 = 1.0524111761716676d-2*t19*t25*t9/rhoa**9.9999999999999
     1         99d-1
            t49 = 1.1332601865197636d-4*t20*t21*t30*t9/t13**3
            t50 = 9.690227711544375d-4*t29*(-1.0d+0*t10*t14*t23*t45+2.92
     1         3719184559675d-2*t10*t13*t43*t44+2.0d+0*t10*t14*t41*t42+3
     2         .898292246079568d-2*t10*t13*t20*t39+6.838507096129838d-3*
     3         t10*t33+2.3389753476477407d-1*t10*t13*t20*t21*t22*t23)*t9
            t51 = 6.314467057030004d-2*t10*t19*t22*t25*t8
            t52 = 9.690227711544375d-4*t10*t22*t29*t30*t8
            fnc(iq) = 2.0d+0*rhoa*(3.10907d-2*log(4.9237251092134837d-1*
     1         t6*t7)+9.690227711544375d-4*log(1.0d+0*(7.016926042943223
     2         d-1*t3+1.0498d-1)**2*t6)+3.8783294878113006d-2*atan(6.151
     3         99081975908d+0/(1.4033852085886447d+0*t3+3.72744d+0)))*wg
     4         ht+fnc(iq)
            Amat(iq,D1_RA) = 2.0d+0*rhoa*t31*wght+1.0d+0*(3.878329487811
     1         3006d-2*t18+9.690227711544375d-4*t15+3.10907d-2*t11)*wght
     2         +Amat(iq,D1_RA)
            Amat2(iq,D2_RA_RA) = 2.0d+0*rhoa*(t52+t51+t50+t49+t48+t47+t4
     1         6+t40+4.274802335403413d-1*t37*t38+t35+t34)*wght+t32+Amat
     2         2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 2.0d+0*rhoa*(t52+t51+t50+t49+t48+t47+t4
     1         6+t40-4.274802335403413d-1*t37*t38+t35+t34)*wght+t32+Amat
     2         2(iq,D2_RA_RB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = t2**5.0d-1
            t4 = 1/t3
            t5 = 1.5752466357994865d+0*t4
            t6 = t5+3.72744d+0
            t7 = atan(6.15199081975908d+0/t6)
            t8 = 7.876233178997433d-1*t4
            t9 = t8+1.0498d-1
            t10 = t9**2
            t11 = 1/t2
            t12 = 6.203504908994001d-1*t11
            t13 = 2.935818660072219d+0*t4+t12+1.29352d+1
            t14 = abs(t13)
            t15 = 1/t14
            t16 = log(1.0d+0*t10*t15)
            t17 = abs(t11)
            t18 = log(6.203504908994001d-1*t15*t17)
            t19 = rhoa-rhob
            t20 = 1/t1
            t21 = 1.0d+0-t19*t20
            t22 = t19*t20+1.0d+0
            t23 = t22**1.3333333333333333d+0+t21**1.3333333333333333d+0-
     1         2.0d+0
            t24 = t5+7.06042d+0
            t25 = t8+3.25d-1
            t26 = t25**2
            t27 = 5.560951426165704d+0*t4+t12+1.8057800000000002d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = -3.8783294878113006d-2*t7+2.2478670955426108d-3*log(1.
     1         0d+0*t26*t29)+1.554535d-2*log(6.203504908994001d-1*t17*t2
     2         9)+5.249139316978092d-2*atan(4.7309269095601136d+0/t24)-3
     3         .10907d-2*t18-9.690227711544375d-4*t16
            t31 = 3.8783294878113006d-2*t7+1.923661050931536d+0*t23*t30+
     1         3.10907d-2*t18+9.690227711544375d-4*t16
            t32 = 1/t1**6.666666666666667d-1
            t33 = 1/t3**3
            t34 = 1/t6**2
            t35 = 3.784699104639999d+1*t34+1
            t36 = 1/t35
            t37 = 6.264085709464389d-2*t32*t33*t34*t36
            t38 = 1/t10
            t39 = -2.067834969664667d-1/t1**1.3333333333333333d+0
            t40 = t39-4.8930311001203647d-1*t32*t33
            t41 = 1/t13
            t42 = -2.625411059665811d-1*t15*t32*t33*t9-1.0d+0*t10*t15*t4
     1         0*t41
            t43 = 9.690227711544375d-4*t14*t38*t42
            t44 = 1/t17
            t45 = 1/t1**1.6666666666666666d+0
            t46 = -2.067834969664667d-1*t15*t44*t45-6.203504908994001d-1
     1         *t15*t17*t40*t41
            t47 = 5.011795824473985d-2*t14*t44*t46
            t48 = 1/t24**2
            t49 = 2.238166942360001d+1*t48+1
            t50 = 1/t49
            t51 = 1/t26
            t52 = t39-9.26825237694284d-1*t32*t33
            t53 = 1/t27
            t54 = -1.0d+0*t26*t29*t52*t53-2.625411059665811d-1*t25*t29*t
     1         32*t33
            t55 = -6.203504908994001d-1*t17*t29*t52*t53-2.06783496966466
     1         7d-1*t29*t44*t45
            t56 = 2.5058979122369923d-2*t28*t44*t55+2.2478670955426108d-
     1         3*t28*t51*t54+6.519760588836059d-2*t32*t33*t48*t50-5.0117
     2         95824473985d-2*t14*t44*t46-9.690227711544375d-4*t14*t38*t
     3         42-6.264085709464389d-2*t32*t33*t34*t36
            t57 = 1.923661050931536d+0*t23*t56
            t58 = 1/t1**2
            t59 = t19*t58
            t60 = -t20
            t61 = t60+t59
            t62 = t21**3.333333333333333d-1
            t63 = -t19*t58
            t64 = t63+t20
            t65 = t22**3.333333333333333d-1
            t66 = 1.3333333333333333d+0*t64*t65+1.3333333333333333d+0*t6
     1         1*t62
            t67 = 1.923661050931536d+0*t30*t66+t57+t47+t43+t37
            t68 = 1.0d+0*t31*wght
            t69 = t59+t20
            t70 = t63+t60
            t71 = 1.3333333333333333d+0*t65*t70+1.3333333333333333d+0*t6
     1         2*t69
            t72 = 1.923661050931536d+0*t30*t71+t57+t47+t43+t37
            t73 = 1/t1**2.3333333333333334d+0
            t74 = 1/t6**5
            t75 = 1/t35**2
            t76 = -1.2448480831567728d+0*t73*t74*t75
            t77 = 1/t6**3
            t78 = 3.289159980064472d-2*t36*t73*t77
            t79 = 1/t1**1.3333333333333336d+0
            t80 = 1/t3**5
            t81 = -3.1320428547321943d-2*t34*t36*t79*t80
            t82 = 1/t1**1.6666666666666669d+0
            t83 = -4.176057139642926d-2*t33*t34*t36*t82
            t84 = 9.690227711544375d-4*t13*t15*t38*t40*t42
            t85 = 5.011795824473985d-2*t13*t15*t40*t44*t46
            t86 = t40**2
            t87 = 1/t13**2
            t88 = 2.7571132928862224d-1/t1**2.333333333333333d+0
            t89 = t88+3.262020733413577d-1*t33*t82+2.4465155500601823d-1
     1         *t79*t80
            t90 = 1.7502740397772074d-1*t15*t33*t82*t9+1.312705529832905
     1         4d-1*t15*t79*t80*t9+5.250822119331622d-1*t15*t32*t33*t40*
     2         t41*t9-1.0d+0*t10*t15*t41*t89+2.0d+0*t10*t15*t86*t87+3.44
     3         6391616107778d-2*t15*t73
            t91 = 9.690227711544375d-4*t14*t38*t90
            t92 = 1/t9**3
            t93 = 2.544083100456872d-4*t14*t32*t33*t42*t92
            t94 = 1/t1**2.6666666666666666d+0
            t95 = 2.7571132928862224d-1*t15*t44*t94-6.203504908994001d-1
     1         *t15*t17*t41*t89+1.2407009817988002d+0*t15*t17*t86*t87+4.
     2         135669939329334d-1*t15*t40*t41*t44*t45
            t96 = 5.011795824473985d-2*t14*t44*t95
            t97 = 1/t1**9.999999999999999d-1
            t98 = 1.670598608157995d-2*t14*t44*t46*t97
            t99 = t52**2
            t100 = 1/t27**2
            t101 = t88+6.178834917961894d-1*t33*t82+4.63412618847142d-1*
     1         t79*t80
            t102 = 1.923661050931536d+0*t23*(2.2478670955426108d-3*t28*t
     1         51*(2.0d+0*t100*t26*t29*t99+1.7502740397772074d-1*t25*t29
     2         *t33*t82+1.3127055298329054d-1*t25*t29*t79*t80+3.44639161
     3         6107778d-2*t29*t73+5.250822119331622d-1*t25*t29*t32*t33*t
     4         52*t53-1.0d+0*t101*t26*t29*t53)+2.5058979122369923d-2*t28
     5         *t44*(1.2407009817988002d+0*t100*t17*t29*t99+2.7571132928
     6         862224d-1*t29*t44*t94+4.135669939329334d-1*t29*t44*t45*t5
     7         2*t53-6.203504908994001d-1*t101*t17*t29*t53)+8.3529930407
     8         89976d-3*t28*t44*t55*t97-1.670598608157995d-2*t14*t44*t46
     9         *t97-5.011795824473985d-2*t14*t44*t95-2.544083100456872d-
     :         4*t14*t32*t33*t42*t92-9.690227711544375d-4*t14*t38*t90-4.
     ;         3465070592240396d-2*t33*t48*t50*t82+4.176057139642926d-2*
     <         t33*t34*t36*t82-3.2598802944180294d-2*t48*t50*t79*t80+3.1
     =         320428547321943d-2*t34*t36*t79*t80-3.289159980064472d-2*t
     >         36*t73*t77+1.2448480831567728d+0*t73*t74*t75+3.4234103112
     ?         606934d-2*t50*t73/t24**3-7.662163788798045d-1*t73/(t24**5
     @         *t49**2)+2.5058979122369923d-2*t27*t29*t44*t52*t55+2.2478
     1         670955426108d-3*t27*t29*t51*t52*t54+5.901575133296435d-4*
     2         t28*t32*t33*t54/t25**3-5.011795824473985d-2*t13*t15*t40*t
     3         44*t46-9.690227711544375d-4*t13*t15*t38*t40*t42)
            t103 = 1/t21**6.666666666666666d-1
            t104 = 1/t1**3
            t105 = -2*t104*t19
            t106 = 2*t58
            t107 = 1/t22**6.666666666666666d-1
            t108 = 2*t104*t19
            t109 = -2*t58
            fnc(iq) = 1.0d+0*t1*t31*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t1*t67*wght+t68+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*t1*t72*wght+t68+Amat(iq,D1_RB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*t1*(t98+t96+t93+t91+t85+t84+t83+
     1         t81+t78+t76+3.847322101863072d+0*t56*t66+1.92366105093153
     2         6d+0*t30*(1.3333333333333333d+0*(t109+t108)*t65+4.4444444
     3         44444444d-1*t107*t64**2+1.3333333333333333d+0*(t106+t105)
     4         *t62+4.444444444444444d-1*t103*t61**2)+t102)*wght+2.0d+0*
     5         t67*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*t1*(t98+t96+t93+t91+t85+t84+t83+
     1         t81+t78+t76+1.923661050931536d+0*t56*t71+1.92366105093153
     2         6d+0*t30*(4.444444444444444d-1*t107*t64*t70+4.44444444444
     3         4444d-1*t103*t61*t69+2.6666666666666666d+0*t104*t19*t65-2
     4         .6666666666666666d+0*t104*t19*t62)+1.923661050931536d+0*t
     5         56*t66+t102)*wght+1.0d+0*t72*wght+1.0d+0*t67*wght+Amat2(i
     6         q,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*t1*(t98+t96+t93+t91+t85+t84+t83+
     1         t81+t78+t76+3.847322101863072d+0*t56*t71+1.92366105093153
     2         6d+0*t30*(4.444444444444444d-1*t107*t70**2+4.444444444444
     3         444d-1*t103*t69**2+1.3333333333333333d+0*(t108+t106)*t65+
     4         1.3333333333333333d+0*(t109+t105)*t62)+t102)*wght+2.0d+0*
     5         t72*wght+Amat2(iq,D2_RB_RB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = t11+3.25d-1
            t22 = t21**2
            t23 = t15+7.06042d+0
            t24 = 9.99999999999999d-1*(1.554535d-2*log(6.203504908994001
     1         d-1*t20*t9)+5.249139316978092d-2*atan(4.7309269095601136d
     2         +0/t23)+2.2478670955426108d-3*log(1.0d+0*t20*t22)-3.87832
     3         94878113006d-2*t17-9.690227711544375d-4*t14-3.10907d-2*t1
     4         0)+3.8783294878113006d-2*t17+9.690227711544375d-4*t14+3.1
     5         0907d-2*t10
            t25 = 1/t9
            t26 = -2.067834969664667d-1/rhoa**1.3333333333333333d+0
            t27 = 1/t2**3
            t28 = 1/rhoa**6.666666666666667d-1
            t29 = t26-4.8930311001203647d-1*t27*t28
            t30 = 1/t6
            t31 = 1/rhoa**1.6666666666666666d+0
            t32 = -6.203504908994001d-1*t29*t30*t8*t9-2.067834969664667d
     1         -1*t25*t31*t8
            t33 = 1/t16**2
            t34 = 3.784699104639999d+1*t33+1
            t35 = 1/t34
            t36 = 1/t13
            t37 = -1.0d+0*t13*t29*t30*t8-2.625411059665811d-1*t12*t27*t2
     1         8*t8
            t38 = t26-9.26825237694284d-1*t27*t28
            t39 = 1/t18
            t40 = -6.203504908994001d-1*t20*t38*t39*t9-2.067834969664667
     1         d-1*t20*t25*t31
            t41 = 1/t23**2
            t42 = 2.238166942360001d+1*t41+1
            t43 = 1/t42
            t44 = 1/t22
            t45 = -1.0d+0*t20*t22*t38*t39-2.625411059665811d-1*t20*t21*t
     1         27*t28
            t46 = 9.99999999999999d-1*(-9.690227711544375d-4*t36*t37*t7-
     1         5.011795824473985d-2*t25*t32*t7+2.2478670955426108d-3*t19
     2         *t44*t45+6.519760588836059d-2*t27*t28*t41*t43+2.505897912
     3         2369923d-2*t19*t25*t40-6.264085709464389d-2*t27*t28*t33*t
     4         35)+9.690227711544375d-4*t36*t37*t7+5.011795824473985d-2*
     5         t25*t32*t7+6.264085709464389d-2*t27*t28*t33*t35
            t47 = 1/t34**2
            t48 = 1/t16**5
            t49 = 1/rhoa**2.3333333333333334d+0
            t50 = 1/t16**3
            t51 = 1/rhoa**1.6666666666666669d+0
            t52 = t29**2
            t53 = 1/t6**2
            t54 = 2.7571132928862224d-1/rhoa**2.333333333333333d+0
            t55 = 1/t2**5
            t56 = 1/rhoa**1.3333333333333336d+0
            t57 = 2.4465155500601823d-1*t55*t56+t54+3.262020733413577d-1
     1         *t27*t51
            t58 = 1/rhoa**2.6666666666666666d+0
            t59 = -6.203504908994001d-1*t30*t57*t8*t9+1.2407009817988002
     1         d+0*t52*t53*t8*t9+2.7571132928862224d-1*t25*t58*t8+4.1356
     2         69939329334d-1*t25*t29*t30*t31*t8
            t60 = 1/rhoa**9.999999999999999d-1
            t61 = 1/t12**3
            t62 = -1.0d+0*t13*t30*t57*t8+1.3127055298329054d-1*t12*t55*t
     1         56*t8+2.0d+0*t13*t52*t53*t8+1.7502740397772074d-1*t12*t27
     2         *t51*t8+3.446391616107778d-2*t49*t8+5.250822119331622d-1*
     3         t12*t27*t28*t29*t30*t8
            t63 = t38**2
            t64 = 1/t18**2
            t65 = 4.63412618847142d-1*t55*t56+t54+6.178834917961894d-1*t
     1         27*t51
            fnc(iq) = 1.0d+0*rhoa*t24*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*t46*wght+1.0d+0*t24*wght+Amat(i
     1         q,D1_RA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*rhoa*(9.99999999999999d-1*(2.505
     1         8979122369923d-2*t19*t25*(-6.203504908994001d-1*t20*t39*t
     2         65*t9+1.2407009817988002d+0*t20*t63*t64*t9+2.757113292886
     3         2224d-1*t20*t25*t58+4.135669939329334d-1*t20*t25*t31*t38*
     4         t39)-9.690227711544375d-4*t29*t36*t37*t6*t8-5.01179582447
     5         3985d-2*t25*t29*t32*t6*t8-9.690227711544375d-4*t36*t62*t7
     6         -2.544083100456872d-4*t27*t28*t37*t61*t7-1.67059860815799
     7         5d-2*t25*t32*t60*t7-5.011795824473985d-2*t25*t59*t7+2.247
     8         8670955426108d-3*t19*t44*(-1.0d+0*t20*t22*t39*t65+2.0d+0*
     9         t20*t22*t63*t64+1.3127055298329054d-1*t20*t21*t55*t56+1.7
     :         502740397772074d-1*t20*t21*t27*t51+3.446391616107778d-2*t
     ;         20*t49+5.250822119331622d-1*t20*t21*t27*t28*t38*t39)+8.35
     <         2993040789976d-3*t19*t25*t40*t60-3.2598802944180294d-2*t4
     =         1*t43*t55*t56+3.1320428547321943d-2*t33*t35*t55*t56-4.346
     >         5070592240396d-2*t27*t41*t43*t51+4.176057139642926d-2*t27
     ?         *t33*t35*t51-3.289159980064472d-2*t35*t49*t50+1.244848083
     @         1567728d+0*t47*t48*t49+3.4234103112606934d-2*t43*t49/t23*
     1         *3-7.662163788798045d-1*t49/(t23**5*t42**2)+2.24786709554
     2         26108d-3*t18*t20*t38*t44*t45+5.901575133296435d-4*t19*t27
     3         *t28*t45/t21**3+2.5058979122369923d-2*t18*t20*t25*t38*t40
     4         )+9.690227711544375d-4*t29*t36*t37*t6*t8+5.01179582447398
     5         5d-2*t25*t29*t32*t6*t8+9.690227711544375d-4*t36*t62*t7+2.
     6         544083100456872d-4*t27*t28*t37*t61*t7+1.670598608157995d-
     7         2*t25*t32*t60*t7+5.011795824473985d-2*t25*t59*t7-3.132042
     8         8547321943d-2*t33*t35*t55*t56-4.176057139642926d-2*t27*t3
     9         3*t35*t51+3.289159980064472d-2*t35*t49*t50-1.244848083156
     :         7728d+0*t47*t48*t49)*wght+2.0d+0*t46*wght+Amat2(iq,D2_RA_
     ;         RA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = t11+3.25d-1
            t22 = t21**2
            t23 = t15+7.06042d+0
            t24 = 9.99999999999999d-1*(1.554535d-2*log(6.203504908994001
     1         d-1*t20*t9)+5.249139316978092d-2*atan(4.7309269095601136d
     2         +0/t23)+2.2478670955426108d-3*log(1.0d+0*t20*t22)-3.87832
     3         94878113006d-2*t17-9.690227711544375d-4*t14-3.10907d-2*t1
     4         0)+3.8783294878113006d-2*t17+9.690227711544375d-4*t14+3.1
     5         0907d-2*t10
            t25 = 1/t9
            t26 = -2.067834969664667d-1/rhob**1.3333333333333333d+0
            t27 = 1/t2**3
            t28 = 1/rhob**6.666666666666667d-1
            t29 = t26-4.8930311001203647d-1*t27*t28
            t30 = 1/t6
            t31 = 1/rhob**1.6666666666666666d+0
            t32 = -6.203504908994001d-1*t29*t30*t8*t9-2.067834969664667d
     1         -1*t25*t31*t8
            t33 = 1/t16**2
            t34 = 3.784699104639999d+1*t33+1
            t35 = 1/t34
            t36 = 1/t13
            t37 = -1.0d+0*t13*t29*t30*t8-2.625411059665811d-1*t12*t27*t2
     1         8*t8
            t38 = t26-9.26825237694284d-1*t27*t28
            t39 = 1/t18
            t40 = -6.203504908994001d-1*t20*t38*t39*t9-2.067834969664667
     1         d-1*t20*t25*t31
            t41 = 1/t23**2
            t42 = 2.238166942360001d+1*t41+1
            t43 = 1/t42
            t44 = 1/t22
            t45 = -1.0d+0*t20*t22*t38*t39-2.625411059665811d-1*t20*t21*t
     1         27*t28
            t46 = 9.99999999999999d-1*(-9.690227711544375d-4*t36*t37*t7-
     1         5.011795824473985d-2*t25*t32*t7+2.2478670955426108d-3*t19
     2         *t44*t45+6.519760588836059d-2*t27*t28*t41*t43+2.505897912
     3         2369923d-2*t19*t25*t40-6.264085709464389d-2*t27*t28*t33*t
     4         35)+9.690227711544375d-4*t36*t37*t7+5.011795824473985d-2*
     5         t25*t32*t7+6.264085709464389d-2*t27*t28*t33*t35
            t47 = 1/t34**2
            t48 = 1/t16**5
            t49 = 1/rhob**2.3333333333333334d+0
            t50 = 1/t16**3
            t51 = 1/rhob**1.6666666666666669d+0
            t52 = t29**2
            t53 = 1/t6**2
            t54 = 2.7571132928862224d-1/rhob**2.333333333333333d+0
            t55 = 1/t2**5
            t56 = 1/rhob**1.3333333333333336d+0
            t57 = 2.4465155500601823d-1*t55*t56+t54+3.262020733413577d-1
     1         *t27*t51
            t58 = 1/rhob**2.6666666666666666d+0
            t59 = -6.203504908994001d-1*t30*t57*t8*t9+1.2407009817988002
     1         d+0*t52*t53*t8*t9+2.7571132928862224d-1*t25*t58*t8+4.1356
     2         69939329334d-1*t25*t29*t30*t31*t8
            t60 = 1/rhob**9.999999999999999d-1
            t61 = 1/t12**3
            t62 = -1.0d+0*t13*t30*t57*t8+1.3127055298329054d-1*t12*t55*t
     1         56*t8+2.0d+0*t13*t52*t53*t8+1.7502740397772074d-1*t12*t27
     2         *t51*t8+3.446391616107778d-2*t49*t8+5.250822119331622d-1*
     3         t12*t27*t28*t29*t30*t8
            t63 = t38**2
            t64 = 1/t18**2
            t65 = 4.63412618847142d-1*t55*t56+t54+6.178834917961894d-1*t
     1         27*t51
            fnc(iq) = 1.0d+0*rhob*t24*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*t46*wght+1.0d+0*t24*wght+Amat(i
     1         q,D1_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*rhob*(9.99999999999999d-1*(2.505
     1         8979122369923d-2*t19*t25*(-6.203504908994001d-1*t20*t39*t
     2         65*t9+1.2407009817988002d+0*t20*t63*t64*t9+2.757113292886
     3         2224d-1*t20*t25*t58+4.135669939329334d-1*t20*t25*t31*t38*
     4         t39)-9.690227711544375d-4*t29*t36*t37*t6*t8-5.01179582447
     5         3985d-2*t25*t29*t32*t6*t8-9.690227711544375d-4*t36*t62*t7
     6         -2.544083100456872d-4*t27*t28*t37*t61*t7-1.67059860815799
     7         5d-2*t25*t32*t60*t7-5.011795824473985d-2*t25*t59*t7+2.247
     8         8670955426108d-3*t19*t44*(-1.0d+0*t20*t22*t39*t65+2.0d+0*
     9         t20*t22*t63*t64+1.3127055298329054d-1*t20*t21*t55*t56+1.7
     :         502740397772074d-1*t20*t21*t27*t51+3.446391616107778d-2*t
     ;         20*t49+5.250822119331622d-1*t20*t21*t27*t28*t38*t39)+8.35
     <         2993040789976d-3*t19*t25*t40*t60-3.2598802944180294d-2*t4
     =         1*t43*t55*t56+3.1320428547321943d-2*t33*t35*t55*t56-4.346
     >         5070592240396d-2*t27*t41*t43*t51+4.176057139642926d-2*t27
     ?         *t33*t35*t51-3.289159980064472d-2*t35*t49*t50+1.244848083
     @         1567728d+0*t47*t48*t49+3.4234103112606934d-2*t43*t49/t23*
     1         *3-7.662163788798045d-1*t49/(t23**5*t42**2)+2.24786709554
     2         26108d-3*t18*t20*t38*t44*t45+5.901575133296435d-4*t19*t27
     3         *t28*t45/t21**3+2.5058979122369923d-2*t18*t20*t25*t38*t40
     4         )+9.690227711544375d-4*t29*t36*t37*t6*t8+5.01179582447398
     5         5d-2*t25*t29*t32*t6*t8+9.690227711544375d-4*t36*t62*t7+2.
     6         544083100456872d-4*t27*t28*t37*t61*t7+1.670598608157995d-
     7         2*t25*t32*t60*t7+5.011795824473985d-2*t25*t59*t7-3.132042
     8         8547321943d-2*t33*t35*t55*t56-4.176057139642926d-2*t27*t3
     9         3*t35*t51+3.289159980064472d-2*t35*t49*t50-1.244848083156
     :         7728d+0*t47*t48*t49)*wght+2.0d+0*t46*wght+Amat2(iq,D2_RB_
     ;         RB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_vwn1 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{\sqrt{{\it t_2}}}}\\\\ 
C>   {\it t_4} &=& 1.575246635799487\,{\it t_3}\\\\ 
C>   {\it t_5} &=& \arctan \left({{6.15199081975908}\over{{\it t_4}
C>    +3.72744}}\right)\\\\ 
C>   {\it t_6} &=& 0.7876233178997433\,{\it t_3}\\\\ 
C>   {\it t_7} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_8} &=& 0.6203504908994001\,{\it t_7}\\\\ 
C>   {\it t_9} &=& {{1}\over{\left| 2.935818660072219\,{\it t_3}+{
C>    \it t_8}+12.9352\right| }}\\\\ 
C>   {\it t_{10}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.10498\right)^2\,{\it t_9}\right)\\\\ 
C>   {\it t_{11}} &=& \left| {\it t_7}\right| \\\\ 
C>   {\it t_{12}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_9}\right)\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{15}} &=& {{1}\over{\left| 5.560951426165705\,{\it t_3}
C>    +{\it t_8}+18.0578\right| }}\\\\ 
C>   {\it t_{16}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{17}} &=& {{1}\over{\sqrt{{\it t_{16}}}}}\\\\ 
C>   {\it t_{18}} &=& {{1}\over{{\it t_{16}}}}\\\\ 
C>   {\it t_{19}} &=& 0.6203504908994001\,{\it t_{18}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\left| {\it t_{19}}
C>    +2.935818660072219\,{\it t_{17}}+12.9352\right| }}\\\\ 
C>   {\it t_{21}} &=& \left| {\it t_{18}}\right| \\\\ 
C>   {\it t_{22}} &=& \log \left(0.6203504908994001\,{\it t_{20}}
C>    \,{\it t_{21}}\right)\\\\ 
C>   {\it t_{23}} &=& 0.7876233178997433\,{\it t_{17}}\\\\ 
C>   {\it t_{24}} &=& \log \left(1.0\,{\it t_{20}}\,\left({\it t_{23}}
C>    +0.10498\right)^2\right)\\\\ 
C>   {\it t_{25}} &=& 1.575246635799487\,{\it t_{17}}\\\\ 
C>   {\it t_{26}} &=& \arctan \left({{6.15199081975908}\over{{
C>    \it t_{25}}+3.72744}}\right)\\\\ 
C>   {\it t_{27}} &=& {{1}\over{\left| {\it t_{19}}
C>    +5.560951426165705\,{\it t_{17}}+18.0578\right| }}\\\\ 
C>   f &=& 1.0\,{\it t_1}\,\left(1.923661050931536\,\left(\left({
C>    \it t_{13}}\,{\it t_{14}}+1.0\right)^{{{4}\over{3}}}+\left(1.0
C>    -{\it t_{13}}\,{\it t_{14}}\right)^{{{4}\over{3}}}-2.0\right)
C>    \,\left(0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{11}}\,{\it t_{15}}\right)+0.002247867095542611
C>    \,\log \left(1.0\,\left({\it t_6}+0.325\right)^2\,{
C>    \it t_{15}}\right)-0.0310907\,{\it t_{12}}
C>    -9.690227711544375 \times 10^{-4}\,{\it t_{10}}
C>    +0.05249139316978092\,\arctan \left({{4.730926909560114}
C>    \over{{\it t_4}+7.06042}}\right)-0.03878329487811301\,{
C>    \it t_5}\right)+0.0310907\,{\it t_{12}}
C>    +9.690227711544375 \times 10^{-4}\,{\it t_{10}}
C>    +0.03878329487811301\,{\it t_5}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.999999999999999\,\left(0.05249139316978092
C>    \,\arctan \left({{4.730926909560114}\over{{\it t_{25}}
C>    +7.06042}}\right)-0.03878329487811301\,{\it t_{26}}
C>    +0.002247867095542611\,\log \left(1.0\,{\it t_{27}}\,\left({
C>    \it t_{23}}+0.325\right)^2\right)-9.690227711544375 \times 10^{
C>    -4}\,{\it t_{24}}+0.01554535\,\log \left(0.6203504908994001
C>    \,{\it t_{27}}\,{\it t_{21}}\right)-0.0310907\,{
C>    \it t_{22}}\right)+0.03878329487811301\,{\it t_{26}}
C>    +9.690227711544375 \times 10^{-4}\,{\it t_{24}}+0.0310907\,{
C>    \it t_{22}}\right)\,\rho_s\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] SH Vosko, L Wilk, M Nusair, Can.J.Phys. 58, 1200 (1980)  , DOI: 
C> <a href="http://dx.doi.org/10.1139/p80-159 "> 
C> 10.1139/p80-159 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_vwn1_d3(param,tol_rho,ipol,nq,wght, 
     +rho,fnc,Amat,Amat2,Amat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,*)  !< [Output] The 3rd derivative wrt rho 
c 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 4.9237251092134837d-1*t4
            t6 = 1/abs(t5+2.615517080950829d+0*t3+1.29352d+1)
            t7 = abs(t4)
            t8 = t5+2.615517080950828d+0*t3+1.29352d+1
            t9 = abs(t8)
            t10 = 1/t9
            t11 = log(4.9237251092134837d-1*t10*t7)
            t12 = 7.016926042943222d-1*t3
            t13 = t12+1.0498d-1
            t14 = t13**2
            t15 = log(1.0d+0*t10*t14)
            t16 = 1.4033852085886445d+0*t3
            t17 = t16+3.72744d+0
            t18 = atan(6.15199081975908d+0/t17)
            t19 = 1/t7
            t20 = -8.206208515355806d-2/rhoa**1.3333333333333333d+0
            t21 = 1/t2**3
            t22 = 1/rhoa**6.666666666666667d-1
            t23 = t20-2.1795975674590234d-1*t21*t22
            t24 = 1/t8
            t25 = 1/rhoa**1.6666666666666666d+0
            t26 = -4.9237251092134837d-1*t10*t23*t24*t7-8.20620851535580
     1         6d-2*t10*t19*t25
            t27 = 1/t17**2
            t28 = 3.784699104639999d+1*t27+1
            t29 = 1/t28
            t30 = 1/t14
            t31 = -1.0d+0*t10*t14*t23*t24-1.1694876738238703d-1*t10*t13*
     1         t21*t22
            t32 = 9.690227711544375d-4*t30*t31*t9+6.314467057030004d-2*t
     1         19*t26*t9+2.790332964441521d-2*t21*t22*t27*t29
            t33 = 2.0d+0*t32*wght
            t34 = 1/t28**2
            t35 = 1/t17**5
            t36 = 1/rhoa**2.3333333333333334d+0
            t37 = -2.470091445929572d-1*t34*t35*t36
            t38 = 1/t17**3
            t39 = 6.526520015557556d-3*t29*t36*t38
            t40 = t5+4.9542444972117183d+0*t3+1.8057800000000002d+1
            t41 = abs(t40)
            t42 = 1/t41
            t43 = t12+3.25d-1
            t44 = t43**2
            t45 = t16+7.06042d+0
            t46 = 1.554535d-2*log(4.9237251092134837d-1*t42*t7)+5.249139
     1         316978092d-2*atan(4.7309269095601136d+0/t45)+2.2478670955
     2         426108d-3*log(1.0d+0*t42*t44)-3.8783294878113006d-2*t18-9
     3         .690227711544375d-4*t15-3.10907d-2*t11
            t47 = 1/rhoa**2
            t48 = 1/rhoa**1.6666666666666669d+0
            t49 = -9.301109881471736d-3*t21*t27*t29*t48
            t50 = t23**2
            t51 = 1/t8**2
            t52 = 1/t2**5
            t53 = 1/rhoa**1.3333333333333336d+0
            t54 = 5.448993918647558d-2*t52*t53+7.265325224863413d-2*t21*
     1         t48+5.470805676903872d-2/rhoa**2.333333333333333d+0
            t55 = 1/rhoa**2.6666666666666666d+0
            t56 = -4.9237251092134837d-1*t10*t24*t54*t7+9.84745021842696
     1         7d-1*t10*t50*t51*t7+5.470805676903869d-2*t10*t19*t55+1.64
     2         12417030711612d-1*t10*t19*t23*t24*t25
            t57 = 6.314467057030004d-2*t19*t56*t9
            t58 = -6.975832411103801d-3*t27*t29*t52*t53
            t59 = 1/rhoa**9.999999999999999d-1
            t60 = 1.0524111761716676d-2*t19*t26*t59*t9
            t61 = 1/t13**3
            t62 = 1.1332601865197636d-4*t21*t22*t31*t61*t9
            t63 = -1.0d+0*t10*t14*t24*t54+2.923719184559675d-2*t10*t13*t
     1         52*t53+2.0d+0*t10*t14*t50*t51+3.898292246079568d-2*t10*t1
     2         3*t21*t48+6.838507096129838d-3*t10*t36+2.3389753476477407
     3         d-1*t10*t13*t21*t22*t23*t24
            t64 = 9.690227711544375d-4*t30*t63*t9
            t65 = 6.314467057030004d-2*t10*t19*t23*t26*t8
            t66 = 9.690227711544375d-4*t10*t23*t30*t31*t8
            t67 = t66+t65+t64+t62+t60+t58+t57+t49+4.274802335403413d-1*t
     1         46*t47+t39+t37
            t68 = t66+t65+t64+t62+t60+t58+t57+t49-4.274802335403413d-1*t
     1         46*t47+t39+t37
            t69 = 1/rhoa**3.3333333333333337d+0
            t70 = 4.3226600303767515d-1*t34*t35*t69
            t71 = -1.1421410027225727d-2*t29*t38*t69
            t72 = 1/rhoa**3
            t73 = 1/rhoa**3.0d+0
            t74 = 4.3732069462725337d+0*t21*t73/(t17**8*t28**3)
            t75 = -2.022119049462691d-1*t21*t34*t73/t17**6
            t76 = 2.289805413347801d-3*t21*t29*t73/t17**4
            t77 = 1/rhoa**2.666666666666667d+0
            t78 = 7.750924901226445d-3*t21*t27*t29*t77
            t79 = 6.975832411103802d-3*t27*t29*t36*t52
            t80 = 1.988000729055306d-5*t31*t36*t9/t13**4
            t81 = t20-4.128537081009765d-1*t21*t22
            t82 = 1/t40
            t83 = 1/t45**2
            t84 = -9.690227711544375d-4*t30*t31*t9-6.314467057030004d-2*
     1         t19*t26*t9+2.904223175587974d-2*t21*t22*t83/(2.2381669423
     2         60001d+1*t83+1)+3.157233528515002d-2*t19*t41*(-4.92372510
     3         92134837d-1*t42*t7*t81*t82-8.206208515355806d-2*t19*t25*t
     4         42)+2.2478670955426108d-3*t41*(-1.0d+0*t42*t44*t81*t82-1.
     5         1694876738238703d-1*t21*t22*t42*t43)/t44-2.79033296444152
     6         1d-2*t21*t22*t27*t29
            t85 = 1/t2**7
            t86 = 1/rhoa**2.0d+0
            t87 = 2.906596837959916d-3*t27*t29*t85*t86
            t88 = -5.262055880858336d-3*t19*t26*t86*t9
            t89 = 1.7540186269527788d-3*t19*t26*t9/rhoa**1.9999999999999
     1         998d+0
            t90 = -3.7775339550658793d-5*t21*t31*t48*t61*t9
            t91 = t23**3
            t92 = 1/t8**3
            t93 = -2.2704141327698155d-2*t85*t86-6.054437687386176d-2*t2
     1         1*t77-5.448993918647558d-2*t36*t52-6.382606623054516d-2/r
     2         hoa**3.333333333333333d+0
            t94 = 6.314467057030004d-2*t19*t9*(-4.9237251092134837d-1*t1
     1         0*t24*t7*t93-2.95423506552809d+0*t10*t7*t91*t92+2.9542350
     2         6552809d+0*t10*t23*t51*t54*t7-1.6412417030711612d-1*t10*t
     3         19*t23*t24*t55+2.4618625546067416d-1*t10*t19*t24*t25*t54-
     4         4.923725109213483d-1*t10*t19*t25*t50*t51-6.38260662305451
     5         5d-2*t10*t19/rhoa**3.6666666666666664d+0)
            t95 = -2.833150466299409d-5*t31*t52*t53*t61*t9
            t96 = 2.1048223523433351d-2*t19*t56*t59*t9
            t97 = 2.1048223523433351d-2*t10*t19*t23*t26*t59*t8
            t98 = 2.2665203730395272d-4*t21*t22*t61*t63*t9
            t99 = 2.2665203730395272d-4*t10*t21*t22*t23*t31*t61*t8
            t100 = 9.690227711544375d-4*t30*t9*(-1.0d+0*t10*t14*t24*t93-
     1         6.0d+0*t10*t14*t91*t92-1.2182163268998646d-2*t10*t13*t85*
     2         t86-3.2485768717329727d-2*t10*t13*t21*t77-1.1967387418227
     3         218d-2*t10*t69+6.0d+0*t10*t14*t23*t51*t54+3.5084630214716
     4         11d-1*t10*t13*t21*t22*t24*t54-8.771157553679026d-2*t10*t1
     5         3*t23*t24*t52*t53-2.923719184559675d-2*t10*t13*t36*t52-7.
     6         016926042943222d-1*t10*t13*t21*t22*t50*t51-1.169487673823
     7         8703d-1*t10*t13*t21*t23*t24*t48-2.0515521288389513d-2*t10
     8         *t23*t24*t36)
            t101 = 6.314467057030004d-2*t10*t19*t26*t54*t8
            t102 = 1.262893411406001d-1*t10*t19*t23*t56*t8
            t103 = 1.938045542308875d-3*t10*t23*t30*t63*t8
            t104 = 9.690227711544375d-4*t10*t30*t31*t54*t8
            fnc(iq) = 2.0d+0*rhoa*(3.10907d-2*log(4.9237251092134837d-1*
     1         t6*t7)+9.690227711544375d-4*log(1.0d+0*(7.016926042943223
     2         d-1*t3+1.0498d-1)**2*t6)+3.8783294878113006d-2*atan(6.151
     3         99081975908d+0/(1.4033852085886447d+0*t3+3.72744d+0)))*wg
     4         ht+fnc(iq)
            Amat(iq,D1_RA) = 2.0d+0*rhoa*t32*wght+1.0d+0*(3.878329487811
     1         3006d-2*t18+9.690227711544375d-4*t15+3.10907d-2*t11)*wght
     2         +Amat(iq,D1_RA)
            Amat2(iq,D2_RA_RA) = 2.0d+0*rhoa*t67*wght+t33+Amat2(iq,D2_RA
     1         _RA)
            Amat2(iq,D2_RA_RB) = 2.0d+0*rhoa*t68*wght+t33+Amat2(iq,D2_RA
     1         _RB)
            Amat3(iq,D3_RA_RA_RA) = 2.0d+0*rhoa*(t99+t98+t97+t96+t95+t94
     1         +t90+t89+t88+t87+1.282440700621024d+0*t47*t84+t80+t79+t78
     2         +t76+t75+t74-1.2824407006210237d+0*t46*t72+t71+t70+t104+t
     3         103+t102+t101+t100)*wght+3.0d+0*t67*wght+Amat3(iq,D3_RA_R
     4         A_RA)
            Amat3(iq,D3_RA_RA_RB) = 2.0d+0*rhoa*(t99+t98+t97+t96+t95+t94
     1         +t90+t89+t88+t87-4.274802335403413d-1*t47*t84+t80+t79+t78
     2         +t76+t75+t74+4.274802335403413d-1*t46*t72+t71+t70+t104+t1
     3         03+t102+t101+t100)*wght+2.0d+0*t68*wght+1.0d+0*t67*wght+A
     4         mat3(iq,D3_RA_RA_RB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = t2**5.0d-1
            t4 = 1/t3
            t5 = 1.5752466357994865d+0*t4
            t6 = t5+3.72744d+0
            t7 = atan(6.15199081975908d+0/t6)
            t8 = 7.876233178997433d-1*t4
            t9 = t8+1.0498d-1
            t10 = t9**2
            t11 = 1/t2
            t12 = 6.203504908994001d-1*t11
            t13 = 2.935818660072219d+0*t4+t12+1.29352d+1
            t14 = abs(t13)
            t15 = 1/t14
            t16 = log(1.0d+0*t10*t15)
            t17 = abs(t11)
            t18 = log(6.203504908994001d-1*t15*t17)
            t19 = rhoa-rhob
            t20 = 1/t1
            t21 = 1.0d+0-t19*t20
            t22 = t19*t20+1.0d+0
            t23 = t22**1.3333333333333333d+0+t21**1.3333333333333333d+0-
     1         2.0d+0
            t24 = t5+7.06042d+0
            t25 = t8+3.25d-1
            t26 = t25**2
            t27 = 5.560951426165704d+0*t4+t12+1.8057800000000002d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = -3.8783294878113006d-2*t7+2.2478670955426108d-3*log(1.
     1         0d+0*t26*t29)+1.554535d-2*log(6.203504908994001d-1*t17*t2
     2         9)+5.249139316978092d-2*atan(4.7309269095601136d+0/t24)-3
     3         .10907d-2*t18-9.690227711544375d-4*t16
            t31 = 3.8783294878113006d-2*t7+1.923661050931536d+0*t23*t30+
     1         3.10907d-2*t18+9.690227711544375d-4*t16
            t32 = 1/t1**6.666666666666667d-1
            t33 = 1/t3**3
            t34 = 1/t6**2
            t35 = 3.784699104639999d+1*t34+1
            t36 = 1/t35
            t37 = 6.264085709464389d-2*t32*t33*t34*t36
            t38 = 1/t10
            t39 = -2.067834969664667d-1/t1**1.3333333333333333d+0
            t40 = t39-4.8930311001203647d-1*t32*t33
            t41 = 1/t13
            t42 = -2.625411059665811d-1*t15*t32*t33*t9-1.0d+0*t10*t15*t4
     1         0*t41
            t43 = 9.690227711544375d-4*t14*t38*t42
            t44 = 1/t17
            t45 = 1/t1**1.6666666666666666d+0
            t46 = -2.067834969664667d-1*t15*t44*t45-6.203504908994001d-1
     1         *t15*t17*t40*t41
            t47 = 5.011795824473985d-2*t14*t44*t46
            t48 = 1/t24**2
            t49 = 2.238166942360001d+1*t48+1
            t50 = 1/t49
            t51 = 1/t26
            t52 = t39-9.26825237694284d-1*t32*t33
            t53 = 1/t27
            t54 = -1.0d+0*t26*t29*t52*t53-2.625411059665811d-1*t25*t29*t
     1         32*t33
            t55 = -6.203504908994001d-1*t17*t29*t52*t53-2.06783496966466
     1         7d-1*t29*t44*t45
            t56 = 2.5058979122369923d-2*t28*t44*t55+2.2478670955426108d-
     1         3*t28*t51*t54+6.519760588836059d-2*t32*t33*t48*t50-5.0117
     2         95824473985d-2*t14*t44*t46-9.690227711544375d-4*t14*t38*t
     3         42-6.264085709464389d-2*t32*t33*t34*t36
            t57 = 1.923661050931536d+0*t23*t56
            t58 = 1/t1**2
            t59 = t19*t58
            t60 = -t20
            t61 = t60+t59
            t62 = t21**3.333333333333333d-1
            t63 = -t19*t58
            t64 = t63+t20
            t65 = t22**3.333333333333333d-1
            t66 = 1.3333333333333333d+0*t64*t65+1.3333333333333333d+0*t6
     1         1*t62
            t67 = 1.923661050931536d+0*t30*t66+t57+t47+t43+t37
            t68 = 1.0d+0*t31*wght
            t69 = t59+t20
            t70 = t63+t60
            t71 = 1.3333333333333333d+0*t65*t70+1.3333333333333333d+0*t6
     1         2*t69
            t72 = 1.923661050931536d+0*t30*t71+t57+t47+t43+t37
            t73 = 1/t1**2.3333333333333334d+0
            t74 = 1/t6**5
            t75 = 1/t35**2
            t76 = -1.2448480831567728d+0*t73*t74*t75
            t77 = 1/t6**3
            t78 = 3.289159980064472d-2*t36*t73*t77
            t79 = 1/t1**1.3333333333333336d+0
            t80 = 1/t3**5
            t81 = -3.1320428547321943d-2*t34*t36*t79*t80
            t82 = 1/t1**1.6666666666666669d+0
            t83 = -4.176057139642926d-2*t33*t34*t36*t82
            t84 = 9.690227711544375d-4*t13*t15*t38*t40*t42
            t85 = 5.011795824473985d-2*t13*t15*t40*t44*t46
            t86 = t40**2
            t87 = 1/t13**2
            t88 = 2.7571132928862224d-1/t1**2.333333333333333d+0
            t89 = t88+3.262020733413577d-1*t33*t82+2.4465155500601823d-1
     1         *t79*t80
            t90 = 1.7502740397772074d-1*t15*t33*t82*t9+1.312705529832905
     1         4d-1*t15*t79*t80*t9+5.250822119331622d-1*t15*t32*t33*t40*
     2         t41*t9-1.0d+0*t10*t15*t41*t89+2.0d+0*t10*t15*t86*t87+3.44
     3         6391616107778d-2*t15*t73
            t91 = 9.690227711544375d-4*t14*t38*t90
            t92 = 1/t9**3
            t93 = 2.544083100456872d-4*t14*t32*t33*t42*t92
            t94 = 1/t1**2.6666666666666666d+0
            t95 = 2.7571132928862224d-1*t15*t44*t94-6.203504908994001d-1
     1         *t15*t17*t41*t89+1.2407009817988002d+0*t15*t17*t86*t87+4.
     2         135669939329334d-1*t15*t40*t41*t44*t45
            t96 = 5.011795824473985d-2*t14*t44*t95
            t97 = 1/t1**9.999999999999999d-1
            t98 = 1.670598608157995d-2*t14*t44*t46*t97
            t99 = 1/t24**5
            t100 = 1/t49**2
            t101 = 1/t24**3
            t102 = t52**2
            t103 = 1/t27**2
            t104 = t88+6.178834917961894d-1*t33*t82+4.63412618847142d-1*
     1         t79*t80
            t105 = 1.7502740397772074d-1*t25*t29*t33*t82+1.3127055298329
     1         054d-1*t25*t29*t79*t80+3.446391616107778d-2*t29*t73+5.250
     2         822119331622d-1*t25*t29*t32*t33*t52*t53-1.0d+0*t104*t26*t
     3         29*t53+2.0d+0*t102*t103*t26*t29
            t106 = 1/t25**3
            t107 = 2.7571132928862224d-1*t29*t44*t94+4.135669939329334d-
     1         1*t29*t44*t45*t52*t53-6.203504908994001d-1*t104*t17*t29*t
     2         53+1.2407009817988002d+0*t102*t103*t17*t29
            t108 = -7.662163788798045d-1*t100*t73*t99+8.352993040789976d
     1         -3*t28*t44*t55*t97-1.670598608157995d-2*t14*t44*t46*t97-5
     2         .011795824473985d-2*t14*t44*t95-2.544083100456872d-4*t14*
     3         t32*t33*t42*t92-9.690227711544375d-4*t14*t38*t90-4.346507
     4         0592240396d-2*t33*t48*t50*t82+4.176057139642926d-2*t33*t3
     5         4*t36*t82-3.2598802944180294d-2*t48*t50*t79*t80+3.1320428
     6         547321943d-2*t34*t36*t79*t80-3.289159980064472d-2*t36*t73
     7         *t77+1.2448480831567728d+0*t73*t74*t75+3.4234103112606934
     8         d-2*t101*t50*t73+2.5058979122369923d-2*t27*t29*t44*t52*t5
     9         5+2.2478670955426108d-3*t27*t29*t51*t52*t54+5.90157513329
     :         6435d-4*t106*t28*t32*t33*t54+2.2478670955426108d-3*t105*t
     ;         28*t51-5.011795824473985d-2*t13*t15*t40*t44*t46+2.5058979
     <         122369923d-2*t107*t28*t44-9.690227711544375d-4*t13*t15*t3
     =         8*t40*t42
            t109 = 1.923661050931536d+0*t108*t23
            t110 = t61**2
            t111 = 1/t21**6.666666666666666d-1
            t112 = 1/t1**3
            t113 = -2*t112*t19
            t114 = 2*t58
            t115 = t114+t113
            t116 = t64**2
            t117 = 1/t22**6.666666666666666d-1
            t118 = 2*t112*t19
            t119 = -2*t58
            t120 = t119+t118
            t121 = 1.3333333333333333d+0*t120*t65+1.3333333333333333d+0*
     1         t115*t62+4.444444444444444d-1*t116*t117+4.444444444444444
     2         d-1*t110*t111
            t122 = t98+t96+t93+t91+t85+t84+t83+t81+t78+t76+3.84732210186
     1         3072d+0*t56*t66+1.923661050931536d+0*t121*t30+t109
            t123 = 4.444444444444444d-1*t117*t64*t70+4.444444444444444d-
     1         1*t111*t61*t69+2.6666666666666666d+0*t112*t19*t65-2.66666
     2         66666666666d+0*t112*t19*t62
            t124 = t98+t96+t93+t91+t85+t84+t83+t81+t78+t76+1.92366105093
     1         1536d+0*t56*t71+1.923661050931536d+0*t56*t66+1.9236610509
     2         31536d+0*t123*t30+t109
            t125 = t69**2
            t126 = t119+t113
            t127 = t70**2
            t128 = t118+t114
            t129 = 1.3333333333333333d+0*t128*t65+1.3333333333333333d+0*
     1         t126*t62+4.444444444444444d-1*t117*t127+4.444444444444444
     2         d-1*t111*t125
            t130 = t98+t96+t93+t91+t85+t84+t83+t81+t78+t76+3.84732210186
     1         3072d+0*t56*t71+1.923661050931536d+0*t129*t30+t109
            t131 = 1/t1**3.0d+0
            t132 = 1/t6**8
            t133 = 1/t35**3
            t134 = 4.947718859586276d+1*t131*t132*t133*t33
            t135 = 1/t6**6
            t136 = -2.2877665475865033d+0*t131*t135*t33*t75
            t137 = 1/t1**3.3333333333333337d+0
            t138 = 4.3569682910487045d+0*t137*t74*t75
            t139 = 1/t6**4
            t140 = 2.590619096601433d-2*t131*t139*t33*t36
            t141 = -1.1512059930225654d-1*t137*t36*t77
            t142 = 1/t1**2.0d+0
            t143 = 1/t3**7
            t144 = 2.610035712276828d-2*t142*t143*t34*t36
            t145 = 6.26408570946439d-2*t34*t36*t73*t80
            t146 = 1/t1**2.666666666666667d+0
            t147 = 6.96009523273821d-2*t146*t33*t34*t36
            t148 = 1.938045542308875d-3*t13*t15*t38*t40*t90
            t149 = 5.088166200913744d-4*t13*t15*t32*t33*t40*t42*t92
            t150 = 9.690227711544375d-4*t13*t15*t38*t42*t89
            t151 = 1.002359164894797d-1*t13*t15*t40*t44*t95
            t152 = 5.011795824473985d-2*t13*t15*t44*t46*t89
            t153 = 3.34119721631599d-2*t13*t15*t40*t44*t46*t97
            t154 = t40**3
            t155 = 1/t13**3
            t156 = -6.433264350067851d-1/t1**3.333333333333333d+0
            t157 = -4.893031100120365d-1*t73*t80-5.436701222355962d-1*t1
     1         46*t33+t156-2.0387629583834851d-1*t142*t143
            t158 = 7.876233178997433d-1*t15*t32*t33*t41*t89*t9-1.5752466
     1         357994865d+0*t15*t32*t33*t86*t87*t9-5.250822119331622d-1*
     2         t15*t33*t40*t41*t82*t9-3.9381165894987163d-1*t15*t40*t41*
     3         t79*t80*t9-2.625411059665811d-1*t15*t73*t80*t9-2.91712339
     4         9628679d-1*t146*t15*t33*t9-1.0939212748607545d-1*t142*t14
     5         3*t15*t9+6.0d+0*t10*t15*t40*t87*t89-1.0339174848323335d-1
     6         *t15*t40*t41*t73-1.0d+0*t10*t15*t157*t41-6.0d+0*t10*t15*t
     7         154*t155-1.2062370656377225d-1*t137*t15
            t159 = 9.690227711544375d-4*t14*t158*t38
            t160 = 5.088166200913744d-4*t14*t32*t33*t90*t92
            t161 = 1/t9**4
            t162 = 1.0018895862972538d-4*t14*t161*t42*t73
            t163 = -1.272041550228436d-4*t14*t42*t79*t80*t92
            t164 = -1.696055400304582d-4*t14*t33*t42*t82*t92
            t165 = 1/t1**3.6666666666666664d+0
            t166 = -8.271339878658668d-1*t15*t40*t41*t44*t94+3.722102945
     1         3964005d+0*t15*t17*t40*t87*t89+6.203504908994001d-1*t15*t
     2         41*t44*t45*t89-1.2407009817988002d+0*t15*t44*t45*t86*t87-
     3         6.433264350067852d-1*t15*t165*t44-6.203504908994001d-1*t1
     4         5*t157*t17*t41-3.7221029453964005d+0*t15*t154*t155*t17
            t167 = 5.011795824473985d-2*t14*t166*t44
            t168 = 3.34119721631599d-2*t14*t44*t95*t97
            t169 = -1.6705986081579946d-2*t14*t142*t44*t46
            t170 = 1/t1**1.9999999999999998d+0
            t171 = 5.568662027193316d-3*t14*t170*t44*t46
            t172 = t52**3
            t173 = 1/t27**3
            t174 = -9.26825237694284d-1*t73*t80-1.0298058196603158d+0*t1
     1         46*t33+t156-3.8617718237261833d-1*t142*t143
            t175 = 1.923661050931536d+0*t23*(2.681757326079316d+0*t100*t
     1         137*t99-3.34119721631599d-2*t14*t44*t95*t97+1.67059860815
     2         7995d-2*t27*t29*t44*t52*t55*t97-3.34119721631599d-2*t13*t
     3         15*t40*t44*t46*t97+1.670598608157995d-2*t107*t28*t44*t97-
     4         1.002359164894797d-1*t13*t15*t40*t44*t95+2.50589791223699
     5         23d-2*t28*t44*(-8.271339878658668d-1*t29*t44*t52*t53*t94+
     6         6.203504908994001d-1*t104*t29*t44*t45*t53-6.2035049089940
     7         01d-1*t17*t174*t29*t53+3.7221029453964005d+0*t103*t104*t1
     8         7*t29*t52-1.2407009817988002d+0*t102*t103*t29*t44*t45-6.4
     9         33264350067852d-1*t165*t29*t44-3.7221029453964005d+0*t17*
     :         t172*t173*t29)-5.088166200913744d-4*t14*t32*t33*t90*t92+1
     ;         .696055400304582d-4*t14*t33*t42*t82*t92+1.272041550228436
     <         d-4*t14*t42*t79*t80*t92-5.088166200913744d-4*t13*t15*t32*
     =         t33*t40*t42*t92-1.938045542308875d-3*t13*t15*t38*t40*t90-
     >         5.011795824473985d-2*t13*t15*t44*t46*t89-9.69022771154437
     ?         5d-4*t13*t15*t38*t42*t89+2.2478670955426108d-3*t28*t51*(-
     @         5.250822119331622d-1*t25*t29*t33*t52*t53*t82-3.9381165894
     1         987163d-1*t25*t29*t52*t53*t79*t80-2.625411059665811d-1*t2
     2         5*t29*t73*t80-1.0339174848323335d-1*t29*t52*t53*t73+7.876
     3         233178997433d-1*t104*t25*t29*t32*t33*t53-1.0d+0*t174*t26*
     4         t29*t53+6.0d+0*t103*t104*t26*t29*t52-1.5752466357994865d+
     5         0*t102*t103*t25*t29*t32*t33-2.917123399628679d-1*t146*t25
     6         *t29*t33-6.0d+0*t172*t173*t26*t29-1.0939212748607545d-1*t
     7         142*t143*t25*t29-1.2062370656377225d-1*t137*t29)-3.934383
     8         422197623d-4*t106*t28*t33*t54*t82-2.9507875666482175d-4*t
     9         106*t28*t54*t79*t80+6.51976058883606d-2*t48*t50*t73*t80-6
     :         .26408570946439d-2*t34*t36*t73*t80+1.1512059930225654d-1*
     ;         t137*t36*t77-4.3569682910487045d+0*t137*t74*t75+2.2877665
     <         475865033d+0*t131*t135*t33*t75+2.3241090936607786d-4*t28*
     =         t54*t73/t25**4-1.0018895862972538d-4*t14*t161*t42*t73+2.5
     >         058979122369923d-2*t104*t27*t29*t44*t55+2.784331013596658
     ?         d-3*t170*t28*t44*t55-8.352993040789973d-3*t142*t28*t44*t5
     @         5+1.1803150266592868d-3*t106*t27*t29*t32*t33*t52*t54+2.24
     1         78670955426108d-3*t104*t27*t29*t51*t54+4.4957341910852217
     2         d-3*t105*t27*t29*t51*t52+5.011795824473985d-2*t107*t27*t2
     3         9*t44*t52+7.244178432040066d-2*t146*t33*t48*t50+2.7165669
     4         12015024d-2*t142*t143*t48*t50+2.69635778788734d-2*t131*t3
     5         3*t50/t24**4-1.1981936089412427d-1*t101*t137*t50+1.800948
     6         1522035156d+1*t131*t33/(t24**8*t49**3)-5.568662027193316d
     7         -3*t14*t170*t44*t46+1.6705986081579946d-2*t14*t142*t44*t4
     8         6-5.011795824473985d-2*t14*t166*t44-9.690227711544375d-4*
     9         t14*t158*t38-6.96009523273821d-2*t146*t33*t34*t36-2.61003
     :         5712276828d-2*t142*t143*t34*t36-2.590619096601433d-2*t131
     ;         *t139*t33*t36+1.1803150266592868d-3*t105*t106*t28*t32*t33
     <         -1.4081430686456894d+0*t100*t131*t33/t24**6-4.94771885958
     =         6276d+1*t131*t132*t133*t33)
            t176 = 1/t21**1.6666666666666669d+0
            t177 = 1/t1**4
            t178 = 6*t177*t19
            t179 = -6*t112
            t180 = 1/t22**1.6666666666666669d+0
            t181 = -6*t177*t19
            t182 = 6*t112
            t183 = 2.0d+0*t124*wght
            t184 = 3.847322101863072d+0*t123*t56
            fnc(iq) = 1.0d+0*t1*t31*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t1*t67*wght+t68+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*t1*t72*wght+t68+Amat(iq,D1_RB)
            Amat2(iq,D2_RA_RA) = 2.0d+0*t67*wght+1.0d+0*t1*t122*wght+Ama
     1         t2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*t72*wght+1.0d+0*t67*wght+1.0d+0*
     1         t1*t124*wght+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 2.0d+0*t72*wght+1.0d+0*t1*t130*wght+Ama
     1         t2(iq,D2_RB_RB)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*t1*(5.770983152794609d+0*t108
     1         *t66+1.923661050931536d+0*t30*(1.3333333333333333d+0*(t18
     2         2+t181)*t65-2.962962962962963d-1*t180*t64**3+1.3333333333
     3         333333d+0*t117*t120*t64+1.3333333333333333d+0*(t179+t178)
     4         *t62-2.962962962962963d-1*t176*t61**3+1.3333333333333333d
     5         +0*t111*t115*t61)+5.770983152794609d+0*t121*t56+t175+t171
     6         +t169+t168+t167+t164+t163+t162+t160+t159+t153+t152+t151+t
     7         150+t149+t148+t147+t145+t144+t141+t140+t138+t136+t134)*wg
     8         ht+3.0d+0*t122*wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = 1.0d+0*t1*(1.923661050931536d+0*t108
     1         *t71+1.923661050931536d+0*t30*(-2.962962962962963d-1*t116
     2         *t180*t70+4.444444444444444d-1*t117*t120*t70-2.9629629629
     3         62963d-1*t110*t176*t69+4.444444444444444d-1*t111*t115*t69
     4         +1.3333333333333333d+0*(t181+2*t112)*t65+1.77777777777777
     5         76d+0*t112*t117*t19*t64+1.3333333333333333d+0*(t178-2*t11
     6         2)*t62-1.7777777777777776d+0*t111*t112*t19*t61)+3.8473221
     7         01863072d+0*t108*t66+1.923661050931536d+0*t121*t56+t184+t
     8         175+t171+t169+t168+t167+t164+t163+t162+t160+t159+t153+t15
     9         2+t151+t150+t149+t148+t147+t145+t144+t141+t140+t138+t136+
     :         t134)*wght+1.0d+0*t122*wght+t183+Amat3(iq,D3_RA_RA_RB)
            Amat3(iq,D3_RA_RB_RB) = 1.0d+0*t1*(3.847322101863072d+0*t108
     1         *t71+1.923661050931536d+0*t30*(1.7777777777777776d+0*t112
     2         *t117*t19*t70-1.7777777777777776d+0*t111*t112*t19*t69-8*t
     3         177*t19*t65-2.6666666666666666d+0*t112*t65-2.962962962962
     4         963d-1*t127*t180*t64+4.444444444444444d-1*t117*t128*t64+8
     5         *t177*t19*t62+2.6666666666666666d+0*t112*t62-2.9629629629
     6         62963d-1*t125*t176*t61+4.444444444444444d-1*t111*t126*t61
     7         )+1.923661050931536d+0*t108*t66+1.923661050931536d+0*t129
     8         *t56+t184+t175+t171+t169+t168+t167+t164+t163+t162+t160+t1
     9         59+t153+t152+t151+t150+t149+t148+t147+t145+t144+t141+t140
     :         +t138+t136+t134)*wght+1.0d+0*t130*wght+t183+Amat3(iq,D3_R
     ;         A_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*t1*(5.770983152794609d+0*t108
     1         *t71+1.923661050931536d+0*t30*(-2.962962962962963d-1*t180
     2         *t70**3+1.3333333333333333d+0*t117*t128*t70-2.96296296296
     3         2963d-1*t176*t69**3+1.3333333333333333d+0*t111*t126*t69+1
     4         .3333333333333333d+0*(t181+t179)*t65+1.3333333333333333d+
     5         0*(t182+t178)*t62)+5.770983152794609d+0*t129*t56+t175+t17
     6         1+t169+t168+t167+t164+t163+t162+t160+t159+t153+t152+t151+
     7         t150+t149+t148+t147+t145+t144+t141+t140+t138+t136+t134)*w
     8         ght+3.0d+0*t130*wght+Amat3(iq,D3_RB_RB_RB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = t11+3.25d-1
            t22 = t21**2
            t23 = t15+7.06042d+0
            t24 = 9.99999999999999d-1*(1.554535d-2*log(6.203504908994001
     1         d-1*t20*t9)+5.249139316978092d-2*atan(4.7309269095601136d
     2         +0/t23)+2.2478670955426108d-3*log(1.0d+0*t20*t22)-3.87832
     3         94878113006d-2*t17-9.690227711544375d-4*t14-3.10907d-2*t1
     4         0)+3.8783294878113006d-2*t17+9.690227711544375d-4*t14+3.1
     5         0907d-2*t10
            t25 = 1/t9
            t26 = -2.067834969664667d-1/rhoa**1.3333333333333333d+0
            t27 = 1/t2**3
            t28 = 1/rhoa**6.666666666666667d-1
            t29 = t26-4.8930311001203647d-1*t27*t28
            t30 = 1/t6
            t31 = 1/rhoa**1.6666666666666666d+0
            t32 = -6.203504908994001d-1*t29*t30*t8*t9-2.067834969664667d
     1         -1*t25*t31*t8
            t33 = 1/t16**2
            t34 = 3.784699104639999d+1*t33+1
            t35 = 1/t34
            t36 = 1/t13
            t37 = -1.0d+0*t13*t29*t30*t8-2.625411059665811d-1*t12*t27*t2
     1         8*t8
            t38 = t26-9.26825237694284d-1*t27*t28
            t39 = 1/t18
            t40 = -6.203504908994001d-1*t20*t38*t39*t9-2.067834969664667
     1         d-1*t20*t25*t31
            t41 = 1/t23**2
            t42 = 2.238166942360001d+1*t41+1
            t43 = 1/t42
            t44 = 1/t22
            t45 = -1.0d+0*t20*t22*t38*t39-2.625411059665811d-1*t20*t21*t
     1         27*t28
            t46 = 9.99999999999999d-1*(-9.690227711544375d-4*t36*t37*t7-
     1         5.011795824473985d-2*t25*t32*t7+2.2478670955426108d-3*t19
     2         *t44*t45+6.519760588836059d-2*t27*t28*t41*t43+2.505897912
     3         2369923d-2*t19*t25*t40-6.264085709464389d-2*t27*t28*t33*t
     4         35)+9.690227711544375d-4*t36*t37*t7+5.011795824473985d-2*
     5         t25*t32*t7+6.264085709464389d-2*t27*t28*t33*t35
            t47 = 1/t34**2
            t48 = 1/t16**5
            t49 = 1/rhoa**2.3333333333333334d+0
            t50 = 1/t16**3
            t51 = 1/rhoa**1.6666666666666669d+0
            t52 = t29**2
            t53 = 1/t6**2
            t54 = 2.7571132928862224d-1/rhoa**2.333333333333333d+0
            t55 = 1/t2**5
            t56 = 1/rhoa**1.3333333333333336d+0
            t57 = 2.4465155500601823d-1*t55*t56+t54+3.262020733413577d-1
     1         *t27*t51
            t58 = 1/rhoa**2.6666666666666666d+0
            t59 = -6.203504908994001d-1*t30*t57*t8*t9+1.2407009817988002
     1         d+0*t52*t53*t8*t9+2.7571132928862224d-1*t25*t58*t8+4.1356
     2         69939329334d-1*t25*t29*t30*t31*t8
            t60 = 1/rhoa**9.999999999999999d-1
            t61 = 1/t12**3
            t62 = -1.0d+0*t13*t30*t57*t8+1.3127055298329054d-1*t12*t55*t
     1         56*t8+2.0d+0*t13*t52*t53*t8+1.7502740397772074d-1*t12*t27
     2         *t51*t8+3.446391616107778d-2*t49*t8+5.250822119331622d-1*
     3         t12*t27*t28*t29*t30*t8
            t63 = 1/t42**2
            t64 = 1/t23**5
            t65 = 1/t23**3
            t66 = t38**2
            t67 = 1/t18**2
            t68 = 4.63412618847142d-1*t55*t56+t54+6.178834917961894d-1*t
     1         27*t51
            t69 = -6.203504908994001d-1*t20*t39*t68*t9+1.240700981798800
     1         2d+0*t20*t66*t67*t9+2.7571132928862224d-1*t20*t25*t58+4.1
     2         35669939329334d-1*t20*t25*t31*t38*t39
            t70 = 1/t21**3
            t71 = -1.0d+0*t20*t22*t39*t68+2.0d+0*t20*t22*t66*t67+1.31270
     1         55298329054d-1*t20*t21*t55*t56+1.7502740397772074d-1*t20*
     2         t21*t27*t51+3.446391616107778d-2*t20*t49+5.25082211933162
     3         2d-1*t20*t21*t27*t28*t38*t39
            t72 = 9.99999999999999d-1*(-9.690227711544375d-4*t29*t36*t37
     1         *t6*t8-5.011795824473985d-2*t25*t29*t32*t6*t8+2.247867095
     2         5426108d-3*t19*t44*t71+5.901575133296435d-4*t19*t27*t28*t
     3         45*t70-9.690227711544375d-4*t36*t62*t7-2.544083100456872d
     4         -4*t27*t28*t37*t61*t7-1.670598608157995d-2*t25*t32*t60*t7
     5         -5.011795824473985d-2*t25*t59*t7+2.5058979122369923d-2*t1
     6         9*t25*t69+3.4234103112606934d-2*t43*t49*t65-7.66216378879
     7         8045d-1*t49*t63*t64+8.352993040789976d-3*t19*t25*t40*t60-
     8         3.2598802944180294d-2*t41*t43*t55*t56+3.1320428547321943d
     9         -2*t33*t35*t55*t56-4.3465070592240396d-2*t27*t41*t43*t51+
     :         4.176057139642926d-2*t27*t33*t35*t51-3.289159980064472d-2
     ;         *t35*t49*t50+1.2448480831567728d+0*t47*t48*t49+2.24786709
     <         55426108d-3*t18*t20*t38*t44*t45+2.5058979122369923d-2*t18
     =         *t20*t25*t38*t40)+9.690227711544375d-4*t29*t36*t37*t6*t8+
     >         5.011795824473985d-2*t25*t29*t32*t6*t8+9.690227711544375d
     ?         -4*t36*t62*t7+2.544083100456872d-4*t27*t28*t37*t61*t7+1.6
     @         70598608157995d-2*t25*t32*t60*t7+5.011795824473985d-2*t25
     1         *t59*t7-3.1320428547321943d-2*t33*t35*t55*t56-4.176057139
     2         642926d-2*t27*t33*t35*t51+3.289159980064472d-2*t35*t49*t5
     3         0-1.2448480831567728d+0*t47*t48*t49
            t73 = 1/rhoa**3.3333333333333337d+0
            t74 = 1/t34**3
            t75 = 1/t16**8
            t76 = 1/rhoa**3.0d+0
            t77 = 1/t16**6
            t78 = 1/t16**4
            t79 = 1/rhoa**2.666666666666667d+0
            t80 = 1/t12**4
            t81 = 1/t2**7
            t82 = 1/rhoa**2.0d+0
            t83 = 1/rhoa**1.9999999999999998d+0
            t84 = t29**3
            t85 = 1/t6**3
            t86 = -6.433264350067851d-1/rhoa**3.333333333333333d+0
            t87 = t86-2.0387629583834851d-1*t81*t82-5.436701222355962d-1
     1         *t27*t79-4.893031100120365d-1*t49*t55
            t88 = 1/rhoa**3.6666666666666664d+0
            t89 = -6.203504908994001d-1*t30*t8*t87*t9-3.7221029453964005
     1         d+0*t8*t84*t85*t9+3.7221029453964005d+0*t29*t53*t57*t8*t9
     2         -6.433264350067852d-1*t25*t8*t88-8.271339878658668d-1*t25
     3         *t29*t30*t58*t8+6.203504908994001d-1*t25*t30*t31*t57*t8-1
     4         .2407009817988002d+0*t25*t31*t52*t53*t8
            t90 = -1.0d+0*t13*t30*t8*t87-6.0d+0*t13*t8*t84*t85-1.0939212
     1         748607545d-1*t12*t8*t81*t82-2.917123399628679d-1*t12*t27*
     2         t79*t8-1.2062370656377223d-1*t73*t8+6.0d+0*t13*t29*t53*t5
     3         7*t8+7.876233178997433d-1*t12*t27*t28*t30*t57*t8-3.938116
     4         5894987163d-1*t12*t29*t30*t55*t56*t8-2.625411059665811d-1
     5         *t12*t49*t55*t8-1.5752466357994865d+0*t12*t27*t28*t52*t53
     6         *t8-5.250822119331622d-1*t12*t27*t29*t30*t51*t8-1.0339174
     7         848323335d-1*t29*t30*t49*t8
            t91 = t38**3
            t92 = 1/t18**3
            t93 = t86-3.8617718237261833d-1*t81*t82-1.0298058196603158d+
     1         0*t27*t79-9.26825237694284d-1*t49*t55
            fnc(iq) = 1.0d+0*rhoa*t24*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*t46*wght+1.0d+0*t24*wght+Amat(i
     1         q,D1_RA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*rhoa*t72*wght+2.0d+0*t46*wght+Am
     1         at2(iq,D2_RA_RA)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*rhoa*(9.99999999999999d-1*(2.
     1         5058979122369923d-2*t19*t25*(-6.203504908994001d-1*t20*t3
     2         9*t9*t93-3.7221029453964005d+0*t20*t9*t91*t92+3.722102945
     3         3964005d+0*t20*t38*t67*t68*t9-6.433264350067852d-1*t20*t2
     4         5*t88+6.203504908994001d-1*t20*t25*t31*t39*t68-1.24070098
     5         17988002d+0*t20*t25*t31*t66*t67-8.271339878658668d-1*t20*
     6         t25*t38*t39*t58)+2.2478670955426108d-3*t19*t44*(-1.0d+0*t
     7         20*t22*t39*t93-6.0d+0*t20*t22*t91*t92-1.0939212748607545d
     8         -1*t20*t21*t81*t82-2.917123399628679d-1*t20*t21*t27*t79-1
     9         .2062370656377223d-1*t20*t73+6.0d+0*t20*t22*t38*t67*t68+7
     :         .876233178997433d-1*t20*t21*t27*t28*t39*t68-1.57524663579
     ;         94865d+0*t20*t21*t27*t28*t66*t67-3.9381165894987163d-1*t2
     <         0*t21*t38*t39*t55*t56-2.625411059665811d-1*t20*t21*t49*t5
     =         5-5.250822119331622d-1*t20*t21*t27*t38*t39*t51-1.03391748
     >         48323335d-1*t20*t38*t39*t49)-9.690227711544375d-4*t36*t7*
     ?         t90-5.011795824473985d-2*t25*t7*t89-5.568662027193316d-3*
     @         t25*t32*t7*t83+2.784331013596658d-3*t19*t25*t40*t83+2.716
     1         566912015024d-2*t41*t43*t81*t82-2.610035712276828d-2*t33*
     2         t35*t81*t82+1.6705986081579946d-2*t25*t32*t7*t82-8.352993
     3         040789973d-3*t19*t25*t40*t82-1.0018895862972538d-4*t37*t4
     4         9*t7*t80-1.938045542308875d-3*t29*t36*t6*t62*t8-5.0881662
     5         00913744d-4*t27*t28*t29*t37*t6*t61*t8-3.34119721631599d-2
     6         *t25*t29*t32*t6*t60*t8-1.002359164894797d-1*t25*t29*t59*t
     7         6*t8-9.690227711544375d-4*t36*t37*t57*t6*t8-5.01179582447
     8         3985d-2*t25*t32*t57*t6*t8+7.244178432040066d-2*t27*t41*t4
     9         3*t79-6.96009523273821d-2*t27*t33*t35*t79-2.5906190966014
     :         33d-2*t27*t35*t76*t78+2.2877665475865033d+0*t27*t47*t76*t
     ;         77-4.947718859586276d+1*t27*t74*t75*t76-1.408143068645689
     <         4d+0*t27*t63*t76/t23**6+2.69635778788734d-2*t27*t43*t76/t
     =         23**4+1.8009481522035156d+1*t27*t76/(t23**8*t42**3)-1.198
     >         1936089412427d-1*t43*t65*t73+2.681757326079316d+0*t63*t64
     ?         *t73+1.1512059930225654d-1*t35*t50*t73-4.356968291048705d
     @         +0*t47*t48*t73+1.1803150266592868d-3*t19*t27*t28*t70*t71+
     1         4.4957341910852217d-3*t18*t20*t38*t44*t71-2.9507875666482
     2         175d-4*t19*t45*t55*t56*t70-3.934383422197623d-4*t19*t27*t
     3         45*t51*t70+1.1803150266592868d-3*t18*t20*t27*t28*t38*t45*
     4         t70-5.088166200913744d-4*t27*t28*t61*t62*t7+1.27204155022
     5         8436d-4*t37*t55*t56*t61*t7+1.696055400304582d-4*t27*t37*t
     6         51*t61*t7-3.34119721631599d-2*t25*t59*t60*t7+1.6705986081
     7         57995d-2*t19*t25*t60*t69+5.011795824473985d-2*t18*t20*t25
     8         *t38*t69+2.2478670955426108d-3*t18*t20*t44*t45*t68+2.5058
     9         979122369923d-2*t18*t20*t25*t40*t68+1.670598608157995d-2*
     :         t18*t20*t25*t38*t40*t60+6.51976058883606d-2*t41*t43*t49*t
     ;         55-6.26408570946439d-2*t33*t35*t49*t55+2.3241090936607786
     <         d-4*t19*t45*t49/t21**4)+9.690227711544375d-4*t36*t7*t90+5
     =         .011795824473985d-2*t25*t7*t89+5.568662027193316d-3*t25*t
     >         32*t7*t83+2.610035712276828d-2*t33*t35*t81*t82-1.67059860
     ?         81579946d-2*t25*t32*t7*t82+1.0018895862972538d-4*t37*t49*
     @         t7*t80+1.938045542308875d-3*t29*t36*t6*t62*t8+5.088166200
     1         913744d-4*t27*t28*t29*t37*t6*t61*t8+3.34119721631599d-2*t
     2         25*t29*t32*t6*t60*t8+1.002359164894797d-1*t25*t29*t59*t6*
     3         t8+9.690227711544375d-4*t36*t37*t57*t6*t8+5.0117958244739
     4         85d-2*t25*t32*t57*t6*t8+6.96009523273821d-2*t27*t33*t35*t
     5         79+2.590619096601433d-2*t27*t35*t76*t78-2.287766547586503
     6         3d+0*t27*t47*t76*t77+4.947718859586276d+1*t27*t74*t75*t76
     7         -1.1512059930225654d-1*t35*t50*t73+4.356968291048705d+0*t
     8         47*t48*t73+5.088166200913744d-4*t27*t28*t61*t62*t7-1.2720
     9         41550228436d-4*t37*t55*t56*t61*t7-1.696055400304582d-4*t2
     :         7*t37*t51*t61*t7+3.34119721631599d-2*t25*t59*t60*t7+6.264
     ;         08570946439d-2*t33*t35*t49*t55)*wght+3.0d+0*t72*wght+Amat
     <         3(iq,D3_RA_RA_RA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = t11+3.25d-1
            t22 = t21**2
            t23 = t15+7.06042d+0
            t24 = 9.99999999999999d-1*(1.554535d-2*log(6.203504908994001
     1         d-1*t20*t9)+5.249139316978092d-2*atan(4.7309269095601136d
     2         +0/t23)+2.2478670955426108d-3*log(1.0d+0*t20*t22)-3.87832
     3         94878113006d-2*t17-9.690227711544375d-4*t14-3.10907d-2*t1
     4         0)+3.8783294878113006d-2*t17+9.690227711544375d-4*t14+3.1
     5         0907d-2*t10
            t25 = 1/t9
            t26 = -2.067834969664667d-1/rhob**1.3333333333333333d+0
            t27 = 1/t2**3
            t28 = 1/rhob**6.666666666666667d-1
            t29 = t26-4.8930311001203647d-1*t27*t28
            t30 = 1/t6
            t31 = 1/rhob**1.6666666666666666d+0
            t32 = -6.203504908994001d-1*t29*t30*t8*t9-2.067834969664667d
     1         -1*t25*t31*t8
            t33 = 1/t16**2
            t34 = 3.784699104639999d+1*t33+1
            t35 = 1/t34
            t36 = 1/t13
            t37 = -1.0d+0*t13*t29*t30*t8-2.625411059665811d-1*t12*t27*t2
     1         8*t8
            t38 = t26-9.26825237694284d-1*t27*t28
            t39 = 1/t18
            t40 = -6.203504908994001d-1*t20*t38*t39*t9-2.067834969664667
     1         d-1*t20*t25*t31
            t41 = 1/t23**2
            t42 = 2.238166942360001d+1*t41+1
            t43 = 1/t42
            t44 = 1/t22
            t45 = -1.0d+0*t20*t22*t38*t39-2.625411059665811d-1*t20*t21*t
     1         27*t28
            t46 = 9.99999999999999d-1*(-9.690227711544375d-4*t36*t37*t7-
     1         5.011795824473985d-2*t25*t32*t7+2.2478670955426108d-3*t19
     2         *t44*t45+6.519760588836059d-2*t27*t28*t41*t43+2.505897912
     3         2369923d-2*t19*t25*t40-6.264085709464389d-2*t27*t28*t33*t
     4         35)+9.690227711544375d-4*t36*t37*t7+5.011795824473985d-2*
     5         t25*t32*t7+6.264085709464389d-2*t27*t28*t33*t35
            t47 = 1/t34**2
            t48 = 1/t16**5
            t49 = 1/rhob**2.3333333333333334d+0
            t50 = 1/t16**3
            t51 = 1/rhob**1.6666666666666669d+0
            t52 = t29**2
            t53 = 1/t6**2
            t54 = 2.7571132928862224d-1/rhob**2.333333333333333d+0
            t55 = 1/t2**5
            t56 = 1/rhob**1.3333333333333336d+0
            t57 = 2.4465155500601823d-1*t55*t56+t54+3.262020733413577d-1
     1         *t27*t51
            t58 = 1/rhob**2.6666666666666666d+0
            t59 = -6.203504908994001d-1*t30*t57*t8*t9+1.2407009817988002
     1         d+0*t52*t53*t8*t9+2.7571132928862224d-1*t25*t58*t8+4.1356
     2         69939329334d-1*t25*t29*t30*t31*t8
            t60 = 1/rhob**9.999999999999999d-1
            t61 = 1/t12**3
            t62 = -1.0d+0*t13*t30*t57*t8+1.3127055298329054d-1*t12*t55*t
     1         56*t8+2.0d+0*t13*t52*t53*t8+1.7502740397772074d-1*t12*t27
     2         *t51*t8+3.446391616107778d-2*t49*t8+5.250822119331622d-1*
     3         t12*t27*t28*t29*t30*t8
            t63 = 1/t42**2
            t64 = 1/t23**5
            t65 = 1/t23**3
            t66 = t38**2
            t67 = 1/t18**2
            t68 = 4.63412618847142d-1*t55*t56+t54+6.178834917961894d-1*t
     1         27*t51
            t69 = -6.203504908994001d-1*t20*t39*t68*t9+1.240700981798800
     1         2d+0*t20*t66*t67*t9+2.7571132928862224d-1*t20*t25*t58+4.1
     2         35669939329334d-1*t20*t25*t31*t38*t39
            t70 = 1/t21**3
            t71 = -1.0d+0*t20*t22*t39*t68+2.0d+0*t20*t22*t66*t67+1.31270
     1         55298329054d-1*t20*t21*t55*t56+1.7502740397772074d-1*t20*
     2         t21*t27*t51+3.446391616107778d-2*t20*t49+5.25082211933162
     3         2d-1*t20*t21*t27*t28*t38*t39
            t72 = 9.99999999999999d-1*(-9.690227711544375d-4*t29*t36*t37
     1         *t6*t8-5.011795824473985d-2*t25*t29*t32*t6*t8+2.247867095
     2         5426108d-3*t19*t44*t71+5.901575133296435d-4*t19*t27*t28*t
     3         45*t70-9.690227711544375d-4*t36*t62*t7-2.544083100456872d
     4         -4*t27*t28*t37*t61*t7-1.670598608157995d-2*t25*t32*t60*t7
     5         -5.011795824473985d-2*t25*t59*t7+2.5058979122369923d-2*t1
     6         9*t25*t69+3.4234103112606934d-2*t43*t49*t65-7.66216378879
     7         8045d-1*t49*t63*t64+8.352993040789976d-3*t19*t25*t40*t60-
     8         3.2598802944180294d-2*t41*t43*t55*t56+3.1320428547321943d
     9         -2*t33*t35*t55*t56-4.3465070592240396d-2*t27*t41*t43*t51+
     :         4.176057139642926d-2*t27*t33*t35*t51-3.289159980064472d-2
     ;         *t35*t49*t50+1.2448480831567728d+0*t47*t48*t49+2.24786709
     <         55426108d-3*t18*t20*t38*t44*t45+2.5058979122369923d-2*t18
     =         *t20*t25*t38*t40)+9.690227711544375d-4*t29*t36*t37*t6*t8+
     >         5.011795824473985d-2*t25*t29*t32*t6*t8+9.690227711544375d
     ?         -4*t36*t62*t7+2.544083100456872d-4*t27*t28*t37*t61*t7+1.6
     @         70598608157995d-2*t25*t32*t60*t7+5.011795824473985d-2*t25
     1         *t59*t7-3.1320428547321943d-2*t33*t35*t55*t56-4.176057139
     2         642926d-2*t27*t33*t35*t51+3.289159980064472d-2*t35*t49*t5
     3         0-1.2448480831567728d+0*t47*t48*t49
            t73 = 1/rhob**3.3333333333333337d+0
            t74 = 1/t34**3
            t75 = 1/t16**8
            t76 = 1/rhob**3.0d+0
            t77 = 1/t16**6
            t78 = 1/t16**4
            t79 = 1/rhob**2.666666666666667d+0
            t80 = 1/t12**4
            t81 = 1/t2**7
            t82 = 1/rhob**2.0d+0
            t83 = 1/rhob**1.9999999999999998d+0
            t84 = t29**3
            t85 = 1/t6**3
            t86 = -6.433264350067851d-1/rhob**3.333333333333333d+0
            t87 = t86-2.0387629583834851d-1*t81*t82-5.436701222355962d-1
     1         *t27*t79-4.893031100120365d-1*t49*t55
            t88 = 1/rhob**3.6666666666666664d+0
            t89 = -6.203504908994001d-1*t30*t8*t87*t9-3.7221029453964005
     1         d+0*t8*t84*t85*t9+3.7221029453964005d+0*t29*t53*t57*t8*t9
     2         -6.433264350067852d-1*t25*t8*t88-8.271339878658668d-1*t25
     3         *t29*t30*t58*t8+6.203504908994001d-1*t25*t30*t31*t57*t8-1
     4         .2407009817988002d+0*t25*t31*t52*t53*t8
            t90 = -1.0d+0*t13*t30*t8*t87-6.0d+0*t13*t8*t84*t85-1.0939212
     1         748607545d-1*t12*t8*t81*t82-2.917123399628679d-1*t12*t27*
     2         t79*t8-1.2062370656377223d-1*t73*t8+6.0d+0*t13*t29*t53*t5
     3         7*t8+7.876233178997433d-1*t12*t27*t28*t30*t57*t8-3.938116
     4         5894987163d-1*t12*t29*t30*t55*t56*t8-2.625411059665811d-1
     5         *t12*t49*t55*t8-1.5752466357994865d+0*t12*t27*t28*t52*t53
     6         *t8-5.250822119331622d-1*t12*t27*t29*t30*t51*t8-1.0339174
     7         848323335d-1*t29*t30*t49*t8
            t91 = t38**3
            t92 = 1/t18**3
            t93 = t86-3.8617718237261833d-1*t81*t82-1.0298058196603158d+
     1         0*t27*t79-9.26825237694284d-1*t49*t55
            fnc(iq) = 1.0d+0*rhob*t24*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*t46*wght+1.0d+0*t24*wght+Amat(i
     1         q,D1_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*rhob*t72*wght+2.0d+0*t46*wght+Am
     1         at2(iq,D2_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*rhob*(9.99999999999999d-1*(2.
     1         5058979122369923d-2*t19*t25*(-6.203504908994001d-1*t20*t3
     2         9*t9*t93-3.7221029453964005d+0*t20*t9*t91*t92+3.722102945
     3         3964005d+0*t20*t38*t67*t68*t9-6.433264350067852d-1*t20*t2
     4         5*t88+6.203504908994001d-1*t20*t25*t31*t39*t68-1.24070098
     5         17988002d+0*t20*t25*t31*t66*t67-8.271339878658668d-1*t20*
     6         t25*t38*t39*t58)+2.2478670955426108d-3*t19*t44*(-1.0d+0*t
     7         20*t22*t39*t93-6.0d+0*t20*t22*t91*t92-1.0939212748607545d
     8         -1*t20*t21*t81*t82-2.917123399628679d-1*t20*t21*t27*t79-1
     9         .2062370656377223d-1*t20*t73+6.0d+0*t20*t22*t38*t67*t68+7
     :         .876233178997433d-1*t20*t21*t27*t28*t39*t68-1.57524663579
     ;         94865d+0*t20*t21*t27*t28*t66*t67-3.9381165894987163d-1*t2
     <         0*t21*t38*t39*t55*t56-2.625411059665811d-1*t20*t21*t49*t5
     =         5-5.250822119331622d-1*t20*t21*t27*t38*t39*t51-1.03391748
     >         48323335d-1*t20*t38*t39*t49)-9.690227711544375d-4*t36*t7*
     ?         t90-5.011795824473985d-2*t25*t7*t89-5.568662027193316d-3*
     @         t25*t32*t7*t83+2.784331013596658d-3*t19*t25*t40*t83+2.716
     1         566912015024d-2*t41*t43*t81*t82-2.610035712276828d-2*t33*
     2         t35*t81*t82+1.6705986081579946d-2*t25*t32*t7*t82-8.352993
     3         040789973d-3*t19*t25*t40*t82-1.0018895862972538d-4*t37*t4
     4         9*t7*t80-1.938045542308875d-3*t29*t36*t6*t62*t8-5.0881662
     5         00913744d-4*t27*t28*t29*t37*t6*t61*t8-3.34119721631599d-2
     6         *t25*t29*t32*t6*t60*t8-1.002359164894797d-1*t25*t29*t59*t
     7         6*t8-9.690227711544375d-4*t36*t37*t57*t6*t8-5.01179582447
     8         3985d-2*t25*t32*t57*t6*t8+7.244178432040066d-2*t27*t41*t4
     9         3*t79-6.96009523273821d-2*t27*t33*t35*t79-2.5906190966014
     :         33d-2*t27*t35*t76*t78+2.2877665475865033d+0*t27*t47*t76*t
     ;         77-4.947718859586276d+1*t27*t74*t75*t76-1.408143068645689
     <         4d+0*t27*t63*t76/t23**6+2.69635778788734d-2*t27*t43*t76/t
     =         23**4+1.8009481522035156d+1*t27*t76/(t23**8*t42**3)-1.198
     >         1936089412427d-1*t43*t65*t73+2.681757326079316d+0*t63*t64
     ?         *t73+1.1512059930225654d-1*t35*t50*t73-4.356968291048705d
     @         +0*t47*t48*t73+1.1803150266592868d-3*t19*t27*t28*t70*t71+
     1         4.4957341910852217d-3*t18*t20*t38*t44*t71-2.9507875666482
     2         175d-4*t19*t45*t55*t56*t70-3.934383422197623d-4*t19*t27*t
     3         45*t51*t70+1.1803150266592868d-3*t18*t20*t27*t28*t38*t45*
     4         t70-5.088166200913744d-4*t27*t28*t61*t62*t7+1.27204155022
     5         8436d-4*t37*t55*t56*t61*t7+1.696055400304582d-4*t27*t37*t
     6         51*t61*t7-3.34119721631599d-2*t25*t59*t60*t7+1.6705986081
     7         57995d-2*t19*t25*t60*t69+5.011795824473985d-2*t18*t20*t25
     8         *t38*t69+2.2478670955426108d-3*t18*t20*t44*t45*t68+2.5058
     9         979122369923d-2*t18*t20*t25*t40*t68+1.670598608157995d-2*
     :         t18*t20*t25*t38*t40*t60+6.51976058883606d-2*t41*t43*t49*t
     ;         55-6.26408570946439d-2*t33*t35*t49*t55+2.3241090936607786
     <         d-4*t19*t45*t49/t21**4)+9.690227711544375d-4*t36*t7*t90+5
     =         .011795824473985d-2*t25*t7*t89+5.568662027193316d-3*t25*t
     >         32*t7*t83+2.610035712276828d-2*t33*t35*t81*t82-1.67059860
     ?         81579946d-2*t25*t32*t7*t82+1.0018895862972538d-4*t37*t49*
     @         t7*t80+1.938045542308875d-3*t29*t36*t6*t62*t8+5.088166200
     1         913744d-4*t27*t28*t29*t37*t6*t61*t8+3.34119721631599d-2*t
     2         25*t29*t32*t6*t60*t8+1.002359164894797d-1*t25*t29*t59*t6*
     3         t8+9.690227711544375d-4*t36*t37*t57*t6*t8+5.0117958244739
     4         85d-2*t25*t32*t57*t6*t8+6.96009523273821d-2*t27*t33*t35*t
     5         79+2.590619096601433d-2*t27*t35*t76*t78-2.287766547586503
     6         3d+0*t27*t47*t76*t77+4.947718859586276d+1*t27*t74*t75*t76
     7         -1.1512059930225654d-1*t35*t50*t73+4.356968291048705d+0*t
     8         47*t48*t73+5.088166200913744d-4*t27*t28*t61*t62*t7-1.2720
     9         41550228436d-4*t37*t55*t56*t61*t7-1.696055400304582d-4*t2
     :         7*t37*t51*t61*t7+3.34119721631599d-2*t25*t59*t60*t7+6.264
     ;         08570946439d-2*t33*t35*t49*t55)*wght+3.0d+0*t72*wght+Amat
     <         3(iq,D3_RB_RB_RB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
