/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service;

import java.util.List;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.chefproject.core.Site;
import org.chefproject.core.SiteEdit;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.generic.GenericSiteService;

public class SiteService {
    protected static GenericSiteService M_service = null;

    protected static void find() {
        if (M_service == null && (M_service = (GenericSiteService)((Object)TurbineServices.getInstance().getService(GenericSiteService.SERVICE_NAME))) == null) {
            Log.warn("chef", "SiteService.find: missing service: " + GenericSiteService.SERVICE_NAME);
        }
    }

    public static GenericSiteService getInstance() {
        SiteService.find();
        return M_service;
    }

    public static boolean allowAccessSite(String id) {
        SiteService.find();
        return M_service.allowAccessSite(id);
    }

    public static Site getSite(String id) throws IdUnusedException {
        SiteService.find();
        return M_service.getSite(id);
    }

    public static boolean allowUpdateSite(String id) {
        SiteService.find();
        return M_service.allowUpdateSite(id);
    }

    public static SiteEdit editSite(String id) throws IdUnusedException, PermissionException, InUseException {
        SiteService.find();
        return M_service.editSite(id);
    }

    public static void commitEdit(SiteEdit site) {
        SiteService.find();
        M_service.commitEdit(site);
    }

    public static void cancelEdit(SiteEdit site) {
        SiteService.find();
        M_service.cancelEdit(site);
    }

    public static List getSites() {
        SiteService.find();
        return M_service.getSites();
    }

    public static boolean allowAddSite(String id) {
        SiteService.find();
        return M_service.allowAddSite(id);
    }

    public static SiteEdit addSite(String id) throws IdInvalidException, IdUsedException, PermissionException {
        SiteService.find();
        return M_service.addSite(id);
    }

    public static SiteEdit addSite(String id, Site other) throws IdInvalidException, IdUsedException, PermissionException {
        SiteService.find();
        return M_service.addSite(id, other);
    }

    public static boolean allowRemoveSite(String id) {
        SiteService.find();
        return M_service.allowRemoveSite(id);
    }

    public static void removeSite(SiteEdit site) throws IdUnusedException, PermissionException {
        SiteService.find();
        M_service.removeSite(site);
    }

    public static String siteReference(String id) {
        SiteService.find();
        return M_service.siteReference(id);
    }

    public static String sitePageReference(String siteId, String pageId) {
        SiteService.find();
        return M_service.sitePageReference(siteId, pageId);
    }

    public static String siteToolReference(String siteId, String toolId) {
        SiteService.find();
        return M_service.siteToolReference(siteId, toolId);
    }

    public static boolean isUserSite(String site) {
        SiteService.find();
        return M_service.isUserSite(site);
    }

    public static String getSiteUserId(String site) {
        SiteService.find();
        return M_service.getSiteUserId(site);
    }

    public static String getUserSiteId(String userId) {
        SiteService.find();
        return M_service.getUserSiteId(userId);
    }

    public static boolean isSpecialSite(String site) {
        SiteService.find();
        return M_service.isSpecialSite(site);
    }

    public static String getSiteSpecialId(String site) {
        SiteService.find();
        return M_service.getSiteSpecialId(site);
    }

    public static String getSpecialSiteId(String special) {
        SiteService.find();
        return M_service.getSpecialSiteId(special);
    }

    public static String getSiteDisplay(String id) {
        SiteService.find();
        return M_service.getSiteDisplay(id);
    }
}

